/*****************************************************************************/
/***                    Gestion de la liste des Users...                   ***/
/*****************************************************************************/

#include <stdio.h>
#include "robot.h"
#include "users.h"

extern user *users;
extern char *p[1024];

/*****************************************************************************/

char *UserNick (char *dser) {
  char *pt,tmp[256];

  strcpy (tmp,dser);
  pt=(char *)strrchr(tmp,'!');
  *pt=NULL;
  return (tmp);
}

/*****************************************************************************/

char *UserLogin (char *dser) {
  char *pt,tmp[256];

  strcpy (tmp,dser);
  pt=(char*)strrchr(tmp,'@');
  *pt=0;
  pt=(char*)strchr(tmp,'!')+1;
  return (pt);
}

/*****************************************************************************/

char *UserDomain (char *dser) {
  char *pt,tmp[256];

  strcpy (tmp,dser);
  if (isdigit(dser[0])) {
    pt=(char*)strrchr(tmp,'.');
    *pt=0;
    return (tmp);
  } else {
    pt=(char*)strchr(tmp,'.')+1;
    return (pt);
  }
}

/*****************************************************************************/

user *DoAuth (char *name,char *chan) {
  user *tmp1=users;
  while (!Rmatch(tmp1->pattern,name) || (chan && !Rmatch(tmp1->channel,chan)))
    tmp1=tmp1->next;
  return (tmp1);
}

/*****************************************************************************/

void FreeUsers (user *users) {
  user *tmp1,*tmp2=users->next;
  while (tmp1=tmp2) {
    tmp2=tmp1->next;
    free (tmp1->pattern);
    free (tmp1->channel);
    free (tmp1);
  }
  users->next=(user*)NULL;
}

/*****************************************************************************/

void LoadUsers () {
  FILE *fichier=fopen(USERSFILE,"r");
  char chan[20],pat[60],nic[20];
  unsigned int pri;
  user *tmp1=users;

  if (!fichier) {
    fprintf(stderr,"***  Error : Cannot open %s\n",USERSFILE);
    exit(1);
  }

  while (fscanf (fichier,"%s%s%s%d",nic,pat,chan,&pri)>0) {
    tmp1->next=(user*)malloc(sizeof(user));
    tmp1=tmp1->next;
    tmp1->next=NULL;
    tmp1->nick=(char*)strdup(nic);
    tmp1->pattern=(char*)strdup(pat);
    tmp1->channel=(char*)strdup(chan);
    tmp1->auth=pri;
  }

  fclose(fichier);
}

/*****************************************************************************/

void SaveUsers () {
  FILE *fichier=fopen(USERSFILE,"w");
  user *tmp1=users;

  if (!fichier) {
    fprintf(stderr,"***  Error : Cannot open save file\n");
    exit(1);
  }

  while (tmp1=tmp1->next)
    fprintf (fichier,"%-16s%-40s%-14s%d\n",tmp1->nick,
	     tmp1->pattern,tmp1->channel,tmp1->auth);

  fclose(fichier);
}

/*****************************************************************************/

void DoAddUser (char *nick,char *pattern,char *channel,int level) {
  user *tmp2,*tmp1=users;
  char from[10],mess[256];

  while (tmp1 && (strcasecmp(tmp1->pattern,pattern) ||
		  strcasecmp(tmp1->channel,channel)))
    tmp1=(tmp2=tmp1)->next;
  if (tmp1) {
    if (level) {
      tmp1->auth=level;
      sprintf (mess,"-User %s (%s) Uptated, Level %d on %s.",
	       nick,pattern,level,channel);
    } else {
      tmp2->next=tmp1->next;
      free (tmp1->nick);
      free (tmp1->pattern);
      free (tmp1->channel);
      free (tmp1);
      sprintf (mess,"-User %s (%s) Removed from channel %s.",
	       nick,pattern,channel);
    }
  } else {
    user *tmp3=(user*)malloc(sizeof(user));
    tmp3->nick=(char*)strdup(nick);
    tmp3->pattern=(char*)strdup(pattern);
    tmp3->channel=(char*)strdup(channel);
    tmp3->auth=level;
    tmp3->next=users->next;
    users->next=tmp3;
    sprintf (mess,"-User %s (%s) Added, Level %d on %s.",
	     nick,pattern,level,channel);
  }
  SaveUsers();
  strcpy (from,UserNick(p[0]));
  ServerNotice (from,mess);
}

/*****************************************************************************/

