/*
 * @(#)TestApplet.java	1.7 95/11/27 Sami Shaio
 *
 * Copyright (c) 1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
import java.applet.*;
import java.awt.*;

public class TestApplet extends Applet {
    OutputHandler outh = new NullOutput();

    public TestApplet() {
    }

    public void print(String s) {
	if (outh instanceof NullOutput) {
	    try {
		AppletContext appCtxt = getAppletContext();

		if (appCtxt != null) {
		    Applet app = getAppletContext().getApplet("Output");

		    if (app != null && app instanceof OutputHandler) {
			outh = (OutputHandler)app;
			outh.setTitle("*" + getClass().getName() + " Output*");
		    }
		}
	    } catch (NullPointerException e) {
	    }
	}
	outh.print(s);
    }

    public void destroy() {
	if (outh instanceof Applet) {
	    ((Applet)outh).destroy();
	}
    }

    public void paint(Graphics g) {
	Dimension s = size();
	g.setColor(Color.black);
	g.drawRect(0, 0, s.width - 1, s.height - 1);
    }

    public Insets insets() {
	return new Insets(2, 2, 2, 2);
    }
}

class NullOutput implements OutputHandler {
    public void setTitle(String s) {
	System.out.println(s);
    }
    public void print(String s) {
	System.out.println(s);
    }
}
