/*
 * @(#)TextAreaTest.java	1.10 95/12/19 Arthur van Hoff
 *
 * Modified: Vijay Srinivasan
 * Date: 11/06/95
 * Comment: app to applet conversion.
 *
 * Copyright (c) 1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

import java.awt.*;
import java.applet.*;

/**
 * A test of a Container with BorderLayout.
 */
public class TextAreaTest extends TestApplet {
    TextArea t1;
    TextArea t2;
    TextField f1;
    TextField start;
    TextField end;

    public void init() {
//	super("TextAreaTest");
	setLayout(new BorderLayout());

	Panel p = new Panel();
	p.setLayout(new GridLayout(0, 1));
	p.add(t1 = new TextArea(4, 30));
	t1.setForeground(Color.blue);
	t1.setEditable(false);
	p.add(t2 = new TextArea(4, 30));
	t2.setFont(new Font("Helvetica", Font.BOLD, 18));
	add("North", p);

	p = new Panel();
	p.setLayout(new GridLayout(0, 2));
	p.add(new Button("clear"));
	p.add(new Button("reset"));
	p.add(new Button("select"));
	p.add(new Button("print"));
	p.add(new Button("insert"));
	p.add(new Button("replace"));
	p.add(new Button("getRows"));
	p.add(new Button("getCols"));
	f1 = new TextField(20);
	p.add(new Label("text:"));
	p.add(f1);

	p.add(new Label("start:"));
	start = new TextField(3);
	start.setText("0");
	p.add(start);

	p.add(new Label("end:"));
	end = new TextField(3);
	end.setText("10");
	p.add(end);

	add("Center", p);
	move(200, 100);
//	pack();
	show();
    }

    public boolean handleEvent(Event evt) {
        String multiline = "Sami\nShaio";
	switch (evt.id) {
	  case Event.ACTION_EVENT:
	    if ("clear".equals(evt.arg)) {
		t1.setText("");
		t2.setText("");
		return true;
	    }
	    if ("reset".equals(evt.arg)) {
                t1.setText("Arthur van Hoff");
		t2.setText(multiline);
		return true;
	    }
	    if ("select".equals(evt.arg)) {
		t2.selectAll();
		return true;
	    }
	    if ("print".equals(evt.arg)) {
		print("-- values --");
		print("text=" + t1.getText());
		print("text=" + t2.getText());
                print("Newlines returned correctly? " + 
                    (t2.getText().equals(multiline) ? "yes" : "no"));
		return true;
	    }
	    if ("insert".equals(evt.arg)) {
		t2.insertText(f1.getText(), Integer.parseInt(start.getText().trim()));
		return true;
	    }
	    if ("replace".equals(evt.arg)) {
		t2.replaceText(f1.getText(),
			       Integer.parseInt(start.getText().trim()),
			       Integer.parseInt(end.getText().trim()));
	    }
	    if ("getRows".equals(evt.arg)) {
		print("Rows: " + String.valueOf(t2.getRows()));
	    }
	    if ("getCols".equals(evt.arg)) {
		print("Cols: " + String.valueOf(t2.getColumns()));
	    }
	    break;
	  case Event.WINDOW_DESTROY:
	    System.exit(0);
	    break;
	}
	print(evt.toString());
	return false;
    }

    public static void main(String args[]) {
	Frame f = new Frame("TextAreaTest");
	TextAreaTest textareatest = new TextAreaTest();

	textareatest.init();
	textareatest.start();

	f.resize(600, 600);
	f.add("Center", textareatest);
	f.show();
    }
}
