#include <windows.h>
#include <stdio.h>

void main(int argc, char * argv[]) {
	FILE	*fin;
	FILE	*fout;
	char	*szInputFileName;
	char	*szOutputFileName;
	char	szTmp[160];


	if (argc != 2) {
		printf("Command line parm invalid.  Expecting infile,outfile.\n");
		return;
	}

	// get pointer to input filename
	szInputFileName = argv[1];

	// get pointer to output filename
	szOutputFileName = strchr(szInputFileName,',');
	if (szOutputFileName==NULL) {
		printf("Command line parm invalid.  Expecting infile,outfile.\n");
		return;
	}

	// terminate the input filename, adjust output filename pointer
	*szOutputFileName = '\0';
	szOutputFileName++;

	// open the input file for read
	fin = fopen(szInputFileName,"r");
	if (fin==NULL) {
		printf("Could not open input file\n");
		return;
	}

	// open the output file for write
	fout = fopen(szOutputFileName,"w");
	if (fout==NULL) {
		printf("Could not open output file.\n");
		return;
	}

	fprintf(fout,"content-type: text/html\n\n");
	fprintf(fout,"<html>\n");
	fprintf(fout,"<head><title>CDEMO</title></head>\n");
	fprintf(fout,"<h1>CDEMO Environment Variables</h1>\n");
	fprintf(fout,"<ul>\n");

	while (fgets(szTmp,sizeof(szTmp),fin)) {
		fprintf(fout,"<li>%s",szTmp);

	}
	fprintf(fout,"</ul>\n");
	fprintf(fout,"</body></html>\n");
	
	fclose(fin);
	fclose(fout);
	_unlink(szInputFileName);

}
