Attribute VB_Name = "cgishell"
Option Explicit
DefInt A-Z

' cgishell.bas
' copyright (c) 1995 Greyware Automation Products

' version of CGIShell required to work with this file is 950930 or newer
Global Const CGIShellVersionRequired = "1.0.b.950930"

' WARNING:  This version of CGISHELL.BAS may not be fully compatible with
' projects compiled for a previous version of CGISHELL.BAS.  In particular,
' the PathToURL and cgiGetScript functions have changed calling conventions.
' This warning applies to your own code and also any sample code from
' Greyware distributed with a date-stamp prior to 951128.

'
' Include this file with your VB3 or VB4 project.
'

' ----- Variables local to this module
    
    Dim Env() As String                 ' array to hold environment variables
    Dim FakeCR As String * 1            ' CR within Env() represented by FakeCR
    Dim FakeLF As String * 1            ' LF within Env() represented by FakeLF
    
' ----- Global variables (filled in by cgiStartUp)

    Global szInFileName As String           ' name of input filename
    Global hOut As Long                     ' handle to output file
    Global CRLF As String * 2               ' CRLF sequence
    Global CR As String * 1                 ' Real CR character
    Global LF As String * 1                 ' Real LF character
    Global CWD As String                    ' Working directory name
    
' ----- Global variables (default to FALSE or blank unless you set them before calling cgiStartup)

    Global PragmaNoCache As Integer         ' If TRUE, "Pragma: no-cache" is sent as part of header
    Global ContentType As String            ' If blank, defaults to "content-type: text/html"
    
' SAMPLE PROGRAM #1:  Dumps CGI Environment Variables
' Sub Main()
'   cgiStartup          ' Call the startup routine
'   cgiTitle "Sample Program #1"
'   cgiHeader "Sample Program #1",1
'   cgiDumpEnv          ' Call the dump environment routine
'   cgiShutdown         ' Call the shutdown routine
' End Sub
'
'
' SAMPLE PROGRAM #2:  Prints Error Message & Exits
' Sub Main()
'   cgiStartup          ' Call the startup routine
'   ' something here generates error
'   cgiErrExit "Sample Program #2:  Error Exit"
' End Sub

'
' This routine dumps all env variables to the output
'
Sub cgiDumpEnv()
    Dim x As Integer
    cgiHeader "CGI Environment Variables", 3
    Out "Input File=" + szInFileName + "<br>"
    Out "Default Directory=" + CurDir$ + "<br>"
    Out "Current Working Directory=" + CWD + "<br>"
    Out "This script: " + cgiGetScript() + "<br>"
    Out "<ul>"
    For x = 1 To UBound(Env, 1)
        Out "<li>" + Env(x)
    Next x
    Out "</ul>"
End Sub
'
' Prints error message and exits; does not return to calling routine
'
Sub cgiErrExit(errmsg As String)
    cgiTitle "CGI Application Problem"
    cgiHeader "CGI Application Problem", 1
    Out "<body>"
    cgiHeader errmsg, 3
    Out "</body>"
    cgiShutdown
End Sub
'
' Returns value of env variable 'var'
'
Function cgiGetEnv(var As String) As String
    Dim x As Integer
    Dim QV As String
    On Error Resume Next
    ' env variables are stores as token=value, so set up QV to match the token= part
    QV = Trim(UCase(var) + "=")
    ' Loop through each env variable until match is found, or array exhausted
    For x = 1 To UBound(Env, 1)
        If Left(UCase(Env(x)), Len(QV)) = QV Then
            cgiGetEnv = Mid(Env(x), Len(QV) + 1)
            Exit Function
        End If
    Next x
End Function
'
' Returns name of running script
'
Function cgiGetScript() As String
    Dim x As Integer
    Dim tmp As String
    On Error Resume Next
    
    tmp = cgiGetEnv("script_name") + cgiGetEnv("Path_Info")
    cgiSwapChar tmp, "/", "\"
    
    If Mid(tmp, 2, 2) = ":\" Then
        x = InStr(4, tmp, "\")
        If x Then tmp = Mid(tmp, x + 1)
    End If
    If Left(tmp, 1) = "\" Then tmp = Mid(tmp, 2)
    cgiGetScript = tmp
End Function


'
' Outputs a header.  Call with 'cgiHeader "Level One Header", 1' etc.
'
Sub cgiHeader(txt As String, level As Integer)
    Out "<H" + Format$(level) + ">" + txt + "</H" + Format$(level) + ">"
End Sub

'
' Normal shutdown procedure; does not return to caller
'
Sub cgiShutdown()
    On Error Resume Next
    
    ' close the output file
    Close #hOut
    
    ' delete the input file, so cgishell knows we're finished here
    Kill szInFileName
    
    ' and terminate
    End
End Sub
'
' Main CGI startup routine.  Your program's Sub Main() should call this routine
' at startup, and call CGIShutdown or CGIErrExit to terminate.
'
' There are two variables your Sub Main() may set before calling cgiStartup():
'    ContentType -- if non-blank, cgiStartup will use this as your content-type header
'    PragmaNoCache -- if TRUE, cgiStartup will tell browsers not to cache your page
' You may leave these variables alone and accept the defaults most of the time.
'
Sub cgiStartup()
    Dim x As Integer            ' generic local counter
    Dim EnvCount As Integer     ' local counter of environment variables
    Dim hIn As Long             ' handle to input file
    Dim szOutFileName As String ' output filename
    On Error Resume Next
    
    ' define constants & such
    CRLF = Chr$(13) + Chr$(10)  ' Fill in the CRLF definition
    FakeCR = Chr$(254)          ' Strings passed to us will use FakeCR instead of CR
    FakeLF = Chr$(255)          ' Strings passed to us will use FakeLF instead of LF
    CR = Chr$(13)               ' Fill in the CR definition
    LF = Chr$(10)               ' Fill in the LF definition
    CWD = App.Path              ' Current Working Directory (not necessarily CurDir$)
    If Right(CWD, 1) <> "\" Then CWD = CWD + "\"
    
    ' parse the command line for our in/out files.  We are always invoked with infile,outfile
    ' on the command line
    x = InStr(Command$, ",")
    If x = 0 Then End           ' just end if no comma on command line
    szInFileName = Trim(Left(Command$, x - 1))  ' grab input file name
    szOutFileName = Trim(Mid(Command$, x + 1))  ' grab output file name
    
    ' open the source file and parse into env() variable array
    ReDim Env(0)                                            ' force Env() array to reinit
    EnvCount = 0                                            ' zero elements thus far
    hIn = FreeFile                                          ' get a free handle
    Open szInFileName For Input As #hIn                     ' open the input file
    If Err Then End                                         ' we don't care what error; just end
    Do Until EOF(hIn)                                       ' loop through entire file
        EnvCount = EnvCount + 1                             ' one more element found
        ReDim Preserve Env(EnvCount)                        ' increase the array size
        Line Input #hIn, Env(EnvCount)                      ' read in the new element
        cgiSwapChar Env(EnvCount), FakeCR + FakeLF, CRLF    ' Swap fake CRLF for real CRLF
        cgiSwapChar Env(EnvCount), FakeLF + FakeCR, CRLF    ' Swap fake LFCR for real CRLF
        cgiSwapChar Env(EnvCount), FakeCR, CRLF             ' Any remaining Fake CRs become real CRLFs
        cgiSwapChar Env(EnvCount), FakeLF, CRLF             ' Any remaining Fake LFs become real CRLFs
    Loop
    Close #hIn
    
    ' done with source file until very end, so now open the target file for output so
    ' all routines can write to it
    hOut = FreeFile                                         ' this is a global handle!
    Open szOutFileName For Output As #hOut                  ' open the file and leave it open!
    
    ' output the standard headers unless told otherwise
    If ContentType = "" Then ContentType = "Content-Type: text/html"
    Print #hOut, ContentType + LF;                          ' start with Content_Type always!
    If PragmaNoCache Then Print #hOut, "Pragma: no-cache" + LF;
    Print #hOut, LF;                                        ' terminate header with blank line
End Sub
'
' searches through string 'source' replacing every instance of
' 'char1' with 'char2' -- char1 and char2 may be any length
'
Sub cgiSwapChar(source As String, char1 As String, char2 As String)
    Dim x As Integer
    Dim tmp1 As String, tmp2 As String
    ' make sure char1 and char2 are uniquely different
    If InStr(char2, char1) = 0 Then
        Do
            x = InStr(source, char1)
            If x Then
                tmp1 = Left(source, x - 1)
                tmp2 = Mid(source, x + Len(char1))
                source = tmp1 + char2 + tmp2
            End If
        Loop While x
    End If
End Sub
'
' Outputs the standard <head><title>blah-blah-blah</title></head> text.
' For good form, you should include a <body> tag immediately after calling
' this function, and a </body> tag just before calling cgiShutdown.
'
Sub cgiTitle(txt As String)
    Out "<HEAD><TITLE>" + txt + "</TITLE></HEAD>"
End Sub

'
' Decodes %xx escapes and plus signs; does NOT change / to \
'
Function cgiURLDecode(ITxt As String) As String
    Dim x As Integer, i As Integer
    Dim oTxt As String
    On Error Resume Next
    
    oTxt = ITxt   ' work on a copy of the string
    
    ' first fix all the plus signs
    Do
        x = InStr(oTxt, "+")
        If x Then Mid(oTxt, x, 1) = " "
    Loop While x
        
    ' now fix the %xx escapes
    Do
        x = InStr(oTxt, "%")
        If x Then
            i = Val("&H" + Mid(oTxt, x + 1, 2))
            oTxt = Left(oTxt, x - 1) + Chr$(i) + Mid(oTxt, x + 3)
        End If
    Loop While x
    cgiURLDecode = oTxt
End Function

'
' Sends txt to the output, with CRLF
'
Sub Out(txt As String)
    On Error Resume Next
    Print #hOut, txt
End Sub
'
' Converts string with pathname to string with url-encoded pathname
'
Function PathToURL(txt As String) As String
    Dim tmp As String
    tmp = txt
    cgiSwapChar tmp, "\", "/"
    cgiSwapChar tmp, " ", "+"
    PathToURL = tmp
End Function
'
' Returns 'txt' surrounded by double-quote marks
'
Function Q(txt As String) As String
    Q = Chr$(34) + txt + Chr$(34)
End Function


