Attribute VB_Name = "GuestBook"
Option Explicit
DefInt A-Z

' GuestBook 1.1
' This file last updated on 951128
' Copyright (c) 1995 Greyware Automation Products
' You may use or modify this code to create your own guest book
'
' Parms:
'   bookfile=file   (required)
'       relative path to guestbook datafile; extension must be .book
'
'   op=operation    (required)
'       show    displays the guestbook
'       add     adds record to guestbook
'       sign    displays form for signing the guestbook
'
'   bookname=name   (optional)
'       if provided, displays give guestbook a display name
'
'
'   startwith=##    (optional; used with op=show)
'       if provided, first record number displayed
'
'   howmany=##      (optional; used with op=show)
'       if provided, number of records to display per page
'
'   background=file (optional)
'       relative path to <body background> file

' Examples:
'
'   1.  Display the guest book, starting with most recent record:
'       <a href="/cgi/cgishell.exe/guestbook.exe?op=show&bookfile=guest.book&bookname=My+Guest+Book">View the GuestBook</a>
'
'   2.  Display form for signing guestbook:
'       <a href="/cgi/cgishell.exe/guestbook.exe?op=sign&bookfile=guest.book&bookname=My+Guest+Book">Sign the GuestBook</a>
'
'   3.  Display 10 records from guestbook, starting with record 17
'       <a href="/cgi/cgishell.exe/guestbook.exe?op=show&bookfile=guest.book&bookname=My+Guest+Book&startwith=17&howmany=10">View 10 Records from the GuestBook</a>
'
'   4.  Use /graphics/mybackground.jpg as the guestbook background
'       <a href="/cgi/cgishell.exe/guestbook.exe?background=/graphics/mybackground.jpg&op=show....


Dim GuestBook As String             ' name of the guest book file
Dim Fixed As String * 1024          ' all file records are 1024-byte strings
Dim BookName As String              ' name of guestbook (from guestbook= env variable)
Dim Background As String            ' <body background=gif> (from background= env variable)

'
' Add a record to the Guest Book file.  Returns zero if unable to open file
' else returns record number of record written
'
Function fileAddRecord(record As String) As Long
    Dim hFile As Long                   ' file handle
    Dim WaitTime As Double              ' time-lapse counter
    Dim Loops As Integer                ' loop counter
    Dim TotRecords As Long              ' total records in file
    LSet Fixed = record                 ' shove data into record
    
    ' wait until we have exclusive access for writing
    On Error Resume Next
    Loops = 0
    Do Until Loops > 10                 ' try for 10 seconds max
        DoEvents
        hFile = FreeFile                ' get a free file handle
        Err = 0                         ' reset the error, if any
        Open GuestBook For Random Access Write Lock Write As #hFile Len = Len(Fixed)
        Select Case Err
            Case 0                      ' did we get exclusive access?
                Exit Do                 ' yes, skip ahead
            Case 70                     ' permission denied?
                hFile = 0               ' reset the handle
                Loops = Loops + 1       ' mark one more loop expired
                WaitTime = Timer + 1    ' wait one full second
                While Timer < WaitTime
                    DoEvents
                Wend
            Case Else                   ' some other error
                hFile = 0
                Exit Do
        End Select
    Loop
    
    ' if we managed to open the file
    If hFile Then
        TotRecords = LOF(hFile) \ Len(Fixed)    ' calc end of file
        Put #hFile, TotRecords + 1, Fixed       ' add a record to the file
        Close #hFile                            ' close the file, releasing locks
        fileAddRecord = TotRecords + 1          ' return record number
    End If
End Function


'
' This routine adds a record to the guestbook
'
Sub BookAddRecord()
    Dim Caller As String, Email As String, HomePage As String, Comments As String
    Dim FName As String
    Dim UserInfo As String
    Dim RecNum As Long
    Dim tmp As String, x As Integer
       
    ' Get pertinent environment variables
    Caller = cgiGetEnv("name")
    Email = LCase(cgiGetEnv("mail"))
    HomePage = PathToURL(LCase(cgiGetEnv("page")))
    Comments = cgiGetEnv("comments")
    
    ' Look for a first name; use it if possible
    x = InStr(Caller, " ")
    If x Then FName = Left(Caller, x - 1) Else FName = Caller
    
    ' Ensure HomePage is a full, valid URL
    If HomePage = "http://" Then HomePage = ""

    ' Remove trailing CRLFs from comments
    If Len(Comments) Then
        While Right(Comments, 2) = CRLF
            Comments = Left(Comments, Len(Comments) - 2)
        Wend
    End If
    
    ' Ensure comments are not too long
    If Len(Comments) > (Len(Fixed) - 300) Then
        Comments = Left(Comments, Len(Fixed) - 300)
    End If
    
    ' Cat up basic user information
    UserInfo = Caller + " called from " + cgiGetEnv("remote_addr") + " with " + cgiGetEnv("http_user_agent")
    UserInfo = UserInfo + "<br>" + CRLF + "Guest Book signed on " + Format$(Now, "dddd, dd mmmm yyyy") + " at " + Format$(Now, "h:mm:ss AM/PM")
    
    If Caller = "" Then
        tmp = "<h3>You left off your name!<h3>"
        tmp = tmp + "<hr>" + CRLF
        tmp = tmp + "Sorry, but you must include your name to sign the Guest Book.  "
        tmp = tmp + "Use your browser's " + Q("back") + " button to try again."
        cgiErrExit tmp
    Else
        Out "<title>" + Caller + " Added to Guest Book</title>"
        Out "<h1>Thank you, " + FName + "!</h1>"
        Out "Your entry has been added to the " + BookName + "Guest Book<hr>"
        tmp = "<h3>" + Caller + "</h3>" + CRLF
        If Len(Comments) Then tmp = tmp + "<em><dd>" + Q(Comments) + "</em></dd><p>" + CRLF
        If Len(Email) Then tmp = tmp + "<dd>Send <a href=" + Q("mailto:" + Email) + ">mail</a> to " + FName + "</dd><br>" + CRLF
        If Len(HomePage) Then tmp = tmp + "<dd>Visit " + FName + "'s <a href=" + Q(HomePage) + ">Home Page</a></dd><br>" + CRLF
        tmp = tmp + "<br>" + UserInfo + "<br>" + CRLF + "<hr>" + CRLF
        
        RecNum = fileAddRecord(tmp)
        Select Case RecNum
            Case 0
                cgiErrExit "Could not open " + GuestBook + "."
            Case Else
                Out "Record " + Format(RecNum) + " added to Guest Book:" + CRLF + tmp
        End Select
    End If
End Sub

'
' This routine builds & displays a form for signing the guest book
'
Sub BookMakeForm()
    Dim tmp As String
    
    cgiTitle "Sign the Guest Book"
    cgiHeader "Sign the " + BookName + "Guest Book", 1
    Out "<body>"
    Out "<hr>"
    Out "Fill in the form below, then click the OK button to sign the Guest Book.  If you don't want "
    Out "to sign, click your browser's " + Q("back") + " button to exit."
    
    ' get the path to cgishell.exe + \ + this executable
    tmp = PathToURL("\" + cgiGetScript() + "?")
    
    Out "<form method=" + Q("post") + " action=" + Q(tmp) + ">"
    Out "<input type=hidden name=bookfile value=" + GuestBook + ">"
    Out "<input type=hidden name=op value=add>"
    If Len(Background) Then Out "<input type=hidden name=background value=" + Q(PathToURL(Background)) + ">"
    If Len(BookName) Then Out "<input type=hidden name=bookname value=" + Trim(BookName) + ">"
    Out "<pre>"
    Out "         Your Name <input type=" + Q("text") + " name=" + Q("name") + " size=30>"
    Out "Your Email Address <input type=" + Q("text") + " name=" + Q("mail") + " size=30>  jblow@somewhere.cool"
    Out "    Your Home Page <input type=" + Q("text") + " name=" + Q("page") + " value=" + Q("http://") + " size=30>  http://www.somewhere.cool/~jblow/"
    Out "</pre>    "
    Out "General Comments -- say something about yourself or this site<br>"
    Out "<textarea rows=6 cols=65 name=" + Q("comments") + "></textarea><p>"
    Out "<input type=" + Q("submit") + " value=" + Q("    OK    ") + ">  <input type=" + Q("reset") + " value=" + Q(" Reset ") + "><br>"
End Sub

'
' This routine displays entries from the guestbook, plus provides
' a navigation bar for browsing through the rest of the book
'
Sub BookShow(StartWith As Long, HowMany As Long)
    Dim hFile As Long               ' file handle
    Dim x As Integer                ' generic
    Dim tmp As String               ' temp string
    Dim TotRecords As Long          ' total count of existing records
    Dim FirstEntry As Long          ' first entry to read
    Dim LastEntry As Long           ' last entry to read
    Dim ThisEntry As Long           ' counter
    Dim NavBar As String            ' navigation
    
    If HowMany = 0 Then HowMany = 5 ' default number of entries to show at a time
    If HowMany < 1 Then HowMany = 1
    If HowMany > 999 Then HowMany = 999
    
    On Error GoTo BookShowError
    
    hFile = FreeFile
    Open GuestBook For Random Access Read Shared As #hFile Len = Len(Fixed)
    TotRecords = LOF(hFile) \ Len(Fixed)
    cgiTitle "Guest Book"
    cgiHeader BookName + "Guest Book", 1
    Out "<body>"
    If TotRecords = 0 Then
        Out "No one has signed the Guest Book yet!  Won't you please be the first?"
        Out "</body>"
        Exit Sub
    End If
    
    If StartWith <> 0 Then      ' if startwith specified
        FirstEntry = StartWith
        If FirstEntry > TotRecords Then FirstEntry = TotRecords
    Else
        FirstEntry = TotRecords
    End If
    LastEntry = FirstEntry - (HowMany - 1)
    If LastEntry < 1 Then LastEntry = 1
    
    cgiHeader "Records " + Format$(FirstEntry) + " through " + Format$(LastEntry) + "<br>", 3
    
    tmp = cgiGetEnv("HTTP_REFERER")
    x = InStr(8, tmp, "\")
    If x Then tmp = Left(tmp, x)
    NavBar = "<a href=" + Q(PathToURL(tmp)) + ">Back to Main Page</a> "
    
    ' get the path to cgishell.exe + \ + this executable + ?
    tmp = "\" + cgiGetScript() + "?"
    
    ' add the operation
    tmp = tmp + "op=show"
    
    ' add the bookfile parm
    tmp = tmp + "&bookfile=" + GuestBook

    ' add the bookname parm
    If Len(BookName) Then tmp = tmp + "&bookname=" + Trim(BookName)
    
    ' add the background parm
    If Len(Background) Then tmp = tmp + "&background=" + cgiGetEnv("background")
    tmp = tmp + "&howmany=" + Format$(HowMany)
    tmp = tmp + "&startwith="       ' we'll add the startwith parm below
    tmp = PathToURL(tmp)
    
    If FirstEntry > HowMany Then
        NavBar = NavBar + "Look at <a href=" + tmp + Format$(FirstEntry - HowMany) + ">Older Records</a> "
    End If
    If FirstEntry < TotRecords Then
        NavBar = NavBar + "Look at <a href=" + tmp + Format$(FirstEntry + HowMany) + ">Newer Records</a> "
    End If
    cgiHeader NavBar, 3
    
    ' read file backwards (firstentry = most recent record)
    For ThisEntry = FirstEntry To LastEntry Step -1
        Get #hFile, ThisEntry, Fixed
        Out Trim(Fixed)
    Next ThisEntry
    Close #hFile
    
    cgiHeader NavBar, 3
    Out "</body>"
    Exit Sub

BookShowError:
    tmp = "Error reading Guest Book: " + Error$
    On Error GoTo 0
    Resume BookShowFatalExit

BookShowFatalExit:
    cgiErrExit tmp
End Sub

'
' This is the entry point for the GuestBook program
'
Sub Main()
    On Error Resume Next
    
    ' initialize the CGI environment
    PragmaNoCache = True
    cgiStartup
    
    ' make sure we have a recent-enough copy of CGIShell
    If CGIShellVersionRequired > cgiGetEnv("CGIShell_Version") Then
        cgiErrExit "This program requires CGIShell version " + CGIShellVersionRequired + " or higher."
    End If
    
    ' find out the guestbook filename
    GuestBook = cgiGetEnv("bookfile")       ' get the name of the guestbook file
    BookName = cgiGetEnv("bookname")        ' get name of guestbook
    Background = cgiGetEnv("background")    ' body background to use
    
    ' ensure guestbook filename is valid format
    If Right(LCase(GuestBook), 5) <> ".book" Then
        cgiErrExit "Guest Book filename is invalid; the extension must be " + Q(".book")
    End If
    
    If Len(BookName) Then BookName = BookName + " "
    If Len(Background) Then Out "<body background=" + Q(PathToURL(Background)) + ">"
    
    Select Case LCase(cgiGetEnv("op"))
        Case "show":        BookShow Val(cgiGetEnv("startwith")), Val(cgiGetEnv("howmany"))
        Case "add":         BookAddRecord
        Case "sign":        BookMakeForm
        Case Else:          cgiErrExit "Unknown operation; must be 'show' 'add' or 'sign'"
    End Select
    
    ' shutdown & exit
    cgiShutdown
End Sub

