Option Explicit
DefInt A-Z

Declare Function GetModuleUsage Lib "kernel" (ByVal hModule As Integer) As Integer

Dim CR As String * 1
Dim LF As String * 1
Dim CRLF As String * 2

Sub Main ()
    On Error Resume Next
    
    ' Declare local variables & constants
    Dim x As Integer        ' generic
    Dim tmp As String       ' temporary string storage
    Dim hFile As Integer    ' handle to file
    Dim ifname As String    ' input filename
    Dim ofname As String    ' output filename
    Const DumpThis = "The command completed successfully."

    ' Fill in global variables
    CR = Chr$(13)
    LF = Chr$(10)
    CRLF = Chr$(13) + Chr$(10)

    ' Look for comma on command line
    x = InStr(Command$, ",")
    If x = 0 Then
        MsgBox "This program is meant to be invoked by CGIShell.", 64, "Server Network Statistics"
        End
    End If
    
    ' comma found; separate input filename from output filename
    ifname = Trim(Left(Command$, x - 1))
    ofname = Trim(Mid(Command$, x + 1))

    ' go get the stats, shoving output into output file for now
    ShellAndWait "cmd.exe /cnet statistics server >" + ofname, 2
    ShellAndWait "cmd.exe /cnet statistics workstation >>" + ofname, 2

    ' read in the results so we can do post-processing
    hFile = FreeFile
    Open ofname For Binary As #hFile
    tmp = Space$(LOF(hFile))
    Get #hFile, 1, tmp      ' Read in the whole file
    Close #hFile

    ' replace CRLF with "<p>"
    'Do
    '    x = InStr(tmp, CRLF)
    '    If x Then tmp = Left(tmp, x - 1) + "<p>" + Mid(tmp, x + 2)
    'Loop While x

    ' replace lone LF with "<br>"
    'Do
    '    x = InStr(tmp, LF)
    '    If x Then tmp = Left(tmp, x - 1) + "<br>" + Mid(tmp, x + 1)
    'Loop While x

    Do
        x = InStr(tmp, DumpThis)
        If x Then
            tmp = Left(tmp, x - 1) + Mid(tmp, x + Len(DumpThis) + 1)
        End If
    Loop While x
    ' open the file again, this time overwriting
    hFile = FreeFile
    Open ofname For Output As #hFile
    Print #hFile, "Content-type: text/html" + LF + LF;
    Print #hFile, "<html>"
    Print #hFile, "<title>Server Network Statistics</title><head><h1>Server Network Statistics</h1><head>"
    Print #hFile, "<body><hr><pre>"; tmp; "</pre></body></html>"
    Close #hFile

    ' delete the input file so CGIShell knows we're done
    Kill ifname
    End
End Sub

'
' Launch a subprocess and wait for it to terminate
'
Sub ShellAndWait (ProgName As String, Parms As Integer)
    Dim hModule As Integer
    hModule = Shell(ProgName, Parms)
    While GetModuleUsage(hModule) > 0
        DoEvents
    Wend
End Sub

