//
// CGITEXT.CPP - A CGI 1.0 compliant HTML form to text converter
//
// Written by Corey Bodzin
//
// ------------------------------------------------------------------------
// Example CGI Script file for use with HTTPS.  Assumes it is invoked from
// a form using the POST method.  It is very bare-bones and does absolutely
// no error checking of any kind.  Its sole purpose is to decode the data
// sent from the HTML form and write it to a text file (specified by the
// environment variable PATH_INFO) in the format of a SQL INSERT command.
//
//  For example, if the input from STDIN was
//
//			 "lname=Smith&fname=John&addr=123+Main"
//
//  and the PATH_INFO environment variable was
//
//			/CGI/FILES/SQLSTUFF.TXT
//
// then it would write the following string to the file:
//
//			INSERT tablename (lname,fname,addr) VALUES ('Smith','John','123 Main')
//
// I then use a simple VB program to periodically retrieve the contents of
// the text file and pass the commands along to SQL server.  The program
// could be easily re-written to send output in a different format (such as
// ASCII, delimited ASCII, dBase, etc.) or to a different location, but
// that's up to you to do!
//
// A couple of notes...
//
//	  1) You probably should read up on the CGI spec if you're unfamiliar
//      with it before trying to figure out this program.
//   2) You may be asking why I don't just output the data directly to SQL
//      server.  Frankly, I'm not that good a C++ programmer.  If you are,
//		  please send me your code!
//   3) I have compiled this program using Borland C++ 4.0 but I don't see
//      why it wouldn't work with other compilers.  Please note that the
//		  EMWAC HTTPS requires that and CGI script be a Win32 CONSOLE mode
//      application.  I have only tested this as Win32 application.
//   4) Everything here is presented as is.  I make no guarantees that it
//      will work perfectly, that it won't bomb your system, etc.  USE THIS
//      AT YOUR OWN RISK!
//   5) Whole sections of this are copied from example scripts supplied
//      with EMWAC HTTPS Server (ftp:emwac.ac.ed.uk).  I take no credit
//      for these sections, but I don't know who originally wrote the
//      code.  Whoever you are -- THANKS!
//
// Please let me know if you find any bugs, make any improvements, etc.
// I can be reached at either of the following addresses:
//
// 		Corey Bodzin
//			cbodzin@interserv.com
//			74222.1506@compuserve.com
//
// ------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <io.h>

char InputBuffer[4096];			 // Holds STDIN data from HTML form
char cFields[4096];            // Holds SQL update field names
char cValues[4096];            // Holds SQL update values

// Strip in cNewChar for cOldChar.  Spaces become "+" when URL-encoded, so
// this routine changes them (and other things) back.
void stripit(char *cString,char cOldChar,char cNewChar) {
	int i;

	i = 0;
	while (cString[i]) {
		if (cString[i]==cOldChar) cString[i] = cNewChar;
		i++;
	}
}

// The string starts with two hex characters.  Returns an integer.  Certain
// characters are converted to hexadecimal escape sequences when URL-encoded.
static int Hex2Int(char *pC) {
	int Hi;
	int Lo;
	int Result;

	Hi = pC[0];
	if ('0'<=Hi && Hi<='9') {
		Hi -= '0';
	} else
	if ('a'<=Hi && Hi<='f') {
		Hi -= ('a'-10);
	} else
	if ('A'<=Hi && Hi<='F') {
		Hi -= ('A'-10);
	}
	Lo = pC[1];
	if ('0'<=Lo && Lo<='9') {
		Lo -= '0';
	} else
	if ('a'<=Lo && Lo<='f') {
		Lo -= ('a'-10);
	} else
	if ('A'<=Lo && Lo<='F') {
		Lo -= ('A'-10);
	}
	Result = Lo + 16*Hi;
	return Result;
}

// Decode the given string in-place by expanding %XX escapes.  HTML forms
// encode certain characters (&, =, etc.) with their hex equivalents.
void urlDecode(char *p) {
	char *pDecoded;

	pDecoded = p;
	while (*p) {
		if (*p=='%') {
			// Escape: next 2 chars are hex representation of the actual
			// character.  Use Hex2Int to get the right ASCII code.
			p++;
			if (isxdigit(p[0]) && isxdigit(p[1])) {
				*pDecoded++ = (char) Hex2Int(p);
				p += 2;
			}
		} else {
			*pDecoded++ = *p++;
		}
	}
	*pDecoded = '\0';
}

// Parse out and store field=value items.
void AddField(char *Item) {
	char *p;
	char *cComma = ",";
	char *cQuote = "'";

	p = strchr(Item,'=');
	*p++='\0';
	urlDecode(Item);
	urlDecode(p);
	stripit(p,'\n',' ');
	stripit(p,'\r',' ');
	stripit(p,'+',' ');

	// Append values to cFields and cValues.
	strcat(cFields, Item);
	strcat(cFields, cComma);
	strcat(cValues, cQuote);
	strcat(cValues, p);
	strcat(cValues, cQuote);
	strcat(cValues, cComma);
}

// Main program starts here...
int main(void) {
	int ContentLength;
	int x;
	int i;
	char *p;
	char *q;
	char *FileName;
	FILE *f;

	// Turn buffering off for stdin.
	setvbuf(stdin,NULL,_IONBF,0);

	// Tell the client what we're going to send.
	printf("Content-type: text/html\n\n");

	// Get the PATH_INFO convert it to a file name.
	FileName = getenv("PATH_INFO");
	q = FileName;
	while (*q) {
		if (*q=='/') *q = '\\';
		q++;
	}
	if (*FileName=='\\') FileName++;
	urlDecode(FileName);

	// Now open the file.  Bomb if we can't...
	f = fopen(FileName, "at");
	if (f==NULL) {
		printf("<HEAD><TITLE>Error - cannot open file</TITLE></HEAD>\n");
		printf("<BODY><H1>Error - cannot open file</H1>\n");
		printf("The file %s could not be opened.\n",FileName);
		printf("</BODY>\n");
		exit(1);
	}

	// Get the data from the client.
	p = getenv("CONTENT_LENGTH");
	if (p!=NULL) {
		ContentLength = atoi(p);
	} else {
		ContentLength = 0;
	}
	if (ContentLength>sizeof(InputBuffer)-1) {
		ContentLength = sizeof(InputBuffer)-1;
	}
	i = 0;
	while (i<ContentLength) {
		x = fgetc(stdin);
		if (x==EOF) break;
		InputBuffer[i++] = x;
	}
	InputBuffer[i] = '\0';
	ContentLength = i;

	// Initialize the cFields and cValues strings.  You will have to change
	// this to indicate the proper table (unless your table really is called
	// "tablename").  You may also want to change the action from INSERT to
	// DELETE, UPDATE, or whatever.
	strcat(cFields, "INSERT tablename (");
	strcat(cValues, " VALUES (");

	// Parse the data, looking for "&" delimiter.
	p = strtok(InputBuffer,"&");
	while (p!=NULL) {
		AddField(p);
		p = strtok(NULL,"&");
	}

	// When we're done parsing the data, it will have an extra comma on the
	// end.  Make the trailing comma into a parenthesis and null-terminate.
	i = strlen(cFields) - 1;
	q = cFields + i;
	*q++ = ')';
	*q = '\0';
	i = strlen(cValues) - 1;
	q = cValues + i;
	*q++ = ')';
	*q = '\0';

	// Now write the info to the file.  Change this into whatever format you
	// want.  This just writes the two strings one after the other.
	fprintf(f,"%s %s\n",cFields, cValues);

	// Confirm to client that the data has been accepted.
	printf("<HEAD><TITLE>Submitted OK</TITLE></HEAD>\n");
	printf("<BODY>The information you supplied has been accepted.</BODY>\n");

	// This is for debugging.  It echos the info send to the text file
	// back to the client.  You'll probably want to remove this.
	printf("<p> %s, %s <p>", cFields, cValues);

	// Close the file and exit the program.
	fclose(f);
	return 0;
}

