#include <string.h>
#include "time.h"
#include <stdio.h>
#ifndef NO_STDLIB_H
#include <stdlib.h>
#else
char *getenv();
#endif

typedef struct clink {
  long number;
  char *name;
  struct clink *next;
} CLINK;

void makebitmapfromnumber(long);

extern int inverse;

char *counterfile={"../logs/count.txt"};
char *hostsfile={"../logs/counterhosts.txt"};
char *linksfile={"../logs/counterlinks.txt"};
char *lockfile={"../logs/counterlock.txt"};


main(int argc, char *argv[]) {
  CLINK *lnk = NULL;
  CLINK *head = NULL;  
  register int x,m=0;
  int cl,host=0,addr=0;
  FILE *output,*input,*hosts,*links,*lock;
  char string[255],name[255];
  int timeout = 10;  /*seconds*/
  long number,outnumber=0;
  time_t tick;
  int i;
                                      /* Output an error bitmap if an
                                           argument is not passed */	
  if(argc < 2) {
    printf("Content-type: image/x-xbitmap\n\n"); 
    printf("#define error_width 26\n");
    printf("#define error_height 8\n");
    printf("static unsigned char error_bits[] = {\n");
    printf("   0x00,0x00,0x00,0x00,0xde,0x39,0xe6,0x00,0x42,0x4a,0x29,0x01,\n");
    printf("   0x4e,0x4a,0x29,0x01,0xc2,0x39,0xe9,0x00,0x42,0x4a,0x29,0x01,\n");
    printf("   0x5e,0x4a,0x26,0x01,0x00,0x00,0x00,0x00};\n");
    exit(0);
  }
					/* parse arguments */
  for(i = 0; i < strlen(argv[1]); i++) {
    if(*(argv[1]+i) == '!') {           /* pipe= argument separator */
      *(argv[1]+i) = 0;
      i++;
      switch(*(argv[1]+i)) {	        
	case 'i':                       /* inverse characters */
          inverse = 255;
          break;
        default:
          break;
      }
    }
  }


  if(argc>2 && !strcmp(argv[2],"-i")) inverse = 255;
 
					/* check to see if this program
 					   is being run by someone else. 
					   ot put an error if timeout */
  lock = fopen(lockfile,"r");
  tick = time(NULL);
					/* wait for lock file to go away */
  while(lock && timeout){
    while(tick == time(NULL)); /* wait one second */
    timeout--;
    tick = time(NULL);

    fclose(lock);			/* check the lock file */
    lock = fopen(lockfile,"r");
  }
  if(!timeout) {
    if(lock) fclose(lock);
    printf("Content-type: image/x-xbitmap\n\n");
    printf("#define error_width 26\n");
    printf("#define error_height 8\n");
    printf("static unsigned char error_bits[] = {\n");
    printf("   0x00,0x00,0x00,0x00,0xde,0x39,0xe6,0x00,0x42,0x4a,0x29,0x01,\n");
    printf("   0x4e,0x4a,0x29,0x01,0xc2,0x39,0xe9,0x00,0x42,0x4a,0x29,0x01,\n");
    printf("   0x5e,0x4a,0x26,0x01,0x00,0x00,0x00,0x00};\n");
    exit(0);
  }
  lock = fopen(lockfile,"w");
  if(lock) fclose(lock);

    

                                          /* open the hosts log file and
                                             add a line with the argument,
                                             the name of the host, and the
                                             name of the user if they are 
                                             available. */
  hosts = fopen(hostsfile,"a");
  if(hosts) {
    fprintf(hosts,"%s: ",argv[1]);
    if(getenv("REMOTE_HOST")) fprintf(hosts,"%s ",getenv("REMOTE_HOST"));
    if(getenv("REMOTE_USER")) fprintf(hosts,"[%s] ",getenv("REMOTE_USER"));
    fprintf(hosts,"\n");
    fclose(hosts);
  }
                                          /* open the linkss log file and
                                             add a line with the argument,
                                             and the name of the page that
                                             referenced this counter if it is
                                             available. */

  links = fopen(linksfile,"a");
  if(links) {
    fprintf(links,"%s: ",argv[1]);
    if(getenv("HTTP_REFERER")) fprintf(links,"%s ",getenv("HTTP_REFERER"));
    fprintf(links,"\n");
    fclose(links);
  }
					/* read in counter data */
  input = fopen(counterfile,"r");
  while(input && fgets(string,254,input)) {
    sscanf(string,"%s %ld",name,&number);
    if(number < 0) number = 0;
					/* check for argument match */
    if(!(strcmp(name,argv[1]))) {
      outnumber = number + 1;
      number ++;
    }
					/* create a link from name and # */
    if(!head) {
      head = (CLINK *)malloc(sizeof(CLINK));
      head->next = NULL;	
      lnk = head;
    }
    else {
      lnk->next = (CLINK *)malloc(sizeof(CLINK));
      lnk = lnk->next;
      lnk->next = NULL;	
    }
    lnk->name = (char *)calloc(strlen(name)+1,sizeof(char));
    strcpy(lnk->name,name);
    lnk->number = number;
  }  
					/* New link? make it! */
  if(!outnumber) {
    outnumber++;
    if(!head) {
      head = (CLINK *)malloc(sizeof(CLINK));
      head->next = NULL;
      lnk = head;
    }
    else {
      lnk->next = (CLINK *)malloc(sizeof(CLINK));
      lnk = lnk->next;
      lnk->next = NULL;
    }
    lnk->name = (char *)calloc(strlen(argv[1])+1,sizeof(char));
    strcpy(lnk->name,argv[1]);
    lnk->number = outnumber;
  }

  if(input) fclose(input);
						/* update the count list */
  output = fopen(counterfile,"w");
  if(output) {
    while(head) {
      fprintf(output,"%s %ld\n",head->name,head->number);
      head = head->next;
    }
    fclose(output);
  }
  						/* remove the lock file */
  sprintf(string,"rm %s",lockfile);
  system(string);

  printf("Content-type: image/x-xbitmap\n\n"); 
  makebitmapfromnumber(outnumber) ; 
}

