#include <stdio.h>
#include <stdlib.h>

void printbytes(long number);
int inverse = 0;

/** SOURCE BITMAP **
This is a slightly modified X11 bitmap.  It consists of the 10 numeric
digits stacked vertically.  The width and height defines are changed to
ints that reflect the size of individual digits.  ie:  each digit in this
map is 32 pixels wide and 40 pixels high.  The whole source bitmap is 32
pixels wide and 400 pixels high to accomodate the digits 0-9.  To make
things simpler, I just divide the width by 8 to convert the width into
bytes. If you decide to put your own map here, it is important that the
numbers be some multiple of 8 pixels wide or the output may not look quite
like you expect. */

int number_bytewidth=4;
int number_height=40;
unsigned char number_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0xf0,0x1f,0x00,0x00,0xfc,0xff,0x00,0x00,0xff,0xff,0x01,0xc0,0xff,
 0xff,0x07,0xe0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x1f,0xf0,0xff,0xff,0x1f,0xf8,
 0x0f,0xff,0x3f,0xf8,0x07,0xf8,0x3f,0xfc,0x07,0xf0,0x7f,0xfc,0x07,0xe0,0x7f,
 0xfc,0x03,0xc0,0x7f,0xfe,0x03,0xc0,0x7f,0xfe,0x03,0x80,0x7f,0xfe,0x03,0x80,
 0x7f,0xfe,0x03,0x80,0x7f,0xfe,0x03,0x80,0x7f,0xfe,0x03,0x80,0x7f,0xfe,0x03,
 0x80,0x3f,0xfe,0x07,0x80,0x3f,0xfe,0x07,0xc0,0x3f,0xfc,0x0f,0xc0,0x1f,0xfc,
 0x1f,0xc0,0x1f,0xfc,0x3f,0xe0,0x0f,0xf8,0x7f,0xf0,0x0f,0xf8,0xff,0xf3,0x07,
 0xf0,0xff,0xff,0x03,0xe0,0xff,0xff,0x03,0xc0,0xff,0xff,0x01,0x80,0xff,0xff,
 0x00,0x00,0xfe,0x7f,0x00,0x00,0xf0,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x20,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x3e,0x00,0x00,0x80,0x3f,
 0x00,0x00,0xc0,0x3f,0x00,0x00,0xf0,0x1f,0x00,0x00,0xfc,0x1f,0x00,0x00,0xff,
 0x1f,0x00,0x80,0xff,0x1f,0x00,0x80,0xff,0x1f,0x00,0x80,0xff,0x1f,0x00,0x80,
 0xf7,0x1f,0x00,0x80,0xf3,0x1f,0x00,0x80,0xf1,0x1f,0x00,0x80,0xf0,0x1f,0x00,
 0x00,0xf0,0x1f,0x00,0x00,0xf0,0x1f,0x00,0x00,0xf0,0x1f,0x00,0x00,0xf0,0x1f,
 0x00,0x00,0xf0,0x0f,0x00,0x00,0xf0,0x0f,0x00,0x00,0xf0,0x0f,0x00,0x00,0xf0,
 0x0f,0x00,0x00,0xf0,0x0f,0x00,0x00,0xf0,0x0f,0x00,0x00,0xf0,0x0f,0x00,0x00,
 0xf0,0x0f,0x00,0x00,0xf0,0x07,0x00,0x00,0xf8,0x07,0x00,0x00,0xf8,0x01,0x00,
 0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xfc,0x07,0x00,0x00,
 0xfe,0x0f,0x00,0x00,0xfe,0x1f,0x00,0x00,0xff,0x3f,0x00,0x80,0xff,0x3f,0x00,
 0xc0,0xff,0x7f,0x00,0xc0,0xff,0x7f,0x00,0x30,0xf8,0x7f,0x00,0x00,0xe0,0x7f,
 0x00,0x00,0xe0,0x7f,0x00,0x00,0xc0,0x7f,0x00,0x00,0xc0,0x3f,0x00,0x00,0xc0,
 0x3f,0x00,0x00,0xc0,0x1f,0x00,0x00,0xc0,0x1f,0x00,0x00,0xe0,0x0f,0x00,0x00,
 0xe0,0x07,0x00,0x00,0xf0,0x07,0x00,0x00,0xf0,0x03,0x00,0x00,0xf8,0x00,0x00,
 0x00,0x7c,0x00,0x00,0x00,0xfe,0x01,0x00,0x00,0xff,0xff,0x01,0x80,0xff,0xff,
 0x00,0xc0,0xff,0xff,0x00,0xe0,0xff,0xff,0x00,0xe0,0xff,0x7f,0x00,0x10,0xfc,
 0x3f,0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x80,0xff,0xff,0x00,0x80,0xff,0x7f,0x00,0x80,0xff,0x7f,0x00,0x80,0xff,
 0x3f,0x00,0xc0,0xff,0x1f,0x00,0xc0,0xff,0x1f,0x00,0xc0,0xff,0x0f,0x00,0xe0,
 0xff,0x0f,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x03,0x00,0x00,0xc0,0x03,0x00,
 0x00,0xe0,0x01,0x00,0x00,0xe0,0x01,0x00,0x00,0xf0,0x00,0x00,0x00,0xf0,0x03,
 0x00,0x00,0xf8,0x3f,0x00,0x00,0xfc,0x7f,0x00,0x00,0xfe,0x7f,0x00,0x00,0xfe,
 0x7f,0x00,0x00,0xff,0x7f,0x00,0x00,0xf0,0x7f,0x00,0x00,0xe0,0x7f,0x00,0x00,
 0xc0,0x7f,0x00,0x00,0xc0,0x7f,0x00,0x00,0xc0,0x3f,0x00,0x00,0xc0,0x3f,0x00,
 0x00,0xc0,0x3f,0x00,0x00,0xe0,0x1f,0x00,0x00,0xf0,0x0f,0x00,0x00,0xf8,0x07,
 0x00,0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x01,
 0x00,0x00,0xfe,0x01,0x00,0x00,0xfe,0x01,0x00,0x00,0xff,0x01,0x00,0x80,0xff,
 0x01,0x00,0x80,0xff,0x01,0x00,0xc0,0xff,0x01,0x00,0xe0,0xff,0x01,0x00,0xe0,
 0xff,0x01,0x00,0xf0,0xff,0x01,0x00,0xf0,0xff,0x01,0x00,0xf8,0xff,0x01,0x00,
 0x7c,0xff,0x01,0x00,0x3c,0xff,0x00,0x00,0x9e,0xff,0x00,0x00,0x8f,0xff,0x00,
 0x00,0x87,0xff,0x00,0x80,0x83,0xff,0x00,0xc0,0x81,0xff,0x00,0xc0,0x80,0xff,
 0x10,0xe0,0xff,0xff,0x1f,0xf0,0xff,0xff,0x1f,0xf0,0xff,0xff,0x0f,0xf8,0xff,
 0xff,0x0f,0xf8,0xff,0xff,0x07,0xfc,0xff,0xff,0x03,0xfe,0xff,0xff,0x00,0x00,
 0x80,0x7f,0x00,0x00,0x80,0x7f,0x00,0x00,0xc0,0x7f,0x00,0x00,0xc0,0x7f,0x00,
 0x00,0xc0,0x7f,0x00,0x00,0xc0,0x07,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x04,0x00,0xfe,0xff,0x07,0x00,0xfe,0xff,0x03,0x00,
 0xfe,0xff,0x01,0x00,0xfe,0xff,0x01,0x00,0xff,0xff,0x00,0x00,0xff,0x7f,0x00,
 0x00,0xff,0x3f,0x00,0x00,0xff,0x0f,0x00,0x00,0x07,0x00,0x00,0x80,0x03,0x00,
 0x00,0x80,0x03,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0xff,0x1f,0x00,0x80,0xff,
 0x3f,0x00,0xc0,0xff,0x3f,0x00,0xc0,0xff,0x7f,0x00,0xc0,0xff,0x7f,0x00,0xc0,
 0xff,0x7f,0x00,0xc0,0xff,0x7f,0x00,0x20,0xfc,0x7f,0x00,0x00,0xe0,0x7f,0x00,
 0x00,0xc0,0x7f,0x00,0x00,0xc0,0x3f,0x00,0x00,0xc0,0x3f,0x00,0x00,0xc0,0x3f,
 0x00,0x00,0xc0,0x1f,0x00,0x00,0xe0,0x0f,0x00,0x00,0xe0,0x0f,0x00,0x00,0xf0,
 0x07,0x00,0x00,0xf0,0x03,0x00,0x00,0xf8,0x01,0x00,0x00,0x7c,0x00,0x00,0x00,
 0x1f,0x00,0x00,0xc0,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x80,0x1f,0x00,0x00,0xf8,0x07,0x00,0x00,0xfc,0x03,0x00,0x00,0xfe,
 0x01,0x00,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0x00,0x80,0x7f,0x00,0x00,0xc0,
 0x7f,0x00,0x00,0xc0,0x7f,0x00,0x00,0xc0,0x3f,0x00,0x00,0xe0,0x3f,0x00,0x00,
 0xe0,0x3f,0x00,0x00,0xe0,0x3f,0x3f,0x00,0xf0,0xdf,0xff,0x00,0xf0,0xff,0xff,
 0x01,0xf0,0xff,0xff,0x03,0xf0,0xff,0xff,0x03,0xf0,0x9f,0xff,0x07,0xf0,0x1f,
 0xfe,0x07,0xf0,0x1f,0xfc,0x07,0xf0,0x3f,0xf8,0x07,0xf0,0x3f,0xf8,0x07,0xf0,
 0x3f,0xf8,0x07,0xe0,0x7f,0xf8,0x03,0xe0,0xff,0xf8,0x03,0xc0,0xff,0xfd,0x01,
 0xc0,0xff,0xff,0x00,0x80,0xff,0xff,0x00,0x00,0xff,0x7f,0x00,0x00,0xfe,0x3f,
 0x00,0x00,0xfc,0x1f,0x00,0x00,0xe0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0xff,0xff,0x0f,
 0x80,0xff,0xff,0x0f,0x80,0xff,0xff,0x07,0x80,0xff,0xff,0x07,0xc0,0xff,0xff,
 0x03,0xc0,0xff,0xff,0x03,0xe0,0xff,0xff,0x01,0xe0,0xff,0xef,0x01,0xe0,0xff,
 0xf0,0x00,0x10,0x00,0xf0,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x78,0x00,0x00,
 0x00,0x3c,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x1e,0x00,
 0x00,0x00,0x0f,0x00,0x00,0x00,0x0f,0x00,0x00,0x80,0x07,0x00,0x00,0x80,0x03,
 0x00,0x00,0xc0,0x03,0x00,0x00,0xc0,0x01,0x00,0x00,0xe0,0x01,0x00,0x00,0xf0,
 0x00,0x00,0x00,0xf0,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,
 0x1e,0x00,0x00,0x00,0x0f,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x03,0x00,0x00,
 0xc0,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x80,0x01,0x00,0x00,0xe0,0x1f,0x00,0x00,0xf8,0xff,0x00,0x00,
 0xfe,0xff,0x01,0x00,0xff,0xff,0x01,0x80,0xbf,0xff,0x03,0xc0,0x1f,0xfe,0x03,
 0xc0,0x1f,0xfc,0x03,0xc0,0x1f,0xf8,0x03,0xe0,0x3f,0xf8,0x03,0xe0,0x3f,0xf8,
 0x01,0xe0,0x7f,0xf8,0x01,0xe0,0xff,0xfd,0x00,0xc0,0xff,0x7f,0x00,0xc0,0xff,
 0x3f,0x00,0x80,0xff,0x3f,0x00,0x00,0xff,0x7f,0x00,0x00,0xfe,0xff,0x00,0x00,
 0xff,0xff,0x01,0xc0,0xef,0xff,0x03,0xe0,0x87,0xff,0x03,0xe0,0x07,0xff,0x03,
 0xf0,0x07,0xfe,0x03,0xf0,0x07,0xfe,0x03,0xf0,0x07,0xfe,0x01,0xf0,0x0f,0xfe,
 0x01,0xf0,0x1f,0xff,0x01,0xe0,0x3f,0xff,0x00,0xe0,0xff,0x7f,0x00,0xc0,0xff,
 0x3f,0x00,0x00,0xff,0x1f,0x00,0x00,0xfc,0x07,0x00,0x00,0xe0,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x3f,
 0x00,0x00,0xf8,0x7f,0x00,0x00,0xfe,0xff,0x00,0x00,0xff,0xff,0x01,0x80,0xff,
 0xff,0x03,0x80,0x7f,0xff,0x03,0xc0,0x7f,0xff,0x03,0xc0,0x3f,0xfe,0x07,0xe0,
 0x3f,0xfe,0x07,0xe0,0x3f,0xfc,0x07,0xe0,0x3f,0xfc,0x07,0xe0,0x3f,0xfc,0x07,
 0xe0,0x3f,0xfc,0x07,0xe0,0x7f,0xfc,0x07,0xe0,0x7f,0xfc,0x07,0xc0,0x7f,0xfc,
 0x07,0xc0,0xff,0xfc,0x03,0x80,0xff,0xff,0x03,0x00,0xff,0xff,0x03,0x00,0xfc,
 0xff,0x01,0x00,0xf8,0xff,0x01,0x00,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0x00,
 0x80,0x7f,0x00,0x00,0x80,0x7f,0x00,0x00,0xc0,0x3f,0x00,0x00,0xe0,0x1f,0x00,
 0x00,0xf0,0x0f,0x00,0x00,0xf0,0x07,0x00,0x00,0xf8,0x03,0x00,0x00,0xfc,0x00,
 0x00,0x00,0x3e,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

/**************************************************************************
  void makebitmapfromnumber(long number)

  DESCRIPTION:  Takes a number and makes an xbitmap from it

**************************************************************************/
void makebitmapfromnumber(long number)
{
  char numstring[30];
  int len,i,j,k,n,c=0;

  sprintf(numstring,"%ld",number);     /* convert to a string */
  len = strlen(numstring);             /* keep the length */
                                       /* Make digits real numbers */
  for(i = 0; i < len; i++) numstring[i] -= '0';  

  printf("#define numbers_width %d\n",number_bytewidth * 8*len);
  printf("#define numbers_height %d\n",number_height);
  printf("static char numbers_bits[] = {\n");


  for(j = 0; j < number_height; j++) { /* loop across scan lines */
    for(i = 0; i < len; i++) {         /* loop across numbers */
      for(k = 0; k < number_bytewidth; k++) { /* loop across bytes */
        n= number_bits[(numstring[i] * number_height + j)
                                  * number_bytewidth + k ] ^ inverse;
        if(n < 16) printf("0x0%x",n);
        else printf("0x%x",n);
	c++;
        if(!((j+1) == number_height && (i+1) == len && 
                (k+1) == number_bytewidth)) printf(",");
	if(!(c%14)) printf("\n");
      }
    }
  }
  printf("\n};\n");

}

