Copyright 1991 Patrick D. Scannell
Used by Permission

                       "Relativity"

                         PART ONE
 
Meanwhile, in another part of the forest, the top physicists
in the universe (plus a couple of programmers) struggle to
perfect "Dynamo Ada", the very thing on which the future of
the company hangs like a terminal.  The vice president of
the division has bicycled in for a conference with the scientists,
to be briefed on the progress of this critical
project.  (Later, he will attend a meeting of the board of
directors, where he will criticized on the progress of this
brief project.)
 
"How are things progressing?"
 
"Well, not so hot.  We have in fact produced an Ada a
zillion times faster (approximately) than any previously seen, but
there is a slight technical glitch when we actually try to run it."
 
"What kind of glitch?"
 
"Well, it has to do with the Theory of Relativity.  The new Ada
compiler is so fast that it begins to approach the speed of
light."
 
"Are you fellows trying to befuddle me with technical jargon?"
 
"Oh, no sir.  You're befuddled enough to suit us just as you
are.  Now as I was saying, when something begins to approach the
speed of light, there are some relativistic effects.  The mass of
an object is affected, but more importantly time begins to run
slower.  The effect, which is called time dilation, has never been
used in any commercial product except ketchup."  The Vice President was
now beginning to show great interest -- not in the scientist's
explanation, but in a piece of lint on the sleeve of his jacket.
 
"For instance, if a rocket travels to another star at nearly the
speed of light, the trip might seem to take a hundred years to an
external observer, but the occupants of the rocket would only
perceive it as having taken ten years, and would only age ten
years."  The Vice President was nodding now.  Soon he would be
completely asleep.
 
They entered the next room, where a programmer sat before a
terminal, completely immobile.  He did not even appear to be
breathing.  "This man is compiling a five-million-line program
using Dynamo Ada.  From his point of view, the compilation takes
forty-two seconds.  But for an external observer, like us, almost
two days have passed."
 
"Very interesting, very interesting," said the Vice President.  "Is it
time for lunch yet?"

                         PART TWO
                    (two years later)

Scene: the same research installation.  The Vice
President of Bizarre Products Development has arrived to discuss
a matter of great importance.  He is met by Zeke Einstein, a
double Ph.D. in Quantum Physics and Computer Science, who escorts
him into the building.
 
"I was afraid you wouldn't be here," says the V.P.  "I thought
the company had stopped doing pure research."
 
"Oh, we don't do pure research here.  We do 80% research and 20%
playing practical jokes on each other."
 
"By the way, what on earth have you got all over your forehead?"
 
"We'll get to that.  Over there is Biff Einstein.  He's our top
man in computer relativity."
 
"Is everybody here named Einstein?"
 
"No, but whenever we get a chance to hire a physicist named
Einstein, we do it, just to be on the safe side.  Over here is
Bill Blooper.  He's the Director of the research center."
 
"Guten tag," said Blooper.  "Ich bin Ein Stein."
 
"Einstein?  I thought you said his name was Blooper!"
 
"His NAME is Blooper, but he thinks he's a German beer mug.  He's
completely mad, of course, but that's just what it takes to stay on
the cutting edge of today's fast-moving technology.  Now, you wanted
to talk about relativistic computer technology?"
 
"Yes.  I don't know too much about it, so I'd appreciate it if
you'd fill me in."
 
"I thought your organization had already developed a product
based on the technology.  That was almost three years ago, wasn't
it?"
 
"That's true, but I wasn't in charge when it started, so I'm not
clear on all the concepts.  The only engineer who really
understands it is currently finishing up the Unit Test, so
naturally he's a bit difficult to talk to right now ..."
 
"Well, let me start at the beginning.  You're aware of the fact
that all data is composed of quantum particles, which sometimes
act like waves, in a manner similar to photons?"
 
"You mean bits?"

"Well, not quite.  The particulate nature of data means that
you can never have one and a half bits of information; it has
to come in quantum-sized packets.  The term "bit" refers to
the measure of information, but the subatomic particles
themselves are generally called logons or offons.  Now, the fact
is that logons travel at the same speed as light.  For instance,
when data is passed through a wire, even though the individual
electrons propogate along the wire very slowly, the data itself
moves at light speed."
 
"That doesn't sound reasonable."
 
"Well, I can demonstrate it to you quite easily.  Here, hold this
wire."
 
"What are you -- Yow!  You gave me a shock!"
 
"Well, yes, of course.  But how FAST did you get it?  One of the
new technologies we're investigating is the possible
existence of an anti-logon particle.  If it exists, we would be
able to construct retroactive memory chips with an access time of
up to negative 30 microseconds."
 
"And if such a particle doesn't it exist?"
 
"Well, we'll have to invent one.  That will more expensive,
of course."
 
"I don't seem to be getting all this."
 
"Well, of course not.  As I said, information particles behave a
lot like photons.  For instance, a mirror reflects almost all of
the light that hits it, whereas a black surface absorbs almost
all of it.  In the same way, different materials reflect or
absorb data particles at different rates.  The human head, we have
found, is one of the most perfect data reflectors in the universe.
However, just let me put some of this data-absorbing paint on your
head and you'll begin to understand me much better."
 
"Careful.  This is a brand new suit."
 
"Oh, it washes right out, don't worry.  Now, I was saying that
with an anti-logon particle we would be able to construct memory
devices with negative access times."
 
"There would have to be some programming changes there, to allow
for reading data out before it's been written."
 
"Now you're getting it."
 
"Can I have some of this paint to take back with me?  I know some
people who could use it."

"Of course.  That reminds me.  One other thing I've been warning
people about. We're now entering an era where gigabytes of memory
are not uncommon."
 
"Yes?"
 
"We're not certain yet, but we're afraid that a large enough
gathering of logons in very close proximity may cause it to reach
critical mass."
 
"What happens then?"
 
"We don't know.  It could mean another Big Bang.  Or the
formation of some sort of object similar to a black hole, from
which no data ever escapes."
 
"But what about relativistic programming?  We're getting off the
subject."
 
"Well, the thing of it is that at a high enough computational
speed, you get effects similar to those produced by an object
moving at close to light speed.  Time dilation and so forth."
 
"That's why it's taking so long for this Unit Test phase, as I
understand it."
 
"Exactly.  To the tester himself, things seem to be going along
quite quickly.  But to an outside observer, it seems to be moving
very slowly.  Time proceeds at different rates.  Probably the
developer himself appears smaller."
 
"Well, I didn't know him before, but these days he's about two
feet tall, so I suppose you're right.  Anyway, what I came here
to discuss is the possibility of producing more products using
the technology."
 
"Why would you want to, if you can't get them out the door?"
 
"Well, the customers seem to be impressed with them, as long as
they're affected by this relativity thing.  The only real problem
has been test time.  And we think we have a solution to that."
 
"Yes?"
 
"Rigorous code inspections.  If we remove all the defects by
inspection, we don't have to do much testing, and we can ship the
products the same century we build them.  Do you see any potential
problems with that?"
 
"Well, the Heisenberg Uncertainty Principle would seem to imply
that, if you know the value assigned to a logon, it may be
impossible to determine for certain that a program assigns the
value you wanted."

"But does the Heisenberg Uncertainty Principle apply to data
particles?"
 
"I'm not certain."
 
"Is there anything else you want to tell me?"
 
"No.  Let me know how you make out with your new products."
 
"Certainly.  And let me know when you find an anti-logon."
 
"Actually, since it will allow us to print and mail the report
before we write it, you may know about it before we do."
 
"That's enough.  I've got to get back to the office."
 
                             THE END
