Date: Tue, 19 Jun 90 18:28 EDT
Subject: RE: [NOTJDN%LSUVM.BITNET@psuvm.psu.edu: OTA]
X-Vms-To: MAILER%"rms@ai.mit.EDU"

This article by Brian Kahin appears in the April 1990 issue of
Technology Review (Building W59, MIT, Cambridge MA 02139,
(617)253-8250).  It may be copied for noncommercial purposes
provided that it is copied, along with this statement and the bio
at the end of the article, without any modification whatsoever. 
(Copyright (C) 1990 by Brian Kahin) 


                   The Software Patent Crisis


     An explosion of patents on software processes may radically
     change the programming industry--and our concept of human
     expression in the computer age.


Last August, Refac International, Ltd., sued six major
spreadsheet publishers, including Lotus, Microsoft, and Ashton-
Tate, claiming they had infringed on U.S. Patent No. 4,398,249. 
The patent deals with a technique called "natural order recalc,"
a common feature of spreadsheet programs that allows a change in
one calculation to reverberate throughout a document.  Refac
itself does not have a spreadsheet program and is not even in the
software industry.  Its business is acquiring, licensing, and
litigating patents.

Within the last few years, software developers have been
surprised to learn that hundreds, even thousands, of patents have
been awarded for programming processes ranging from sequences of
machine instructions to features of the user interface.  Many of
the patents cover processes that seem conventional or obvious,
and developers now fear that any of the thousands of individual
processes in their programs may be subject to patent-infringement
claims.

The Refac suit demonstrates the vulnerability of the industry to
such claims.  Patent no. 4,398,249 was applied for in 1970,
granted in 1983, and only recently acquired by Refac.  In the
meantime, software developers have been busily creating
spreadsheets and other new products unmindful of patents.  The
industry accepted copyright and trade secret as adequate
protection for its products, and most programmers assumed that
patents were not generally available for software.

Never before has an industry in which copyright was widely
established suddenly been subjected to patenting.  As it is, only
a few companies that create microcomputer software have the
resources to try to defend against patent infringement claims. 
Most small firms will be forced to pay license fees rather than
contest the claims, even though many software patents may not
stand up in court.

In the long run, the costs of doing business in a patent
environment will radically restructure the industry.  Many small
companies will fold under the costs of licensing, avoiding patent
infringement, and pursuing patents defensively.  The individual
software entrepreneur and inventor may all but disappear.  There
will be fewer publishers and fewer products, and the price of
software will rise to reflect the costs.

Especially disturbing is that the broad claims of many recent
software patents appear to establish monopolies on the automation
of such common functions as generating footnotes and comparing
documents.  Some claims even cover processes for presenting and
communicating information, raising troubling questions about the
effect of patents on the future of computer-mediated expression.


Patent vs. Copyright

Software patents, like all patents, give an inventor the right to
exclude all others from making, selling, or using an invention
for 17 years.  In return, the patentee discloses his or her "best
method" of implementing the invention, thereby relinquishing
trade secrets that might otherwise be enforced forever (like the
formula for Coca-Cola).

To obtain a patent, an applicant must convince Patent Office
examiners that the invention would not be obvious to a "person of
ordinary skill in the art" who is familiar with all the "prior
art," which includes previous patents and publications.  In
contrast, copyright inheres in books, poems, music, and other
works of authorship, including computer programs, from the moment
they are created.  Registering one's work with the Copyright
Office is a simple, inexpensive procedure that has important
benefits (it is a precondition for filing suit, for example), but
the copyright itself is automatic when the work is fixed on paper
or on disk.

Copyright and patent protect different things.  Copyright
protects expression but not underlying ideas.  Patents protect
useful processes, machines, and compositions of matter. 
Traditionally "processes" have included methods of physically
transforming materials but not business methods or mental steps. 
Thus, computer programs fall somewhere between the traditional
territories of copyright and patent.

>From the 1960s to the early 1980s, the Patent Office and the
courts grappled with the question of whether algorithms--the
elemental processes on which computer programs are built--are
patentable as either processes or machines.  Early on, the
Patent Office granted some patents for processes built into
computer hardware that today would be contained in software, but
it was reluctant to grant patents for programs per se.  As the
1966 Report of the President's Commission on the Patent System
pointed out, the Patent Office had no system for classifying
programs.  The report also noted that even if this were remedied,
the volume of programs being created was so enormous that
reliable searches of "prior art" would not be feasible or
economical.

However, the Court of Customs and Patent Appeals (CCPA)
maintained that computer programs were patentable and overturned
numerous Patent Office decisions denying patentability.  The
Supreme Court vindicated the Patent Office in two decisions,
Gottschalk v. Benson (1972) and Parker v. Flook (1978), holding
that mathematical algorithms were not patentable subject matter. 
Still, the CCPA continued to uphold patentability in other cases. 
Finally, in Diamond v. Diehr (1981), a sharply divided Supreme
Court upheld the patentability of a process for curing rubber
that included a computer program.  The majority concluded that
programs that did not preempt all uses of a computer algorithm
could be patented--at least when used in a traditional process
for physically transforming materials.

That case has been the Supreme Court's last word on the subject. 
But despite the narrowness of the ruling, the Patent Office
underwent a radical change of heart.  Until very recently, there
were no reported appeals of adverse Patent Office decisions,
leading observers to conclude that the office was eventually
granting almost all applications for software patents.  Although
articles began appearing in legal periodicals a few years ago
noting that patents were being routinely granted for many
software processes, not until 1988 did the industry realize that
the rules were changing, or had already changed, in the middle of
the game.  By the spring of 1989, the patents that entered the
pipeline after Diamond v. Diehr were starting to flow out in
significant numbers--by one count, nearly 200 in the first four
months of that year.


Processing Problems

Unfortunately, the Patent Office classification system remains
unchanged, and the volume of software being created has grown
exponentially.  This makes searching for prior art--processes
already in public use--time-consuming and expensive.

The search is extraordinarily difficult because the field's
printed literature is thin and unorganized.  Software documents
its own design, in contrast to physical processes, which require
written documentation.  Also, software is usually distributed
without source code under licenses that forbid reverse
engineering.  This may amount to suppressing or concealing the
invention and therefore prevent the program from qualifying as
prior art.  The search for prior art may require securing oral
testimony from people who developed software at universities many
years ago, an expensive proposition.

Many programmers suspect that patent examiners lack knowledge of
the field, especially since the Patent Office does not accept
computer science as a qualifying degree for patent practice (it
accepts degrees in electrical engineering).  Moreover, attracting
and holding individuals with expertise in a field like software,
where industry demand is high, is not easy for a government
agency.  Less qualified examiners create problems because they
naturally have a lower standard in determining the hypothetical
"person having ordinary skill in the art," and are thus more apt
to grant patents for obvious processes.  Since the examination
process is conducted ex parte (as a private matter between the
Patent Office and the applicant), less qualified personnel are
also more likely to be influenced by sophisticated patent
attorneys and the apparent expertise of the applicant.

The quality of software patents being awarded has aroused
concern even among patent lawyers and other advocates of the new
regime.  But it will be left to firms being sued for infringement
to prove that a process should not have been patented because it
was obvious in view of the prior art.  Meanwhile, software
patents stand as intimidating weapons for those who hold them.


Restructuring the Industry

Perhaps because of some of these problems, applications for
software patents take an average of 32 months to be approved and
published.  That's significantly longer than the overall average
of 20 months, and a very long time given the short product cycles
of the software business.

Unlike copyright, independent creation is irrelevant to patent
infringement.  Every developer is charged with knowledge of all
patents.  Even if someone is not aware of a patent, he or she can
still infringe against it.  Furthermore, patent applications and
the examination process are confidential, so there are ordinarily
several years of patents in the pipeline that no search will
reveal.  Although no infringement occurs until the patent issues,
an inventor may find that a newly awarded patent covers a feature
he or she has already incorporated and marketed in a finished
product.  While this is a problem for the patent system as a
whole, it is intolerable for software developers because of the
industry's rapid pace of innovation and long patent-processing
period.

The problem is compounded by the fact that a modern software
package may contain thousands of separately patentable processes,
each of which adds to the risk of infringing patents that are
already in the pipeline.  Since software functions are
interdependent and must be carefully integrated, developers can
find it difficult to excise a process built into the original
program.

The patent system exacts a high penalty in an industry as
decentralized as software.  Programming requires no special
materials, facilities, or tools: to design software is to build
it.  Because barriers to entry are low, the industry attracts
many small players, including hundreds of thousands of
individuals who work as consultants or short-term employees. 
Rather than a handful of competitors working on the same problem,
there are likely to be dozens, hundreds, even thousands.  Since
under the patent system one winner takes all, many 
others--including developers without lawyers--are deprived of
the fruits of their independent labor and investments.

Patent proponents argue that this uninhibited duplication of
effort wastes resources.  But the "waste" could be cut only by
reducing the number of players and slowing the pace of
development to fit the cycles of the patent system.  The result
would be a handful of giants competing on a global scale, bidding
for the ideas and loyalty of inventive individuals.

However, many programmers believe that there are diseconomies of
scale in software development--that the best programs are
authored rather than assembled.  The success of Visicalc, Lotus 
1-2-3, WordPerfect, and other classic programs testifies to the
genius of individuals and small teams.  Certainly there has been
no evidence that they need more incentives.  Quite the contrary,
the freewheeling U.S. software industry has been a model of
creative enterprise.


A Costly System

Even software developers and publishers who do not wish to patent
their products must bear the costs of operating under a patent
system.  While these costs may initially come out of the software
industry's operating margins, in the long run, they will be borne
by users.

At the first level is the expense of analyzing prior art to avoid
patent infringement.  A precautionary search and report by
outside patent counsel can run about $2,000--that's per process,
not per program.

Next are the direct costs of the patent monopoly--the license
fees that must be paid to patent holders.  If the patent holder
refuses to license at a reasonable fee, developers must design
around the patent, if that is possible.  Otherwise, they must
reconceive or even abandon the product.

The third set of costs are those incurred in filing for patents. 
Searching for prior art, plus preparing, filing, negotiating, and
maintaining a patent, can total $10,000 to $25,000, not including
internal staff time.  Seeking foreign patents can make the bill
substantially higher.

The notoriously high costs of patent litigation must be borne by
both sides.  Just the discovery phase of a lawsuit is likely to
cost each side a minimum of $150,000, and a full trial can cost
each from $250,000 to millions.  Again, these figures do not
include internal staff time, which could easily double the real
cost.  While a small patent holder may be able to secure a law
firm on a contingency basis or sell an interest in the patent to
speculators, the defendant has no such options.

Litigation also involves the possibility and further expense of
an appeal.  All appealed patent cases now go directly to the
Court of Appeals for the Federal Circuit (CAFC, successor to the
CCPA), where panels in patent cases are usually led by patent
lawyers turned judges.  Whereas patents once fared poorly on
appeal, the CAFC has found patents to be both valid and infringed
in over 60 percent of the cases that have come before it.  The
CAFC has greatly strengthened the presumption of patent validity
and upheld royalties ranging from 5 to 33 percent.

While a large software company may be able to absorb these costs,
they will disproportionately burden smaller companies.  The first
to suffer will be independent developers who cannot afford to
market their own products.  These developers typically receive
royalties of 10 to 15 percent from publishers who serve as their
distributors.  Such modest margins, out of which developers must
recoup their own costs, would be wiped out by the need to pay
royalties to a few patent holders.

The high costs of a patent environment give patentees
considerable leverage over small firms who will, as a practical
necessity, pay a license fee rather than contest a dubious claim. 
To establish credibility, the patentee will settle for small fees
from the initial licensees.  The patent holder can then move on
to confront other small firms, pointing to such licensings as
acknowledgments of the patent's validity and power.  This tactic
has a snowballing effect that can give the patent holder the
momentum and resources to take on larger companies.

Cross-licensing--where firms secure patents to trade for the
right to other patents--seems to work reasonably well in many
industries and has been touted as the answer to these problems. 
However, cross-licensing is of little value to smaller companies,
which have little to bring to the table.  And cross-licensing may
prove of limited value even to large companies, since it does not
protect against companies like Refac that have no interest in
producing software and therefore no need to cross-license.

Of course, the power that software patents afford may induce some
venture capitalists to invest in them.  But investing in software
patents is one thing; investing in robust, complex products for a
mass market is another.

In fact, software publishers hold very few patents.  The vast
majority are held by large hardware companies, computer
manufacturers that have in-house patent counsel and considerable
experience in patenting and cross-licensing.  Nearly 40 percent
of the software patents that the U.S. Patent and Trademark Office
now issues go to Japanese hardware companies.  It is quite
possible that the separate software publishing industry may cease
to exist as companies find that they need the patent portfolios
and legal resources that the hardware giants can provide.  The
result will be a loss of diversity in software products, reduced
competition, and, many believe, a less productive software
industry.


Protecting Ideas and Information

A deeper, more disturbing problem in patenting programs was
barely evident before computers became ubiquitous personal tools
and software became infinitely versatile.  More than a
"universal machine," the computer has developed into a medium for
human expression and a mediator of human experience.  Software is
designed to satisfy specific needs for shaping and delivering
information.  Thus, what is increasingly at stake in software
patents is the generation and flow of information.  This becomes
more threatening when the claims in a patent extend far beyond
the disclosed means of implementation to cover general ideas.

Broad patent claims covering abstract processes are not limited
to software, or even to computer hardware.  Consider patent no.
4,170,832, granted in 1979 for an "interactive teaching machine." 
The patent discloses a clumsy-looking combined videotape deck and
television with a set of push buttons.

The patent includes a process claim for a procedure commonly used
in interactive video: showing an introductory video segment,
presenting the viewer with a limited number of choices,
registering the viewer's decision, and then revealing the likely
outcome of that decision.  The disclosed machine, which was never
marketed, contributes nothing to the public domain: it simply
reveals one person's way of implementing a basic instructional
technique.

In a notorious 1983 case, a federal district court upheld the
patentability of Merrill Lynch's Cash Management Account system,
a procedure for moving investment funds among different types of
accounts.  Acknowledging that the system--essentially a method of
doing business--would not be patentable if executed with pencil
and paper, the court nevertheless upheld the patent because it
made use of a computer.

The Patent Office has taken this principle one step further. 
Besides granting monopolies on new procedures such as the Cash
Management Account system, the office is also awarding patents
merely for automating familiar processes such as generating
footnotes (patent no. 4,648,067) and comparing documents (patent
no. 4,807,182).  But software developers have been routinely
automating such common office functions, bookkeeping procedures,
learning strategies, and modes of human interaction for years. 
The principle that patents are granted to induce inventors to
disclose trade secrets has no relevance here.  These processes
are part of everyday life, and can and should be computerized in
a number of ways.

What's more, information per se is traditionally the substance
and territory of copyright.  The intelligent ordering of
information is the very heart of grammar, rhetoric, and graphic
design.  

Why should information be subject to the pervasive restraints of
patent simply because it is interactive rather than linear? 
Should human expression that is assembled, communicated, or
assimilated with the aid of a computer be restrained by patents? 
If the computer is seen as an extension of the human mind rather
than vice versa, the answer is no.


Changing Patent Policy

Software developers who understand the impact of patents are
demoralized.  Lawyers assure them that patents are here to stay,
and that programmers must seek new patents to protect against
other patents.  These lawyers point to the growing torrent of
software patents, the presumption of patent validity, and the
fervidly pro-patent record of the Court of Appeals for the
Federal Circuit.  Smaller companies that cannot afford this
advice can only hope that companies with deeper pockets will
afford more visible and attractive targets for patent holders
bringing suit.

But the narrowness of the Supreme Court decision in Diamond v.
Diehr remains.  The Court never explicitly rejected the
traditional doctrines against the patentability of mental steps
and business methods, doctrines that may yet defeat many of the
patents that have issued.  If the hue and cry grows, Congress
could amend the Patent Act to make it clear that the scope of
patenting is still limited to physical processes.

The software industry was not broke, but it is in the process of
being "fixed."  The question is whether the fixing will be done
by the gush of awards from private proceedings in the Patent 
Office--or by a public decision about whether software patents
serve "to promote the Progress of Science and useful Arts," as
the Constitution requires.

---------------

Brian Kahin is an attorney specializing in information technology
and policy.  An adjunct research fellow in the Science,
Technology and Public Policy Program at Harvard University's
Kennedy School of Government, he was formerly affiliated with the
MIT Research Program on Communications Policy and the MIT
Communications Forum.  He is a graduate of Harvard College and
Harvard Law School.................................

