/*
The programs contained herein are adapted from 
Artificial Intelligence Using C by
Herbert Schildt published by Osborne/McGraw-Hill, Copyright
1987, Osborne/McGraw-Hill.  Used with the permission of
Osborne/McGraw-Hill.  Program adaptations are solely the
work of Herbert Schildt and are not a publication of
Osborne/McGraw-Hill.
*/


listing 8-1
/* Logical transformation program for
   DeMorgan's laws
*/

char input[80];
char token[80];

char *p_pos;

main()
{
  for(;;) {
    printf(": ");
    gets(input);
    if(!*input) break;
    p_pos=input;
    transform();
  }
}

/* do the transformations */
transform()
{
  char p[80],q[80],s[4];
  char is_and;

  /* try DeMorgan's theorems */
  /* first, try form:

     not(p or q) ==> not p and not q

  */
  get_token();
  if(!strcmp(token,"not")) {
    get_token();
    if(*token=='(') {
      get_token();
      strcpy(p,token);
      get_token();
      if(!strcmp(token,"and")) is_and=1;
      else is_and=0;
      get_token();
      strcpy(q,token);
      get_token();
      if(*token==')') { /* is a DeMorgan expression */
        if(is_and) strcpy(s,"or");
        else strcpy(s,"and");
        printf("not %s %s not %s\n",p,s,q);
        return;
      }
    }
  }
  /* now try reverse transformation of form

     not p or not q ==> not(p and q)

  */
  p_pos=input; /* reset */
  get_token();
  if(!strcmp(token,"not")) {
    get_token();
    strcpy(p,token);
    get_token();
    if(!strcmp(token,"and")) is_and=1;
    else is_and=0;
    get_token();
    if(!strcmp(token,"not")) {
      get_token();
      strcpy(q,token);
      if(is_and) strcpy(s,"or");
      else strcpy(s,"and");
      printf("not (%s %s %s)\n",p,s,q);
    }
  }
}

/* return a token from the input stream */
get_token()
{
  char *p;

  p=token;
  /* skip spaces */
  while(*p_pos==' ') p_pos++;
 
  if(*p_pos=='\0') {  /* is end of input */
    *p++='\0';
    return;
  }
  if(is_in(*p_pos,"()")) {
    *p=*p_pos;
    p++, p_pos++;
    *p='\0';
    return;
  }

  /* read word until */
  while(*p_pos!=' ' && !is_in(*p_pos,"()"))  {
    *p=*p_pos++;
    p++;
  }
  *p='\0';
}

is_in(c,s)
char c,*s;
{
  while(*s) {
    if(c==*s) return 1;
    s++;
  }
  return 0;
}

 





listing 8-2

/* fuzzy logic analizer */

char expr[80];
char token[80];
char *p_pos;

main()
{
  int result;

  for(;;) {
    printf("enter expression: ");
    gets(expr);
    if(!*expr) break;
    p_pos=expr;
    analize(&result);
    printf("answer is: ");
    switch(result) {
      case 1: printf("true\n");
	      break;
      case 0: printf("false\n");
              break;
      case 'u': printf("unknown\n");
              break;
    }
  }
}

analize(result)
int *result;
{
  get_token();
  if(!*token) {
    serror(2);
    return;
  }
  level1(result);
}

/* logic parser */

level1(result)
int *result;
{
  register char  op;
  int hold;

  level2(result);
  while((op = *token) == '|') {
    get_token();
    level2(&hold);
    determine(op,result,&hold);
  }
}

level2(result)
int *result;
{
  int hold;
  char op;

  level3(result);
  while((op=*token)== '&') {
    get_token();
    level3(&hold);
    determine(op,result,&hold);
  }
}

level3(result)
int *result;
{
  register char  op;

  op = 0;
  if(*token == '!') {
    op='!';
    get_token();
  }
  level4(result);
  if(op)
    determine(op,result,result);
}

level4(result)
int *result;
{
  if((*token == '(')) {
    get_token();
    level1(result);
    if(*token != ')')
      serror(1);
    get_token();
  }
  else
    primitive(result);
}

primitive(result)
int *result;
{
  register int i;

  if(is_in(*token,"01u")) {
    if(*token=='u') *result='u';
    else *result=atoi(token);
    return   get_token();
  }
  serror(0);  /* otherwise syntax error in expression */
}


determine(o,r,h)
char o;
int *r,*h;
{
  register int t,ex;
  switch(o) {
    case '&':
     if(*r!='u' && *h!='u') {
        *r=*r && *h;
        return;
      }
      if(*r=='u' && *h==0) *r=0;
      else if(*r==0 && *h=='u') *r=0;
      else *r='u';
      break;
    case '|':
      if(*r!='u' && *h!='u') {
        *r=*r || *h;
        return;
      }
      if(*r==1 || *h==1) *r=1;
      else *r='u';
      break;    
    case '!':
      if(*r!='u') *r=!*r;
      else *r='u';
      break;
  }
}

serror(error)
int error;
{
  static char *e[]= {   
      "syntax error",
      "unbalanced parentheses",
      "no expression present"
  };
  printf("%s\n",e[error]);
}


get_token()
{
  char *p;

  p=token;
  /* skip spaces */
  while(*p_pos==' ') p_pos++;
 
  if(*p_pos=='\0') {  /* is end of input */
    *p++='\0';
    return;
  }
  if(is_in(*p_pos,"()|&!")) {
    *p=*p_pos;
    p++, p_pos++;
    *p='\0';
    return;
  }

  /* read word until */
  while(*p_pos!=' ' && !is_in(*p_pos,"()&|!"))  {
    *p=*p_pos++;
    p++;
  }
  *p='\0';
}

is_in(c,s)
char c,*s;
{
  while(*s) {
    if(c==*s) return 1;
    s++;
  }
  return 0;
}






listing 8-3

struct attribute {
  char attrib[80];
  float prob;  /* probability assoc with attribute */
  struct attribute *next; /* use linked list */
} at;  






listing 8-4
/* input an object and its list of attributes */
enter()
{
  int t,i;
  struct attribute *p, *oldp;

  for(;;) {
    t=get_next(); /* get the index of the next
       available object in k_base */
    if(t==-1) {
      printf("Out of list space.\n");
      return;
    }
    printf("Object name: ");
    gets(k_base[t].name);

    if(!*k_base[t].name) {
      l_pos--;
      break;
    }

    p=(struct attribute *) malloc(sizeof(at));
    if(p=='\0') {
      printf("Out of memory.\n");
      return;
    }
    k_base[t].alist=p;
    for(i=0;i<sizeof(p->attrib);i++) p->attrib[i]=' ';
    printf("Enter attributes (RETURN to quit)\n");
    for(;;) {
      printf("attribute: ");
      gets(p->attrib);
      if(!p->attrib[0]) break;
      printf("probability: (0-1): ");
      scanf("%f",&p->prob);
      getchar(); /* through away crfl */
      oldp=p;
      p->next=(struct attribute *) malloc(sizeof(at));
      if(p->next=='\0') {
        printf("Out of memory.\n");
        return;
      }
      p=p->next;
      p->next='\0';
      for(i=0;i<sizeof(p->attrib);i++) p->attrib[i]=' ';
    } 
    oldp->next='\0';
  }
}






listing 8-5
/* try an object */
try(p,ob)
struct attribute *p;
char *ob;
{
  char answer;
  struct attribute *a,*t;

  if(!trailno(p,ob)) return 0;

  if(!trailyes(p,ob)) return 0;

  while(p) {
    /* if already been asked then move on to next
       attribute 
    */
    if(ask(p->attrib)) {
      printf("is/does/has it %s? ",p->attrib);
      answer=tolower(getche());
      printf("\n");

      a=(struct attribute *) malloc(sizeof(at));
      if(!a) {
        printf("out of memory\n");
        return;
      }
      a->next='\0';
      switch(answer) {
        case 'n':
          strcpy(a->attrib,p->attrib);
          if(!no) {
            no=a;
            nonext=no;
          }
          else {
	    nonext->next=a;
            nonext=a;
          }
          reject(ob,p->attrib,'n');
	  /* reject if prob >= 50% */
          if(p->prob>=0.5) return 0;
        case 'y':
          strcpy(a->attrib,p->attrib);
          if(!yes) {
            yes=a;
            yesnext=yes;
          }
          else {
            yesnext->next=a;
            yesnext=a;
          }
	  compute_prob(p->prob);
          p=p->next;
          break;
        case 'w': /* why? */
	  reasoning(ob);
          break;
      }
    }
    else p=p->next;
  }
  return 1;
}

/* see if it has any attributes known not
   to be part of the object by checking the no list */
trailno(p,ob)
struct attribute *p;
char *ob;
{
  struct attribute *a,*t;

  a=no;
  while(a) {
    t=p;
    while(t) {
      if(!strcmp(t->attrib,a->attrib)) {
        reject(ob,t->attrib,'n');
        if(t->prob>=0.5) return 0;  /* reject only if
				       high prob */
      }
      t=t->next;
    }
    a=a->next;
  }
  return 1;
}






listing 8-6

compute_odds(f)
float f;
{
   prob*=f;
}






listing 8-7


/* A probabilistic expert system that finds multiple
   goals and displays reasoning using classical
   probability theory */

#include "stdio.h"
#include "malloc.h"

#define MAX 100

struct attribute {
  char attrib[80];
  float prob;  /* probability assoc with attribute */
  struct attribute *next; /* use linked list */
} at;  

struct object {
  char name[80];
  struct attribute *alist; /* pointer to list of attributes */
} ob;

struct rejected_object {
  char name[80];
  char attrib[80]; /* attribute that caused rejection */
  char condition;  /* did it need it or shouldn't it
		      have been found?  */
} rj;
struct rejected_object r_base[MAX];

struct object k_base[MAX];  /* holds the knowledge base */
int l_pos=-1;  /* location of top of k base */
int r_pos=-1;  /* location of top of reject base */

struct attribute *yes,*no;  /* used for yes and no lists */
struct attribute *yesnext, *nonext;

float prob; /* holds the probability of the current 
	       solution */

main()
{
  char ch;

  no=yes='\0';
  do {
    free_trails();
    ch=menu();
    switch(ch) {
      case 'e': enter();
        break;
      case 'q': query();
        break;
      case 's': save();
        break;
      case 'l': load();
    }

  } while (ch!='x');
}

free_trails()
{
  struct attribute *p;

  while(yes) {
    p=yes->next;
    free(yes);
    yes=p;
  }

  while(no) {
    p=no->next;
    free(no);
    no=p;
  }
  r_pos=-1;
}

/* input an object and its list of attributes */
enter()
{
  int t,i;
  struct attribute *p, *oldp;

  for(;;) {
    t=get_next(); /* get the index of the next
       available object in k_base */
    if(t==-1) {
      printf("Out of list space.\n");
      return;
    }
    printf("Object name: ");
    gets(k_base[t].name);

    if(!*k_base[t].name) {
      l_pos--;
      break;
    }

    p=(struct attribute *) malloc(sizeof(at));
    if(p=='\0') {
      printf("Out of memory.\n");
      return;
    }
    k_base[t].alist=p;
    for(i=0;i<sizeof(p->attrib);i++) p->attrib[i]=' ';
    printf("Enter attributes (RETURN to quit)\n");
    for(;;) {
      printf("attribute: ");
      gets(p->attrib);
      if(!p->attrib[0]) break;
      printf("probability: (0-1): ");
      scanf("%f",&p->prob);
      getchar(); /* through away crfl */
      oldp=p;
      p->next=(struct attribute *) malloc(sizeof(at));
      if(p->next=='\0') {
        printf("Out of memory.\n");
        return;
      }
      p=p->next;
      p->next='\0';
      for(i=0;i<sizeof(p->attrib);i++) p->attrib[i]=' ';
    } 
    oldp->next='\0';
  }
}

/* inquire information from the expert */
query()
{
  int t;
  char ch;
  struct attribute *p;

  for(t=0;t<=l_pos;t++) {
    p=k_base[t].alist;
    prob=1.0;
    if(try(p,k_base[t].name)) {
      printf("%s fits current description\n",k_base[t].name);
      printf("with probability factor of %f\n",prob);
      printf("continue? (Y/N): ");
      ch=tolower(getche());
      printf("\n");
      if(ch=='n') return;
    }
  }
  printf("No (more) object(s) found\n");
}
  
/* try an object */
try(p,ob)
struct attribute *p;
char *ob;
{
  char answer;
  struct attribute *a,*t;

  if(!trailno(p,ob)) return 0;

  if(!trailyes(p,ob)) return 0;

  while(p) {
    /* if already been asked then move on to next
       attribute 
    */
    if(ask(p->attrib)) {
      printf("is/does/has it %s? ",p->attrib);
      answer=tolower(getche());
      printf("\n");

      a=(struct attribute *) malloc(sizeof(at));
      if(!a) {
        printf("out of memory\n");
        return;
      }
      a->next='\0';
      switch(answer) {
        case 'n':
          strcpy(a->attrib,p->attrib);
          if(!no) {
            no=a;
            nonext=no;
          }
          else {
	    nonext->next=a;
            nonext=a;
          }
          reject(ob,p->attrib,'n');
	  /* reject if prob >= 50% */
          if(p->prob>=0.5) return 0;
        case 'y':
          strcpy(a->attrib,p->attrib);
          if(!yes) {
            yes=a;
            yesnext=yes;
          }
          else {
            yesnext->next=a;
            yesnext=a;
          }
	  compute_odds(p->prob);
          p=p->next;
          break;
        case 'w': /* why? */
	  reasoning(ob);
          break;
      }
    }
    else p=p->next;
  }
  return 1;
}

/* see if it has any attributes known not
   to be part of the object by checking the no list */
trailno(p,ob)
struct attribute *p;
char *ob;
{
  struct attribute *a,*t;

  a=no;
  while(a) {
    t=p;
    while(t) {
      if(!strcmp(t->attrib,a->attrib)) {
        reject(ob,t->attrib,'n');
        if(t->prob>=0.5) return 0;  /* reject only if
				       high prob */
      }
      t=t->next;
    }
    a=a->next;
  }
  return 1;
}

/* see if it has all attributes known 
   to be part of the object by checking the yes list */
trailyes(p,ob)
struct attribute *p;
char *ob;
{
  struct attribute *a,*t;
  char ok;

  a=yes;
  while(a) {
    ok=0;
    t=p;
    while(t) {
      if(!strcmp(t->attrib,a->attrib)) {
        ok=1;  /* does have a needed attribute */
        compute_odds(t->prob);
      }
      t=t->next;
    }
    if(!ok) {
      reject(ob,a->attrib,'y');
      return 0;
    }
    a=a->next;
  }
  return 1;
}

/* see if attribute already asked */
ask(attrib)
char *attrib;
{
  struct attribute *p ,*q;
    
  p=yes;
  while(p && strcmp(attrib,p->attrib))
    p=p->next;

  q=no;
  while(q && strcmp(attrib,q->attrib))
    q=q->next;

  if(q && q->prob<0.5) return 0;
  if(!p) return 1; /* false if end of list */
  else return 0;
}


/* show why a line of reasoning is being followed */
reasoning(ob)
char *ob;
{
  struct attribute *t;
  int i;

  printf("Trying %s\n",ob);
  if(yes)
    printf("it is/has/does:\n");
  t=yes;
  while(t) {
    printf("%s\n",t->attrib);
    t=t->next;
  }
  if(no) printf("it is/has/does not:\n");
  t=no;
  while(t) {
    printf("%s\n",t->attrib);
    t=t->next;
  }
   
  for(i=0;i<=r_pos;i++) {
    printf("%s rejected because ",r_base[i].name);
    if(r_base[i].condition=='n')
      printf("%s is not an attribute.\n",r_base[i].attrib);
    else
      printf("%s is a required attribute.\n",r_base[i].attrib);
  }  
}

/* place rejected object into database */
reject(ob,at,cond)
char *ob, *at, cond;
{
  r_pos++;
  
  strcpy(r_base[r_pos].name,ob);
  strcpy(r_base[r_pos].attrib,at);
  r_base[r_pos].condition=cond;
}

/* get next free index in k_base array */  
get_next()
{
  l_pos++;
  if(l_pos<MAX) return l_pos;
  else return -1;
}

menu()
{
  char ch;

  printf("(E)nter, (Q)uery, (S)save, (L)oad, e(X)it\n");
  do {
    printf("choose one: ");
    ch=tolower(getche());
  } while (!is_in(ch,"eqslx"));
  printf("\n");
  return ch;
}

save()
{
  int t,x;
  struct attribute *p;
  FILE *fp;

  if((fp=fopen("expert.dat","w"))==0) {
    printf("cannot open file\n");
    return;
  }
  printf("saving knowledgebase\n");

  for(t=0;t<=l_pos;++t) {
    for(x=0;x<sizeof(k_base[t].name);x++) 
      putc(k_base[t].name[x],fp);
    p=k_base[t].alist;
    while(p) {
      for(x=0;x<sizeof(p->attrib);x++)
        putc(p->attrib[x],fp);
      fprintf(fp,"%f",p->prob);
      p=p->next;
    }
    /* end of list marker */
    for(x=0;x<sizeof(p->attrib);x++ ) putc('\0',fp);
  }
  putc(0,fp);
  fclose(fp);
}

load()
{
  int t,x;
  struct attribute *p, *oldp;
  FILE *fp;

  if((fp=fopen("expert.dat","r"))==0) {
    printf("cannot open file\n");
    return;
  }
  printf("loading knowledgebase\n");

  /* free any old lists */
  clear_kbase();

  for(t=0;t<MAX;++t) {
    if((k_base[t].name[0]=getc(fp))==0) break; 
    for(x=1;x<sizeof(k_base[t].name);x++) 
      k_base[t].name[x]=getc(fp);

    k_base[t].alist=(struct attribute *) malloc(sizeof(at));
    p=k_base[t].alist;
    if(!p) {
      printf("Out of memory\n");
      return;
    }
    for(;;) {
      for(x=0;x<sizeof(p->attrib);x++)
        p->attrib[x]=getc(fp);

      if(!p->attrib[0]) {
        oldp->next='\0';
        break; /* end of list */
      }
      p->next=(struct attribute *) malloc(sizeof(at));
      if(!p->next) {
        printf("out of memory\n");
        break;
      }
      fscanf(fp,"%f",&p->prob);
      oldp=p;
      p=p->next;
    }   
  }
  fclose(fp);
  l_pos=t-1;
}


clear_kbase()
{
  int t;
  struct attribute *p,*p2;

  for(t=0;t<=l_pos;t++) {
    p=k_base[t].alist;
    while(p) {
      p2=p->next;
      free(p);
      p=p2;
    }
  }
}

is_in(ch,s)
char ch,*s;
{
  while(*s)
    if(ch==*s++) return 1;
  return 0;
}


compute_odds(f)
float f;
{
   prob*=f;
}






listing 8-8

/* compute the probability of a solution */
/* weakest link method */
compute_prob(f)
float f;
{
  if(prob>f) prob=f;
}






listing 8-9

/* compute the probability of a solution */
/* strongest link method */
compute_prob(f)
float f;
{
  if(prob<f) prob=f;
}






listing 8-10


/* A probabilistic expert system that finds multiple
   goals and displays reasoning using the strongest
   link approach */

#include "stdio.h"
#include "malloc.h"

#define MAX 100

struct attribute {
  char attrib[80];
  float prob;  /* probability assoc with attribute */
  struct attribute *next; /* use linked list */
} at;  


struct object {
  char name[80];
  struct attribute *alist; /* pointer to list of attributes */
} ob;

struct rejected_object {
  char name[80];
  char attrib[80]; /* attribute that caused rejection */
  char condition;  /* did it need it or shouldn't it
		      have been found?  */
} rj;
struct rejected_object r_base[MAX];

struct object k_base[MAX];  /* holds the knowledge base */
int l_pos=-1;  /* location of top of k base */
int r_pos=-1;  /* location of top of reject base */

struct attribute *yes,*no;  /* used for yes and no lists */
struct attribute *yesnext, *nonext;

float prob; /* holds the probability of the current 
	       solution */

main()
{
  char ch;

  no=yes='\0';
  do {
    free_trails();
    ch=menu();
    switch(ch) {
      case 'e': enter();
        break;
      case 'q': query();
        break;
      case 's': save();
        break;
      case 'l': load();
    }

  } while (ch!='x');
}

free_trails()
{
  struct attribute *p;

  while(yes) {
    p=yes->next;
    free(yes);
    yes=p;
  }

  while(no) {
    p=no->next;
    free(no);
    no=p;
  }
  r_pos=-1;
}

/* input an object and its list of attributes */
enter()
{
  int t,i;
  struct attribute *p, *oldp;

  for(;;) {
    t=get_next(); /* get the index of the next
       available object in k_base */
    if(t==-1) {
      printf("Out of list space.\n");
      return;
    }
    printf("Object name: ");
    gets(k_base[t].name);

    if(!*k_base[t].name) {
      l_pos--;
      break;
    }

    p=(struct attribute *) malloc(sizeof(at));
    if(p=='\0') {
      printf("Out of memory.\n");
      return;
    }
    k_base[t].alist=p;
    for(i=0;i<sizeof(p->attrib);i++) p->attrib[i]=' ';
    printf("Enter attributes (RETURN to quit)\n");
    for(;;) {
      printf("attribute: ");
      gets(p->attrib);
      if(!p->attrib[0]) break;
      printf("probability: (0-1): ");
      scanf("%f",&p->prob);
      getchar(); /* through away crfl */
      oldp=p;
      p->next=(struct attribute *) malloc(sizeof(at));
      if(p->next=='\0') {
        printf("Out of memory.\n");
        return;
      }
      p=p->next;
      p->next='\0';
      for(i=0;i<sizeof(p->attrib);i++) p->attrib[i]=' ';
    } 
    oldp->next='\0';
  }
}

/* inquire information from the expert */
query()
{
  int t;
  char ch;
  struct attribute *p;

  for(t=0;t<=l_pos;t++) {
    p=k_base[t].alist;
    prob=0.0; /* strongest length inititial point */
    if(try(p,k_base[t].name)) {
      printf("%s fits current description\n",k_base[t].name);
      printf("with probability factor of %f\n",prob);
      printf("continue? (Y/N): ");
      ch=tolower(getche());
      printf("\n");
      if(ch=='n') return;
    }
  }
  printf("No (more) object(s) found\n");
}
  
/* try an object */
try(p,ob)
struct attribute *p;
char *ob;
{
  char answer;
  struct attribute *a,*t;

  if(!trailno(p,ob)) return 0;

  if(!trailyes(p,ob)) return 0;

  while(p) {
    /* if already been asked then move on to next
       attribute 
    */
    if(ask(p->attrib)) {
      printf("is/does/has it %s? ",p->attrib);
      answer=tolower(getche());
      printf("\n");

      a=(struct attribute *) malloc(sizeof(at));
      if(!a) {
        printf("out of memory\n");
        return;
      }
      a->next='\0';
      switch(answer) {
        case 'n':
          strcpy(a->attrib,p->attrib);
          if(!no) {
            no=a;
            nonext=no;
          }
          else {
	    nonext->next=a;
            nonext=a;
          }
          reject(ob,p->attrib,'n');
	  /* reject if prob >= 50% */
          if(p->prob>=0.5) return 0;
        case 'y':
          strcpy(a->attrib,p->attrib);
          if(!yes) {
            yes=a;
            yesnext=yes;
          }
          else {
            yesnext->next=a;
            yesnext=a;
          }
	  compute_prob(p->prob);
          p=p->next;
          break;
        case 'w': /* why? */
	  reasoning(ob);
          break;
      }
    }
    else p=p->next;
  }
  return 1;
}

/* see if it has any attributes known not
   to be part of the object by checking the no list */
trailno(p,ob)
struct attribute *p;
char *ob;
{
  struct attribute *a,*t;

  a=no;
  while(a) {
    t=p;
    while(t) {
      if(!strcmp(t->attrib,a->attrib)) {
        reject(ob,t->attrib,'n');
        if(t->prob>=0.5) return 0;  /* reject only if
				       high prob */
      }
      t=t->next;
    }
    a=a->next;
  }
  return 1;
}

/* see if it has all attributes known 
   to be part of the object by checking the yes list */
trailyes(p,ob)
struct attribute *p;
char *ob;
{
  struct attribute *a,*t;
  char ok;

  a=yes;
  while(a) {
    ok=0;
    t=p;
    while(t) {
      if(!strcmp(t->attrib,a->attrib)) {
        ok=1;  /* does have a needed attribute */
        compute_prob(t->prob);
      }
      t=t->next;
    }
    if(!ok) {
      reject(ob,a->attrib,'y');
      return 0;
    }
    a=a->next;
  }
  return 1;
}

/* see if attribute already asked */
ask(attrib)
char *attrib;
{
  struct attribute *p ,*q;
    
  p=yes;
  while(p && strcmp(attrib,p->attrib))
    p=p->next;

  q=no;
  while(q && strcmp(attrib,q->attrib))
    q=q->next;

  if(q && q->prob<0.5) return 0;
  if(!p) return 1; /* false if end of list */
  else return 0;
}


/* show why a line of reasoning is being followed */
reasoning(ob)
char *ob;
{
  struct attribute *t;
  int i;

  printf("Trying %s\n",ob);
  if(yes)
    printf("it is/has/does:\n");
  t=yes;
  while(t) {
    printf("%s\n",t->attrib);
    t=t->next;
  }
  if(no) printf("it is/has/does not:\n");
  t=no;
  while(t) {
    printf("%s\n",t->attrib);
    t=t->next;
  }
   
  for(i=0;i<=r_pos;i++) {
    printf("%s rejected because ",r_base[i].name);
    if(r_base[i].condition=='n')
      printf("%s is not an attribute.\n",r_base[i].attrib);
    else
      printf("%s is a required attribute.\n",r_base[i].attrib);
  }  
}

/* place rejected object into database */
reject(ob,at,cond)
char *ob, *at, cond;
{
  r_pos++;
  
  strcpy(r_base[r_pos].name,ob);
  strcpy(r_base[r_pos].attrib,at);
  r_base[r_pos].condition=cond;
}

/* get next free index in k_base array */  
get_next()
{
  l_pos++;
  if(l_pos<MAX) return l_pos;
  else return -1;
}

menu()
{
  char ch;

  printf("(E)nter, (Q)uery, (S)save, (L)oad, e(X)it\n");
  do {
    printf("choose one: ");
    ch=tolower(getche());
  } while (!is_in(ch,"eqslx"));
  printf("\n");
  return ch;
}

save()
{
  int t,x;
  struct attribute *p;
  FILE *fp;

  if((fp=fopen("expert.dat","w"))==0) {
    printf("cannot open file\n");
    return;
  }
  printf("saving knowledgebase\n");

  for(t=0;t<=l_pos;++t) {
    for(x=0;x<sizeof(k_base[t].name);x++) 
      putc(k_base[t].name[x],fp);
    p=k_base[t].alist;
    while(p) {
      for(x=0;x<sizeof(p->attrib);x++)
        putc(p->attrib[x],fp);
      fprintf(fp,"%f",p->prob);
      p=p->next;
    }
    /* end of list marker */
    for(x=0;x<sizeof(p->attrib);x++ ) putc('\0',fp);
  }
  putc(0,fp);
  fclose(fp);
}

load()
{
  int t,x;
  struct attribute *p, *oldp;
  FILE *fp;

  if((fp=fopen("expert.dat","r"))==0) {
    printf("cannot open file\n");
    return;
  }
  printf("loading knowledgebase\n");

  /* free any old lists */
  clear_kbase();

  for(t=0;t<MAX;++t) {
    if((k_base[t].name[0]=getc(fp))==0) break; 
    for(x=1;x<sizeof(k_base[t].name);x++) 
      k_base[t].name[x]=getc(fp);

    k_base[t].alist=(struct attribute *) malloc(sizeof(at));
    p=k_base[t].alist;
    if(!p) {
      printf("Out of memory\n");
      return;
    }
    for(;;) {
      for(x=0;x<sizeof(p->attrib);x++)
        p->attrib[x]=getc(fp);

      if(!p->attrib[0]) {
        oldp->next='\0';
        break; /* end of list */
      }
      p->next=(struct attribute *) malloc(sizeof(at));
      if(!p->next) {
        printf("out of memory\n");
        break;
      }
      fscanf(fp,"%f",&p->prob);
      oldp=p;
      p=p->next;
    }   
  }
  fclose(fp);
  l_pos=t-1;
}


clear_kbase()
{
  int t;
  struct attribute *p,*p2;

  for(t=0;t<=l_pos;t++) {
    p=k_base[t].alist;
    while(p) {
      p2=p->next;
      free(p);
      p=p2;
    }
  }
}

is_in(ch,s)
char ch,*s;
{
  while(*s)
    if(ch==*s++) return 1;
  return 0;
}

/* compute the probability of a solution */
/* strongest link method */
compute_prob(f)
float f;
{
  if(prob<f) prob=f;
}





