/*****************************************************************************
 ****                                                                     ****
 **** atree.h                                                             ****
 ****                                                                     ****
 **** atree release 2.7                                                   ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, M. Thomas, W.W. Armstrong ****
 ****               1991, 1992                                            ****
 ****                                                                     ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES ONLY  ****
 **** to adapt logic trees using this program and its modifications.      ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 ****                                                                     ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 90.05.09 Initial implementation, A.Dwelly                           ****
 **** 91.07.15 Release 2, Rolf Manderscheid                               ****
 **** 92.27.02 Release 2.5, Monroe Thomas                                 ****
 **** 92.03.07 Release 2.6, Monroe Thomas                                 ****
 **** 92.01.08 Release 2.7, Monroe Thomas                                 ****
 ****                                                                     ****
 *****************************************************************************/

/*****************************************************************************
 ****                                                                     ****
 **** atree                                                               ****
 ****                                                                     ****
 **** An atree is the fundamental structure used by these routines; it is ****
 **** a binary tree with nodes taking one of four logical functions, AND, ****
 **** OR, LEFT or RIGHT depending on initialization or the training it    ****
 **** has undergone.  The tree is randomly connected to input variables   ****
 **** and their complements.                                              ****
 ****                                                                     ****
 *****************************************************************************/

// windows.h must be included before atree.h

#ifndef __ATREE_H
#define __ATREE_H

#ifdef __cplusplus
extern "C" {
#endif  // __cplusplus

#ifndef __STDIO_H
#include <stdio.h>
#endif

#ifndef __STDLIB_H
#include <stdlib.h>
#endif

#ifndef __ALLOC_H
#include <alloc.h>
#endif

#ifndef __STRING_H
#include <string.h>
#endif

#ifndef __MATH_H
#include <math.h>
#endif

#ifndef __ASSERT_H
#include <assert.h>
#endif

#ifndef __CTYPE_H
#include <ctype.h>
#endif

#ifndef __ERRNO_H
#include <errno.h>
#endif

#ifndef __PROCESS_H
#include <process.h>
#endif

#ifndef __BV_H
#include "bv.h"
#endif

typedef union atree_type {

	union atree_node_type {
	union atree_node_type far *next;    // 4 byte pointer for free list management
	struct {
	  char cnt_right;
	  char cnt_left;
	  unsigned char tag;
	  unsigned char sig_right;
	  unsigned char sig_left;
	  union atree_type far *child[2];
	} data;                             // structure is 8 bytes long
	} node;                               // union is 8 bytes long

  union atree_leaf_type {
	union atree_leaf_type far *next;    // 4 byte pointer
	struct {
	  unsigned int bit_no;
	  unsigned char tag;
	  unsigned char comp;
	} data;                             // structure is 4 bytes long
  } leaf;								// union is 4 bytes long

} atree;                                // union is 8 bytes long

typedef atree far *LPATREE;    			// common Windows convention

#define c_tag       	node.data.tag   	// common field tags
#define l_bit_no    	leaf.data.bit_no
#define l_comp      	leaf.data.comp
#define n_sig_right 	node.data.sig_right
#define n_sig_left  	node.data.sig_left
#define n_cnt_right 	node.data.cnt_right
#define n_cnt_left  	node.data.cnt_left
#define n_child			node.data.child
#define n_child_right   node.data.child[1]
#define n_child_left	node.data.child[0]

typedef union atree_node_type atree_node;
typedef atree_node far *LPATREE_NODE;   // common Windows convention

typedef union atree_leaf_type atree_leaf;
typedef atree_leaf far *LPATREE_LEAF;   // common Windows convention

typedef struct fast_tree_struct {
  struct fast_tree_struct far *next[2];
  int bit_no;
  int comp;
} fast_tree;                            // struct is 12 bytes long

typedef fast_tree far *LPFAST_TREE;     // common Windows convention

typedef struct code_struct {
  int vector_count;
  int width;
  float low;
  float high;
  float step;
  LPBIT_VEC vector;
} code_t;                               // struct is 22 bytes long

typedef code_t far *LPCODE_T;           // common Windows convention

/* Public function prototypes */

void FAR PASCAL         Windows_Interrupt(DWORD);

void FAR PASCAL         atree_init(HANDLE, HWND);
void FAR PASCAL         atree_quit(void);
LPATREE FAR PASCAL      atree_create(int, int);
void FAR PASCAL         atree_print(LPATREE, FILE *, int);
BOOL FAR PASCAL         atree_eval(LPATREE, LPBIT_VEC);
int FAR PASCAL          atree_train(LPATREE, LPBIT_VEC, LPBIT_VEC,int,int,int,int,int);
LPBIT_VEC FAR PASCAL    atree_rand_walk(int, int, int);
void FAR PASCAL         atree_free(LPATREE);

LPATREE FAR PASCAL      atree_fold(LPATREE);
LPFAST_TREE FAR PASCAL  atree_compress(LPATREE);
BOOL FAR PASCAL         atree_fast_eval(LPFAST_TREE, LPBIT_VEC);
void FAR PASCAL         atree_fast_print(LPFAST_TREE, FILE *);

int FAR PASCAL          atree_store(LPATREE, LPSTR);
LPATREE FAR PASCAL      atree_load(LPSTR);
int FAR PASCAL          atree_write(FILE *, LPATREE);
LPATREE FAR PASCAL      atree_read(FILE *);

int FAR PASCAL          atree_set_code(LPCODE_T, double, double, int, int, int);
int FAR PASCAL          atree_encode(double, LPCODE_T);
int FAR PASCAL          atree_decode(LPBIT_VEC, LPCODE_T);
int FAR PASCAL          atree_write_code(FILE *, LPCODE_T);
LPCODE_T FAR PASCAL     atree_read_code(FILE *, LPCODE_T);

/* some public Macros */

#define MEMCHECK(p) \
		if (p == NULL){ \
						 MessageBox(NULL,"Could not allocate requested memory",\
						 "atree",MB_OK | MB_ICONSTOP);\
						 PostQuitMessage(0);\
						 exit(0);\
						}
#define RANDOM(b) (rand() % (b))
#define Malloc(cb) farmalloc(cb)
#define Free(p)    farfree(p)

#define IDD_ATREE_EPOCH 100
#define IDD_ATREE_CORRECT 101
#define IDD_ATREE_ACTUAL 102

#ifdef __cplusplus
}
#endif  // __cplusplus

#endif	// __ATREE_H