/*****************************************************************************
 ****                                                                     ****
 **** bv.h                                                                ****
 ****                                                                     ****
 **** atree release 2.7                                                   ****
 **** Adaptive Logic Network (ALN) simulation library.	             	  ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, M. Thomas, W.W. Armstrong ****
 ****               1991, 1992                                            ****
 ****                                                                     ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES ONLY  ****
 **** to adapt logic trees using this program and its modifications.      ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 ****                                                                     ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 90.05.09 Initial implementation, A.Dwelly                           ****
 **** 91.07.15 Release 2, Rolf Manderscheid                               ****
 **** 92.27.02 Release 2.5 Monroe Thomas                                  ****
 **** 92.03.07 Release 2.6, Monroe Thomas                                 ****
 **** 92.01.08 Release 2.7, Monroe Thomas                                 ****
 ****                                                                     ****
 *****************************************************************************/

/*****************************************************************************
 ****                                                                     ****
 **** bit_vec                                                             ****
 ****                                                                     ****
 **** A bit_vec is a packed vector of bits, stored in an array of chars.  ****
 *****************************************************************************/

#ifndef __BV_H
#define __BV_H

#ifndef __WINDOWS_H
#include <windows.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif  // __cplusplus

typedef struct bit_vec_strc
{
	int len;    /* The length of the vector in bits */
	LPSTR bv;
}
bit_vec;								// struct is 6 bytes long

typedef bit_vec far *LPBIT_VEC;         // common Windows convention

/* Public function prototypes */

int FAR PASCAL          bv_diff(LPBIT_VEC, LPBIT_VEC);
LPBIT_VEC FAR PASCAL    bv_create(int);
LPBIT_VEC FAR PASCAL    bv_pack(LPSTR, int);
LPBIT_VEC FAR PASCAL    bv_concat(int, LPBIT_VEC FAR *);
LPBIT_VEC FAR PASCAL    bv_copy(LPBIT_VEC);
void FAR PASCAL         bv_set(int,LPBIT_VEC,BOOL);
BOOL FAR PASCAL         bv_extract(int,LPBIT_VEC);
BOOL FAR PASCAL         bv_equal(LPBIT_VEC, LPBIT_VEC);
void FAR PASCAL         bv_free(LPBIT_VEC);
int FAR PASCAL          bv_print(FILE *, LPBIT_VEC);

#ifdef __cplusplus
}
#endif  // __cplusplus

#endif	// __BV_H