/*****************************************************************************
 ****                                                                     ****
 **** filedlg.c                                                           ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, M. Thomas, W.W. Armstrong ****
 ****               1991, 1992                                            ****
 ****                                                                     ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 91.05.20 Initial implementation, M. Thomas                          ****
 **** 91.07.17 atree v2.0 for Windows, M. Thomas                          ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas                                 ****
 **** 92.01.08 Release 2.7, Monroe Thomas                                 ****
 ****                                                                     ****
 *****************************************************************************/

#include <windows.h>
#include "commdlg.h"

LPSTR lstrchr  (LPSTR str, char ch);
LPSTR lstrrchr (LPSTR str, char ch);

int DoFileOpenDlg (HWND hwnd, LPSTR szFileName)
{
	OPENFILENAME ofn;
	BOOL nResult;

	memset(&ofn, 0, sizeof(OPENFILENAME));

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwnd;
	ofn.lpstrFilter = "LF Files(*.LF)\0*.lf\0LF Output Files(*.OUT)\0*.out\0All Files(*.*)\0*.*\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFileTitle = (LPSTR)szFileName;
	ofn.nMaxFileTitle = 127;
	ofn.Flags = OFN_CREATEPROMPT;
	ofn.lpstrDefExt = "LF";

	nResult = GetOpenFileName(&ofn);
	return (nResult);
}

int DoFileSaveDlg (HWND hwnd, LPSTR szFileName)
{
	OPENFILENAME ofn;
	BOOL nResult;
	char szFile[128];

	lstrcpy(szFile, szFileName);

	memset(&ofn, 0, sizeof(OPENFILENAME));

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwnd;
	ofn.lpstrFilter = "LF Files(*.LF)\0*.lf\0LF Output Files(*.OUT)\0*.out\0All Files(*.*)\0*.*\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = (LPSTR)szFile;
	ofn.nMaxFile = 127;
	ofn.lpstrFileTitle = (LPSTR)szFileName;
	ofn.nMaxFileTitle = 127;
	ofn.Flags = OFN_OVERWRITEPROMPT;
	ofn.lpstrDefExt = "LF";
	 
	nResult = GetSaveFileName(&ofn);
	return (nResult);
}

int DoOutFileDlg (HWND hwnd, LPSTR szFileName)
{
	OPENFILENAME ofn;
	BOOL nResult;
	char szFile[128];

	lstrcpy(szFile, szFileName);

	memset(&ofn, 0, sizeof(OPENFILENAME));

	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwnd;
	ofn.lpstrFilter = "LF Output Files(*.OUT)\0*.out\0Text Files(*.TXT)\0*.txt\0All Files(*.*)\0*.*\0";
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = (LPSTR)szFile;
	ofn.nMaxFile = 127;
	ofn.lpstrFileTitle = (LPSTR)szFileName;
	ofn.nMaxFileTitle = 127;
	ofn.Flags = OFN_OVERWRITEPROMPT;
	ofn.lpstrDefExt = "OUT";
	 
	nResult = GetSaveFileName(&ofn);
	return (nResult);
}

LPSTR lstrchr (LPSTR str, char ch)
{
  while (*str)
  {
    if (ch == *str) return str;
    str = AnsiNext(str);
  }
  return NULL;
}

LPSTR lstrrchr (LPSTR str, char ch)
{
  LPSTR strl = str + lstrlen(str);

  do
  {
    if (ch == *strl) return strl;
    strl = AnsiPrev(str, strl);
	}
	while (strl > str);

  return NULL;
}
