
/*****************************************************************************
 ****                                                                     ****
 **** lf.h                                                                ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, M. Thomas, W.W. Armstrong ****
 ****               1991, 1992                                            ****
 ****                                                                     ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 90.09.05 Initial implementation, A.Dwelly                           ****
 **** 91.04.15 Port to PC and minor bug fixes, R. Manderscheid            ****
 **** 91.05.20 Windows Port & Windows Extensions, M. Thomas               ****
 **** 91.07.17 atree v2.0 for Windows, M. Thomas                          ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas                                 ****
 **** 92.01.08 Release 2.7, Monroe Thomas                                 ****
 ****                                                                     ****
 *****************************************************************************/

#define TRUE 1
#define FALSE 0

typedef struct prog_struct
{
		BOOL error;
		BOOL warning;
		BOOL forest_folded;

    /*
     * total_dimensions = dimensions + codimensions
     * domain: 0 .. dimensions - 1
     * codomain: dimensions .. total_dimensions - 1
     */

    int dimensions;
    int codimensions;
    int total_dimensions;

    int domain_width;
    int codomain_width;
    int trainset_sz;
    int testset_sz;
    float far * far *train_table;
    float far * far *test_table;

    LPCODE_T code;
    int far *walk_step;

    int tree_sz;
    int min_correct;
    int max_epochs;
    int vote;

    char *save_tree;
    char *load_tree;
    char *save_code;
    char *load_code;
}
prog_t;

union stack_type {
  int   i;
  float f;
  char  *s;
};

#define YYSTYPE union stack_type

/* status dlg constants */

#define IDD_TEXT	100
#define	IDD_PERCENT	101