/*****************************************************************************
 ****                                                                     ****
 **** lfedit.c                                                            ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, M. Thomas, W.W. Armstrong ****
 ****               1991, 1992                                            ****
 ****                                                                     ****												  ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 91.05.20 Initial implementation, M. Thomas                          ****
 **** 91.07.17 atree v2.0 for Windows, M. Thomas                          ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas                                 ****
 **** 92.01.08 Release 2.7, Monroe Thomas                                 ****
 ****                                                                     ****
 *****************************************************************************/

#include <windows.h>
#include "lfedit.h"
#include "atree.h"
#define EDITID 1

long FAR PASCAL WndProc(HWND, WORD, WORD, LONG);

// in lfeditio.c
BOOL ReadFile (HWND, HWND, POFSTRUCT, LPSTR, BOOL) ;
BOOL WriteFile (HWND, HWND, POFSTRUCT, LPSTR, BOOL) ;
BOOL GetOutFile (HWND) ;
BOOL PrintFile (HANDLE, HWND, HWND, LPSTR);

// in lf.c
extern BOOL PASCAL lf_main(HWND, LPSTR, LPSTR, HANDLE); /*in lf.c*/
extern BOOL lf_quit;
extern int line_no;

// filedlg.c
LPSTR lstrrchr (LPSTR, char);

char szAppName []  = "lfEdit";
static char szUntitled [] = "(untitled)";
char szFileNameIn[128] ;
char szFileNameOut[128];

BOOL bIsProcessing = FALSE;

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
				   LPSTR lpszCmdLine, int nCmdShow)

{
	HWND hwnd;
	MSG msg;
	HANDLE hAccel;
	WNDCLASS wndclass;

	if (!hPrevInstance)
	{
		wndclass.style          = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc    = (long (FAR PASCAL*)())WndProc;
		wndclass.cbClsExtra     = 0;
		wndclass.cbWndExtra     = 0;
		wndclass.hInstance      = hInstance;
		wndclass.hIcon          = LoadIcon(hInstance, "atreeico");
		wndclass.hCursor        = LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground  = COLOR_WINDOW + 1;
		wndclass.lpszMenuName   = szAppName;
		wndclass.lpszClassName  = szAppName;

		RegisterClass(&wndclass);
	}
	else
	{
		MessageBox(NULL, "LF is already running!", "LF", MB_OK);
		return FALSE;
	}

	hwnd = CreateWindow(szAppName, NULL,
											WS_OVERLAPPEDWINDOW,
											CW_USEDEFAULT,
											CW_USEDEFAULT,
											CW_USEDEFAULT,
											CW_USEDEFAULT,
											NULL, NULL, hInstance, lpszCmdLine) ;

	ShowWindow (hwnd, nCmdShow);
	UpdateWindow (hwnd);

	hAccel = LoadAccelerators(hInstance, szAppName);

	while (GetMessage (&msg, NULL, 0, 0))
		{
		if (!TranslateAccelerator(hwnd, hAccel, &msg))
			{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
			}
		}
	return msg.wParam;
	}

#pragma argsused

BOOL FAR PASCAL AboutDlgProc(HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
	switch(message)
	{
		case WM_INITDIALOG:
			return TRUE;

		case WM_COMMAND :
			switch (wParam)
			{
				case IDOK:
					EndDialog(hDlg, 0);
					return TRUE;
			}
			break;
	}
	return FALSE;
}

void DoCaption (HWND hwnd, LPSTR szFileName)
{
	char szCaption [40];

	wsprintf(szCaption, "%s - %s", (LPSTR) szAppName,
			  (LPSTR) (szFileName[0] ? szFileName : szUntitled));

	SetWindowText(hwnd, szCaption);
}

short AskAboutSave (HWND hwnd, LPSTR szFileName)
{
	char szBuffer[80];
	short nReturn;

	wsprintf(szBuffer, "Save current changes: %s",
			 (LPSTR) (szFileName[0] ? szFileName : szUntitled));

	if (IDYES == (nReturn = MessageBox(hwnd, szBuffer, szAppName,
								MB_YESNOCANCEL | MB_ICONQUESTION)))
	{
		if (!SendMessage(hwnd, WM_COMMAND, IDM_SAVE, 0L))
			return IDCANCEL;
	}
	return nReturn;
}

short AskAboutProcess (HWND hwnd, LPSTR szFileName)
{
	char szBuffer[80];
	short nReturn;

	wsprintf(szBuffer, "Are you sure you wish to quit while processing %s?",
				(LPSTR) szFileName);

	nReturn = MessageBox(hwnd, szBuffer, szAppName,
								MB_OKCANCEL | MB_ICONQUESTION);

	return nReturn;
}

long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
	static BOOL     bNeedSave = FALSE;
	static char     szRealFileName[16];
	static FARPROC  lpfnAboutDlgProc;
	static HANDLE   hInst;
	static HWND     hwndEdit;
	static char     szFileName[128];
	LONG            lSelect;
	OFSTRUCT        of;
	WORD            wEnable;

	switch(message)
	{
		case WM_CREATE :

			hInst = ((LPCREATESTRUCT) lParam) -> hInstance;
			lpfnAboutDlgProc = MakeProcInstance(AboutDlgProc, hInst);

			hwndEdit = CreateWindow ("edit", NULL,
					WS_CHILD | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL |
						WS_BORDER | ES_LEFT | ES_MULTILINE | ES_OEMCONVERT |
						ES_AUTOHSCROLL | ES_AUTOVSCROLL,
					0,0,0,0,
					hwnd, EDITID, hInst, NULL);

			line_no = 1;
			SendMessage (hwndEdit, EM_LIMITTEXT, 64000, 0L);
			SendMessage (hwndEdit, WM_SETFONT, GetStockObject(SYSTEM_FIXED_FONT), TRUE);

			if (lstrlen (((LPCREATESTRUCT) lParam) -> lpCreateParams))
			{
				OpenFile (((LPCREATESTRUCT) lParam) -> lpCreateParams, &of,	OF_PARSE);

				lstrcpy  (szFileName, AnsiNext (lstrrchr (of.szPathName, '\\')));

				if (ReadFile (hwnd, hwndEdit, &of, (LPSTR)szFileName, FALSE))
        {
					lstrcpy(szRealFileName, szFileName);
				}
			}

			DoCaption (hwnd, szRealFileName);
			return 0;

		case WM_SETFOCUS:
			SetFocus(hwndEdit);
			return 0;

		case WM_SIZE:
			MoveWindow (hwndEdit, 0, 0, LOWORD(lParam), HIWORD(lParam), TRUE);
			return 0;

		case WM_INITMENUPOPUP:
			if (lParam == 1)        /* Edit Menu */
			{
				EnableMenuItem(wParam, IDM_UNDO, SendMessage(hwndEdit, EM_CANUNDO, 0, 0L) ?
					  					 MF_ENABLED : MF_GRAYED);

				EnableMenuItem(wParam, IDM_PASTE,	IsClipboardFormatAvailable(CF_TEXT) ?
					 	 					 MF_ENABLED : MF_GRAYED);

				lSelect = SendMessage(hwndEdit, EM_GETSEL, 0, 0L);

				if (HIWORD(lSelect) == LOWORD(lSelect))
        {
					wEnable = MF_GRAYED;
        }
				else
        {
					wEnable = MF_ENABLED;
        }

				EnableMenuItem (wParam, IDM_CUT,   wEnable);
				EnableMenuItem (wParam, IDM_COPY,  wEnable);
				EnableMenuItem (wParam, IDM_CLEAR, wEnable);
			}

			else if (lParam == 0)   /*File menu */
			{
				if (szRealFileName[0])
        {
					wEnable = MF_ENABLED;
        }
				else
        {
					wEnable = MF_GRAYED;
        }

				EnableMenuItem (wParam, IDM_RUN,   wEnable);
				EnableMenuItem (wParam, IDM_PRINT, wEnable);
			}
			return 0;

		case WM_COMMAND:
			if (LOWORD(lParam) && wParam == EDITID)
			{
				switch (HIWORD(lParam))
				{
					case EN_UPDATE :
						bNeedSave = TRUE;
						return 0;

					case EN_ERRSPACE :
						MessageBox(hwnd, "Editor is out of space.",	szAppName,
											 MB_OK | MB_ICONSTOP);
						return 0;
				}
				break;
			}

			switch (wParam)
			{
				case IDM_HELP:
					WinHelp(hwnd, "atree.hlp", HELP_CONTEXT, 40);
					break;

				case IDM_NEW :
					if(bNeedSave && IDCANCEL == AskAboutSave(hwnd, szRealFileName))
          {
						return 0;
          }
					SetWindowText(hwndEdit, "\0");
					szRealFileName[0] = '\0';
					DoCaption (hwnd, szRealFileName);
					bNeedSave = FALSE;
					line_no = 1;
					return(0);

				case IDM_OPEN :
					if (bNeedSave && IDCANCEL == AskAboutSave (hwnd, szRealFileName))
          {
						return 0;
          }

					if (ReadFile (hwnd, hwndEdit, &of, (LPSTR)szFileName, TRUE))
					{
						lstrcpy (szRealFileName, szFileName);
						DoCaption (hwnd, szRealFileName);
						bNeedSave = FALSE;
					}

					line_no = 1;
					return 0;

				case IDM_SAVE :
					if (szRealFileName[0])
					{
						if (WriteFile(hwnd, hwndEdit, &of, (LPSTR)szRealFileName, FALSE))
						{
							bNeedSave = FALSE;
							return 1;
						}
						return 0;
					}

 				/* fall through */
  			case IDM_SAVEAS:
					if (WriteFile (hwnd, hwndEdit, &of, (LPSTR)szFileName, TRUE))
					{
						lstrcpy (szRealFileName, szFileName);
						DoCaption (hwnd, szFileName);
						bNeedSave = FALSE;
						return 1;
					}
					return 0;

				case IDM_PRINT:
					PrintFile(hInst, hwnd, hwndEdit, szRealFileName[0] ?
			 							(LPSTR) szRealFileName : szUntitled);
					return 0;

				case IDM_RUN:
					if (bIsProcessing)
					{
						char szBuffer[80];
						wsprintf(szBuffer, "Already processing %s ", (LPSTR) szFileNameIn);
						(void) MessageBox(hwnd, szBuffer, szAppName,
									MB_OK | MB_ICONEXCLAMATION);
					}

					else
					{
						if (!bNeedSave || IDCANCEL !=
								   AskAboutSave (hwnd, szRealFileName))
						{
							lstrcpy(szFileNameIn, szRealFileName[0] ? szRealFileName : "lf.in");
							if (GetOutFile(hwnd))
							{
								bIsProcessing = TRUE;
								if (!lf_main(hwnd, szFileNameIn, szFileNameOut, hInst))
								{
									char szBuffer[80];
									int curr_line;
									int line_len;
									wsprintf(szBuffer,"Could not execute %s ",
												   (LPSTR) szFileNameIn);
									MessageBox(hwnd, (LPSTR)szBuffer, "LF Error", MB_OK | MB_ICONEXCLAMATION);

									// set the selection to the error line
									curr_line = SendMessage(hwndEdit, EM_LINEFROMCHAR, -1, 0L);
									SendMessage(hwndEdit, EM_LINESCROLL, 0, MAKELONG((line_no - 1) - curr_line,0));
									curr_line = SendMessage(hwndEdit, EM_LINEINDEX, line_no - 1, 0);
									line_len = SendMessage(hwndEdit, EM_LINELENGTH, curr_line, 0);
									SendMessage(hwndEdit, EM_SETSEL, 0, MAKELONG(curr_line, curr_line + line_len));
								}
							}
							bIsProcessing = FALSE;
						}
					}
					return 0;

				case IDM_EXIT:
					SendMessage(hwnd, WM_CLOSE, 0, 0L);
					return 0;

				case IDM_ABOUT:
					DialogBox(hInst, "AboutBox", hwnd, lpfnAboutDlgProc);
					return 0;

				case IDM_UNDO:
					SendMessage(hwndEdit, WM_UNDO, 0, 0L);
					return 0;

				case IDM_CUT:
					SendMessage(hwndEdit, WM_CUT, 0, 0L);
					return 0;

				case IDM_COPY:
					SendMessage(hwndEdit, WM_COPY, 0, 0L);
					return 0;

				case IDM_PASTE:
					SendMessage(hwndEdit, WM_PASTE, 0, 0L);
					return 0;

				case IDM_CLEAR:
					SendMessage(hwndEdit, WM_CLEAR, 0, 0L);
					return 0;

				case IDM_SELALL:
					SendMessage(hwndEdit, EM_SETSEL, 0, MAKELONG(0, 32767));
					return 0;
			}
			break;

		case WM_CLOSE :
			if (!bNeedSave || IDCANCEL != AskAboutSave (hwnd, szRealFileName))
      {
				if (!bIsProcessing || IDCANCEL != AskAboutProcess(hwnd, szFileNameIn))
        {
					DestroyWindow(hwnd);
				}
      }
			return 0;

		case WM_QUERYENDSESSION :
			if (!bNeedSave || IDCANCEL != AskAboutSave (hwnd, szRealFileName))
      {
				if (!bIsProcessing || IDCANCEL != AskAboutProcess(hwnd, szFileNameIn))
        {
					return 1L;
				}
      }
			return 0;

		case WM_DESTROY:
			atree_quit();
			lf_quit = TRUE;
			FreeProcInstance(lpfnAboutDlgProc);
			PostQuitMessage(0);
			return  0;

	}
	return DefWindowProc(hwnd, message, wParam, lParam);
}
