/*****************************************************************************
 ****                                                                     ****
 **** lfeditio.c                                                          ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, M. Thomas, W.W. Armstrong ****
 ****               1991, 1992                                            ****
 ****                                                                     ****												  ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 91.05.20 Initial implementation, M. Thomas                          ****
 **** 91.07.17 atree v2.0 for Windows, M. Thomas                          ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas                                 ****
 **** 92.01.08 Release 2.7, Monroe Thomas                                 ****
 ****                                                                     ****
 *****************************************************************************/

/***** editor I/O *****/

#include <windows.h>
#include <string.h>
#include "lfedit.h"

/* in filedlg.c */
int DoFileOpenDlg (HWND, LPSTR);
int DoFileSaveDlg (HWND, LPSTR);
int DoOutFileDlg  (HWND, LPSTR);
LPSTR lstrrchr (LPSTR, char);

extern char szAppName[];       /*in lfedit.c*/
extern char szFileNameOut[];
extern char szFileNameIn[];

BOOL bUserAbort;
HWND hDlgPrint;

#pragma argsused

BOOL FAR PASCAL PrintDlgProc(HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
			EnableMenuItem (GetSystemMenu(hDlg, FALSE), SC_CLOSE, MF_GRAYED);
			return TRUE;

    case WM_COMMAND:
      bUserAbort = TRUE;
      EnableWindow(GetParent(hDlg), TRUE);
      DestroyWindow(hDlg);
      hDlgPrint = 0;
      return TRUE;
  }
  return FALSE;
}

#pragma argsused

BOOL FAR PASCAL AbortProc (HDC hPrinterDC, short nCode)
{
  MSG msg;

  while(!bUserAbort && PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
  {
    if (!hDlgPrint || !IsDialogMessage(hDlgPrint, &msg))
    {
			TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  }
  return !bUserAbort;
}

HDC GetPrinterDC (void)
{
  static char szPrinter[80];
  char *szDevice, *szDriver, *szOutput;

  GetProfileString("windows", "device", ",,,", szPrinter, 80);

#pragma warn -pia
  if (((szDevice = strtok (szPrinter, ",")) &&
       (szDriver = strtok (NULL     , ", "))) &&
       (szOutput = strtok (NULL     , ", ")))
#pragma warn .pia
  {
		return CreateDC(szDriver, szDevice, szOutput, NULL);
  }
  else return 0;
}

BOOL PrintFile (HANDLE hInst, HWND hwnd, HWND hwndEdit, char *szFileName)
{
	BOOL        bError = FALSE;
	char        szMsg[40];
	FARPROC     lpfnAbortProc, lpfnPrintDlgProc;
	HDC         hdcPrn;
	NPSTR       psBuffer;
	short       yChar, nCharsPerLine, nLinesPerPage,
							nTotalLines, nTotalPages, nPage, nLine, nLineNum = 0;
	int         nEscapeReturn;
	TEXTMETRIC  tm;

	if (0 ==
		 (nTotalLines = (short) SendMessage(hwndEdit, EM_GETLINECOUNT, 0 , 0L)))
  {
		return FALSE;
  }

	if (NULL == (hdcPrn = GetPrinterDC()))
  {
		return TRUE;
  }

	/* set printer font */
	GetTextMetrics (hdcPrn, &tm) ;
	yChar = tm.tmHeight  + tm.tmExternalLeading;

	nCharsPerLine = GetDeviceCaps (hdcPrn, HORZRES) / tm.tmAveCharWidth;
	nLinesPerPage = GetDeviceCaps (hdcPrn, VERTRES) / yChar;
	nTotalPages   = (nTotalLines + nLinesPerPage - 1) / nLinesPerPage;

	psBuffer = (NPSTR) LocalAlloc(LPTR, nCharsPerLine);

	EnableWindow(hwnd, FALSE);

	bUserAbort = FALSE;
	lpfnPrintDlgProc = MakeProcInstance(PrintDlgProc, hInst);
	hDlgPrint = CreateDialog(hInst, "PrintDlgBox", hwnd, lpfnPrintDlgProc);
	SetDlgItemText (hDlgPrint, IDD_FNAME, szFileName);

	lpfnAbortProc = MakeProcInstance (AbortProc, hInst);
	Escape (hdcPrn, SETABORTPROC, 0, (LPSTR)lpfnAbortProc, NULL);

	strcat (strcat (strcpy (szMsg, szAppName), " - "), szFileName);

	nEscapeReturn = Escape(hdcPrn, STARTDOC, strlen(szMsg), szMsg, NULL);

	if (nEscapeReturn < 0)
  {
		bError = TRUE;
  }
	else
	{
		for (nPage = 0; nPage < nTotalPages; nPage++)
		{
			for (nLine = 0; nLine < nLinesPerPage &&
	 				 nLineNum < nTotalLines; nLine++, nLineNum++)
			{
				*(short *) psBuffer = nCharsPerLine;
				TabbedTextOut(hdcPrn, 0, yChar * nLine, psBuffer,
											(short) SendMessage (hwndEdit, EM_GETLINE, nLineNum,
							  			(LONG) (LPSTR) psBuffer), 0, NULL, 0);
			}

			nEscapeReturn = Escape(hdcPrn, NEWFRAME, 0, NULL, NULL) ;

			if (nEscapeReturn < 0)
			{
				bError = TRUE;
				break;
			}

#pragma warn -rch
			if (bUserAbort)
      {
				break;
      }
#pragma warn .rch
		}
	}

	if (!bError)
  {
		Escape(hdcPrn, ENDDOC, 0, NULL, NULL);
  }

	if (!bUserAbort)
	{
		EnableWindow(hwnd, TRUE);
		DestroyWindow(hDlgPrint);
	}

	if (bError || bUserAbort)
	{
		strcat(strcpy(szMsg, "Could not print: "), szFileName);
		MessageBox (hwnd, szMsg, szAppName, MB_OK | MB_ICONEXCLAMATION);
	}

	LocalFree ((LOCALHANDLE) psBuffer);
	FreeProcInstance (lpfnPrintDlgProc);
	FreeProcInstance (lpfnAbortProc);;

	DeleteDC (hdcPrn);

	return bError || bUserAbort;
}

void OkMessageBox(HWND hwnd, char *szString, char *szFileName)
{
	char szBuffer [256];
  wsprintf (szBuffer, szString, (LPSTR) szFileName);
  MessageBox(hwnd, szBuffer, szAppName, MB_OK | MB_ICONEXCLAMATION);
}

long FileLength (HANDLE hFile)
{
	long    lCurrentPos = _llseek(hFile, 0L, 1);
	long    lFileLength = _llseek(hFile, 0L, 2);

	_llseek(hFile, lCurrentPos, 0);

	return lFileLength;
}

BOOL GetOutFile (HWND hwnd)
{
	char szBuffer[256];

	lstrcpy(szFileNameOut, szFileNameIn);

	*(lstrrchr(szFileNameOut, '.')) = '\0';

	lstrcat(szFileNameOut, ".out");

	if (!DoOutFileDlg (hwnd, szFileNameOut))
  {
		return FALSE;
  }

	return TRUE;
}

BOOL ReadFile (HWND hwnd, HWND hwndEdit, POFSTRUCT pof, LPSTR szFileName,
							 BOOL bAskName)
{
  DWORD dwLength;
  HANDLE hFile, hTextBuffer;
	LPSTR lpTextBuffer;
	char szBuffer[80];
  int nResult;

  if (bAskName)
  {
		if (!DoFileOpenDlg (hwnd, szFileName))
    {
      return FALSE;
    }
	}

#pragma warn -rng
	if (-1 == (hFile = OpenFile(szFileName, pof, OF_READ)))
  {
    OkMessageBox(hwnd, "Cannot open file %s", szFileName);
    return FALSE;
  }

	if ((dwLength = FileLength(hFile)) < 48000)
	{
		EnableWindow(hwndEdit, TRUE);

		if (NULL == (hTextBuffer = GlobalAlloc(GHND, (DWORD) dwLength + 1)))
	  {
  	  _lclose(hFile);
    	OkMessageBox(hwnd,"Not enough memory for %s", szFileName);
	    return FALSE;
  	}

	  lpTextBuffer = GlobalLock (hTextBuffer);
  	_lread(hFile, lpTextBuffer, (WORD) dwLength);
	  _lclose(hFile);

  	lpTextBuffer [(WORD) dwLength] = '\0';

	  SetWindowText (hwndEdit, lpTextBuffer);
  	GlobalUnlock (hTextBuffer);
		GlobalFree(hTextBuffer);
	}
	else
	{
		_lclose(hFile);
		sprintf(szBuffer, "%s is too large to edit.\n\n"
											"Run %s without editing?",
					  szFileName, szFileName);

		nResult = MessageBox(hwnd, szBuffer, "LF File too large",
    										 MB_YESNO | MB_ICONQUESTION);	
		if (nResult == IDNO)
		{
			return FALSE;
		}
		else
		{
			PostMessage(hwnd, WM_COMMAND, IDM_RUN, 0L);
			EnableWindow(hwndEdit, FALSE);
    }
  }

  return TRUE;
}

BOOL WriteFile (HWND hwnd, HWND hwndEdit, POFSTRUCT pof, LPSTR szFileName,
								BOOL bAskName)
{
  char szBuffer[40];
  HANDLE hFile, hTextBuffer;
  NPSTR npTextBuffer;
	WORD wStatus, wLength;

  if (bAskName)
  {
		if(!DoFileSaveDlg (hwnd, szFileName))
		{
			return(FALSE);
    }
	}
	else
  {
		OpenFile (szFileName, pof, OF_PARSE);
  }

  if (-1 == (hFile = OpenFile(szFileName, pof, OF_CREATE)))
  {
    OkMessageBox(hwnd, "Cannot create file %s", szFileName);
    return FALSE;
  }
#pragma warn .rng

  wLength = GetWindowTextLength(hwndEdit);
  hTextBuffer = (HANDLE) SendMessage (hwndEdit, EM_GETHANDLE, 0, 0L);
  npTextBuffer = LocalLock(hTextBuffer);

  if (wLength != _lwrite(hFile, npTextBuffer, wLength))
  {
    _lclose(hFile);
    OkMessageBox(hwnd, "Cannot write file %s to disk: ", szFileName);
    return FALSE;
  }

  _lclose(hFile);
  LocalUnlock(hTextBuffer);

  return TRUE;
}
