
/*  A Bison parser, made from winsynan.y  */

#define	FUNCTION	258
#define	DOMAINS	259
#define	CODOMAINS	260
#define	DIMENSIONS	261
#define	EQUALS	262
#define	INTEGER	263
#define	QUANTIZATION	264
#define	COLON	265
#define	TRAINING	266
#define	SET	267
#define	_SIZE	268
#define	TEST	269
#define	CODING	270
#define	LARGEST	271
#define	SMALLEST	272
#define	REAL	273
#define	TREE	274
#define	MIN	275
#define	MAX	276
#define	CORRECT	277
#define	EPOCHS	278
#define	VOTE	279
#define	IDENTIFIER	280
#define	STRING	281
#define	SAVE	282
#define	TO	283
#define	LOAD	284
#define	FROM	285
#define	FOLDED	286

#line 1 "winsynan.y"

/*****************************************************************************
 ****                                                                     ****
 **** winsynan.y                                                          ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, M. Thomas, W.W. Armstrong ****
 ****               1991, 1992                                            ****
 ****                                                                     ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 90.02.10 Initial implementation, A.Dwelly                           ****
 **** 91.07.15 Release 2, Rolf Manderscheid                               ****
 **** 91.07.15 Windows Port, M. Thomas                                    ****
 **** 92.04.27 atree v2.5, M. Thomas                                      ****
 **** 92.03.07 Release 2.6, Monroe Thomas                                 ****
 **** 92.01.08 Release 2.7, Monroe Thomas                                 ****
 ****                                                                     ****
 *****************************************************************************/

#include "atree.h"
#include "lf.h"

extern BOOL train_size_flag;
extern BOOL test_size_flag;
extern BOOL largest_flag;
extern BOOL smallest_flag;
extern BOOL fold_flag;
extern BOOL code_flag;
extern BOOL quant_flag;
extern prog_t prog;

FILE *yyin;
int line_no;

static BOOL first = TRUE;
static int tuple_ptr;
static int table_ptr;
static int table_size;
extern float far * far *tmp_table;
char szBuffer[120];

void
yyerrexit()
{
	int i;

	first = TRUE;

	if (tmp_table != NULL)
		Free(tmp_table);

	for(i = 0; i < prog.total_dimensions; i++)
	{
		if (prog.trainset_sz && prog.train_table[i] != NULL)
			Free(prog.train_table[i]);

		if (prog.testset_sz && prog.test_table[i] != NULL)
			Free(prog.test_table[i]);
	}

	if (prog.train_table != NULL)
		Free(prog.train_table);

	if (prog.test_table != NULL)
		Free(prog.test_table);

	if (prog.walk_step != NULL)
		Free(prog.walk_step);

	if (prog.code != NULL)
		Free(prog.code);
}


#ifndef YYLTYPE
typedef
  struct yyltype
    {
      int timestamp;
      int first_line;
      int first_column;
      int last_line;
      int last_column;
      char *text;
   }
  yyltype;

#define YYLTYPE yyltype
#endif

#ifndef YYSTYPE
#define YYSTYPE int
#endif
#include <stdio.h>

#ifndef __STDC__
#define const
#endif



#define	YYFINAL		122
#define	YYFLAG		-32768
#define	YYNTBASE	32

#define YYTRANSLATE(x) ((unsigned)(x) <= 286 ? yytranslate[x] : 68)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     2,     3,     4,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
    26,    27,    28,    29,    30,    31
};

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   139,   140,   143,   178,   178,   190,   194,   207,   208,   211,
   212,   213,   214,   215,   216,   217,   218,   219,   222,   235,
   251,   265,   281,   294,   310,   337,   348,   352,   365,   372,
   401,   421,   428,   457,   478,   491,   506,   507,   513,   519,
   535,   543,   553,   559,   575,   583,   592,   594,   595,   597,
   598,   599,   600,   601,   604,   627,   632,   637,   651,   657,
   663
};

static const char * const yytname[] = {     0,
"error","$illegal.","FUNCTION","DOMAINS","CODOMAINS","DIMENSIONS","EQUALS","INTEGER","QUANTIZATION","COLON",
"TRAINING","SET","_SIZE","TEST","CODING","LARGEST","SMALLEST","REAL","TREE","MIN",
"MAX","CORRECT","EPOCHS","VOTE","IDENTIFIER","STRING","SAVE","TO","LOAD","FROM",
"FOLDED","program"
};
#endif

static const short yyr1[] = {     0,
    32,    32,    34,    33,    35,    36,    36,    37,    37,    38,
    38,    38,    38,    38,    38,    38,    38,    38,    40,    39,
    41,    41,    43,    42,    44,    44,    45,    45,    46,    48,
    47,    49,    51,    50,    52,    52,    53,    53,    55,    54,
    56,    56,    58,    57,    59,    59,    60,    61,    61,    62,
    62,    62,    62,    62,    63,    64,    64,    64,    65,    66,
    67
};

static const short yyr2[] = {     0,
     2,     2,     0,     5,     4,     0,     4,     1,     2,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     0,     4,
     1,     2,     0,     4,     3,     4,     4,     4,     5,     0,
     5,     5,     0,     5,     1,     2,     1,     1,     0,     4,
     1,     2,     0,     4,     1,     2,     2,     1,     2,     1,
     1,     1,     1,     1,     3,     4,     5,     4,     4,     4,
     3
};

static const short yydefact[] = {     0,
     0,     0,     0,     0,     0,     6,     0,     0,     0,     0,
     0,     0,    47,    48,    50,    51,    52,    53,    54,     1,
     2,     0,     0,     3,     0,     0,     0,     0,     0,     0,
     0,    49,     0,     0,     0,    55,     0,     0,    61,     0,
     0,     0,     5,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     4,     8,    10,    11,    12,    13,    14,    15,
    16,    17,    18,    59,    60,    56,     0,    58,     7,    19,
     0,     0,    23,    39,    43,     0,     0,     9,    57,     0,
    30,     0,    33,     0,     0,     0,     0,     0,     0,    21,
    20,     0,     0,     0,     0,     0,    24,    38,    37,    41,
    40,    45,    44,    27,    28,    22,    31,    35,    29,    34,
    32,     0,     0,    42,    46,    36,    25,     0,    26,     0,
     0,     0
};

static const short yydefgoto[] = {   120,
     3,    35,     6,    24,    53,    54,    55,    80,    91,    56,
    85,    97,    57,    58,    59,    92,    60,    61,    94,   107,
   108,    62,    86,   101,    63,    87,   103,     4,    13,    14,
    15,    16,    17,    18,    19
};

static const short yypact[] = {     0,
     1,     5,    -6,     9,     8,    26,    21,    13,    14,    31,
    -8,    22,     5,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,    32,    34,-32768,    35,    37,    38,    39,    18,    29,
    12,-32768,    41,    43,    -7,-32768,    44,    45,-32768,    25,
    27,    28,-32768,    48,    50,    46,    47,    53,    54,    55,
    49,    51,    -7,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,    42,-32768,-32768,-32768,
    20,    23,-32768,-32768,-32768,    52,    33,-32768,-32768,    57,
-32768,    60,-32768,    62,    63,    -2,    -2,    56,    58,-32768,
    64,    -2,    65,    -2,    66,    67,    68,-32768,-32768,-32768,
    -2,-32768,    -2,-32768,-32768,-32768,    -2,-32768,-32768,    -2,
-32768,    70,    69,-32768,-32768,-32768,-32768,    73,-32768,    75,
    83,-32768
};

static const short yypgoto[] = {-32768,
    81,-32768,-32768,-32768,-32768,    17,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,    -5,
   -86,-32768,-32768,-32768,-32768,-32768,-32768,    84,-32768,    77,
-32768,-32768,-32768,-32768,-32768
};


#define	YYLAST		90


static const short yytable[] = {   100,
   102,    45,     1,    46,     5,    98,    47,    48,    49,    50,
    29,     1,     2,    22,   114,    99,   115,     7,     2,    51,
   116,    52,    30,   116,     8,     9,    81,    25,    10,    83,
    23,    11,    82,    12,    26,    84,    27,    28,    33,    34,
    31,    42,    36,    37,    38,    40,    39,    41,    43,    44,
    66,    64,    65,    68,    67,    69,    70,    71,    72,    73,
    74,    75,    89,    76,    90,    77,    93,    79,    95,    78,
    96,   106,   109,   111,   121,   113,   112,   117,   118,    88,
   119,   104,   122,   105,    21,     0,    20,     0,   110,    32
};

static const short yycheck[] = {    86,
    87,     9,     3,    11,     4,     8,    14,    15,    16,    17,
    19,     3,    19,     6,   101,    18,   103,    13,    19,    27,
   107,    29,    31,   110,    20,    21,     7,     7,    24,     7,
     5,    27,    13,    29,    22,    13,    23,     7,     7,     6,
    19,    30,     8,     7,     7,    28,     8,    19,     8,     7,
    26,     8,     8,    26,    28,     8,     7,    12,    12,     7,
     7,     7,    30,    15,     8,    15,     7,    26,     7,    53,
     8,     8,     8,     8,     0,     8,    10,     8,    10,    28,
     8,    26,     0,    26,     4,    -1,     3,    -1,    94,    13
};
#define YYPURE 1

/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "bison.sim"

/* modification made by MONROE THOMAS 07/18/91 after call to YYLEX to 
   check for negative return value YYEXIT.  Needed for Windows version 
   of parser where exit() calls are not desireable.  Instead, 
   yyparse() will return YYABORT to its caller if yylex() returns 
   YYEXIT.  Users should use return(1) calls in their action file that 
   becomes part of yyparse() instead of exit(1) */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Bob Corbett and Richard Stallman

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifdef __GNUC__
#define alloca __builtin_alloca
#else /* Not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__)
#include <alloca.h>
#endif /* Sparc.  */
#endif /* Not GNU C.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)
#define YYEMPTY         -2

/* next define added by M. THOMAS 07/18/91 */

#define YYEXIT          -3

#define YYEOF           0
#define YYACCEPT        return(0)
#define YYABORT         return(1)
#define YYERROR         goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL          goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do                                                              \
  if (yychar == YYEMPTY && yylen == 1)                          \
    { yychar = (token), yylval = (value);                       \
      yychar1 = YYTRANSLATE (yychar);                           \
      YYPOPSTACK;                                               \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    { yyerror ("syntax error: cannot back up"); YYERROR; }      \
while (0)

#define YYTERROR        1
#define YYERRCODE       256

#ifndef YYIMPURE
#define YYLEX           yylex()
#endif

#ifndef YYPURE
#define YYLEX           yylex(&yylval, &yylloc)
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYIMPURE

int     yychar;                 /*  the lookahead symbol                */
YYSTYPE yylval;                 /*  the semantic value of the           */
                /*  lookahead symbol                    */

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;                 /*  location data for the lookahead     */
                /*  symbol                              */
#endif

int yynerrs;                    /*  number of parse errors so far       */
#endif  /* YYIMPURE */

#if YYDEBUG != 0
int yydebug;                    /*  nonzero means print parse trace     */
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks       */

#ifndef YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_bcopy (from, to, count)
     char *from;
     char *to;
     int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#line 143 "bison.sim"
int
yyparse()
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;      /*  number of tokens to shift before error messages enabled */
  int yychar1;          /*  lookahead token as an internal (translated) token number */

  short yyssa[YYINITDEPTH];     /*  the state stack                     */
  YYSTYPE yyvsa[YYINITDEPTH];   /*  the semantic value stack            */

  short *yyss = yyssa;          /*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;        /*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  YYLTYPE yylsa[YYINITDEPTH];   /*  the location stack                  */

#define YYPOPSTACK   (yyvsp--, yysp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yysp--)
#endif

  int yystacksize = YYINITDEPTH;

#ifndef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;                /*  the variable used to return         */
                /*  semantic values from the action     */
                /*  routines                            */

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;             /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
     the data in use in that stack, in bytes.  */
      yyoverflow("parser stack overflow",
         &yyss1, size * sizeof (*yyssp),
         &yyvs1, size * sizeof (*yyvsp),
#ifdef YYLSP_NEEDED
         &yyls1, size * sizeof (*yylsp),
#endif
         &yystacksize);

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
    {
      yyerror("parser stack overflow");
      return 2;
    }
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
    yystacksize = YYMAXDEPTH;
      yyss = (short *) alloca (yystacksize * sizeof (*yyssp));
      __yy_bcopy ((char *)yyss1, (char *)yyss, size * sizeof (*yyssp));
      yyvs = (YYSTYPE *) alloca (yystacksize * sizeof (*yyvsp));
      __yy_bcopy ((char *)yyvs1, (char *)yyvs, size * sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) alloca (yystacksize * sizeof (*yylsp));
      __yy_bcopy ((char *)yyls1, (char *)yyls, size * sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
    fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
    YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
    fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;

  /* next test added by M. THOMAS. 07/18/91 */

      if (yychar == YYEXIT) YYABORT;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)              /* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;           /* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
    fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
    fprintf(stderr, "Next token is %d (%s)\n", yychar, yytname[yychar1]);
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
    goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      if (yylen == 1)
    fprintf (stderr, "Reducing 1 value via rule %d (line %d), ",
         yyn, yyrline[yyn]);
      else
    fprintf (stderr, "Reducing %d values via rule %d (line %d), ",
         yylen, yyn, yyrline[yyn]);
    }
#endif


  switch (yyn) {

case 3:
#line 144 "winsynan.y"
{
				  int dim;

				  prog.total_dimensions = prog.dimensions + prog.codimensions;

				  prog.train_table = (float far * far *)
					  Malloc((unsigned)sizeof(float far *) * prog.total_dimensions);
				  MEMCHECK(prog.train_table);

				  prog.test_table = (float far * far *)
					  Malloc((unsigned)sizeof(float far *) * prog.total_dimensions);
				  MEMCHECK(prog.test_table);

				  prog.walk_step = (int far *)
					  Malloc((unsigned)sizeof(int) * prog.total_dimensions);
				  MEMCHECK(prog.walk_step);

				  prog.code = (LPCODE_T)
					  Malloc((unsigned)sizeof(code_t) * prog.total_dimensions);
				  MEMCHECK(prog.code);

				  tmp_table = (float far * far *)
					  Malloc((unsigned)sizeof(float far *) * prog.total_dimensions);
				  MEMCHECK(tmp_table);

				  for(dim = 0; dim < prog.total_dimensions; dim++)
				  {
					  prog.test_table[dim] = NULL;
					  prog.train_table[dim] = NULL;
					  tmp_table[dim] = NULL;
				  }
			 ;
    break;}
case 5:
#line 179 "winsynan.y"
{
			  prog.dimensions = yyvsp[0].i;
			  if (prog.dimensions < 1)
			  {
				  wsprintf(szBuffer, "number of domain dimensions must be at least 1, line %d.\n", line_no);
				  MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				  yyerrexit();
				  return(1);
			  }
		  ;
    break;}
case 6:
#line 191 "winsynan.y"
{
				prog.codimensions = 1;
			;
    break;}
case 7:
#line 195 "winsynan.y"
{
				prog.codimensions = yyvsp[0].i;
				if (prog.codimensions < 1)
				{
					wsprintf(szBuffer, "number of codomain dimensions must be at least 1, line %d.\n", line_no);
					MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
					yyerrexit();
					return(1);
				}
			;
    break;}
case 19:
#line 223 "winsynan.y"
{
				 tuple_ptr = 0;
				 quant_flag = TRUE;
				 if (prog.load_code)
				 {
					 wsprintf(szBuffer,
						"warning: coding(s) will be read from file '%s',\n\tquantization statement ignored, line %d.\n",
						(LPSTR)prog.load_code,line_no);
					 MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				 }
			 ;
    break;}
case 20:
#line 235 "winsynan.y"
{
				 if (tuple_ptr > prog.total_dimensions)
				 {
					 prog.error = TRUE;
					 wsprintf(szBuffer, "too many elements in quantization list on line %d.\n", line_no);
					 MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				 }
				 if (tuple_ptr < prog.total_dimensions)
				 {
					 prog.error = TRUE;
					 wsprintf(szBuffer, "too few elements in quantization list on line %d.\n", line_no);
					 MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				 }
			;
    break;}
case 21:
#line 252 "winsynan.y"
{
			   if (tuple_ptr < prog.total_dimensions)
			   {
				   prog.code[tuple_ptr].vector_count = yyvsp[0].i;
				   if (yyvsp[0].i < 2)
				   {
					   prog.error = TRUE;
					   wsprintf(szBuffer, "must have at least 2 quantization levels, column %d.\n", tuple_ptr + 1);
					   MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				   }
			   }
			   tuple_ptr++;
		   ;
    break;}
case 22:
#line 266 "winsynan.y"
{
			   if (tuple_ptr < prog.total_dimensions)
			   {
				   prog.code[tuple_ptr].vector_count = yyvsp[0].i;
				   if (yyvsp[0].i < 2)
				   {
					   prog.error = TRUE;
					   wsprintf(szBuffer, "must have at least 2 quantization levels, column %d.\n", tuple_ptr + 1);
					   MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				   }
			   }
			   tuple_ptr++;
		   ;
    break;}
case 23:
#line 282 "winsynan.y"
{
		   tuple_ptr = 0;
		   code_flag = TRUE;
		   if (prog.load_code)
		   {
			   wsprintf(szBuffer,
					"warning: coding(s) will be read from file '%s',\n\tcoding statement ignored, line %d.\n",
						 (LPSTR)prog.load_code, line_no);
			   MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
		   }
	   ;
    break;}
case 24:
#line 294 "winsynan.y"
{
		   if (tuple_ptr > prog.total_dimensions)
		   {
			   prog.error = TRUE;
			   wsprintf(szBuffer, "too many elements in coding list on line %d.\n", line_no);
			   MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
		   }
		   if (tuple_ptr < prog.total_dimensions)
		   {
			   prog.error = TRUE;
			   wsprintf(szBuffer, "too few elements in coding list on line %d.\n", line_no);
			   MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
		   }
	   ;
    break;}
case 25:
#line 311 "winsynan.y"
{
			  if (tuple_ptr < prog.total_dimensions)
			  {
				  prog.code[tuple_ptr].width = yyvsp[-2].i;
				  prog.walk_step[tuple_ptr] = yyvsp[0].i;
				  if (yyvsp[-2].i < 1)
				  {
					  prog.error = TRUE;
					  wsprintf(szBuffer, "coding width must be at least 1, column %d.\n", tuple_ptr + 1);
					  MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				  }
				  if (yyvsp[0].i < 1)
				  {
					  prog.error = TRUE;
					  wsprintf(szBuffer, "coding distance must be at least 1, column %d.\n", tuple_ptr + 1);
					  MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				  }
				  if (yyvsp[0].i > yyvsp[-2].i)
				  {
					  prog.error = TRUE;
					  wsprintf(szBuffer, "coding distance must not be greater than coding width, column %d.\n", tuple_ptr + 1);
					  MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				  }
			  }
			  tuple_ptr++;
		  ;
    break;}
case 26:
#line 338 "winsynan.y"
{
			  if (tuple_ptr < prog.total_dimensions)
			  {
				  prog.code[tuple_ptr].width = yyvsp[-2].i;
				  prog.walk_step[tuple_ptr] = yyvsp[0].i;
			  }
			  tuple_ptr++;
		  ;
    break;}
case 27:
#line 349 "winsynan.y"
{
			  prog.save_code = yyvsp[0].s;
		  ;
    break;}
case 28:
#line 353 "winsynan.y"
{
			  prog.load_code = yyvsp[0].s;
			  if (code_flag || quant_flag)
			  {
				  wsprintf(szBuffer,
						"warning: coding(s) will be read from file '%s',\n\tcoding and quantization statements ignored.\n",
						 (LPSTR)prog.load_code);
				  MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
			  }
		  ;
    break;}
case 29:
#line 366 "winsynan.y"
{
				prog.trainset_sz = yyvsp[0].i;
				train_size_flag = TRUE;
			;
    break;}
case 30:
#line 373 "winsynan.y"
{
				if (!train_size_flag)
				{
					wsprintf(szBuffer, "training set defined before size.\n");
					MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
					yyerrexit();
					return(1);
				}
				else
				{
					int dim;

					tuple_ptr = 0;
					table_ptr = 0;
					table_size = prog.trainset_sz;

					if (table_size > 0)
					{
						for (dim = 0; dim < prog.total_dimensions; dim++)
						{
							tmp_table[dim] = (float far *)
								Malloc((unsigned) sizeof(float) * table_size);
							MEMCHECK(tmp_table[dim]);
						}
					}
				}
			;
    break;}
case 31:
#line 401 "winsynan.y"
{
				int dim;

				if (tuple_ptr < prog.trainset_sz)
				{
					prog.error = TRUE;
					wsprintf(szBuffer,"too few elements in training set.\n");
					MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				}
				else if (tuple_ptr > prog.trainset_sz || table_ptr != 0)
				{
					wsprintf(szBuffer, "warning: extra elements in training set ignored.\n");
					MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				}
				for (dim = 0; dim < prog.total_dimensions; dim++)
				{
					prog.train_table[dim] = (prog.trainset_sz ? tmp_table[dim] : NULL);
				}
			;
    break;}
case 32:
#line 422 "winsynan.y"
{
				prog.testset_sz = yyvsp[0].i;
				test_size_flag = TRUE;
			;
    break;}
case 33:
#line 429 "winsynan.y"
{
				if (!test_size_flag)
				{
					wsprintf(szBuffer, "test set defined before size.\n");
					MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
					yyerrexit();
					return(1);
				}
				else
				{
					int dim;

					tuple_ptr = 0;
					table_ptr = 0;
					table_size = prog.testset_sz;

					if (table_size > 0)
					{
						for (dim = 0; dim < prog.total_dimensions; dim++)
						{
							tmp_table[dim] = (float far *)
								Malloc((unsigned)sizeof(float) * table_size);
							MEMCHECK(tmp_table[dim]);
						}
					}
				}
			;
    break;}
case 34:
#line 457 "winsynan.y"
{
				int dim;

				if (tuple_ptr < prog.testset_sz)
				{
					prog.error = TRUE;
					wsprintf(szBuffer, "too few elements in test set.\n");
					MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				}
				else if (tuple_ptr > prog.testset_sz || table_ptr != 0)
				{
					wsprintf(szBuffer, "warning: extra elements in test set ignored.\n");
					MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				}
				for (dim = 0; dim < prog.total_dimensions; dim++)
				{
					prog.test_table[dim] = (prog.testset_sz ? tmp_table[dim] : NULL);
				}
			;
    break;}
case 35:
#line 479 "winsynan.y"
{
		  if (tuple_ptr < table_size)
		  {
			  tmp_table[table_ptr][tuple_ptr] = yyvsp[0].f;
		  }
		  table_ptr++;
		  if (table_ptr == prog.total_dimensions)
		  {
			  table_ptr = 0;
			  tuple_ptr++;
		  }
	  ;
    break;}
case 36:
#line 492 "winsynan.y"
{
		  if (tuple_ptr < table_size)
		  {
			  tmp_table[table_ptr][tuple_ptr] = yyvsp[0].f;
		  }
		  table_ptr++;
		  if (table_ptr == prog.total_dimensions)
		  {
			  table_ptr = 0;
			  tuple_ptr++;
		  }
	  ;
    break;}
case 38:
#line 508 "winsynan.y"
{
		yyval.f = (float) yyvsp[0].i;
	;
    break;}
case 39:
#line 514 "winsynan.y"
{
				 tuple_ptr = 0;
				 largest_flag = TRUE;
			 ;
    break;}
case 40:
#line 519 "winsynan.y"
{
				 if (tuple_ptr > prog.total_dimensions)
				 {
					 prog.error = TRUE;
					 wsprintf(szBuffer, "too many elements in largest list on line %d.\n", line_no);
					 MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				 }
				 if (tuple_ptr < prog.total_dimensions)
				 {
					 prog.error = TRUE;
					 wsprintf(szBuffer, "too few elements in largest list on line %d.\n", line_no);
					 MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				 }
			 ;
    break;}
case 41:
#line 536 "winsynan.y"
{
				 if (tuple_ptr < prog.total_dimensions)
				 {
					 prog.code[tuple_ptr].high = yyvsp[0].f;
				 }
				 tuple_ptr++;
			 ;
    break;}
case 42:
#line 544 "winsynan.y"
{
                 if (tuple_ptr < prog.total_dimensions)
				 {
					 prog.code[tuple_ptr].high = yyvsp[0].f;
                 }
                 tuple_ptr++;
             ;
    break;}
case 43:
#line 554 "winsynan.y"
{
				 tuple_ptr = 0;
                 smallest_flag = TRUE;
			 ;
    break;}
case 44:
#line 559 "winsynan.y"
{
				 if (tuple_ptr > prog.total_dimensions)
				 {
					 prog.error = TRUE;
					 wsprintf(szBuffer, "too many elements in smallest list on line %d.\n", line_no);
					 MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				 }
				 else if (tuple_ptr < prog.total_dimensions)
				 {
					 prog.error = TRUE;
					 wsprintf(szBuffer, "too few elements in smallest list on line %d.\n", line_no);
					 MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				 }
			 ;
    break;}
case 45:
#line 576 "winsynan.y"
{
				 if (tuple_ptr < prog.total_dimensions)
				 {
					 prog.code[tuple_ptr].low = yyvsp[0].f;
                 }
                 tuple_ptr++;
			 ;
    break;}
case 46:
#line 584 "winsynan.y"
{
                 if (tuple_ptr < prog.total_dimensions)
                 {
					 prog.code[tuple_ptr].low = yyvsp[0].f;
                 }
                 tuple_ptr++;
             ;
    break;}
case 55:
#line 605 "winsynan.y"
{
              if (prog.load_tree)
              {
                  wsprintf(szBuffer,
						  "warning: tree(s) will be read from file '%s',\n\ttree size statement ignored, line %d.\n",
                           (LPSTR)prog.load_tree, line_no);
                  MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
              }
			  else if (yyvsp[0].i < 1)
			  {
				  wsprintf(szBuffer, "lf: tree size too small, line %d.\n",
								 line_no);
                  MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				  prog.error++;
			  }
              else
              {
                  prog.tree_sz = yyvsp[0].i;
			  }
          ;
    break;}
case 56:
#line 628 "winsynan.y"
{
            prog.save_tree = yyvsp[0].s;
            fold_flag = FALSE;
		;
    break;}
case 57:
#line 633 "winsynan.y"
{
			prog.save_tree = yyvsp[0].s;
			fold_flag = TRUE;
		;
    break;}
case 58:
#line 638 "winsynan.y"
{
			prog.load_tree = yyvsp[0].s;
			if (prog.tree_sz > 0)
			{
				wsprintf(szBuffer,
						  "lf: warning: tree(s) will be read from file '%s',\n\ttree size statement ignored, line %d.\n",
						  (LPSTR)prog.load_tree,line_no);
				MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
			}
		;
    break;}
case 59:
#line 652 "winsynan.y"
{
				prog.min_correct = yyvsp[0].i;
			;
    break;}
case 60:
#line 658 "winsynan.y"
{
			   prog.max_epochs = yyvsp[0].i;
		   ;
    break;}
case 61:
#line 664 "winsynan.y"
{
			if (yyvsp[0].i % 2 != 1)
			{
				wsprintf(szBuffer,
							   "vote number must be odd, line %d.\n",
							   line_no);
				MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
				yyerrexit();
				return(1);
			}
			prog.vote = yyvsp[0].i;
		;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 378 "bison.sim"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
    fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
    {
      int size = 0;
      char *msg;
      int x, count;

      count = 0;
      for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
        if (yycheck[x + yyn] == x)
          size += strlen(yytname[x]) + 15, count++;
      msg = (char *) xmalloc(size + 15);
      strcpy(msg, "parse error");

      if (count < 5)
        {
          count = 0;
          for (x = 0; x < (sizeof(yytname) / sizeof(char *)); x++)
        if (yycheck[x + yyn] == x)
          {
            strcat(msg, count == 0 ? ", expecting `" : " or `");
            strcat(msg, yytname[x]);
            strcat(msg, "'");
            count++;
          }
        }
      yyerror(msg);
      free(msg);
    }
      else
#endif /* YYERROR_VERBOSE */
    yyerror("parse error");
    }

yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
    YYABORT;

#if YYDEBUG != 0
      if (yydebug)
    fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;              /* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
    fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
    goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;
}
#line 677 "winsynan.y"


yyerror(description)
char *description;
{
	wsprintf(szBuffer, "%s, line %d.\n", (LPSTR)description, line_no);
	MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
	prog.error = TRUE;
	yyerrexit();	/* prepare for exit */
	return(0);
}


/* Lexical states */

#define LEX_START 0
#define LEX_INT 1
#define LEX_DEC 2
#define LEX_IDENT 3
#define LEX_PUNCT 4
#define LEX_COMMENT 5
#define LEX_STRING 6
#define LEX_STOP 1000

#define ISCOMMENT(c) ((c) == '#')
#define MAX_LEN_BUF 1000

static char yytext[MAX_LEN_BUF];
static int lexstate;
static int nextchar;


static void
lexinit()

{
	lexstate = LEX_START;
	nextchar = getc(yyin);
}

isextdigit(c)

char c;

{
	return((c == 'e') || (c == 'E') || (c == '+') || (c == '-') || isdigit(c));
}

iswhite(c)

char c;

{
	if (c == '\n')
	{
		line_no++;
		return(TRUE);
	}
	else
	{
		return((c == 0) || (c == ' ') || (c == '\t'));
	}
}

static int
gettoken(str)

char *str;

{

	int i;
	int outcode;

	static struct tok
	{
		char *token;
		int code;
	} toktab[] =
	{
		"function"    , FUNCTION,
		"dimension"   , DIMENSIONS,
		"dimensions"  , DIMENSIONS,
		"="           , EQUALS,
		"quantization", QUANTIZATION,
		":"           , COLON,
		"coding"      , CODING,
		"training"    , TRAINING,
		"set"         , SET,
		"size"        , _SIZE,
		"test"        , TEST,
		"tree"        , TREE,
		"minimum"     , MIN,
		"min"         , MIN,
		"maximum"     , MAX,
		"max"         , MAX,
		"correct"     , CORRECT,
		"epochs"      , EPOCHS,
		"largest"     , LARGEST,
		"smallest"    , SMALLEST,
		"domain"      , DOMAINS,
		"codomain"    , CODOMAINS,
		"vote"        , VOTE,
		"save"        , SAVE,
		"to"          , TO,
		"load"        , LOAD,
		"from"        , FROM,
		"folded"      , FOLDED,
		NULL          ,0
	};

	outcode = IDENTIFIER;

	for (i = 0; toktab[i].token != NULL; i++)
	{
		if (strcmp(str,toktab[i].token) == 0)
		{
			outcode = toktab[i].code;
			break;
		}
	}

	return(outcode);
}

static int
yylex()

{
	int bufptr;
	BOOL found_token;
	int token;

	found_token = FALSE;
	bufptr = 0;

	if (first)
	{
		first = FALSE;
		lexinit();
	}

	while (!found_token)
	{
		switch (lexstate)
		{
			case LEX_START:
				while (iswhite(nextchar))
				{
					 nextchar = getc(yyin);
				}

				if (ISCOMMENT(nextchar))
				{
					nextchar = getc(yyin);
					lexstate = LEX_COMMENT;
				}
				else if (isdigit(nextchar) || (nextchar == '-'))
				{
					yytext[bufptr++] = nextchar;
					nextchar = getc(yyin);
					lexstate = LEX_INT;
				}
				else if (isalpha(nextchar))
				{
					yytext[bufptr++] = nextchar;
					nextchar = getc(yyin);
					lexstate = LEX_IDENT;
				}
				else if (nextchar == '"')
				{
					nextchar = getc(yyin);
					lexstate = LEX_STRING;
				}
				else if (ispunct(nextchar))
				{
					yytext[bufptr++] = nextchar;
					nextchar = getc(yyin);
					lexstate = LEX_PUNCT;
				}
				else if (nextchar == EOF)
				{
					lexstate = LEX_STOP;
				}
				else
				{
					wsprintf(szBuffer,
								  "unrecognized character '%c', line %d.\n",
								   nextchar, line_no);
					MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
					yyerrexit();
					return(YYEXIT);
				}
				break;

			case LEX_INT:
				while (isdigit(nextchar))
				{
					yytext[bufptr++] = nextchar;
					nextchar = getc(yyin);
				}
				if (nextchar == '.')
				{
					yytext[bufptr++] = nextchar;
					nextchar = getc(yyin);
					lexstate = LEX_DEC;
				}
				else
				{
					yytext[bufptr] = 0;
					yylval.i = atoi(yytext);
					token = INTEGER;
					found_token = TRUE;
				}
				break;

			case LEX_DEC:
				while (isextdigit(nextchar))
				{
					yytext[bufptr++] = nextchar;
					nextchar = getc(yyin);
				}
				yytext[bufptr] = 0;
				sscanf(yytext,"%g",&yylval.f);
				token = REAL;
				found_token = TRUE;
				break;

			case LEX_IDENT:
				while (isalpha(nextchar) || isdigit(nextchar))
				{
					yytext[bufptr++] = nextchar;
					nextchar = getc(yyin);
				}
				yytext[bufptr] = 0;
				token = gettoken(yytext);
				found_token = TRUE;
				break;

			case LEX_STRING:
				while (nextchar != '"')
				{
					if (nextchar == '\n')
					{
						wsprintf(szBuffer,
									   "newline in string, line %d.\n",
									   line_no);
						MessageBox(NULL, szBuffer, "lf read_prog()", MB_OK | MB_ICONEXCLAMATION);
						return (YYEXIT);
					}
					yytext[bufptr++] = nextchar;
					nextchar = getc(yyin);
				}
				nextchar = getc(yyin); /* skip closing quote */
				yytext[bufptr] = 0;
				yylval.s = strdup(yytext);
				token = STRING;
				found_token = TRUE;
				break;

			case LEX_PUNCT:
				yytext[bufptr] = 0;
				token = gettoken(yytext);
				found_token = TRUE;
				break;

			case LEX_COMMENT:
				while (nextchar != '\n')
				{
					nextchar = getc(yyin);
				}
				lexstate = LEX_START;
				break;

			case LEX_STOP:
				token = 0;
				found_token = TRUE;
				first = TRUE;
				break;
		}
	}

	if (lexstate != LEX_STOP)
	{
		lexstate = LEX_START;
	}
	return(token);
}
