/*****************************************************************************
 ****                                                                     ****
 **** mosquito.c                                                          ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, M. Thomas, W.W. Armstrong ****
 ****               1991, 1992                                            ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 ****                                                                     ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 5.9.90 Initial implementation, A.Dwelly                             ****
 **** 31.5.91 Windows Port & Windows Extensions, M. Thomas                ****
 **** 91.07.17 atree v2.0 for Windows, M. Thomas                          ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas                                 ****
 **** 92.01.08 Release 2.7, Monroe Thomas                                 ****
 ****                                                                     ****
 *****************************************************************************/

#include <windows.h>
#include "atree.h"

#define VERBOSITY 0
#define TRAINSETSIZE 500
#define WIDTH 80
#define TREESIZE 256
#define TESTSIZE 500

#define BITTEN 1
#define QUININE 7
#define ANEMIA 12

#define Printf(str,fmt1,fmt2) \
			{ \
			char Buff[80]; \
			sprintf(Buff, str, fmt1, fmt2); \
			MessageBox(hwnd, Buff, "Mosquito", MB_OK); \
			}

BOOL quit_flag;

char mosquito(v)

char *v;

{
	return(v[BITTEN] && (!v[QUININE]) && (!v[ANEMIA]));
}

BOOL NEAR PASCAL main(HWND hwnd, HANDLE hInstance)

{
	int i;
	int j;
	int malaria = 0;
	int healthy = 0;
	char vec[WIDTH];
	char ui[1];
	int correct = 0;
	LPBIT_VEC training_set;
	LPBIT_VEC icres;
	LPBIT_VEC test;
	LPATREE tree;
	HCURSOR hCursor;

	/* Initialise */

	quit_flag = FALSE;

	training_set = (LPBIT_VEC) Malloc(TRAINSETSIZE * sizeof(bit_vec));
	MEMCHECK(training_set);

	icres = (LPBIT_VEC) Malloc(TRAINSETSIZE * sizeof(bit_vec));
	MEMCHECK(icres);

	atree_init(hInstance, hwnd);

	/* Create the test data */

	for (i = 0; i < TRAINSETSIZE; i++)
	{
		/* allow multitasking during long loop! */
		Windows_Interrupt(1500);

		if (quit_flag) exit(0);

		for (j = 0; j < WIDTH; j++)
		{
			vec[j] = (char)RANDOM(2);
		}
		training_set[i] = *(bv_pack(vec, WIDTH));
		ui[0] = mosquito(vec);
		if (ui[0])
		{
			malaria++;
		}
		else
		{
			healthy++;
		}
		icres[i] = *(bv_pack(ui,1));
	}

	Printf("There are %d patients with malaria, and %d healthy in the training set\n",malaria,healthy);

	if (quit_flag) exit(0);

	/* Create a tree and train it */

	tree = atree_create(WIDTH,TREESIZE);
	(void) atree_train(tree,training_set,icres,0,TRAINSETSIZE,
					   TRAINSETSIZE-1,10,1);

	if (quit_flag) exit(0);

   /* Test the trained tree */

	for (i = 0; i < TESTSIZE; i++)
	{
		/* allow multitasking during long loop! */
		Windows_Interrupt(1500);

		if (quit_flag) exit(0);

		for (j = 0; j < WIDTH; j++)
		{
			vec[j] = RANDOM(2);
		}
		test = bv_pack(vec,WIDTH);
		if (atree_eval(tree,test) == mosquito(vec))
		{
			correct++;
		}
		bv_free(test);
	}

	if (quit_flag) exit(0);

	Printf("%d correct out of %d in final test\n",correct,TESTSIZE);

	/* Discard training set */

	hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
	ShowCursor(TRUE);

	for (i = 0; i < TRAINSETSIZE; i++)
	{
		Free(training_set[i].bv);
		Free(icres[i].bv);
	}

	Free(training_set);
	Free(icres);

	ShowCursor(FALSE);
	SetCursor(hCursor);

	/* Discard tree */
	atree_free(tree);
	atree_quit();

	return(1);
}
