/*****************************************************************************
 ****                                                                     ****
 **** mosqwin.c                                                           ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, M. Thomas, W.W. Armstrong ****
 ****               1991, 1992                                            ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 ****                                                                     ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 91.05.20 Initial Implementation, M. Thomas                          ****
 **** 91.07.17 atree v2.0 for Windows, M. Thomas                          ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas                                 ****
 **** 92.01.08 Release 2.7, Monroe Thomas                                 ****
 ****                                                                     ****
 *****************************************************************************/

/*****************************
* Windows Support File for
* Mosquito.C
******************************/

#include <windows.h>
#include "atree.h"
#include "mosqwin.h"

extern int NEAR PASCAL main(HWND, HANDLE);
long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);
BOOL FAR PASCAL AboutDlgProc (HWND, WORD, WORD, LONG);

extern BOOL quit_flag;

HANDLE hInst;
FARPROC lpitAbout;

#pragma argsused

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
				   LPSTR lpszCmdLine, int nCmdShow)

{
	static char szAppName[] = "MOSQUITO";
	HWND hwnd;
	MSG msg;
	WNDCLASS wndclass;

	if (!hPrevInstance)
	{
		wndclass.style          = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc    = (long (FAR PASCAL*)()) WndProc;
		wndclass.cbClsExtra     = 0;
		wndclass.cbWndExtra     = 0;
		wndclass.hInstance      = hInstance;
		wndclass.hIcon          = LoadIcon(hInstance, "mosqico");
		wndclass.hCursor        = LoadCursor(hInstance, "mosqcur");
		wndclass.hbrBackground  = GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName   = "MENU_RESOURCE";
		wndclass.lpszClassName  = szAppName;

		RegisterClass(&wndclass);
	}

	hInst = hInstance;

	hwnd = CreateWindow(szAppName,                      /* Class */
						 "Mosquito",                    /* Title */
						 WS_OVERLAPPEDWINDOW,           /* Style */
						 CW_USEDEFAULT, CW_USEDEFAULT,  /* x, y */
						 240,180,                       /* xsize, ysize */
						 NULL,                          /* parent */
						 NULL,                          /* class menu */
						 hInstance,                     /* creator */
						 NULL);                         /* Params */


	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	lpitAbout = MakeProcInstance((FARPROC)AboutDlgProc, hInst);

	while (GetMessage(&msg, NULL,0,0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	FreeProcInstance(lpitAbout);
	return msg.wParam;
}


long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
	static HMENU hMenu;

	switch (message)
	{
		case WM_COMMAND:
			switch (wParam)
			{
				case IDM_HELP:
					WinHelp(hwnd, "atree.hlp", HELP_CONTEXT, 20);
					break;

				case IDM_EXIT:
					DestroyWindow(hwnd);
					break;

				case IDM_RUN:
					hMenu = GetMenu(hwnd);
					EnableMenuItem(hMenu, IDM_RUN, MF_GRAYED);
					DrawMenuBar(hwnd);

					if (!main(hwnd, hInst))
					{
						MessageBeep(0);
						MessageBox(hwnd,"Could not run Mosquito!", "Multiplexor", MB_OK);
					}

					EnableMenuItem(hMenu, IDM_RUN, MF_ENABLED);
					DrawMenuBar(hwnd);
					break;

				case IDM_ABOUT:
					DialogBox(hInst, MAKEINTRESOURCE(IDD_ABOUT), hwnd,
							  lpitAbout);
					break;
			}
			break;

		case WM_DESTROY:
			atree_quit();
			quit_flag = TRUE;
			PostQuitMessage(0);
			break;

		default:
			return DefWindowProc(hwnd,message,wParam,lParam);
	}
	return 0L;
}

#pragma argsused

BOOL FAR PASCAL AboutDlgProc (HWND hdlg, WORD message, WORD wParam, LONG lParam)
{
	switch (message)
	{
		case WM_COMMAND:
			EndDialog(hdlg, TRUE);
			return TRUE;
		default:
			return FALSE;
   }
}
