/*****************************************************************************
 ****                                                                     ****
 **** mult.c                                                              ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) A. Dwelly, R. Manderscheid, M. Thomas, W.W. Armstrong ****
 ****               1991, 1992                                            ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 90.09.05 Initial implementation, A.Dwelly                           ****
 **** 91.04.15 Port to PC and minor bug fixes, R. Manderscheid            ****
 **** 91.05.20 Windows Port & Windows Extensions, M. Thomas               ****
 **** 91.07.17 atree v2.0 for Windows, M. Thomas                          ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas                                 ****
 **** 92.01.08 Release 2.7, Monroe Thomas                                 ****
 ****                                                                     ****
 *****************************************************************************/

/* multiplexor test */

#include <stdio.h>
#include <windows.h>
#include "atree.h"

#define CONTROL_BITS    3

/* number of leaves should increase with number of control bits */

#define LEAVES          1536
#define TEST_SIZE       500
#define TRAIN_SIZE      500
#define VOTERS          1
#define EPOCHS          100
#define VERBOSITY       1

#define WIDTH           ((CONTROL_BITS) + (1 << (CONTROL_BITS)))

#define Printf(str,fmt1,fmt2) \
            { \
            char Buff[80]; \
            sprintf(Buff, str, fmt1, fmt2); \
            MessageBox(hwnd, Buff, "Multiplexor", MB_OK); \
            }


BOOL quit_flag;

char multiplexor(v)
char *v;
{
int i;
int lead = 0;

    for (i = 0; i < CONTROL_BITS; i++)
    {
       lead = (lead << 1) + v[i];
    }
    return(v[lead + CONTROL_BITS]);
}

int NEAR PASCAL
main(HWND hwnd, HANDLE hInstance)
{
    LPATREE tree[VOTERS];
    LPBIT_VEC training_set;
	LPBIT_VEC result_set;
	LPBIT_VEC test;
	char vec[WIDTH];
	char unpacked_result[1];
	int correct;
	int voter;
	int i;
	int j;
	HCURSOR hCursor;

	/* Initialize */

	quit_flag = FALSE;

	training_set = (LPBIT_VEC) Malloc(TRAIN_SIZE * sizeof(bit_vec));
	MEMCHECK(training_set);

	result_set = (LPBIT_VEC) Malloc(TRAIN_SIZE * sizeof(bit_vec));
	MEMCHECK(result_set);

	atree_init(hInstance, hwnd);

/* if VOTERS is odd the next loop will generate a unreachable code
   error - use pragma to turn off checking */

#pragma warn -rch
#pragma warn -ccc
	if (VOTERS % 2 != 1)
	{
	   MessageBox(hwnd, "VOTERS must be odd", "MULTIPLEXOR", MB_OK);
	   return(FALSE);
	}
#pragma warn .ccc
#pragma warn .rch

	/* Create the training data */

	for (i = 0; i < TRAIN_SIZE; i++)
	{

		/* allow multitasking during long loop! */
		Windows_Interrupt(1500);

		if (quit_flag) exit(0);

		for (j = 0; j < WIDTH; j++)
		{
			vec[j] = RANDOM(2);
		}
		training_set[i] = *(bv_pack(vec, WIDTH));
		unpacked_result[0] = multiplexor(vec);
		result_set[i] = *(bv_pack(unpacked_result, 1));
	}

	if (quit_flag) exit(0);

	/* Create a tree and train it */

	for (voter = 0; voter < VOTERS; voter++)
	{
		tree[voter] = atree_create(WIDTH, LEAVES);
		(void) atree_train(tree[voter], training_set, result_set, 0,
						   TRAIN_SIZE, TRAIN_SIZE-1, EPOCHS, VERBOSITY);
	}

	if (quit_flag) exit(0);

	/* Test the trained tree */

	correct = 0;
	for (i = 0; i < TEST_SIZE; i++)
	{
		int weight = 0;

		/* allow multitasking during long loop! */
		Windows_Interrupt(1500);

		if (quit_flag) exit(0);

		for (j = 0; j < WIDTH; j++)
		{
			vec[j] = RANDOM(2);
		}
		test = bv_pack(vec, WIDTH);

		for (voter = 0; voter < VOTERS; voter++)
		{
			weight += atree_eval(tree[voter], test);
		}

		if (multiplexor(vec) == (weight > VOTERS / 2))
		{
			correct++;
		}

		bv_free(test);
	}

	if (quit_flag) exit(0);

	Printf("%d correct out of %d in final test\n", correct, TEST_SIZE);

	/* Discard training set */

	hCursor = SetCursor(LoadCursor(NULL, IDC_WAIT));
	ShowCursor(TRUE);

	for (i = 0; i < TRAIN_SIZE; i++)
		{
		Free(training_set[i].bv);
		Free(result_set[i].bv);
		}

	Free(training_set);
	Free(result_set);

	ShowCursor(FALSE);
	SetCursor(hCursor);

	/* Discard tree */

	for (voter = 0; voter < VOTERS; voter++)
	{
		atree_free(tree[voter]);
	}

	atree_quit();
	return(TRUE);
}
