/*****************************************************************************
 ****                                                                     ****
 **** bitmap.h                                                            ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) M. Thomas, N. Sanche, W.W. Armstrong 1991, 1992       ****
 ****                                                 			  						****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas, Neal Sanche                    ****
 **** 92.01.08 Release 2.7, Monroe Thomas, Neal Sanche                    ****
 ****                                                                     ****
 *****************************************************************************/

// bitmap.h header for bitmap and bitmap control objects

#include <owl.h>
#include <math.h>
#include <alloc.h>
#include <control.h>

_CLASSDEF(TBitmap)
class TBitmap
{
protected:

	HBITMAP hBitmap;
	COLORREF crDraw;
	COLORREF crErase;

public:

	virtual void Init(HBITMAP hABitmap);

	TBitmap(HBITMAP hABitmap)
		{   hBitmap = NULL; Init(hABitmap); }

	~TBitmap() { if (hBitmap != NULL) DeleteObject(hBitmap); }

	HBITMAP GetBitmap() { return(hBitmap); }
	DWORD GetBits(LPSTR lpBits);
	LONG SetBits(LPSTR lpBits, DWORD dwCount);
	DWORD GetWidth();
	DWORD GetHeight();
	DWORD GetPlanes();
	DWORD GetBitsPixel();
	DWORD GetWidthBytes();
	DWORD GetBytes();
	COLORREF GetDrawColor();
	COLORREF SetDrawColor(COLORREF crColor);
	COLORREF GetEraseColor();
	COLORREF SetEraseColor(COLORREF crColor);
	virtual DWORD GetPoint(int x, int y);
	virtual DWORD SetPoint(int x, int y, COLORREF crColor);
	virtual void Rotate(float theta, BOOL isRadians = FALSE);
};

_CLASSDEF(TBitmapControl)
class TBitmapControl : public TControl, public TBitmap
{
public:

	virtual void Init(HBITMAP hABitmap)
		{ TBitmap::Init(hABitmap); }

	TBitmapControl(PTWindowsObject AParent, int AnId, LPSTR ATitle, int X,
					 int Y, int W, int H, HBITMAP hABitmap,
					 PTModule AModule = NULL) : TControl(AParent, AnId,
						ATitle, X, Y, W, H, AModule), TBitmap(hABitmap)
			{ Init(hABitmap); }

	TBitmapControl(PTWindowsObject AParent, int ResId, HBITMAP hABitmap,
					 PTModule AModule = NULL) : TControl(AParent, ResId, AModule),
					 TBitmap(hABitmap)
			{ DisableAutoCreate(); Init(hABitmap); }

	virtual LPSTR GetClassName() { return ("TBitmapControl"); }
	virtual void GetWindowClass(WNDCLASS &);
	virtual void Paint(HDC PaintDC, PAINTSTRUCT _FAR & PaintInfo);
	virtual void Refresh()
		{ InvalidateRect(HWindow, NULL, FALSE); UpdateWindow(HWindow); }
	virtual DWORD GetPoint(int x, int y);
	virtual DWORD SetPoint(int x, int y, COLORREF crColor);
	virtual void Reset(short w, short h);
};

_CLASSDEF(TBitmapDrawControl)
class TBitmapDrawControl : public TBitmapControl
{
protected:

	BOOL TBDCClear;
	BOOL TBDCRotate;
	BOOL drawon;
	BOOL eraseon;

	void setdimensions(HDC wndDC);

public:

	virtual void Init(HBITMAP hABitmap)
	{
		TBitmapControl::Init(hABitmap);
		crDraw = RGB(0, 0, 0);
		crErase = RGB(255, 255, 255);
		drawon = eraseon = FALSE;
	}

	TBitmapDrawControl(PTWindowsObject AParent, int AnId, LPSTR ATitle, int X,
					 int Y, int W, int H, HBITMAP hABitmap,
					 PTModule AModule = NULL) : TBitmapControl(AParent, AnId,
						ATitle, X, Y, W, H, hABitmap, AModule)
		{ Init(hABitmap); }

	TBitmapDrawControl(PTWindowsObject AParent, int ResId, HBITMAP hABitmap,
					 PTModule AModule = NULL) : TBitmapControl(AParent, ResId, hABitmap, AModule)
		{ Init(hABitmap); }

	virtual LPSTR GetClassName() { return ("TBitmapDrawControl"); }
	virtual void GetWindowClass(WNDCLASS &);
	virtual void WMLButtonDown(RTMessage Msg) = [WM_FIRST + WM_LBUTTONDOWN];
	virtual void WMLButtonUp(RTMessage Msg) = [WM_FIRST + WM_LBUTTONUP];
	virtual void WMLButtonDblClk(RTMessage Msg) = [WM_FIRST + WM_LBUTTONDBLCLK];
	virtual void WMRButtonDown(RTMessage Msg) = [WM_FIRST + WM_RBUTTONDOWN];
	virtual void WMRButtonUp(RTMessage Msg) = [WM_FIRST + WM_RBUTTONUP];
	virtual void WMRButtonDblClk(RTMessage Msg) = [WM_FIRST + WM_RBUTTONDBLCLK];
	virtual void WMMouseMove(RTMessage Msg) = [WM_FIRST + WM_MOUSEMOVE];
};

#define TBDC_COORDCHANGE WM_USER + 99
