/*****************************************************************************
 ****                                                                     ****
 **** editlett.cpp                                                        ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) M. Thomas, N. Sanche, W.W. Armstrong 1991, 1992       ****
 ****                                                 			  						****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas, Neal Sanche                    ****
 **** 92.01.08 Release 2.7, Monroe Thomas, Neal Sanche                    ****
 ****                                                                     ****
 *****************************************************************************/

#include "ocr.h"
#include "editlett.h"
//
// Letter Editing Dialog object implementation code
//

TEditDlg::TEditDlg(PTWindowsObject AParent, PTBitmapControl ABitmap)
    : TDialog(AParent, OCR_EDITCHAR)
{
    OrigBitmap = ABitmap;
    EditChar = new TBitmapDrawControl(this, OCR_DRAWCHAR,
        OrigBitmap->GetBitmap());
		Rotate = new TEditScroll(this, ID_EDITSCRL, 0, 360, 0, 10);
}

void TEditDlg::SetupWindow()
{
    EditChar->SetDrawColor(RGB(0,0,255));
    EditChar->SetEraseColor(RGB(192,192,192));
    SetDlgItemInt(HWindow, ID_COORDX, 0, TRUE);
    SetDlgItemInt(HWindow, ID_COORDY, 0, TRUE);
}

void TEditDlg::Ok(RTMessage Msg)
{
    OrigBitmap->Init(EditChar->GetBitmap());
    OrigBitmap->SetDrawColor(RGB(0,0,255));
    OrigBitmap->SetEraseColor(RGB(192,192,192));
    OrigBitmap->Refresh();
    TDialog::Ok(Msg);
}

void TEditDlg::IDCounter(RTMessage)
{
    char Buffer[10];
    int Angle;

    Rotate->GetText(Buffer, 10);
    Angle = atoi(Buffer);
//    EnableWindow(GetDlgItem(HWindow, IDCOUNTER), FALSE);
    EditChar->Rotate(Angle);
//    EnableWindow(GetDlgItem(HWindow, IDCOUNTER), TRUE);
    EditChar->Refresh();
}

void TEditDlg::IDClockwise(RTMessage)
{
    char Buffer[10];
    int Angle;

    Rotate->GetText(Buffer, 10);
    Angle = atoi(Buffer);
//    EnableWindow(GetDlgItem(HWindow, IDCLOCKWISE), FALSE);
    EditChar->Rotate(-Angle);
//    EnableWindow(GetDlgItem(HWindow, IDCLOCKWISE), TRUE);
    EditChar->Refresh();
}

void TEditDlg::IDHelp(RTMessage)
{
    PTDialog D;

		D = new TDialog(this, OCR_DRAWHELP);
    GetApplication()->ExecDialog(D);
}

void TEditDlg::TBDCCoordChange(RTMessage Msg)
{
		char szBuffer[6];
		SetDlgItemInt(HWindow, ID_COORDY, Msg.LP.Hi, TRUE);
    SetDlgItemInt(HWindow, ID_COORDX, Msg.LP.Lo, TRUE);
}
