/*****************************************************************************
 ****                                                                     ****
 **** editscro.cpp                                                        ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) M. Thomas, N. Sanche, W.W. Armstrong 1991, 1992       ****
 ****                                                 			  ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas, Neal Sanche                    ****
 **** 92.01.08 Release 2.7, Monroe Thomas, Neal Sanche                    ****
 ****                                                                     ****
 *****************************************************************************/


#ifndef __EDITSCRO_H
#include "editscro.h"
#endif

#ifndef __WINDOWSX_H
#include "windowsx.h"
#endif

#define EDITHEIGHT 22

const int IDES_EDIT = 100;
const int IDES_UP = 101;
const int IDES_DOWN = 102;
const int IDES_BORDER = 103;
const int ESBN_CLICKED = 3;
const int ESBN_NOMORE = 4;

_CLASSDEF(TESButton)

class TESButton : public TButton
{
private:
	HBITMAP hbmDown;
	HBITMAP hbmUp;

	WORD wSrcHeight;
	WORD wSrcWidth;

	BOOL bClicked;

public:
	void Init(int AnId);

	TESButton(PTWindowsObject AParent, int AnId, LPSTR AText,
						int X, int Y, int W, int H, PTModule AModule = NULL) :
		TButton(AParent, AnId, AText, X, Y, W, H, FALSE, AModule)
		{ DisableAutoCreate(); Init(AnId); }

	~TESButton()
  	{ DeleteBitmap(hbmDown); DeleteBitmap(hbmUp); }

	virtual void ODADrawEntire(DRAWITEMSTRUCT& dis);
	virtual void ODASelect(DRAWITEMSTRUCT& dis);

	virtual void WMLButtonUp(RTMessage) = [WM_FIRST + WM_LBUTTONUP]
		{	SendMessage(Parent->HWindow, WM_COMMAND, Attr.Id,
									MAKELPARAM(HWindow, ESBN_NOMORE)); }
	virtual void WMLButtonDblClk(RTMessage Msg) = [WM_FIRST + WM_LBUTTONDBLCLK]
		{ SendMessage(HWindow, WM_LBUTTONDOWN, Msg.WParam, Msg.LParam); }
	virtual void WMEnable(RTMessage Msg) = [WM_FIRST + WM_ENABLE];
};

void
TESButton::Init(int AnId)
{
	DisableAutoCreate();
	Attr.Style |= BS_OWNERDRAW;
	if (AnId == IDES_UP)
	{
		hbmUp = LoadBitmap(NULL,MAKEINTRESOURCE(OBM_UPARROW));
		hbmDown = LoadBitmap(NULL,MAKEINTRESOURCE(OBM_UPARROWD));
	}
	else
	{
		hbmUp = LoadBitmap(NULL,MAKEINTRESOURCE(OBM_DNARROW));
		hbmDown = LoadBitmap(NULL,MAKEINTRESOURCE(OBM_DNARROWD));
	}

	BITMAP bm;

	GetObject(hbmUp, sizeof(bm), (LPSTR)&bm);
	wSrcHeight = bm.bmHeight;
	wSrcWidth = bm.bmWidth;
}

void
TESButton::ODADrawEntire(DRAWITEMSTRUCT& dis)
{
	HDC  hdcMem;

	RECT rc;
	GetWindowRect(HWindow, &rc);

	DPtoLP(dis.hDC, (LPPOINT)&rc, 2);
	int wWidth = rc.right - rc.left;
	int wHeight = rc.bottom - rc.top;

	hdcMem = CreateCompatibleDC(dis.hDC);
	SelectObject(hdcMem,(dis.itemState & ODS_SELECTED) ? hbmDown : hbmUp);
	SetStretchBltMode(dis.hDC, BLACKONWHITE);
	StretchBlt(dis.hDC, dis.rcItem.left, dis.rcItem.top, wWidth, wHeight,
						 hdcMem, 0, 0, wSrcWidth, wSrcHeight, SRCCOPY);

	DeleteDC(hdcMem);
}

void
TESButton::ODASelect(DRAWITEMSTRUCT far & dis)
{
	HDC  hdcMem;

	RECT rc;
	GetWindowRect(HWindow, &rc);

	DPtoLP(dis.hDC, (LPPOINT)&rc, 2);
	int wWidth = rc.right - rc.left;
	int wHeight = rc.bottom - rc.top;

	hdcMem = CreateCompatibleDC(dis.hDC);
	SelectObject(hdcMem,(dis.itemState & ODS_SELECTED) ? hbmDown : hbmUp);
	SetStretchBltMode(dis.hDC, BLACKONWHITE);
	StretchBlt(dis.hDC, dis.rcItem.left, dis.rcItem.top, wWidth, wHeight,
						 hdcMem, 0, 0, wSrcWidth, wSrcHeight, SRCCOPY);

	DeleteDC(hdcMem);

	if (dis.itemState & ODS_SELECTED)
	{
		bClicked = TRUE;
	}
	else
	{
		bClicked = FALSE;
	}

	// enter PeekMessage loop until clicked = FALSE

	int wCounter = 0;
	while (bClicked)
	{
		if ((wCounter++ % 250) == 0)
		{
			SendMessage(Parent->HWindow, WM_COMMAND, Attr.Id,
									MAKELPARAM(HWindow, ESBN_CLICKED));
		}

		MSG msg;
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			 TranslateMessage(&msg);
			 DispatchMessage(&msg);
		}
	}
}

void
TESButton::WMEnable(RTMessage Msg)
{
	if (Attr.Id == IDES_UP)
	{
		if (Msg.WParam)
			hbmUp = LoadBitmap(NULL,MAKEINTRESOURCE(OBM_UPARROW));
		else
			hbmUp = LoadBitmap(NULL,MAKEINTRESOURCE(OBM_UPARROWI));
	}
	else
	{
		if (Msg.WParam)
			hbmUp = LoadBitmap(NULL,MAKEINTRESOURCE(OBM_DNARROW));
		else
			hbmUp = LoadBitmap(NULL,MAKEINTRESOURCE(OBM_DNARROWI));
	}
	InvalidateRect(HWindow, NULL, FALSE);
}

class TESEdit : public TEdit
{
public:
	TESEdit(PTWindowsObject AParent, int AnId, LPSTR AText, int X, int Y, int W,
			int H, WORD ATextLen, BOOL Multiline = FALSE,
			PTModule AModule = NULL)
		: TEdit(AParent, AnId, AText, X, Y, W, H, ATextLen, Multiline, AModule)
		{ DisableAutoCreate(); }

	virtual void WMSetFocus(RTMessage) = [WM_FIRST + WM_SETFOCUS];
	virtual void WMChar(RTMessage) = [WM_FIRST + WM_CHAR];
	virtual void WMKeyDown(RTMessage) = [WM_FIRST + WM_KEYDOWN];
};

void
TESEdit::WMSetFocus(RTMessage Msg)
{
	SendMessage(Parent->Parent->HWindow, WM_ACTIVATE, 1, 0L);
	SetSelection(0, TextLen);
	DefWndProc(Msg);
}

void
TESEdit::WMChar(RTMessage Msg)
{
	if (((Msg.WParam >= '0') && (Msg.WParam <= '9')) || (Msg.WParam == '-')
		|| (Msg.WParam == 8))
	{
		DefWndProc(Msg);
	}
}

void
TESEdit::WMKeyDown(RTMessage Msg)
{
	DefWndProc(Msg);
	if (Msg.WParam == VK_UP)
	{
		SendMessage(Parent->HWindow, WM_COMMAND, IDES_UP,
								MAKELONG(HWindow, ESBN_CLICKED));
		SetSelection(0, TextLen);
	}
	else if (Msg.WParam == VK_DOWN)
	{
		SendMessage(Parent->HWindow, WM_COMMAND, IDES_DOWN,
								MAKELONG(HWindow, ESBN_CLICKED));
		SetSelection(0, TextLen);
	}
}

void
TEditScroll::Init(int AStart, int AnEnd, int AFirst,
									int ATextLen, PTModule AModule)
{
	wStart = AStart;
	wEnd = AnEnd;
	wCurrent = AFirst;
	wTextLen = ATextLen;
	Attr.Style |= WS_BORDER;
	if (wStart > wEnd)
	{
		int wTmp = wEnd;
		wEnd = wStart;
		wStart = wTmp;
	}
	if (wCurrent < wStart) wCurrent = wStart;
	if (wCurrent > wEnd) wCurrent = wEnd;
	Edit = new TESEdit(this, IDES_EDIT, "", 0, 0, 0, 0,
										 ATextLen, FALSE, AModule);
	Up = new TESButton(this, IDES_UP, "", 0, 0, 0, 0, AModule);
	Down = new TESButton(this, IDES_DOWN, "", 0, 0, 0, 0,	AModule);
}

void
TEditScroll::GetWindowClass(WNDCLASS& AWndClass)
{
	TControl::GetWindowClass(AWndClass);
	AWndClass.hCursor = LoadCursor(NULL, IDC_IBEAM);
}

void
TEditScroll::SetupWindow()
{
	TControl::SetupWindow();

	POINT pt[2];
	GetWindowRect(HWindow, (RECT*)pt);
	ScreenToClient(HWindow, &(pt[0]));
	ScreenToClient(HWindow, &(pt[1]));

	Up->Attr.X = pt[1].x - GetSystemMetrics(SM_CXVSCROLL),
	Up->Attr.Y = pt[0].y,
	Up->Attr.W = GetSystemMetrics(SM_CXVSCROLL),
	Up->Attr.H = (pt[1].y - pt[0].y) / 2,

	Down->Attr.X = pt[1].x - GetSystemMetrics(SM_CXVSCROLL);
	Down->Attr.Y = pt[0].y + ((pt[1].y - pt[0].y) / 2);
	Down->Attr.W = GetSystemMetrics(SM_CXVSCROLL);
	Down->Attr.H = (pt[1].y - pt[0].y) / 2;

	Edit->Attr.Style &= ~WS_BORDER;
	Edit->Attr.X = 2;
	Edit->Attr.H = EDITHEIGHT;
	Edit->Attr.Y = (pt[1].y - pt[0].y - EDITHEIGHT) / 2 + 2;
	Edit->Attr.W = pt[1].x - pt[0].x - GetSystemMetrics(SM_CXVSCROLL) - 3;

	GetApplication()->MakeWindow(Up);
	GetApplication()->MakeWindow(Down);
	GetApplication()->MakeWindow(Edit);

	char sz[80];
	Edit->SetText((LPSTR)itoa(wCurrent, sz, 10));
	SendMessage(Parent->HWindow, WM_COMMAND, Attr.Id,
							MAKELPARAM(HWindow, ESN_CHANGE));
}

void
TEditScroll::DefChildProc(RTMessage Msg)
{
	char sz[80];
	switch(Msg.LP.Hi)
	{
		case ESBN_NOMORE:
			SetFocus(Edit->HWindow);
			break;
		case ESBN_CLICKED:
			if (Msg.WParam == IDES_UP)
			{
				wCurrent++;
				if (wCurrent > wEnd) wCurrent = wStart;
			}
			else
			{
				wCurrent--;
				if (wCurrent < wStart) wCurrent = wEnd;
			}
			Edit->SetText((LPSTR)itoa(wCurrent, sz, 10));
			SendMessage(Parent->HWindow, WM_COMMAND, Attr.Id,
									MAKELPARAM(HWindow, ESN_CHANGE));
			break;

		case EN_UPDATE:
			Edit->GetText(sz, wTextLen);
			int wTmp = atoi(sz);
			if (wTmp < wStart)
			{
				wsprintf(sz, "Please enter a number between %d and %d!", wStart, wEnd);
				MessageBox(HWindow, sz, NULL, MB_OK | MB_ICONQUESTION);
				Edit->SetText((LPSTR)itoa(wCurrent, sz, 10));
				break;
			}
			if (wTmp > wEnd)
			{
				wsprintf(sz, "Please enter a number between %d and %d!", wStart, wEnd);
				MessageBox(HWindow, sz, NULL, MB_OK | MB_ICONQUESTION);
				Edit->SetText((LPSTR)itoa(wCurrent, sz, 10));
				break;
			}
			wCurrent = wTmp;
			SendMessage(Parent->HWindow, WM_COMMAND, Attr.Id,
									MAKELONG(HWindow, ESN_CHANGE));
			break;

		default:
			DefWndProc(Msg);
	}
}

void
TEditScroll::WMDrawItem(RTMessage Msg)
{
	if(((LPDRAWITEMSTRUCT)(Msg.LParam))->CtlID == IDES_UP)
	{
		switch ( ((LPDRAWITEMSTRUCT)(Msg.LParam))->itemAction )
		{
			case ODA_DRAWENTIRE:
				Up->ODADrawEntire(*((LPDRAWITEMSTRUCT)(Msg.LParam)));
				break;
			case ODA_SELECT:
				Up->ODASelect(*((LPDRAWITEMSTRUCT)(Msg.LParam)));
				break;
		}
	}
	else
	{
		switch ( ((LPDRAWITEMSTRUCT)(Msg.LParam))->itemAction )
		{
			case ODA_DRAWENTIRE:
				Down->ODADrawEntire(*((LPDRAWITEMSTRUCT)(Msg.LParam)));
				break;
			case ODA_SELECT:
				Down->ODASelect(*((LPDRAWITEMSTRUCT)(Msg.LParam)));
				break;
		}
	}
}

int
TEditScroll::GetText(LPSTR AString, int ATextLen)
{
	return Edit->GetText(AString, ATextLen);
}

void
TEditScroll::SetText(LPSTR AString)
{
	Edit->SetText(AString);
	SendMessage(Parent->HWindow, WM_COMMAND, Attr.Id,
							MAKELONG(HWindow, ESN_CHANGE));
}

void
TEditScroll::WMLButtonDown(RTMessage Msg)
{
	SetFocus(Edit->HWindow);

	POINT pt;
	pt.x = Msg.LP.Lo;
	pt.y = Msg.LP.Hi;
	HWND hwndChild = ChildWindowFromPoint(HWindow, pt);
	if (hwndChild == Up->HWindow)
	{
		SendMessage(Up->HWindow, WM_LBUTTONDOWN, Msg.WParam, Msg.LParam);
	}
	else if (hwndChild == Down->HWindow)
	{
		SendMessage(Down->HWindow, WM_LBUTTONDOWN, Msg.WParam, Msg.LParam);
	}
}

void
TEditScroll::WMEnable(RTMessage Msg)
{
	EnableWindow(Edit->HWindow, Msg.WParam);
	EnableWindow(Up->HWindow, Msg.WParam);
	EnableWindow(Down->HWindow, Msg.WParam);
}

void
TEditScroll::WMSetFocus(RTMessage Msg)
{
	DefWndProc(Msg);
	SetFocus(Edit->HWindow);
}

