/*****************************************************************************
 ****                                                                     ****
 **** editscro.h                                                          ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) M. Thomas, N. Sanche, W.W. Armstrong 1991, 1992       ****
 ****                                                 			  ****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas, Neal Sanche                    ****
 **** 92.01.08 Release 2.7, Monroe Thomas, Neal Sanche                    ****
 ****                                                                     ****
 *****************************************************************************/

// Defines

#ifndef __EDITSCRO_H
#define __EDITSCRO_H

#define OEMRESOURCE

#ifndef __OWL_H
#include <owl.h>
#endif

#ifndef __BUTTON_H
#include <button.h>
#endif

#ifndef __CONTROL_H
#include <control.h>
#endif

#ifndef __EDIT_H
#include <edit.h>
#endif

#undef OEMRESOURCE

#define ESN_CHANGE 0

_CLASSDEF(TESEdit)
_CLASSDEF(TESButton)
_CLASSDEF(TEditScroll)

class TESButton;
class TESEdit;

class TEditScroll : public TControl
{
private:
	PTESButton Up;
	PTESButton Down;
	PTESEdit Edit;

	int wStart;
	int wEnd;
	int wCurrent;
	int wTextLen;

public:
	virtual void Init(int AStart, int AnEnd, int AFirst,
										int ATextLen, PTModule AModule);

	TEditScroll(PTWindowsObject AParent, int AnId,
				int AStart, int AnEnd, int AFirst,
				int X, int Y, int W, int H,
				int ATextLen, PTModule AModule = NULL)
			: TControl(AParent, AnId, "", X, Y, W, H, AModule)
		{ Init(AStart, AnEnd, AFirst, ATextLen, AModule); }

	TEditScroll(PTWindowsObject AParent, int ResourceId,
							int AStart, int AnEnd, int AFirst,
							int ATextLen, PTModule AModule = NULL)
			:	TControl(AParent, ResourceId, AModule)
		{ Init(AStart, AnEnd, AFirst, ATextLen, AModule); }

	virtual void SetupWindow();

	virtual void DefChildProc(RTMessage);
	virtual int GetText(LPSTR, int);
	virtual void SetText(LPSTR);
	virtual LPSTR GetClassName() { return "EditScroll"; }
	virtual void GetWindowClass(WNDCLASS&);
	virtual void WMDrawItem(RTMessage) = [WM_FIRST + WM_DRAWITEM];
	virtual void WMLButtonDown(RTMessage) = [WM_FIRST + WM_LBUTTONDOWN];
	virtual void WMEnable(RTMessage) = [WM_FIRST + WM_ENABLE];
	virtual void WMSetFocus(RTMessage) = [WM_FIRST + WM_SETFOCUS];
};

#endif	// __EDITSCRO_H