/*****************************************************************************
 ****                                                                     ****
 **** ocr.cpp                                                             ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) M. Thomas, N. Sanche, W.W. Armstrong 1991, 1992       ****
 ****                                                 			  						****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas, Neal Sanche                    ****
 **** 92.01.08 Release 2.7, Monroe Thomas, Neal Sanche                    ****
 ****                                                                     ****
 *****************************************************************************/

#include "ocr.h"
#include "editlett.h"
#include "editscro.h"

_CLASSDEF(Tocrapp)
class TOcrApp : public TApplication
{
public:
	TOcrApp(LPSTR AName, HANDLE hInst, HANDLE hPrevInst,
			 LPSTR lpCmdLine, int nCmdShow) : TApplication(AName,
			 hInst, hPrevInst, lpCmdLine, nCmdShow) {};
	virtual void InitMainWindow();
};

//
// Main Dialog methods
//

TOcr::TOcr() : TDialog(NULL, OCR)
{
	randomize();

	shutdown = FALSE;

	Quit = new TBButton(this, OCR_QUIT);
	Start = new TBButton(this, OCR_START);
	Stop = new TBButton(this, OCR_STOP);
	Train = new TBButton(this, OCR_TRAIN);
	Reverse = new TBButton(this, OCR_REVERSE);
	Forget = new TBButton(this, OCR_FORGET);
	Reset = new TBButton(this, OCR_RESET);
	EditA = new TBButton(this, OCR_EDITA);
	EditL = new TBButton(this, OCR_EDITL);
	EditN = new TBButton(this, OCR_EDITN);

	hLightOn = LoadBitmap(GetApplication()->hInstance, MAKEINTRESOURCE(OCR_LIGHTON));
	hLightOff = LoadBitmap(GetApplication()->hInstance, MAKEINTRESOURCE(OCR_LIGHTOFF));
	hLetterA = LoadBitmap(GetApplication()->hInstance, MAKEINTRESOURCE(OCR_LETTER_A));
	hLetterL = LoadBitmap(GetApplication()->hInstance, MAKEINTRESOURCE(OCR_LETTER_L));
	hLetterN = LoadBitmap(GetApplication()->hInstance, MAKEINTRESOURCE(OCR_LETTER_N));
	hLetterClear = LoadBitmap(GetApplication()->hInstance, MAKEINTRESOURCE(OCR_LETTER_CLEAR));

	Correct = new TBStatic(this, OCR_CORRECT, 9);
	Incorrect = new TBStatic(this, OCR_INCORRECT, 9);
	Status = new TBStatic(this, OCR_STATUS, 60);

	LetterBitmap = new TBitmapControl(this, OCR_BITMAP, hLetterA);
	LightBulbA = new TBitmapControl(this, OCR_LIGHTBULB_A, hLightOff);
	LightBulbL = new TBitmapControl(this, OCR_LIGHTBULB_L, hLightOff);
	LightBulbN = new TBitmapControl(this, OCR_LIGHTBULB_N, hLightOff);
	LetterA = new TBitmapControl(this, OCR_DRAW_A, hLetterA);
	LetterL = new TBitmapControl(this, OCR_DRAW_L, hLetterL);
	LetterN = new TBitmapControl(this, OCR_DRAW_N, hLetterN);
}

TOcr::~TOcr()
{
	delete Quit;
	delete Start;
	delete Stop;
	delete Train;
	delete Reverse;
	delete Forget;
	delete Reset;
	delete EditA;
	delete EditL;
	delete EditN;

	delete Correct;
	delete Incorrect;
	delete Status;

	DeleteObject(hLightOn);
	DeleteObject(hLightOff);
	DeleteObject(hLetterA);
	DeleteObject(hLetterL);
	DeleteObject(hLetterN);
	DeleteObject(hLetterClear);

	delete LetterBitmap;
	delete LightBulbA;
	delete LightBulbL;
	delete LightBulbN;
	delete LetterA;
	delete LetterL;
	delete LetterN;
}

LPSTR
TOcr::GetClassName()
{
	return("bordlg_ocr");
}

void
TOcr::GetWindowClass(WNDCLASS& AWndClass)
{
	TDialog::GetWindowClass(AWndClass);
	AWndClass.lpfnWndProc = BWCCDefDlgProc;
	AWndClass.hIcon = LoadIcon(GetApplication()->hInstance, "atreeico");
	AWndClass.cbWndExtra = DLGWINDOWEXTRA;
}

void
TOcr::SetupWindow()
{
	TDialog::SetupWindow();
	Status->SetText("ALN Demo - Light flashes on under character ALN detects");
	EnableWindow(Stop->HWindow, FALSE);

	LetterBitmap->SetDrawColor(RGB(0, 0, 255));
	LetterBitmap->SetEraseColor(RGB(192, 192, 192));
	LetterBitmap->Refresh();
	LightBulbA->Refresh();
	LightBulbL->Refresh();
	LightBulbN->Refresh();
	LetterA->SetDrawColor(RGB(0, 0, 255));
	LetterA->SetEraseColor(RGB(192, 192, 192));
	LetterA->Refresh();
	LetterL->SetDrawColor(RGB(0, 0, 255));
	LetterL->SetEraseColor(RGB(192, 192, 192));
	LetterL->Refresh();
	LetterN->SetDrawColor(RGB(0, 0, 255));
	LetterN->SetEraseColor(RGB(192, 192, 192));
	LetterN->Refresh();

	write_default();

	hSysMenu = GetSystemMenu(HWindow, FALSE);
}

BOOL
TOcr::CanClose()
{
	stop = TRUE;
	shutdown = TRUE;
	WinHelp(HWindow, "atree.hlp", HELP_QUIT, NULL);
//	remove("ocr.tre");
	return(TRUE);
}

void
TOcr::OcrAbout()
{
	GetApplication()->ExecDialog(new TDialog(this, OCR_ABOUTDLG));
}

void
TOcr::OcrQuit()
{
	CloseWindow();
}

void
TOcr::OcrHelp()
{
	WinHelp(HWindow, "atree.hlp", HELP_CONTEXT, 30L);
}

void
TOcr::OcrReset()
{
	LetterA->Init(hLetterA);
	LetterA->SetDrawColor(RGB(0, 0, 255));
	LetterA->SetEraseColor(RGB(192, 192, 192));
	LetterA->Refresh();
	LetterL->Init(hLetterL);
	LetterL->SetDrawColor(RGB(0, 0, 255));
	LetterL->SetEraseColor(RGB(192, 192, 192));
	LetterL->Refresh();
	LetterN->Init(hLetterN);
	LetterN->SetDrawColor(RGB(0, 0, 255));
	LetterN->SetEraseColor(RGB(192, 192, 192));
	LetterN->Refresh();
	write_default();
}

void
TOcr::OcrStop()
{
	stop = TRUE;
}

void
TOcr::OcrForget()
{
	LPATREE atree;
	FILE* outstream;
	WORD width = LetterBitmap->GetWidthBytes();

	Status->SetText("Selecting YES means you will need to retrain in the future!");
	int result = BWCCMessageBox(HWindow, "Forget previous training?", "OCR Forget",
							MB_ICONQUESTION | MB_YESNOCANCEL);

	if (result != IDYES) return;

	Status->SetText("ALN Demo - Light flashes on under character ALN detects");

	if ((outstream = fopen("ocr.tre", "w")) == NULL)
	{
		BWCCMessageBox(HWindow, "Can't open 'ocr.tre'", "OCR Train",
						 MB_ICONEXCLAMATION | MB_OK);
		exit(0);
	}

	fprintf(outstream, "1\n");

	for (WORD i = 0; i < 3; i++)
	{
		atree = atree_create(width*8, 512);
		atree_write(outstream, atree);
		atree_free(atree);
	}

	fclose(outstream);
}

void
TOcr::OcrEditA()
{
	PTEditDlg EditCharDlg;

	EditCharDlg = new TEditDlg(this, (PTBitmapControl)LetterA);
	GetApplication()->ExecDialog(EditCharDlg);
}

void
TOcr::OcrEditL()
{
	PTEditDlg EditCharDlg;

	EditCharDlg = new TEditDlg(this, (PTBitmapControl)LetterL);
	GetApplication()->ExecDialog(EditCharDlg);

}

void
TOcr::OcrEditN()
{
	PTEditDlg EditCharDlg;

	EditCharDlg = new TEditDlg(this, (PTBitmapControl)LetterN);
	GetApplication()->ExecDialog(EditCharDlg);

}

void TOcrApp::InitMainWindow()
{
	MainWindow = new TOcr();
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpCmd, int nCmdShow)
{
  TOcrApp OcrApp("OCR", hInstance, hPrevInstance,
		lpCmd, nCmdShow);
	BWCCGetVersion();
	OcrApp.Run();
  return OcrApp.Status;
}
