/*****************************************************************************
 ****                                                                     ****
 **** ocr.h                                                               ****
 ****                                                                     ****
 **** atree release 2.7 for Windows                                       ****
 **** Adaptive Logic Network (ALN) simulation program.                    ****
 **** Copyright (C) M. Thomas, N. Sanche, W.W. Armstrong 1991, 1992       ****
 ****                                                 			  						****
 **** License:                                                            ****
 **** A royalty-free license is granted for the use of this software for  ****
 **** NON_COMMERCIAL PURPOSES ONLY. The software may be copied and/or     ****
 **** modified provided this notice appears in its entirety and unchanged ****
 **** in all derived source programs.  Persons modifying the code are     ****
 **** requested to state the date, the changes made and who made them     ****
 **** in the modification history.                                        ****
 ****                                                                     ****
 **** Patent License:                                                     ****
 **** The use of a digital circuit which transmits a signal indicating    ****
 **** heuristic responsibility is protected by U. S. Patent 3,934,231     ****
 **** and others assigned to Dendronic Decisions Limited of Edmonton,     ****
 **** W. W. Armstrong, President.  A royalty-free license is granted      ****
 **** by the company to use this patent for NON_COMMERCIAL PURPOSES to    ****
 **** adapt logic trees using this program and its modifications.         ****
 ****                                                                     ****
 **** Limited Warranty:                                                   ****
 **** This software is provided "as is" without warranty of any kind,     ****
 **** either expressed or implied, including, but not limited to, the     ****
 **** implied warrantees of merchantability and fitness for a particular  ****
 **** purpose.  The entire risk as to the quality and performance of the  ****
 **** program is with the user.  Neither the authors, nor the             ****
 **** University of Alberta, its officers, agents, servants or employees  ****
 **** shall be liable or responsible in any way for any damage to         ****
 **** property or direct personal or consequential injury of any nature   ****
 **** whatsoever that may be suffered or sustained by any licensee, user  ****
 **** or any other party as a consequence of the use or disposition of    ****
 **** this software.                                                      ****
 **** Modification history:                                               ****
 ****                                                                     ****
 **** 92.04.27 atree v2.5 for Windows, M. Thomas                          ****
 **** 92.03.07 Release 2.6, Monroe Thomas, Neal Sanche                    ****
 **** 92.01.08 Release 2.7, Monroe Thomas, Neal Sanche                    ****
 ****                                                                     ****
 *****************************************************************************/

// ocr.h

#include <owl.h>
#include <dialog.h>
#include <bstatic.h>
#include <bbutton.h>
#include <bwcc.h>
#include <stdio.h>
#include <iostream.h>
#include <conio.h>

#include "atree.h"
#include "bitmap.h"
#include "ocr.rch"

_CLASSDEF(TOcr)
class TOcr : public TDialog
{
	PTBitmapControl LightBulbA;
	PTBitmapControl LightBulbL;
	PTBitmapControl LightBulbN;
	PTBitmapControl LetterA;
	PTBitmapControl LetterL;
	PTBitmapControl LetterN;
	PTBitmapControl LetterBitmap;
	PTBStatic Correct;
	PTBStatic Incorrect;
	PTBStatic Status;

	HBITMAP hLightOn;
	HBITMAP hLightOff;
	HBITMAP hLetterA;
	HBITMAP hLetterL;
	HBITMAP hLetterN;
	HBITMAP hLetterClear;

	HMENU hSysMenu;

	BOOL stop;
	BOOL shutdown;

	PTBButton Start;
	PTBButton Stop;
	PTBButton Train;
	PTBButton Quit;
	PTBButton Reverse;
	PTBButton Forget;
	PTBButton Reset;
	PTBButton EditA;
	PTBButton EditL;
	PTBButton EditN;

	typedef struct tagTrainStruct
	{
		FILE* stream;
		HBITMAP bitmaps[3];
		int treesize;
		int voters;
		int numsamples;
		WORD maxepochs;
		float mincorrect;
		int maxrotation;
	} TrainStruct;

	BOOL vote(LPFAST_TREE* ftree, LPBIT_VEC vec, int voters);
	void train(TrainStruct& ts);
	void clear_bv(bit_vec);
	void write_default();
	void translate(HBITMAP hbm, int dx, int dy);

public:

	// constructor
	TOcr();
	~TOcr();

	virtual LPSTR GetClassName();
	virtual void GetWindowClass(WNDCLASS&);

	virtual void SetupWindow();

	virtual BOOL CanClose();

	virtual void OcrAbout() = [ID_FIRST + OCR_ABOUT];
	virtual void OcrQuit() = [ID_FIRST + OCR_QUIT];
	virtual void OcrStart() = [ID_FIRST + OCR_START];
	virtual void OcrStop() = [ID_FIRST + OCR_STOP];
	virtual void OcrTrain(RTMessage) = [ID_FIRST + OCR_TRAIN];
	virtual void OcrReverse() = [ID_FIRST + OCR_REVERSE];
	virtual void OcrForget() = [ID_FIRST + OCR_FORGET];
	virtual void OcrReset() = [ID_FIRST + OCR_RESET];
	virtual void OcrHelp() = [ID_FIRST + OCR_HELP];
	virtual void OcrEditA() = [ID_FIRST + OCR_EDITA];
	virtual void OcrEditL() = [ID_FIRST + OCR_EDITL];
	virtual void OcrEditN() = [ID_FIRST + OCR_EDITN];
};

