


/*
--      RADIOLAR.C radiolarian see Scientific American July 1989
--         Computer Recreations by A.K. Dewdney p. 110
--         and Biomorphs: Computer Displays of Biological
--         Forms Generated from Mathematical Feedback Loops in
--         Computer Graphics Forum 5 (1986) 313-316 C.A. Pickover
--
--                                 9/89   h.m. pollock
*/

#include <graphics.h>
#include <stdlib.h>
#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>


#define MAXROW 200
#define MAXCOL 320

#define RESOLUTION 150                             /* array 150 by 150     */
#define ITERATIONS 10                              /* repeat formula for z */
#define COLORS_POSSIBLE 3
#define COLOR_STEPS ITERATIONS/COLORS_POSSIBLE
#define CGA_BLACK 0

char Response[81];

main ()  {
	 struct complex c;
	 int again;
	 float range;
     struct arccoordstype arcinfo;
     struct textsettingstype oldtext;
	 int xasp, yasp, menu_choice;
	 int graphdriver = CGA;
	 int graphmode = CGAC1;
	 again = 'y';
	 while (again == 'y' || again == 'Y' )  {
		  clrscr();
		  logo();
		  get_c(&c, &range);
		  clrscr();
		  menu_choice = menu();
		 initgraph(&graphdriver, &graphmode, "");
		  generator(&menu_choice, &c, &range);
		  restorecrtmode();
		  gotoxy(30,12);
		  printf("Again ? ");
		  gets(Response);
		  again = Response[0];
		}
}


logo()  {

 printf("\nͻ"
        "\n serious software from                                     "
        "\n                                                           "
        "\n         I A T R O G E N I C   S O F T W A R E             "
        "\n             Essex Center Drive - Suite 205                "
        "\n            Peabody, Massachusetts 01960-2972              "
        "\n                                                           "
        "\n             you know its serious ....  when its iatrogenic"
		"\nͼ");
}


int menu()     {
	int x,y,z;
	z = 4;
	printf("\n"
"\n The appearance of the radiolarian is markedly influenced by the choice"
"\n of method use to color it.  Choose from one of the following --"
"\n "
"\n 1.  The original or discovery mode depends on whether either part of the"
"\n     complex number remains less than 10 (converges) "
"\n "
"\n 2.  Alternatively on may color in a step-wise fashion depending whether"
"\n 	the entire complex number converges"
"\n "
"\n 3.  Use the modulus function to determine color."
"\n "
"\n               which choice ? ");
	  x = wherex();
	  y = wherey();
	 while (( z < 1 )|| (z > 3) ) {
		gotoxy(x,y);
		gets(Response);
		z = atoi(Response);
	 }
	 return(z);
}



get_c(struct complex *c, float *sde)

{

    char ch;
	char response[81];
	int x,y;

    struct complex start;

    while(1)  {

     start.x = 19;
     start.y = 19;
     *sde    = 30;

	  x = wherex();
	  y = wherey();
      while (!((start.x > -11) && (start.x < 11))) {
		   gotoxy(x,y);
		   printf("\n\nWhere do you want to start the real part? ");
		   printf("\nRange should be between -10 and +10  ");
			gets(Response);
			start.x = atof(Response);
        }

	  x = wherex();
	  y = wherey();
      while (!((start.y > -11) && (start.y < 11))) {
		   gotoxy(x,y);
            printf("\n\nWhere do you want to start the imaginary part? ");
               printf("\nRange should be between -10 and +10  ");
			gets(Response);
			start.y = atof(Response);
        }

	  x = wherex();
	  y = wherey();
	  while (!((*sde > 0) && (*sde <= 20))) {
		   gotoxy(x,y);
		   printf("\n\nRange should be between 0 and 20");
            printf("\nHow long a distance should the display cover ? ");
			gets(Response);
			*sde = atof(Response);
        }

       printf("\nThe origin is       real: %f",start.x);
       printf("\n               imaginary: %f",start.y);
       printf("\n     range to be graphed: %f",*sde   );
        printf("\nIs this ok (y/n) ? ");
       ch=getch();
       while (!( ((ch=='y') || (ch=='Y'))||((ch=='n')||(ch=='N'))))  {
           printf("\rIs this ok (y/n) ? ");
           ch=getch();
       }

       if (ch == 'y' || ch == 'Y')
           break;
    }
*c = start ;
}



generator(int *choice, struct complex *c_passed, float *side)

{

  struct complex c,z,zo,temp1_z, temp2_z;


	int y_counter,x_counter, i, color, pauser;
	float increment_per_count;
    double size;
    increment_per_count = *side/RESOLUTION;                        /* relate picture & plane*/

   c   = *c_passed;

   printf("%5.2f\n", c.y + *side);
   printf("  \n");
   printf("I \n");
   printf("M \n");
   printf("A \n");
   printf("G \n");
   printf("I \n");
   printf("N \n");
   printf("A \n");
   printf("R \n");
   printf("Y \n");
   printf("  \n");
   printf("P \n");
   printf("A \n");
   printf("R \n");
   printf("T \n");
   printf("  \n");
   printf("  \n");
   printf("%5.2f\n", c.y );
   printf("  \n");

   printf("%5.2f REAL PART - COMPLEX PLANE  ",c.x);
   printf("%5.2f",c.x + *side);
   printf("\n\n  color  Z <- Z^3 + C     by \n");
   switch (*choice) {
		case 1:
			printf("         escape of part");
			break;
		case 2:
			printf("         escape of whole");
			break;
		case 3:
			printf("         modulus");
			break;
   }

   z.x   = 0;
   z.y   = 0;
   zo.x  = c.x;
   zo.y  = c.y;
   c.x   = .5;
   c.y   = 0;
	for (y_counter = 1; y_counter <= RESOLUTION; y_counter++)         {
        if  ( kbhit())   break;
        for (x_counter = 1; x_counter <= RESOLUTION; x_counter++)     {
            if  ( kbhit())   break;
			   z.x = zo.x + ((double)x_counter * (double)increment_per_count);
			   z.y = zo.y + ((double)y_counter * (double)increment_per_count);
            for(i = 1; i <= ITERATIONS+1; i++)  {
                if  ( kbhit())   break;
/*  z <- z^3 + c */
                    multiply_complex_numbers( &z, &z, &temp1_z);
                    multiply_complex_numbers( &z, &temp1_z, &temp2_z);


					add_complex_numbers( &temp2_z, &c, &z);

					if (cabs(z)   > 10) break;
					if (fabs(z.x) > 10) break;
					if (fabs(z.y) > 10) break;


			} /* end iterations */

	   switch (*choice) {
/* discovery mode  escape of a part of the  complex number*/
		case 1:
			if ( (fabs(z.x) < 10) || (fabs(z.y) < 10))
			   color = CGA_BLACK;
			else
			   color = CGA_WHITE;
			break;
/* escape of the complex number as a whole                */
		case 2:
			if (i == ITERATIONS)
              color = 0;
            else
			   color =  (COLORS_POSSIBLE - i /(COLOR_STEPS + 1));
			break;
/* mod mode */
		case 3:
			if (i == ITERATIONS)
              color = 0;
            else
			   color = i % COLOR_STEPS + 1;
			break;
		}  /* end switch  */
		putpixel( (x_counter + 50), (RESOLUTION - y_counter), color);
		} /* end x-counter */
	}
	pauser = getche();
	return(pauser);          /* dummy return suppresses error msg  */
}





     add_complex_numbers(  struct complex *a,
                           struct complex *b,
                           struct complex *c)
{
          c->x = a->x  + b->x;
          c->y = a->y  + b->y;
}

     subtract_complex_numbers(  struct complex *a,
                                struct complex *b,
                                struct complex *c)
{
          c->x = a->x  - b->x;
          c->y = a->y  - b->y;
}

     multiply_complex_numbers(  struct complex *a,
                                struct complex *b,
                                struct complex *c)
{
		  c->x = (a->x * b->x) - (a->y * b->y);
          c->y = (b->x * a->y) + (b->y * a->x);
}



     divide_complex_numbers  (  struct complex *a,
                                struct complex *b,
                                struct complex *c)
{
           double temp;

           temp = (b->x * b->x) + (b->y * b->y);


          c->x = ((a->x * b->x) + (a->y * b->y))/ temp ;
          c->y = ((a->y * b->x) - (a->x * b->y))/ temp ;
}



