/*	File = FILES.C
	This program reads & writes the Knowledge Base to/from
	 Disk Files.
	*/

#include	<ctype.h>
#include	<stdio.h>
#include	<string.h>
#include	"fuzzy.h"

/*	Load a Knowledge Base File. A default is assumed consisting
	of the Command Line Name with a .knb suffix. This name is
	presented to the user, who may accept with a CR or may supply
	his/her own File name.
	*/
load_kb()
{
FILE	*fp;
char	buf[25], save_file[25];
int	i, j, k;

strcpy(save_file, File_Name);
strcat(save_file, KBFILE);	/* Filename has .kbn suffix.		*/
printf("Load Knowledge Base from %s (CR to accept) ",save_file);
getline(buf);		printf("\n");

if( strlen(buf) != 0)			/* If a non-null string is 	*/
    { i = instr(buf, '\.');		/* returned, check for suffix.	*/
    if (i > 0)				/* Force the suffix to be .knb	*/
	buf[i] = 0;			/* (Only legal suffix) If no	*/
    strcpy(save_file, buf);		/* suffix, provide one.		*/
    strcat(save_file, KBFILE);
    }

printf("Loading Knowledge Base from File <%s>\n\n\n",save_file);
fp = fopen(save_file, "r");
if( fp == NULL )
    { printf("FLP_11A: Cannot open Knowledge Base File to read.\n\n\n");
    return;
    }

/* 1st thing to do - read inputs...					*/
for(i=0; i < NUM_IN_NAME; ++i)	/* read all inputs.			*/
    {
    fscanf(fp, "%s\n", In_Name+(i*NAMESIZE));
    fscanf(fp, "%d\n", In_Min+i );
    fscanf(fp, "%d\n", In_Max+i );
    fscanf(fp, "%s\n", In_Units+(i*UNITSIZE));
    for(j=0; j < NUM_IN_FUNC; ++j)	/* read all functions.*/
	{
	fscanf(fp, "%s\n", In_Func+((i*NUM_IN_FUNC)+j)*FUNCSIZE );
	for(k=0; k < NUM_IN_POINTS; ++k)	/* read all Points.*/
	    {
	    fscanf(fp, "%d\n", In_Points+(i*NUM_IN_POINTS*NUM_IN_FUNC)+
                    (j*NUM_IN_POINTS)+k );
	    }
	}
    }


/* 2nd thing to do - read outputs...					*/
for(i=0; i < NUM_OUT_NAME; ++i)	/* read all inputs.			*/
    {
    fscanf(fp, "%s\n", Out_name+(i*NAMESIZE));
    fscanf(fp, "%d\n", Out_min+i );
    fscanf(fp, "%d\n", Out_max+i );
    fscanf(fp, "%s\n", Out_units+(i*UNITSIZE));
    for(j=0; j < NUM_OUT_FUNC; ++j)	/* read all functions.*/
	{
	fscanf(fp, "%s\n", Out_func+((i*NUM_OUT_FUNC)+j)*FUNCSIZE );
	for(k=0; k < NUM_OUT_POINTS; ++k)	/* read all Points.*/
	    {
	    fscanf(fp, "%d\n", 
			Out_points+(i*NUM_OUT_FUNC*NUM_OUT_POINTS)+
			(j*NUM_OUT_POINTS)+k );
	    }
	}
    }

/*	Now read the Rules.		*/
j = NO;				/* flag first occurrance of $FF	*/
for(i=0; i<MAX_RULE_SIZE; ++i)
    {
    fscanf(fp,"%X\n",Rules+i );
    if( (Rules[i] == 0xff) && (j == NO) )
	{ j = YES;
	Rules_ptr = i;
	}
    }

fclose(fp);    
Kb_Dirty = NO;
}
/**/
save_kb()
{
FILE	*fp;
char	buf[25], save_file[25];
int	i, j, k;

strcpy(save_file, File_Name);
strcat(save_file, KBFILE);	/* Filename has .kbn suffix.		*/
printf("Save Knowledge Base to File <%s> (CR to accept) ",save_file);
getline(buf);		 printf("\n");

if( strlen(buf) != 0)			/* If a non-null string is 	*/
    { i = instr(buf, '\.');		/* returned, check for suffix.	*/
    if (i > 0)				/* Force the suffix to be .knb	*/
	buf[i] = 0;			/* (Only legal suffix) If no	*/
    strcpy(save_file, buf);		/* suffix, provide one.		*/
    strcat(save_file, KBFILE);
    }

printf("Saving Knowledge Base to File <%s>\n\n\n",save_file);
fp = fopen(save_file, "w");
if( fp == NULL )
    { printf("FLP_11A: Cannot open Knowledge Base File to write.\n\n\n");
    return;
    }

/* 1st thing to do - write inputs...					*/
for(i=0; i < NUM_IN_NAME; ++i)	/* write all inputs.			*/
    {
    fprintf(fp, "%s\n", In_Name+(i*NAMESIZE));
    fprintf(fp, "%d\n", In_Min[i]);
    fprintf(fp, "%d\n", In_Max[i]);
    fprintf(fp, "%s\n", In_Units+(i*UNITSIZE));
    for(j=0; j < NUM_IN_FUNC; ++j)	/* write all functions.*/
	{
	fprintf(fp, "%s\n", In_Func+((i*NUM_IN_FUNC)+j)*(FUNCSIZE) );
	for(k=0; k < NUM_IN_POINTS; ++k)	/* write all Points.*/
	    fprintf(fp, "%d\n", 
                    In_Points[(i*NUM_IN_POINTS*NUM_IN_FUNC)+
				(j*NUM_IN_POINTS)+k]);
	}
    }


/* 2nd thing to do - write outputs...					*/
for(i=0; i < NUM_OUT_NAME; ++i)	/* write all inputs.			*/
    {
    fprintf(fp, "%s\n", Out_name+(i*NAMESIZE));
    fprintf(fp, "%d\n", Out_min[i]);
    fprintf(fp, "%d\n", Out_max[i]);
    fprintf(fp, "%s\n", Out_units+(i*UNITSIZE));
    for(j=0; j < NUM_OUT_FUNC; ++j)	/* write all functions.*/
	{
	fprintf(fp, "%s\n", Out_func+((i*NUM_OUT_FUNC)+j)*(FUNCSIZE) );
	for(k=0; k < NUM_OUT_POINTS; ++k)	/* write all Points.*/
	    {
	    fprintf(fp, "%d\n", 
			Out_points[(i*NUM_OUT_POINTS*NUM_OUT_FUNC)+
			(j*NUM_OUT_POINTS)+k]);
	    }
	}
    }

/*	Now write the Rules.		*/
for(i=0; i<MAX_RULE_SIZE; ++i)
    fprintf(fp,"%X\n",Rules[i]);

fclose(fp);    
Kb_Dirty = NO;
}
/**/
/*	This routine creates the assembly code routine which
	is assembled along with the Inference Engine source
	code. Together these form the Fuzzy Logic System.
	The filename is assumed to be the name captured
	from the command line with the suffix ".asm" added.
	The user may override this default with his/her own
	filename.
	*/
#define	VARSIZE

make_asm()
{
FILE	*fp;
char	buf[25], save_file[25];
float	temp, scale_factor, range;
int	i, j, k, min, max;
int	num_inputs, num_outputs;
int	P1, P2, P3, P4, S2, S4;
float	SP1, SP2, SP3, SP4;
#ifdef	VARSIZE
int	inputs_used, outputs_used;
#endif

strcpy(save_file, File_Name);
strcat(save_file, ASMFILE);	/* Filename has .asm suffix.		*/
printf("Create Output File <%s> (CR to accept) ",save_file);
getline(buf);		 printf("\n");

if( strlen(buf) != 0)			/* If a non-null string is 	*/
    { i = instr(buf, '\.');		/* returned, check for suffix.	*/
    if (i > 0)				/* Force the suffix to be .asm	*/
	buf[i] = 0;			/* (Only legal suffix) If no	*/
    strcpy(save_file, buf);		/* suffix, provide one.		*/
    strcat(save_file, ASMFILE);
    }

printf("Creating Assembly File <%s>\n",save_file);
fp = fopen(save_file, "w");
if( fp == NULL )
    { printf("FLP_11A: Cannot create Assembly Output File.\n\n\n");
    return;
    }

fprintf(fp,"*\tFUZZY Logic Preprocessor Version V%s\n",Version);
fprintf(fp,"*\tAuthor: John Dumas\n");
fprintf(fp,"*\tCopyright Motorola 1991,1992\n");
fprintf(fp,"*\tFile Name = %s\n\n",save_file);
/**/
fprintf(fp, "INPUT_MFS\tEQU\t*\tInput Membership Functions.\n");
inputs_used = 0;
for(i=0; i<NUM_IN_NAME; ++i)	/* Do each of the inputs.		*/
    {				/* First print its name,,,,,		*/
#ifdef	VARSIZE
    if(In_Name[i*NAMESIZE] == TILDE)	/* if Empty, skip it!		*/
	{
  	continue;
	}
    else
	++inputs_used; 
#endif

    fprintf(fp,"IN%1dMF\t\tEQU\t*\t%16s\n",i,In_Name+(i*NAMESIZE));
    min = In_Min[i];	max = In_Max[i];	
    range = max - min;

    if( range == 0)
        {
	scale_factor = 1;
        }
    else
        {
	scale_factor = (float) (255 / range) ;
 	}

    for(j=0; j<NUM_IN_FUNC; ++j)	/* Then each Function Member	*/
	{			/* Along with the POINTS description.	*/
	fprintf(fp,"\t\tFCB\t");
/* 	This "stuff" is specific to # of points!			*/
	k = (i*NUM_IN_NAME*NUM_IN_POINTS)+(j*NUM_IN_POINTS);
	P1 = In_Points[k];	P3 = In_Points[k+2];
	P2 = In_Points[k+1];	P4 = In_Points[k+3];
	SP1 = (P1 - min) * scale_factor;  /* Scale it to 255!*/
	SP2 = (P2 - min) * scale_factor;  /* Scale it to 255!*/
	SP3 = (P3 - min) * scale_factor;  /* Scale it to 255!*/
	SP4 = (P4 - min) * scale_factor;  /* Scale it to 255!*/
	temp = SP2 - SP1;
	if (temp == 0)
	    SP2 = 0;
	else {
	    SP2 = 255 / temp;
	    if(SP2 >= 256)
		SP2 = 255;
	    }

	temp = SP4 - SP3;
	if (temp == 0)
	    SP4 = 0;
	else {
	    SP4 = 255 / temp;
	    if(SP4 >= 256)
		SP4 = 255;
	    }

	P1 = (int)SP1+0.5;
	P3 = (int)SP3+0.5;
	S2 = (int)SP2+0.5;
	S4 = (int)SP4+0.5;
	fprintf(fp,"$%02X,$%02X,$%02X,$%02X\t%16s\n",P1,S2,P3,S4,In_Func+
			( (i*NUM_IN_FUNC)+j)*FUNCSIZE);
	}		/* End of FOR "j" Loop.				*/
    } 			/* End of FOR "i" Loop.				*/
/**/
fprintf(fp, "SGLTN_POS\tEQU\t*\tOutput Membership Functions.\n");
outputs_used = 0;
for(i=0; i<NUM_OUT_NAME; ++i)	/* Do each of the outputs.		*/
    {				/* First print its name,,,,,		*/
#ifdef	VARSIZE
    if(Out_name[i*NAMESIZE] == TILDE)	/* if Empty, skip it!		*/
  	continue;
    else
	++outputs_used; 
#endif

    fprintf(fp,"OUT%1dMF\t\tEQU\t*\t%16s\n",i,Out_name+(i*NAMESIZE));
    min = Out_min[i];	max = Out_max[i];	
    range = max-min;

    if( range == 0)
	scale_factor = 1;
    else
	{
	scale_factor = 255 / range;
	}

    for(j=0; j<NUM_OUT_FUNC; ++j)	/* Then each Function Member	*/
	{			/* Along with the POINTS description.	*/
	fprintf(fp,"\t\tFCB\t");
/* 	This "stuff" is specific to # of points!			*/
	k = (i*NUM_OUT_FUNC*NUM_OUT_POINTS)+(j*NUM_OUT_POINTS);
	P1 = Out_points[k];	
	SP1 = (P1 - min) * scale_factor;	/* Scale it to 255!     */
	P1 = (int) SP1+0.5;
	fprintf(fp,"$%02X\t\t%16s\n",P1,Out_func+
			( (i*NUM_OUT_FUNC)+j)*FUNCSIZE);
	}		/* End of FOR "j" Loop.				*/
    } 			/* End of FOR "i" Loop.				*/

/**/
fprintf(fp,"RULE_START\tEQU\t*\n");
for(i=0; i<MAX_RULE_SIZE; ++i)	/* Do each of the Rules.		*/
    { if(Rules[i] == 255)
	{ fprintf(fp,"END_OF_RULE\tFCB\t$%X\n",Rules[i]);
	break;
	}
    else
	fprintf(fp,"\t\tFCB\t$%X\n",Rules[i]);
    }

#ifdef	VARSIZE
fprintf(fp,"NUMINP\tEQU\t$%d\n",inputs_used);
fprintf(fp,"NUMOUT\tEQU\t$%d\n",outputs_used);
#endif

fclose(fp);
}
