/*	File = FUZZY.C
	This program prompts the users for INPUTS, OUTPUTS, and
	 RULES. These are used to generate FCBs for Jim Sib's
	 68HC11B FUZZY inference generator.
	*/

#include	<ctype.h>
#include	<stdio.h>
#include	<string.h>
#include	"fuzzy.h"

main(argc, argv)
int	argc;
char	*argv[];
{
int	cp;

if(argc != 2)				/* kbg_11 wants to have default	*/
    { printf("FLP_11A: Syntax error.\n");	/* File name in the 	*/
    printf("Usage: FLP_11A <FileName> CR\n");	/* command line.	*/
    exit(1);
    }

strcpy(File_Name, argv[1]);
if((cp = instr(File_Name, '\.')) != NULL)
    { printf("FLP_11A: Filename extension not needed. Removed.\n");
    File_Name[cp] = NULL; 
    printf("Using '%s' as the base FileName.\n",File_Name);
    }

init();

strcpy(Version, VERSION);
printf("                  KBG_11B\n");
printf("MC68HC11 Fuzzy Logic Preprocessor V%s\n",Version);
printf("Copyright Motorola Inc. 1991,1992.\n");
printf("Author: John Dumas\n\n");
printf("Use THIS version ONLY with the 'fuzzy11b' Inference Engine!\n");
main_menu();

}
/**/
init()			/* Clear & init the memory arrays.	*/
{			/* Later they will be loaded/edited.	*/
int	i, j;

for(i=0; i<(NUM_IN_NAME); ++i)
    strcpy(In_Name+(i * NAMESIZE), "~");
for(i=0; i < NUM_IN_NAME; ++i)
    In_Min[i] = 0;
for(i=0; i < NUM_IN_NAME; ++i)
    In_Max[i] = 0;
for(i=0; i < (NUM_IN_NAME); ++i)
    strcpy(In_Units+(i * UNITSIZE), "~");
for(i=0; i < (NUM_IN_NAME)*(NUM_IN_FUNC); ++i)
    strcpy(In_Func+(i * FUNCSIZE), "~");
for(i=0; i < (NUM_IN_NAME)*(NUM_IN_FUNC)*(NUM_IN_POINTS); ++i)
    In_Points[i] = 0;

for(i=0; i<(NUM_OUT_NAME); ++i)
    strcpy(Out_name+(i * NAMESIZE), "~");
for(i=0; i < (NUM_OUT_NAME); ++i)
    strcpy(Out_units+(i * UNITSIZE), "~");
for(i=0; i < NUM_OUT_NAME; ++i)
    Out_min[i] = 0;
for(i=0; i < NUM_OUT_NAME; ++i)
    Out_max[i] = 0;
for(i=0; i < (NUM_OUT_NAME)*(NUM_OUT_FUNC); ++i)
    strcpy(Out_func+(i * FUNCSIZE), "~");
for(i=0; i < (NUM_OUT_NAME)*(NUM_OUT_FUNC)*(NUM_OUT_POINTS); ++i)
    Out_points[i] = 0;

for(i=0; i < MAX_RULE_SIZE; ++i)
    Rules[i] = 255;

Rules_ptr = 0;
Kb_Dirty = NO;
}
/**/
main_menu()
{
char	cmdline[80];

while(1)
    {
    printf("	FLP_11B Main Menu.\n\n");
    printf("	1) Load a (previously created) Knowledge Base.\n");
    printf("	2) Save the current Knowledge Base.\n");
    printf("	3) Enter new data to current Knowledge Base.\n");
    printf("	4) Show the current Knowledge Base.\n");
    printf("	5) Create .ASM file.\n");
    printf("	6) Exit to OS.\n");
    printf("Enter your selection: ");
    getline(cmdline);
    printf("\n");
    switch (*cmdline)
	{
	case ('1'):
	    load_kb();	break;
	case ('2'):
	    save_kb();	break;
	case ('3'):
	    enter_data();	break;
	case ('4'):
	    display_kb();	break;
	case ('5'):
	    make_asm();	break;
	case ('6'):
	    if(Kb_Dirty == YES)
		{
		while(1)
		    {
		    printf("The current Knowledge Base has not been saved. Save it? ");
		    getline(cmdline);	printf("\n");
		    *cmdline = toupper(*cmdline);
		    if (*cmdline == 'Y')
			{ save_kb();
			break;
			}
		    else if(*cmdline == 'N')
			{ break;
			}	
		    }
		}
	    printf("\n\nThank you for using the Knowledge Base Generator.\n");
	    exit();
	}
    }
}
/**/
enter_data()
{
char	cmdline[80];


while(1)
    {
    printf("\n\n\n");
    printf("	FLP_11B Data Entry Menu.\n\n");
    printf("	1) Specify INPUT signal names.\n");
    printf("	2) Specify OUTPUT signal names.\n");
    printf("	3) Specify INPUT Membership Functions.\n");
    printf("	4) Specify OUTPUT Membership Functions.\n");
    printf("	5) Specify RULES.\n");
    printf("	6) Exit to Main Menu.\n");
    printf("Enter your selection: ");
    getline(cmdline);
    printf("\n");
    switch (*cmdline)
	{
	case ('1'):
	    spec_in_names();	break;
	case ('2'):
	    spec_out_names();	break;
	case ('3'):
	    spec_in_member();	break;
	case ('4'):
	    spec_out_member();	break;
	case ('5'):
	    spec_rules();		break;
	case ('6'):
	    return ;
	}
    }
}
