/*	File = INPUTS.C
	This file contains the INPUT add, delete section.
	That includes Membership functions.
	*/

#include	<ctype.h>
#include	<stdio.h>
#include	<string.h>
#include	"fuzzy.h"

/* This routine is used to add, delete, & edit INPUTS.			*/
/*  Version V100 (V1.00) had no provision for edits. That was added	*/
/*  in Version 101 (V1.01).						*/
spec_in_names()
{
int	fnum, flag;
char	buf[80];

flag = NO;
while (flag == NO)		/* We always show the current state 	*/
    {				/* asking questions.			*/
    show_inputs();		printf("\n");

#ifdef V100 
    printf("Do you wish to (A)dd INPUTS, (D)elete INPUTS or (Q)uit? ");
#else
    printf("Do you wish to (A)dd INPUTS, (D)elete INPUTS, (E)dit INPUTS or (Q)uit? ");
#endif
 
    getline(buf);		printf("\n");
    *buf = toupper(*buf);

    if (*buf == 'A')
	add_input();
	
    else if (*buf == 'D')
	delete_input();
	
#ifndef V100 
    else if (*buf == 'E')
	edit_input();
	
#endif
    else if (*buf == 'Q')
	return YES;
    }
return YES;
}
/**/
/* 	Search for an empty input & ask for data to define it.	*/
/*	If no empties are left, report it. (The user must be	*/
/*	be BLIND, but we'll play it cool.....)			*/
add_input()
{
int	in_num;

in_num =0;				/* Search for empty input slot.	*/
while (in_num < NUM_IN_NAME)
    { if(In_Name[in_num*NAMESIZE] == TILDE)	/*Check for Tilde.	*/
	{ get_input(in_num) ;
	return YES;
	}
    ++in_num;
    }
printf("I'm sorry but you have no more free inputs.\n");
return NO;
}
/**/
edit_input()
{
char	buf[132];
int	flag;
int	in_num;

printf("Which INPUT (number) would you like to Edit? ");
getline(buf);		printf("\n");
in_num = atoi(buf);
if( (in_num < 1) || (in_num > NUM_IN_NAME) )
    {
    printf("WHAT? Inputs are numbered 1 to %d!!??!!\n",NUM_IN_NAME);
    return NO;
    }

--in_num;
flag = NO;
while(flag == NO)
    { 
    show_in_func(in_num);
    printf("\t\t\tEdit What?\n");
	printf("\t\t1) Input Name.\t\t2) Minimum Value.\n");
	printf("\t\t3) Maximum Value.\t4) Units Name.\n");
	printf("\t\t5) Quit Edit.\n");
	printf("\t\tSelect ==> ");
    getline(buf);	printf("\n");
    switch(*buf)
	{
	case '1':				/* Rewrite the name.	*/
	    printf("New Input Name: ");
	    getline(buf);	printf("\n");
	    buf[15] = 0;			/* limit to 15 chars.	*/
	    strcpy(In_Name+(in_num*NAMESIZE), buf);
	    break;
	case '2':
	    printf("New Minimum Value: ");
	    getline(buf);	printf("\n");
	    buf[15] = 0;			/* limit to 15 chars.	*/
	    In_Min[in_num] = atoi(buf);
	    break;
	case '3':
	    printf("New Maximum Value: ");
	    getline(buf);	printf("\n");
	    buf[15] = 0;			/* limit to 15 chars.	*/
	    In_Max[in_num] = atoi(buf);
	    break;
	case '4':
	    printf("New Units Name: ");
	    getline(buf);	printf("\n");
	    buf[15] = 0;			/* limit to 15 chars.	*/
	    strcpy(In_Units+(in_num * UNITSIZE), buf);
	    break;
	case '5':
	    flag = YES;
	    break;
	}
    }
Kb_Dirty = YES;
}
/**/
delete_input()
{
char	buf[80];
int	fnum;
int	in_num;

printf("Which INPUT (number) would you like to delete? ");
getline(buf);		printf("\n");
in_num = atoi(buf);
if( (in_num < 1) || (in_num > NUM_IN_NAME) )
    {
    printf("WHAT? Inputs are numbered 1 to %d!!??!!\n",NUM_IN_NAME);
    return NO;
    }

--in_num;
strcpy(In_Name+(in_num*NAMESIZE),"~");
for(fnum=0; fnum<NUM_IN_FUNC; ++fnum)
    strcpy(In_Func+( (in_num*NUM_IN_FUNC)+fnum)*FUNCSIZE,"~");

Kb_Dirty = YES;
}
/**/
/*	This routine collects data for an INPUT & puts it into the	*/
/*	array.								*/
get_input(inum)
int	inum;
{
char	name[80], low_name[80];
int	min, max; 

/* Collect the NAME (string of CHAR) for this INPUT			*/
/* Check for Terminator string & return YES.				*/
strcpy(low_name, "");
printf("What is the NAME of this input? ");
printf("Input #%d > ",inum+1);
getline(name);		
printf("\n");
if(strlen(name) == 0)
    return;
strcpy(low_name, name);
low_name[NAMESIZE-1] = 0;	/* Truncate the name.			*/
strcpy(In_Name+(inum*NAMESIZE),low_name);
Kb_Dirty = YES;

/* Collect the UNITS (string of CHAR) for this INPUT			*/
printf("What UNITS(MPH, DegC, PPM, etc..) are used to describe it? ");
getline(name);		
printf("\n");
strcpy(low_name, name);
low_name[NAMESIZE-1] = 0;	/* Truncate the name.			*/
strcpy(In_Units+(inum * UNITSIZE), low_name);
Kb_Dirty = YES;

/* 	Get the Min & Max value then compute the Scale Factor.		*/
GetMin:
printf("What is the MINIMUM value that this Input may assume? ");
getline(name);		
printf("\n");
min = atoi(name);	/* Note WELL!! min may be NEGATIVE!!		*/
printf("What is the MAXIMUM value that this Input may assume? ");
getline(name);		
printf("\n");
max = atoi(name);	/* Note WELL!! max may be NEGATIVE!!		*/
if(min >= max)
    { printf("I don't understand that range! MAX must be greater than MIN!\n");
    goto GetMin;
    }
In_Min[inum] = min;
In_Max[inum] = max;
return NO;
}
/**/
spec_in_member()
{
char	name[20], low_name[20];
int	inum, funcnum;

show_inputs();
printf("\n");
printf("To which INPUT (number) would you like to add FUNCTION members? ");
getline(name);		printf("\n");
inum = atoi(name);
if( (inum < 1) || (inum > NUM_IN_NAME) )
    {
    printf("WHAT? Inputs are numbered 1 to %d!!??!!\n",NUM_IN_NAME);
    return ;
    }

--inum;
More_in_members:
show_in_func(inum);
printf("\n");

printf("(A)dd Membership FUNCTIONS, (D)elete FUNCTIONS, or (Q)uit? ");
getline(name);	printf("\n");
*name = toupper(*name);
if (*name == 'A')
    goto Add_In_Func;
else if (*name == 'D')
    goto Delete_In_Func;
else
    return ;


Add_In_Func:
/* First check to see if there is a valid signal name!!!	*/
if(In_Name[inum*NAMESIZE] == TILDE)	/*Check for Tilde.	*/
    { printf("That is not a VALID Input!!\n");
    printf("You must give the INPUT a Name before adding Membership Functions.\n");
    return;
    }
for(funcnum=0; funcnum < NUM_IN_FUNC; ++funcnum)
    {
    if(In_Func[((inum*NUM_IN_FUNC)+funcnum)*FUNCSIZE] == TILDE)  
	{
	get_in_function(funcnum, inum);
	goto More_in_members;		
	}
    }
printf("I'm sorry but you have no more free Membership FUNCTIONS for this INPUT.\n");
return ;

Delete_In_Func:
printf("Which membership FUNCTION (number) would you like to delete? ");
getline(name);	printf("\n");
funcnum = atoi(name);
if( (funcnum < 1) || (funcnum > NUM_IN_FUNC) )
    {
    printf("WHAT? Function Members are numbered 1 to %d!!??!!\n",NUM_IN_FUNC);
    return NO;
    }

--funcnum;
strcpy(In_Func+( (inum*NUM_IN_FUNC)+funcnum)*FUNCSIZE,"~");
Kb_Dirty = YES;
goto More_in_members;
}
/**/
get_in_function(func_num, in_num)
int	func_num, in_num;
{
char	low_name[20], name[20];

/* Collect the NAME (string of CHAR) for this FUNCTION.			*/
/* Check for Terminator string & return YES.				*/
strcpy(low_name, "");
printf("What is the NAME of this function? ");
printf("Function #%d > ",func_num+1);
getline(name);		
printf("\n");
if(strlen(name) == 0)
    return;

strcpy(low_name, name);
low_name[NAMESIZE-1] = 0;	/* Truncate the name.			*/
strcpy(In_Func+( (in_num*NUM_IN_FUNC)+
		func_num)*FUNCSIZE,low_name);
get_points(in_num, func_num, NUM_IN_POINTS);
Kb_Dirty = YES;
return NO;
}
/**/
get_points(in, func, points)
int	in, func, points;
{
int	i, xP1, xP2, xP3, xP4;
char	buf[25];

RePoint:
if(points == NUM_IN_POINTS)	/* It's input member.		*/
    {
    printf("Input Membership is defined by four points of inflection.\n");
    printf("Points P1, P2, P3, P4 must monotonically increase.\n");
    printf("Enter P1: "); getline(buf); 
    printf("\n"); xP1 = atoi(buf);
    if(xP1 < In_Min[in])
	{ printf("P1 is less that MINIMUM value for this input!\n");
	goto RePoint;
	}
    if(xP1 > In_Max[in])
	{ printf("Point is GREATER that MAXIMUM value for this input!\n");
	goto RePoint;
	}
    printf("Enter P2: "); getline(buf); 
    printf("\n"); xP2 = atoi(buf);
    if(xP2 < xP1)
	{ printf("P2 is less P1!\n");
	goto RePoint;
	}
    if(xP2 > In_Max[in])
	{ printf("Point is GREATER that MAXIMUM value for this input!\n");
	goto RePoint;
	}
    printf("Enter P3: "); getline(buf); 
    printf("\n"); xP3 = atoi(buf);
    if(xP3 < xP2)
	{ printf("P3 is less P2!\n");
	goto RePoint;
	}
    if(xP3 > In_Max[in])
	{ printf("Point is GREATER that MAXIMUM value for this input!\n");
	goto RePoint;
	}
    printf("Enter P4: "); getline(buf); 
    printf("\n"); xP4 = atoi(buf);
    if(xP4 < xP3)
	{ printf("P4 is less P3!\n");
	goto RePoint;
	}
    if(xP4 > In_Max[in])
	{ printf("Point is GREATER that MAXIMUM value for this input!\n");
	goto RePoint;
	}
    if(xP4 > In_Max[in])
	{ printf("P4 is greater than MAXIMUM value for this input!\n");
	goto RePoint;
	}
    In_Points[ (in*NUM_IN_FUNC*NUM_IN_POINTS)+(func*NUM_IN_POINTS)+0] = xP1;
    In_Points[ (in*NUM_IN_FUNC*NUM_IN_POINTS)+(func*NUM_IN_POINTS)+1] = xP2;
    In_Points[ (in*NUM_IN_FUNC*NUM_IN_POINTS)+(func*NUM_IN_POINTS)+2] = xP3;
    In_Points[ (in*NUM_IN_FUNC*NUM_IN_POINTS)+(func*NUM_IN_POINTS)+3] = xP4;
    }
/**/
else if (points == NUM_OUT_POINTS)
    {
RePoint1:
    printf("Output Membership is defined by one singlton (P1).\n");
    printf("Enter P1: "); getline(buf); 
    printf("\n"); xP1 = atoi(buf);
    if(xP1 < Out_min[in])
	{ printf("P1 is less that MINIMUM value for this output!\n");
	goto RePoint1;
	}
    if(xP1 > Out_max[in])
	{ printf("P1 is greater than MAXIMUM value for this output!\n");
	goto RePoint1;
	}
    Out_points[ (in*NUM_OUT_FUNC*NUM_OUT_POINTS)+(func*NUM_OUT_POINTS)+0] = xP1;
    }
}
