/*	File = OUTPUTS.C
	This file contains the OUTPUT add, delete section.
	That includes Membership functions.
	*/

#include	<ctype.h>
#include	<stdio.h>
#include	<string.h>
#include	"fuzzy.h"

spec_out_names()
{
int	flag;
char	buf[80];

flag = NO;
while (flag == NO)
    {
    printf("The current Knowledge Base is aware of the following OUTPUTS:\n");
    show_outputs();		printf("\n");

#ifdef V100
    printf("Do you wish to (A)dd OUTPUTS, (D)elete OUTPUTS, or (Q)uit? ");
#else
    printf("Do you wish to (A)dd OUTPUTS, (D)elete OUTPUTS, (E)dit OUTPUTS or (Q)uit? ");
#endif

    getline(buf);		printf("\n");
    *buf = toupper(*buf);
    if (*buf == 'A')
	add_output();
	    
    else if (*buf == 'D')
	delete_output();
	 
#ifndef V100
    else if (*buf == 'E')
	edit_output();

#endif
    else if (*buf == 'Q')
	return YES;

    }
return YES;
}
/**/
edit_output()
{
char	buf[132];
int	flag;
int	out_num;

printf("Which OUTPUT (number) would you like to Edit? ");
getline(buf);		printf("\n");
out_num = atoi(buf);

if(valid_out_range(out_num) == NO)
    return NO;

--out_num;
flag = NO;
while(flag == NO)
    { 
    show_out_func(out_num);
    printf("\t\t\tEdit What?\n");
	printf("\t\t1) Output Name.\t\t2) Minimum Value.\n");
	printf("\t\t3) Maximum Value.\t4) Units Name.\n");
	printf("\t\t5) Quit Edit.\n");
	printf("\t\tSelect ==> ");
    getline(buf);	printf("\n");
    switch(*buf)
	{
	case '1':				/* Rewrite the name.	*/
	    printf("New Output Name: ");
	    getline(buf);	printf("\n");
	    buf[15] = 0;			/* limit to 15 chars.	*/
	    strcpy(Out_name+(out_num*NAMESIZE), buf);
	    break;
	case '2':
	    printf("New Minimum Value: ");
	    getline(buf);	printf("\n");
	    buf[15] = 0;			/* limit to 15 chars.	*/
	    Out_min[out_num] = atoi(buf);
	    break;
	case '3':
	    printf("New Maximum Value: ");
	    getline(buf);	printf("\n");
	    buf[15] = 0;			/* limit to 15 chars.	*/
	    Out_max[out_num] = atoi(buf);
	    break;
	case '4':
	    printf("New Units Name: ");
	    getline(buf);	printf("\n");
	    buf[15] = 0;			/* limit to 15 chars.	*/
	    strcpy(Out_units+(out_num * UNITSIZE), buf);
	    break;
	case '5':
	    flag = YES;
	    break;
	}
    }
Kb_Dirty = YES;
}
/**/
delete_output()
{
char	buf[132];
int	fnum;
int	out_num;

printf("Which OUTPUT (number) would you like to delete? ");
getline(buf);		printf("\n");
out_num = atoi(buf);

if(valid_out_range(out_num) == NO)
    return NO;

--out_num;
strcpy(Out_name+(out_num*NAMESIZE),"~");
for(fnum=0; fnum<NUM_OUT_FUNC; ++fnum)
    strcpy(Out_func+( (out_num*NUM_OUT_FUNC)+fnum)*FUNCSIZE,"~");

return (Kb_Dirty = YES);
}
/**/
add_output()
{
int	out_num;

out_num =0;			/* Search for empty output slot.	*/
while (out_num < NUM_OUT_NAME)
    { if(Out_name[out_num*NAMESIZE] == TILDE)	/*Check for Tilde.	*/
	{ get_output(out_num) ;
	return YES;
	}
    ++out_num;
    }
printf("I'm sorry but you have no more free output.\n");
return NO;
}
/**/
get_output(onum)
int	onum;
{
char	name[80], low_name[80];
int	min, max; 

/* Collect the NAME (string of CHAR) for this OUTPUT			*/
/* Check for Terminator string & return YES.				*/
strcpy(low_name, "");

printf("What is the NAME of this output? ");
printf("Output #%d > ",onum+1);
getline(name);		printf("\n");
if(strlen(name) == 0)
    return ;

strcpy(low_name, name);
low_name[NAMESIZE-1] = 0;	/* Truncate the name.			*/
strcpy(Out_name+(onum*NAMESIZE),low_name);
Kb_Dirty = YES;

/* Collect the UNITS (string of CHAR) for this OUTPUT			*/
printf("What UNITS(MPH, DegC, PPM, etc..) are used to describe it? ");
getline(name);		printf("\n");
strcpy(low_name, name);
low_name[NAMESIZE-1] = 0;	/* Truncate the name.			*/
strcpy(Out_units+(onum * UNITSIZE), low_name);
Kb_Dirty = YES;

/* 	Get the Min & Max value then compute the Scale Factor.		*/
GetMin:
printf("What is the MINIMUM value that this Output may assume? ");
getline(name);		printf("\n");

min = atoi(name);	/* Note WELL!! min may be NEGATIVE!!		*/
printf("What is the MAXIMUM value that this Output may assume? ");
getline(name);		printf("\n");

max = atoi(name);	/* Note WELL!! max may be NEGATIVE!!		*/
if(min >= max)
    { printf("I don't understand that range! MAX must be greater than MIN!\n");
    goto GetMin;
    }
Out_min[onum] = min;	Out_max[onum] = max;
Kb_Dirty = YES;
return NO;
}
/**/
spec_out_member()
{
char	name[20];
int	onum, funcnum;

printf("The current Knowledge Base is aware of the following OUTPUTS:\n");
show_outputs();
printf("\n");
printf("To which OUTPUT (number) would you like to add FUNCTION members? ");
getline(name);		printf("\n");
onum = atoi(name);

if(valid_out_range(onum) == NO)
    return ;

--onum;
More_out_members:
show_out_func(onum);
printf("\n");

Ques2:
printf("Do you wish to (A)dd FUNCTIONS, (D)elete FUNCTIONS, or (Q)uit? ");
getline(name);		printf("\n");
*name = toupper(*name);
if (*name == 'A')
    goto Add_out_Func;
else if (*name == 'D')
    goto Delete_out_Func;
else if (*name == 'Q')
    return ;
else
    goto Ques2;


Add_out_Func:
/* First check to see if there is a valid signal name!!!	*/
if(Out_name[onum*NAMESIZE] == TILDE)	/*Check for Tilde.	*/
    { printf("That is not a VALID Output!!\n");
    printf("You must give the OUTPUT a Name before adding Membership Functions.\n");
    return;
    }
for(funcnum=0; funcnum < NUM_OUT_FUNC; ++funcnum)
    { if(Out_func[((onum*NUM_OUT_FUNC)+funcnum)*FUNCSIZE] == TILDE)  
	{ get_out_function(funcnum, onum);
	goto More_out_members;		
	}
    }
printf("I'm sorry but you have no more free FUNCTIONS for this OUTPUT.\n");
return ;

Delete_out_Func:
printf("Which FUNCTION (number) would you like to delete? ");
getline(name);	printf("\n");
funcnum = atoi(name);
if( (funcnum < 1) || (funcnum > NUM_OUT_FUNC) )
    { printf("WHAT? Function Members are numbered 1 to %d!!??!!\n",NUM_OUT_FUNC);
    return ;
    }

--funcnum;
strcpy(Out_func+( (onum*NUM_OUT_FUNC)+funcnum)*FUNCSIZE,"~");
Kb_Dirty = YES;
goto More_out_members;		
}
/**/
get_out_function(func_num, out_num)
int	func_num, out_num;
{
char	low_name[80], name[80];

/* Collect the NAME (string of CHAR) for this FUNCTION.			*/
/* Check for Terminator string & return YES.				*/
strcpy(low_name, "");

printf("What is the NAME of this function? ");
printf("Function #%d > ",func_num+1);
getline(name);		printf("\n");
if(strlen(name) ==0)
    return;

strcpy(low_name, name);
low_name[NAMESIZE-1] = 0;	/* Truncate the name.			*/
strcpy(Out_func+( (out_num*NUM_OUT_FUNC)+func_num)*FUNCSIZE,low_name);
get_points(out_num, func_num, NUM_OUT_POINTS);
Kb_Dirty = YES;
return NO;
}
/**/
valid_out_range(num)
int	num;
{

if( (num < 1) || (num > NUM_OUT_NAME) )
    {
    printf("WHAT? Outputs are numbered 1 to %d!!??!!\n",NUM_OUT_NAME);
    return NO;
    }
else return YES;
}
