/*	File = RULES.C
	This file contains the RULES add, delete section.
	*/

#include	<ctype.h>
#include	<stdio.h>
#include	<string.h>
#include	"fuzzy.h"

spec_rules()
{
char	buf[132];

More_Rules:
printf("(A)dd RULES, (D)elete RULES, or (Q)uit ? ");
getline(buf);	printf("\n");
*buf = toupper(*buf);
if (*buf == 'A')
    { add_Rules(buf);
    goto More_Rules;
    }
else if (*buf == 'D')
    { delete_Rules();
    goto More_Rules;
    }
else
    return NO;


}

delete_Rules()
{
char	flag, buf[80];
int	i,
	rule_num,		/* Number of Rule to delete.	*/
	rule_start,		/* Index to first byte of Rule.	*/
	rule_stop,		/* Index to last byte of Rule.	*/
	last_rule,		/* Index to last byte of all Rules*/
	rule_count,		/* Count Rules from start.	*/
	line;			/* Line count for output.	*/

printf("What Rule (number) do you wish to delete? ");
getline(buf);	printf("\n");

rule_num = atoi(buf);
if(rule_num < 1)
    { printf("?? Rule numbers are positive integers beginning with 1. ??\n");
    return;
    }

rule_start = 0;		flag = OUTPUT;
rule_count = 0;
while(1)		/* Search for the rule desired.		*/
    {			/* A rule begins at the OUTPUT->INPUT transition.*/
    if(Rules[rule_start] < 128)
     	{			/* It's an input clause.	*/
	if(flag == OUTPUT)
	    {		 /* Beginning of a Rule!		*/
	    ++rule_count;
	    if( rule_num == rule_count)
		{		/* We have found it!!!			*/
		rule_stop = rule_start; /* Maintain index to 
							start of rule.	*/

		break;		/* to end of WHILE.			*/
		}
	    }
	flag = INPUT;
	}
    else if(Rules[rule_start] == 255)
	{		/* We have RUN OUT of Rules!			*/
	printf("I cannot find that Rule!\n");
	return;
	}
    else {		/* It's an output..Do nothing except mark it.	*/
	flag = OUTPUT;
	}
    ++rule_start;
    }

while(1)			/* And find the end of input clause	*/
    {				/* start of the output clause.		*/
    ++rule_stop;
    if(Rules[rule_stop] > 127)
	{			/* found the 1st (only??) output clause.*/
	break;
	}
    }
while(1)			/* And find the end of rule (really the	*/
    {				/* start of the NEXT rule (or FF)	*/
    ++rule_stop;
    if(Rules[rule_stop] < 128)
	break;
    if(Rules[rule_stop] == 255)
	break; 			/* found the END of all Rules.		*/
    }

--rule_stop;			/* Point to last output clause.		*/

printf("Rule #%d:\n",rule_num);
flag = NONE;		 line = 1;
for(i=rule_start; i <= rule_stop; ++i)
    { if( Rules[i] < 128)
	{ if(flag != INPUT)
	    { if( line > 16)
		{ line = 1;
		wait_key();
		}
	    }
	input_rule(Rules[i], &line, flag, NO, stdout);
	flag = INPUT;
	}
    else
	{ output_rule(Rules[i], &line, flag, NO, stdout);
	flag = OUTPUT;
	}
    }

Del_ask:
printf("\nAre you SURE you wish to delete this Rule (Y/N)? ");
getline(buf);		printf("\n");
*buf = toupper(*buf);
if(*buf == 'Y')
    { zap_rule(rule_start, rule_stop);
    return;
    }
else if(*buf == 'N')
    { printf("Rule #%d NOT deleted!\n",rule_num);
    return;
    }
else
    goto Del_ask;
    
}
/**/
zap_rule(start, stop)
int	start, stop;
{

++stop;				/* Point to start of NEXT rule.		*/
while(1)
    {				/* move FCBs up in the buffer by the	*/
    Rules[start++] = Rules[stop++];	/* number of bytes used by the	*/
    if(stop > MAX_RULE_SIZE)	/* rule to be deleted.			*/
 	break;
    }

while(1)
    { Rules[start++] = 255;	/* Put $FFs at the bottom of the buf	*/
    if(start > MAX_RULE_SIZE)	/* Bytes added are same as deleted.	*/
 	break;
    }
Kb_Dirty = YES;
}
/**/
add_Rules()
{
int	fcb[50],	/* Place to hold FCBs till rule is done.	*/
	fcb_ptr;	/* index to above.				*/
int	i, token;
int	larg, rarg;
char	buf[512];

printf("\n\nRULES have the following form:\n");
printf("          IF   in IS label1   THEN   out IS label2   (CR)\n\n");
printf(" in is an  INPUT name & label1 is a Membership FUNCTION of  in.\n");
printf("out is an OUTPUT name & label2 is a Membership FUNCTION of out.\n");
printf("'IF' and 'THEN' clauses may be joined with the keyword 'AND'.\n");

while(1)
    { fcb_ptr = 0;		/* Begin new line.			*/
    printf("\nEnter Rules now. (CR only to exit.)\n");
    getline(buf);
    if(strlen(buf) < 2)
	return;

    if(token=next_token(buf,NO) == -1)
	{ printf("Unrecognizable statement!\n");
	continue;
	}
    ucase(buf+token);
    if( strcmp(buf+token, "IF") != 0)
	{ printf("Unrecognized keyword!\n");
	continue;
	}
    else		/* An IF statement exists..Parse it.	*/
	{
Get_in_clause:
	if(find_inp(&larg, &rarg, buf) == NO)	
	    { printf("Unrecognized IF construction!\n");
	    continue;
	    }

/*	We have collected one IF clause. Now check the next token
	 to see if there is another INPUT clause or whether it's
	 time to look at output clause.
	*/
    	token=next_token(buf, YES);
	ucase(buf+token);
	if(strcmp(buf+token, "AND") == 0 )
	    { fcb[fcb_ptr++] = (8 * rarg) + larg;
	    goto Get_in_clause;
	    }
/**/	
/*	The THEN keyword found...Now read the Output clause(s).	*/
	else if(strcmp(buf+token, "THEN") == 0 )
	    { fcb[fcb_ptr++] = (8 * rarg) + larg;

Get_Out_clause:
	    if(find_outp(&larg, &rarg, buf) == NO)	
		{ printf("Unrecognized THEN construction!\n");
		continue;
		}
/*	We have collected one OUTPUT clause. Now check the next token
	 to see if there is another OUTPUT clause or whether it's
	 time to go to the next line.
	*/
	    token=next_token(buf, YES);
	    ucase(buf+token);
	    if(strcmp(buf+token, "AND") == 0 )
		{ fcb[fcb_ptr++] = (8 * larg) + rarg + 128;
		goto Get_Out_clause;
		}
	    else
		{ fcb[fcb_ptr++] = (8 * larg) + rarg + 128;

/*	Check to see that the number of Rules is within the predefined
	maximum size limit.
	*/
		if( (Rules_ptr + fcb_ptr) < MAX_RULE_SIZE )
		    { for(i = 0; i<fcb_ptr; ++i)
			Rules[Rules_ptr++] = fcb[i];
		    Kb_Dirty = YES;
		    }
		else {
		    printf("Maximum number of RULES reached!\n");
		    printf("RULE not saved!\n");
		    }

		continue;
		}
	    }
	else
	    { printf("No THEN or AND conjunction!\n");
	    continue;
	    }


	}
    }
}
/**/
find_inp(lnum, rnum, buf)
int	*lnum, *rnum;
char	*buf;
{
int	token, found, left, right, l, r;

if( (left=next_token(buf, YES)) == -1)
    { printf("Missing INPUT Name.\n");
    return NO;
    }
if( (token=next_token(buf, YES)) == -1)
    { printf("Missing IS token.\n");
    return NO;
    }
if( (right=next_token(buf, YES)) == -1)
    { printf("Missing INPUT Membership FUNCTION Name.\n");
    return NO;
    }
ucase(buf+token);
if( strcmp(buf+token, "IS") != 0)
    { printf("IS keyword not found.\n");
    return NO;
    }

found = NO;
for(l=0; l<NUM_IN_NAME; ++l)
    { if(strcmp(buf+left, In_Name+(l*NAMESIZE)) == 0)
	{ found = YES;
	break;
	}
    }
if (found == NO)
    { printf("INPUT name not Found!\n");
    return NO;
    }

found = NO;
for(r=0; r<NUM_IN_FUNC; ++r)
    { if(strcmp(buf+right, In_Func+( (l*NUM_IN_FUNC)+r)*FUNCSIZE) == 0)
	{ found = YES;
	break;
	}
     }

if (found == NO)
    { printf("Input MEMBERSHIP FUNCTION not Found!\n");
    return NO;
    }

*lnum = l;	*rnum = r;
return YES;
}
/**/
find_outp(lnum, rnum, buf)
int	*lnum, *rnum;
char	*buf;
{
int	token, found, left, right, l, r;

if( (left=next_token(buf, YES)) == -1)
    { printf("Missing OUTPUT Name.\n");
    return NO;
    }
if( (token=next_token(buf, YES)) == -1)
    { printf("Missing IS token.\n");
    return NO;
    }
if( (right=next_token(buf, YES)) == -1)
    { printf("Missing OUTPUT Membership FUNCTION Name.\n");
    return NO;
    }
ucase(buf+token);
if( strcmp(buf+token, "IS") != 0)
    { printf("IS keyword not found.\n");
    return NO;
    }

found = NO;
for(l=0; l<NUM_OUT_NAME; ++l)
    { 
    if(strncmp(buf+left, Out_name+(l*NAMESIZE),
			strlen(Out_name+(l*NAMESIZE))) == 0)
	{ found = YES;
	break;
	}
    }
if (found == NO)
    { printf("OUTPUT Name not Found!\n");
    return NO;
    }

found = NO;
for(r=0; r<NUM_OUT_FUNC; ++r)
    { if(strcmp(buf+right, Out_func+( (l*NUM_OUT_FUNC)+r)*FUNCSIZE) == 0)
	{ found = YES;
	break;
	}
     }

if (found == NO)
    { printf("Output FUNCTION MEMBERSHIP not Found!\n");
    return NO;
    }

*lnum = l;	*rnum = r;
return YES;
}
