/*-----------------------------------------------------------------------*
 * Greg Stevens                                                  6/24/93 *
 *                               nndisply.c                              *
 *                                             [file 4 in a series of 6] *
 *                                                                       *
 *  This file contains a series of functions for displaying different    *
 * values for nodes and weights in the network on the screen.            *
 *                                                                       *
 *  This file assumes the following declared in nnstruct:                *
 *                               NUMNODES[]  number nodes in each layer  *
 *                                                                       *
 *                                                                       *
 *-----------------------------------------------------------------------*/
#include "nnstruct.c"                 /* for access to net information   */
#include "stdio.h"                    /* for printf function             */

/* Function Display Layer displays layer Layer of net N formatted to width */
/* W, where W is a number of nodes.                                        */

/* prototype for function */
void DisplayLayer( NNETtype N, int Layer, int W );


/* function definition */
void DisplayLayer( NNETtype N, int Layer, int W )
{
   int u;                             /* looping variable for units      */


   if (Layer==0)                      /* tags which layer is outputted   */
     printf( " I:" );
   else if (Layer==(NUMLAYERS-1))
     printf( " O:" );
   else
     printf( "H%d:", Layer );


   for (u=0; (u<NUMNODES[Layer]); ++u)             /* show activations   */
     {
       printf( "%6.2f", N.unit[Layer][u].state );
       if (  (((u+1) % W)==0)  && ((u+1)!=NUMNODES[Layer])  )
         printf( "\n   " );
     }
}