#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include "bp.h"


CELL_RECORD cell[NUM_OF_ROWS][NUM_OF_COLS];
float inputs[NUM_OF_COLS];
float dOut[NUM_OF_COLS];

float random(void);
void calcIO(int iteration);
void updateCellFP(int r, int c);
void updateCellBP(int r, int c);
int main(void);


	//	Input is the iteration - there are four different combinations of output
void calcIO(int iteration)
{
	inputs[1] = ((iteration%2) == 1) ?  ONE : ZERO;
	inputs[2] = iteration%4 > 1 ?  ONE : ZERO;
	dOut[1] = inputs[1] >(float).5 && inputs[2] > (float).5 ? ONE : ZERO;
	dOut[2] = ((inputs[1] >(float).5 && !(inputs[2] > (float).5)) ||  
				(!(inputs[1] >(float).5) && inputs[2] > (float).5)) ? ONE : ZERO;
	return;
}


	// r - row, c - column
void updateCellFP(int r, int c)
{
	float sum;
	int j;

	sum = 0.;
	for (j=0; j < NUM_OF_COLS; ++j)
	{
		sum += cell[r][c].wght[j]*cell[r-1][j].out;
	}
	cell[r][c].out = (float)(1./(1+exp((double)-sum)));
	cell[r][c].err = (float)0.0;
	return;
}
	
void updateCellBP(int r, int c)
{
	int j;
	
	for (j=1; j < NUM_OF_COLS; ++j)
	{
		cell[r-1][j].err += 
			cell[r][c].err*cell[r][c].out*(1.-cell[r][c].out)*cell[r][c].wght[j];
	}
	for (j=0; j < NUM_OF_COLS; ++j)
	{
		cell[r][c].wght[j] += 
			RATE*cell[r][c].err*cell[r][c].out*(1-cell[r][c].out)*cell[r-1][j].out;
	}
	return;
}

int main()
{
	int i,j,k;
	int convItr, itr;
	float err;

	printf("\nIteration\tInputs\tdOut\tActualOutputs\n");

	itr = 0;
	convItr = 0;

	for (i=1; i<NUM_OF_ROWS; ++i)
	{
		for (j=1; j<NUM_OF_COLS; ++j)
		{
			for(k=0; k<NUM_OF_COLS; ++k)
			{
				cell[i][j].wght[k] = (float).2*((float)random()-(float).1);
			}
		}
	}

	for (i=0; i<NUM_OF_ROWS; ++i)
	{
		cell[i][0].out = ONE;
	}

	do 
	{
		calcIO(itr);
		for (j=1; j<NUM_OF_COLS; ++j)
			cell[0][j].out = inputs[j];

		for (i=1; i<NUM_OF_ROWS; ++i)
		{
			for (j=1; j<NUM_OF_COLS; ++j)
			{
				updateCellFP(i, j);
			}
		}

		for (j=1; j<NUM_OF_COLS; ++j)
		{
			cell[NUM_OF_ROWS-1][j].err = dOut[j]-cell[NUM_OF_ROWS-1][j].out;
		}

		for (i=NUM_OF_ROWS-1; i>0; --i)
		{
			for (j=1; j<NUM_OF_COLS; ++j)
			{
				updateCellBP(i, j);
			}
		}
		err = 0.0;
		for (j=1; j<NUM_OF_COLS; ++j)
		{
			err += cell[NUM_OF_ROWS-1][j].err*cell[NUM_OF_ROWS-1][j].err;
		}

		if (err < CRITERIA)
		{
			++convItr;
		}
		else 
		{
			convItr = 0;
		}

		if (itr % 100 < 4)
		{
			if (!(itr % 100))
			{
				for (j=1; j< NUM_OF_COLS; ++j)
				{
					printf("%d\t%.8f\t%.8f\t%.8f\n", 
						itr, inputs[j], dOut[j], cell[NUM_OF_ROWS-1][j].out);
				}
			}
		}
		itr +=1;
  }
  while (convItr != 4 && itr <= 32767);

  	if (convItr != 4)
		printf("problemas");
	else
	{
		printf("success!!!");
		for (i=0; i<NUM_OF_COLS; ++i)
		{
			for (j=0; j<NUM_OF_COLS; ++j)
			{
				printf("%d:%d\to=%.6f\te=%.6f\n", i,j,
					cell[i][j].out,cell[i][j].err);

				for (k=0; k<NUM_OF_COLS; ++k)
					printf("w=%.6f\t", cell[i][j].wght[k]);
				printf("\n");
			}
			printf("%d:\ti=%.6f\tdout=%.6f\n",i,inputs[i], dOut[i]);
		}
	}
	return 1;
}


	// return a random # between 0 and 1
float random()
{
	return(float)((float)rand()/(float)32767);
}

