10 CLS:PRINT  "** TARGDAT.BAS - COPYRIGHT 1987 BY WM. C. DAVIS, JR. **":PRINT "":REM REV 04/27/87
20 PRINT "THIS PROGRAM ACCEPTS INPUT OF X,Y-COORDINATES OF SHOTS ON THE TARGET,  MEASURED"
30 PRINT "FROM VERTICAL AND HORIZONTAL AXES. IT IS CONVENIENT (BUT NOT NECESSARY) TO DRAW"
40 PRINT "THE HORIZONTAL (X) AXIS THROUGH THE CENTER OF THE LOWEST SHOT, AND THE VERTICAL"
50 PRINT "(Y) AXIS THROUGH THE LEFT-MOST SHOT. THE NUMBER OF SHOTS PER TARGET MUST BE"
60 PRINT "AT LEAST THREE. THE PROGRAM WILL COMPUTE THE LINEAR STANDARD DEVIATIONS IN"
70 PRINT"BOTH HORIZONTAL AND VERTICAL DIRECTIONS, THE RADIAL STANDARD DEVIATION, THE"
80 PRINT "MEAN RADIUS, THE EXTREME SPREAD, AND THE CENTER OF IMPACT. IT WILL COMPUTE"
90 PRINT "UNBIASED ESTIMATES OF THE POPULATION STANDARD DEVIATIONS (LINEAR AND RADIAL).":PRINT ""
100 INPUT "NAME OR NUMBER FOR THIS TARGET";T$:PRINT ""
110 INPUT "HOW MANY SHOTS PER TARGET";NR
120 IF NR<3 THEN PRINT "MUST BE AT LEAST 3 SHOTS PER TARGET.":GOTO 110
130 DIM X(NR):DIM Y(NR):DIM R(NR)
140 FOR N=1 TO NR
150 PRINT "X";N;:INPUT X(N)
160 PRINT "Y";N;:INPUT Y(N):PRINT ""
170 NEXT N
180 FOR N=1 TO NR
190 SUMX=SUMX+X(N):SUMY=SUMY+Y(N)
200 SUMXQ=SUMXQ+X(N)^2:SUMYQ=SUMYQ+Y(N)^2
210 NEXT N
220 XB=SUMX/NR:YB=SUMY/NR
230 FOR N=1 TO NR
240 R(N)=SQR((X(N)-XB)^2+(Y(N)-YB)^2)
250 SUMR=SUMR+R(N)
260 NEXT N
270 MR=SUMR/NR:REM MEAN RADIUS
280 SX=SQR(SUMXQ/NR-(SUMX/NR)^2):REM LINEAR SD IN X
290 SY=SQR(SUMYQ/NR-(SUMY/NR)^2):REM LINEAR SD IN Y
300 RSD=SQR(SX^2+SY^2):REM RADIAL STANDARD DEVIATION
310 IF NR<6 THEN SR=1.028-.925/NR:GOTO 340
320 IF NR=>6 AND NR<21 THEN SR=1.009-.87/NR:GOTO 340
330 IF NR=>21 THEN C=SQR(NR/(NR-1)):GOTO 350
340 C=1/SR: REM RATIO (POPULATION SD)/(SAMPLE SD) - SEE GRUBBS
350 PSX=SX*C:PSY=SY*C:REM UNBIASED ESTIMATES POPULATION LSD IN X & Y
360 PRSD=SQR(PSX^2+PSY^2):REM UNBIASED ESTIMATE POPULATION RSD
370 ES=0:REM INTITIALIZE EXTREME SPREAD
380 FOR A=1 TO (NR-1)
390 FOR B=2 TO NR
400 S=SQR((X(A)-X(B))^2+(Y(A)-Y(B))^2):REM DIST BETWEEN A PAIR OF SHOTS
410 IF S>ES THEN ES=S:REM SORT FOR MAX
420 NEXT B
430 NEXT A
440 CLS
450 PRINT T$:PRINT ""
460 PRINT "X,Y-COORDINATES OF SHOTS:"
470 FOR N=1 TO NR:PRINT X(N);Y(N),:NEXT N: PRINT ""
480 PRINT "THE COORDINATES OF THE CENTER OF IMPACT ARE: X(CI)=";:PRINT USING "##.###";XB;
490 PRINT "   Y(CI)=";:PRINT USING "##.###";YB:PRINT ""
500 PRINT "LINEAR STANDARD DEVIATIONS OF GROUP:"TAB(40); "LSD(X)=";:PRINT USING "##.###";SX;
510 PRINT TAB(60);"LSD(Y)=";:PRINT USING "##.###";SY
520 PRINT "RADIAL STANDARD DEVIATION OF GROUP:";TAB(40);:PRINT USING "##.###";RSD
530 PRINT "MEAN RADIUS OF GROUP:";TAB(40);:PRINT USING "##.###";MR
540 PRINT "EXTREME SPREAD OF GROUP:";TAB(40);:PRINT USING "##.###";ES:PRINT ""
550 PRINT "ESTIMATES OF POPULATION STATISTICS:"
560 PRINT TAB(10);"PLSD(X)=";:PRINT USING "##.###";PSX;
570 PRINT TAB(30);"PLSD(Y)=";:PRINT USING "##.###";PSY;
580 PRINT TAB(50);"PRSD=";:PRINT USING "##.###";PRSD:PRINT ""
590 INPUT "COPY THIS (1=YES 2=NO)";QC
600 IF QC<>1 THEN GOTO 750
610 LPRINT T$:LPRINT ""
620 LPRINT "X,Y-COORDINATES OF SHOTS:"
630 FOR N=1 TO NR:LPRINT X(N);Y(N),:NEXT N:LPRINT ""
640 LPRINT "COORDINATES OF THE CENTER OF IMPACT:";TAB(40);"XCI=";:LPRINT USING "##.###";XB;
650 LPRINT TAB(60);"YCI=";:LPRINT USING "##.###";YB:LPRINT ""
660 LPRINT "LINEAR STANDARD DEVIATIONS OF GROUP:";TAB(40);"LSD(X)=";:LPRINT USING "##.###";SX;
670 LPRINT TAB(60);"LSD(Y)=";:LPRINT USING "##.###";SY
680 LPRINT "RADIAL STANDARD DEVIATION OF GROUP:";:LPRINT TAB(40);"RSD=";:LPRINT USING "##.###";RSD
690 LPRINT "MEAN RADIUS OF GROUP:";:LPRINT TAB(40);"MR=";:LPRINT USING "##.###";MR
700 LPRINT "EXTREME SPREAD OF GROUP:";:LPRINT TAB(40);"ES=";:LPRINT USING "##.###";ES:LPRINT ""
710 LPRINT "ESTIMATES OF POPULATION STATISTICS:"
720 LPRINT TAB(10);"PLSD(X)=";:LPRINT USING "##.###";PSX;
730 LPRINT TAB(30);"PLSD(Y)=";:LPRINT USING "##.###";PSY;
740 LPRINT TAB(50);"PRSD=";:LPRINT USING "##.###";PRSD:LPRINT ""
750 INPUT "WHAT NEXT (1=ANOTHER RUN 2=END PROGRAM)";QN
760 IF QN=1 THEN ERASE X,Y,R:CLS:RUN 100
770 CLEAR:CLS:RUN "MENU.BAS"
780 END

