10 CLS:KEY OFF:PRINT TAB(11)"*** TESTING FOR 'FLYERS' IN A GROUP ***":PRINT" ":REM ** CODE'TFLYER' **
20 PRINT TAB(9)" *** COPYRIGHT 1983 BY WM. C. DAVIS,JR. ***":PRINT" ":REM - REV 03/28/86, 05/08/88
30 PRINT "THIS PROGRAM ASSUMES THAT YOU HAVE ONE GROUP IN A SERIES WHICH CONTAINS A SHOT"
40 PRINT "THAT YOU SUSPECT IS A 'FLYER'. THE PROGRAM TESTS TO DETERMINE WHETHER THE"
50 PRINT "SUSPECT SHOT SHOULD BE REJECTED STATISTICALLY AS A TRUE 'FLYER', OR IS MERELY"
60 PRINT "ONE OF THE POORER SHOTS THAT MUST BE STATISTICALLY EXPECTED WITH THIS GUN AND"
70 PRINT "LOAD. THE CRITERION FOR REJECTING THE SUSPECT SHOT AS A 'FLYER' IS THAT THE"
80 PRINT "SUSPECT SHOT ALONE, ENLARGES THE GROUP IN WHICH IT OCCURS, SO THAT THE GROUP IS"
90 PRINT "MADE LARGER THAN 95 PERCENT OF THE GROUPS STATISTICALLY EXPECTED ON THE BASIS"
100 PRINT "OF ALL THE REMAINING SHOTS IN THE SERIES. IF THE SHOT IS REJECTED, THE PROGRAM"
110 PRINT "WILL STATISTICALLY ADJUST THE EXTREME SPREAD OF THE GROUP IN WHICH IT OCCURRED,"
120 PRINT "SO THAT THE ADJUSTED EXTREME SPREAD CAN PROPERLY BE INCLUDED IN YOUR AVERAGE,"
130 PRINT "IF YOU CANNOT REFIRE THE GROUP IN WHICH THE SUSPECT SHOT OCCURRED.":PRINT ""
140 PRINT "YOU MAY EITHER REFIRE THE SUSPECT GROUP, OR USE THE STATISTICALLY ADJUSTED"
150 PRINT "GROUP, BUT IT IS INVALID TO DISREGARD THE 'FLYER' IN COMPUTING YOUR AVERAGE.":PRINT ""
160 PRINT "YOU MUST HAVE AT LEAST THREE GROUPS, AND A TOTAL OF AT LEAST 15 SHOTS, TO"
170 PRINT "PROVIDE A REASONABLE BASIS FOR IDENTIFYING A 'FLYER'.":PRINT ""
180 INPUT"NUMBER OF SHOTS PER GROUP";P
190 IF P<3 THEN PRINT "YOU MUST HAVE AT LEAST THREE SHOTS IN EACH GROUP.":PRINT "":GOTO 180
200 INPUT"NUMBER OF GROUPS FIRED ";N:PRINT" "
210 TOT=P*N
220 IF N<3 OR TOT<15 THEN PRINT "":GOTO 160
230 INPUT "WHAT TITLE ON THE PRINTOUT OF THIS ANALYSIS";T$
240 PRINT "ENTER THE EXTREME SPREAD OF THE GROUP CONTAINING THE SUSPECT SHOT,"
250 PRINT "WITH THE SUSPECT SHOT INCLUDED";:INPUT SN:PRINT ""
260 PRINT "ENTER THE EXTREME SPREAD OF THE GROUP CONTAINING THE SUSPECT SHOT,"
270 PRINT "WITH THE SUSPECT SHOT EXCLUDED";:INPUT SX:PRINT ""
280 GOSUB 600:REM ADJUST SUSPECT GROUP OF (P-1) SHOTS TO EXPECTED SPREAD FOR P SHOTS, FIND ADJUSTED MEAN INCLUDING THIS GROUP
290 CV=.11+.812/P:REM COEFFICIENT OF VARIATION FOR P-SHOT GROUPS
300 SD=CV*MA:REM EXPECTED SD OF EXTREME SPREADS
310 GOSUB 760:REM FIND'TN' FOR .05 LEVEL FROM TABLE OF EXTREME STUDENTIZED DEVIATE TABLE
320 TX=(SN-MA)/SD:REM TEST'T'
330 IF TX<TN THEN PRINT "THE SUSPECT SHOT CANNOT BE REJECTED AS A 'FLYER' WITH 95 PERCENT CONFIDENCE.":PRINT ""
340 IF TX=>TN THEN GOTO 430
350 SS=0:REM INITIALIZE ACCUMULATOR
360 FOR K=1 TO (N-1)
370 SS=SS+S(K)
380 NEXT K
390 SS=SS+SN
400 MA=SS/N
410 PRINT "THE AVERAGE IS: ";:PRINT USING "##.###";MA:PRINT ""
420 GOTO 540
430 IF TX=>TN THEN PRINT "THE SUSPECT SHOT CAN BE REJECTIED AS A TRUE 'FLYER' WITH 95 PERCENT CONFIDENCE."
440 PRINT "IF THE GROUP CONTAINING THE 'FLYER' CANNOT BE REFIRED, YOU MAY USE THE ADJUSTED"
450 PRINT "EXTREME SPREAD FOR THAT GROUP.":PRINT ""
460 IF TX=>TN THEN PRINT"THE ADJUSTED EXTREME SPREAD FOR THE SUSPECT GROUP IS: ";:PRINT USING "##.###";SA:PRINT ""
470 SS=0:REM INITIALIZE ACCUMULATOR
480 FOR K=1 TO (N-1)
490 SS=SS+S(K)
500 NEXT K
510 SS=SS+SA
520 MA=SS/N
530 PRINT "THE ADJUSTED AVERAGE IS: ";:PRINT USING "##.###";MA:PRINT ""
540 INPUT"DO YOU WANT HARD COPY OF THIS ANALYSIS (1=YES 2=NO)";QP
550 IF QP=1 THEN GOSUB 790
560 PRINT "WHAT NEXT?":PRINT "   1=ANOTHER ANALYSIS":PRINT "   2=END THIS PROGRAM"
570 INPUT QN
580 IF QN=1 THEN CLS:RUN 180
590 RUN "MENU.BAS":END
600 REM *** ROUTINE TO FIND ADJUSTED AVERAGE EXTREME SPREAD AND ADJUSTED EXTREME SPREAD FOR GROUP HAVING SUSPECT SHOT ***
610 PRINT "ENTER THE EXTREME SPREAD OF EACH GROUP EXCEPT THAT ONE WHICH CONTAINS THE":PRINT "SUSPECT SHOT.":PRINT ""
620 FOR K=1 TO (N-1)
630 PRINT"NUMBER ";K;
640 INPUT S(K)
650 NEXT K
660 REM ** NEXT THREE LINES ADJUST SPREAD OF SUSPECT GROUP FOR REDUCED SAMPLE SIZE **
670 RT=1.2777+1.07458*LOG(P)
680 RP=1.2777+1.07458*LOG(P-1)
690 SA=SX*RT/RP:REM SUSPECT GROUP, EXCLUDING SUSPECT SHOT, CORRECTED FOR (P-1) SHOTS
700 S(N)=SA
710 FOR K=1 TO N
720 SS=SS+S(K)
730 NEXT K
740 MA=SS/N:REM ADJUSTED MEAN OF ALL GROUPS, EXCLUDING SUSPECT SHOT
750 RETURN
760 REM *** FIND 'TN' FOR .05 LEVEL IN TABLE OF EXTREME STUDENTIZED DEVIATE VALUES, SD ASSUMED KNOWN ***
770 TN=.862+.3887*N-.035*N^2+.00118*N^3
780 RETURN
790 REM *** ROUTINE TO LPRINT RESULTS ***
800 LPRINT TAB(5);T$:LPRINT ""
810 LPRINT TAB(5);"THE ";N;"GROUPS OF ";P;"SHOTS EACH IN THIS SERIES, EXCLUDING THE SUSPECT GROUP:":LPRINT" "
820 SP=5
830 FOR K=1 TO (N-1)
840 LPRINT TAB(SP);:LPRINT USING "##.###";S(K);
850 SP=SP+8
860 NEXT K
870 LPRINT" ":LPRINT" "
880 LPRINT TAB(5);"THE EXTREME SPREAD OF THE SUSPECT GROUP INCLUDING THE SUSPECT SHOT: ";:LPRINT USING "##.###";SN
890 LPRINT TAB(5);"THE EXTREME SPREAD OF THE ";(P-1);"-SHOT GROUP EXCLUDING THE SUSPECT SHOT:";:LPRINT USING "##.###";SX:LPRINT" "
900 IF TX>TN THEN GOSUB 930:REM REJECT CRITERION MET
910 IF TX<=TN THEN GOSUB 1070:REM REJECT CRITERION NOT MET
920 RETURN
930 LPRINT TAB(5);"THE SUSPECT SHOT CAN BE REJECTED AS A 'FLYER' WITH 95-PERCENT CONFIDENCE."
940 LPRINT TAB(5);"IF THE GROUP CONTAINING THE 'FLYER' CANNOT BE REFIRED, YOU MAY USE"
950 LPRINT TAB(5);"THE ADJUSTED GROUP SIZE FOR THAT GROUP.":LPRINT ""
960 LPRINT TAB(5);"THE ADJUSTED EXTREME SPREAD FOR THE GROUP"
970 LPRINT TAB(5);"CONTAINING THE 'FLYER' IS:";:LPRINT USING "##.###";SA:LPRINT ""
980 LPRINT TAB(5);"THE GROUPS IN THE SERIES, INCLUDING THE ADJUSTED GROUP:":LPRINT" "
990 SP=5
1000 FOR K=1 TO N
1010 LPRINT TAB(SP);:LPRINT USING "##.###";S(K);
1020 SP=SP+8
1030 NEXT K
1040 LPRINT" ":LPRINT" "
1050 LPRINT TAB(5);"THE AVERAGE EXTREME SPREAD FOR THE SERIES IS: ";:LPRINT USING "##.###";MA:LPRINT" "
1060 RETURN
1070 LPRINT TAB(5);"THE SUSPECT SHOT CANNOT BE REJECTED AS A 'FLYER' WITH 95-PERCENT CONFIDENCE.":LPRINT" "
1080 S(N)=SN
1090 LPRINT"THE GROUPS IN THE SERIES ARE:":LPRINT" "
1100 SP=5
1110 FOR K=1 TO N
1120 LPRINT TAB(SP);:LPRINT USING "##.###";S(K);
1130 SP=SP+6
1140 NEXT K
1150 LPRINT" ":LPRINT" "
1160 SS=0: REM INITIALIZE ACCUMULATOR
1170 FOR K=1 TO N
1180 SS=SS+S(K)
1190 NEXT K
1200 MA=SS/N
1210 LPRINT TAB(10);"THE AVERAGE EXTREME SPREAD FOR THE SERIES IS: ";:LPRINT USING "##.###";MA:LPRINT" "
1220 RETURN

