10 CLS: PRINT "THIS PROGRAM CALCULATES TRAJECTORY DATA FOR SPHERICAL OR SPHEROIDAL PROJECTILES."
20 PRINT "THE DRAG DATA ARE BASED ON WORK DONE UNDER AUSPICES OF THE U. S. DEPARTMENT OF"
30 PRINT "ENERGY BY DONALD G. MILLER, DESCRIBED IN UCRL REPORT 52755 DATED 01/31/79.":PRINT ""
40 PRINT "THE MEASUREMENTS ON WHICH THE DRAG DATA ARE BASED WERE MADE WITH SPHERICAL"
50 PRINT "PROJECTILES FROM .30 INCH TO 1.00 INCH IN DIAMETER. ACCURACY OF THE PROGRAM FOR"
60 PRINT "SPHERES MUCH SMALLER THAN #1 BUCKSHOT HAS NOT BEEN CONFIRMED. THE RETARDATION"
70 PRINT "OF THE INDIVIDUAL PELLETS IN A SHOT CHARGE FIRED FROM A SHOTGUN IS AFFECTED AT"
80 PRINT "CLOSE RANGES BY FACTORS THAT ARE NOT ACCURATELY PREDICTABLE, AND THIS PROGRAM"
90 PRINT "CAN GIVE ONLY APPROXIMATE RESULTS UNDER THOSE CONDITIONS.":PRINT ""
100 PRINT "THIS PROGRAM WRITTEN BY WM. C. DAVIS, JR. - 12/31/80, REV 04/13/86, 04/04/88, 10/17/88":PRINT "":PRINT ""
110 REM ** COPYRIGHT 1986 BY WM. C. DAVIS, JR. - CODE 'TRABALL' **
120 PRINT "WHAT ATMOSPHERIC CONDITIONS FOR YOUR CALCULATIONS?":PRINT "  1=STANDARD METRO (59 DEG-F AT SEA LEVEL)":PRINT "  2=ANOTHER TEMPERATURE AND/OR ALTITUDE"
130 INPUT QA:PRINT ""
140 IF QA=2 THEN GOSUB 2370 ELSE RO=1:AL=0:TF=59:A=1
150 INPUT "HEIGHT OF SIGHT ABOVE BORE (INS)";H
160 INPUT "NAME THE PROJECTILE";C$
170 INPUT "PROJECTILE DIAMETER (INCH)";DIA
180 PRINT "IS IT A SOFT LEAD BALL? (1=YES  2=NO)":INPUT QLB
190 IF QLB=1 THEN G=1334.5*DIA^3:GOTO 210
200 INPUT "PROJECTILE WEIGHT (GRS)";G
210 CX=G/(7000*DIA^2):REM BALLISTIC COEFF REF SPHERE DRAG LAW
220 INPUT "MUZZLE VELOCITY (FPS)";V:VA=V/A:REM ADJ F/SONIC VEL
230 X=0:GOSUB 320: REM INITIALIZE RANGE, FIND DATA FOR MUZZLE VELOCITY
240 PRINT "WHAT IS YOUR CHOICE?"
250 PRINT "   1=RANGE TABLE"
260 INPUT "   2=BULLET PATH FROM SIGHT LINE";QB
270 IF QB<>1 AND QB<>2 THEN PRINT "TRY AGAIN":GOTO 240
280 IF QB=1 THEN GOTO 500
290 IF QB=2 THEN GOTO 1230
300 PRINT " "
310 GOTO 240
320 REM ** FIND SVA,TVA,SUA, TRAJECTORY ELEMENTS **
330 UA=VA:GOSUB 2480: REM GO FIND FOR V/A :KA,KB,CS,CT,SVA,TVA
340 SVA=SUA:TVA=TUA:REM TAG VALUES FOR MUZZLE VELOCITY
350 SUA=SVA+RO*X/CX
360 GOSUB 2590: REM GO FIND UA AS F(SUA)
370 GOSUB 2480:REM GO GET NEW VALUES FOR KA,KB,CS,CT,SUA,TUA
380 U=UA*A
390 EN=U^2*G/450400!: REM ENERGY
400 F=14.0069+6.59285*((U/V)-.65)-1.94051*((U/V)-.65)^2
410 T=(CX/(RO*A))*(TUA-TVA)
420 D=12*F*T^2: REM DROP
430 YM=48.6*T^2: REM MAX ORDINATE
440 HM=YM-.4*H: REM MAX HEIGHT ABOVE SIGHT LINE
450 DF=176*(T-X/V): REM WIND DEFLECTION FOR 10MPH CROSS-COMPONENT
460 MM=2*(EN/U): REM MOMENTUM, LB-SEC
470 IF X=0 THEN E=0 ELSE E=(D+H)/(X/300): REM ELEVATION MOA
480 RETURN
490 REM ** DO RANGE TABLE **
500 INPUT "CHOOSE: (1=YARDS 2=METERS)";QM
510 IF QM<>1 AND QM<>2 THEN PRINT "TRY AGAIN":GOTO 500
520 IF QM=2 THEN INPUT "FIRST RANGE FOR TABLE (METERS)";FM:FX=3.2808*FM
530 IF QM=2 THEN INPUT "LAST RANGE FOR TABLE (METERS)";LM:LX=3.2808*LM
540 IF QM=2 THEN INPUT "RANGE INCREMENT (METERS)";IM:IX=3.2808*IM
550 IF QM=2 AND IM>(LM-FM) THEN PRINT "TRY AGAIN!":GOTO 520
560 IF QM=2 THEN GOTO 630
570 INPUT "FIRST RANGE FOR TABLE (YDS)";FR:FX=3*FR
580 INPUT "LAST RANGE FOR TABLE (YDS)";LR:LX=3*LR
590 INPUT "RANGE INCREMENT (YDS)";IR:IX=3*IR
600 IF IR>(LR-FR) THEN PRINT "TRY AGAIN!":GOTO 570
610 PRINT "":PRINT "ONE MOMENT PLEASE! COMPUTING TABLE."
620 Z=INT((LR-FR)/IR): REM DIMENSION FOR ARRAY
630 IF QM=2 THEN Z=INT((LM-FM)/IM+5): REM DIMENSION FOR ARRAY
640 DIM X(Z):DIM E(Z):DIM V(Z):DIM U(Z):DIM SV(Z):DIM SU(Z):DIM TV(Z):DIM TU(Z):DIM EN(Z):DIM F(Z):DIM T(Z):DIM D(Z):DIM YM(Z):DIM HM(Z):DIM DF(Z):DIM MM(Z): REM DIMENSION ARRAYS FOR RANGE TABLE
650 X=FX:N=0: REM INITIALIZE X,N
660 GOSUB 320: REM FIND DATA FOR NTH RANGE
670 X(N)=X:V(N)=V:U(N)=U:EN(N)=EN:T(N)=T:D(N)=D:YM(N)=YM:HM(N)=HM:DF(N)=DF:MM(N)=MM:E(N)=E: REM SAVE VALUES THIS PASS
680 IF X(N)=0 THEN YM(N)=0:HM(N)=-H
690 N=N+1:X=FX+N*IX: REM INCREMENT N AND X
700 IF X>(LX+1) THEN GOTO 720: REM BREAKOUT CONDITION
710 GOTO 660: REM NEXT LOOP
720 NF=N:REM END VALUE ON COUNTER
730 CLS
740 IF QA=1 THEN PRINT "CARTRIDGE: ";C$;TAB(48);"STANDARD METRO":GOTO 770
750 PRINT "CARTRIDGE IDENTIFICATION:";C$
760 PRINT "ALTITUDE (FT):";AL;TAB(48);"TEMPERATURE (DEG-F):";TF
770 PRINT "BULLET WEIGHT (GRS):";:PRINT USING "####.#";G;:PRINT TAB(48);"SIGHT ABOVE BORE (IN):";H
780 PRINT "MUZZLE VELOCITY (FPS):";V;TAB(48);"BALLISTIC COEFF:";:PRINT USING ".####";CX:PRINT ""
790 PRINT "RANGE";TAB(8);"REM.";TAB(16);"REM.";TAB(24);"MOM-";TAB(32);"DROP";TAB(40);"ELEV-";TAB(48);"TIME OF";TAB(56);"MAX.";TAB(64);"MAX.";TAB(72);"10MPH"
800 IF QM=1 THEN PRINT "YARDS";
810 IF QM=2 THEN PRINT "METERS";
820 PRINT TAB(8);"VELOC.";TAB(16);"ENERGY";TAB(24);"ENTUM";TAB(32);"INCHES";TAB(40);"ATION";TAB(48);"FLIGHT";TAB(56);"ORD";TAB(64);"HIGH";TAB(72);"WIND"
830 PRINT TAB(8);"FPS";TAB(16);"FT-LBS";TAB(24);"LB-SECS";TAB(40);"MOA";TAB(48);"SEC";TAB(56);"INCHES";TAB(64);"INCHES";TAB(72);"INCHES"
840 FOR N=0 TO (NF-1)
850 IF QM=1 THEN PRINT USING "####";X(N)/3;
860 IF QM=2 THEN PRINT USING "####";X(N)/3.2808;
870 PRINT TAB(8);:PRINT USING "####";U(N);
880 PRINT TAB(16);:PRINT USING "####";EN(N);
890 PRINT TAB(24);:PRINT USING "#.##";MM(N);
900 PRINT TAB(32);:PRINT USING "###.#";D(N);
910 PRINT TAB(40);:PRINT USING "##.#";E(N);
920 PRINT TAB(48);:PRINT USING "#.###";T(N);
930 PRINT TAB(56);:PRINT USING "###.#";YM(N);
940 PRINT TAB(64);:PRINT USING "###.#";HM(N);
950 PRINT TAB(72);:PRINT USING "###.##";DF(N)
960 NEXT N
970 INPUT "COPY TABLE? (1=YES 2=NO)";QP
980 IF QP<>1 THEN CLS: GOTO 2150
990 IF QA=1 THEN LPRINT "CARTRIDGE: ";C$;TAB(48);"STANDARD METRO":GOTO 1020
1000 LPRINT "CARTRIDGE IDENTIFICATION:";C$
1010 LPRINT "ALTITUDE (FT): ";AL;TAB(48);"TEMPERATURE (DEG-F):";TF
1020 LPRINT "BULLET WEIGHT (GRS):";:LPRINT USING "####.#";G;:LPRINT TAB(48);"SIGHT ABOVE BORE (IN):";H
1030 LPRINT "MUZZLE VELOCITY:";V;TAB(48);"BALLISTIC COEFF:";:LPRINT USING ".####";CX:LPRINT ""
1040 LPRINT "RANGE";TAB(8);"REM.";TAB(16);"REM.";TAB(24);"MOM-";TAB(32);"DROP";TAB(40);"ELEV-";TAB(48);"TIME OF";TAB(56);"MAX.";TAB(64);"MAX.";TAB(72);"10MPH"
1050 IF QM=1 THEN LPRINT "YARDS";
1060 IF QM=2 THEN LPRINT "METERS";
1070 LPRINT TAB(8);"VELOC.";TAB(16);"ENERGY";TAB(24);"ENTUM";TAB(32);"INCHES";TAB(40);"ATION";TAB(48);"FLIGHT";TAB(56);"ORD";TAB(64);"HIGH";TAB(72);"WIND"
1080 LPRINT TAB(8);"FPS";TAB(16);"FT-LBS";TAB(24);"LB-SECS";TAB(40);"MOA";TAB(48);"SEC";TAB(56);"INCHES";TAB(64);"INCHES";TAB(72);"INCHES"
1090 FOR N=0 TO (NF-1)
1100 IF QM=1 THEN LPRINT USING "####";X(N)/3;
1110 IF QM=2 THEN LPRINT USING "####";X(N)/3.2808;
1120 LPRINT TAB(8);:LPRINT USING "####";U(N);
1130 LPRINT TAB(16);:LPRINT USING "####";EN(N);
1140 LPRINT TAB(24);:LPRINT USING "#.##";MM(N);
1150 LPRINT TAB(32);:LPRINT USING "###.#";D(N);
1160 LPRINT TAB(40);:LPRINT USING "##.#";E(N);
1170 LPRINT TAB(48);:LPRINT USING "#.###";T(N);
1180 LPRINT TAB(56);:LPRINT USING "###.#";YM(N);
1190 LPRINT TAB(64);:LPRINT USING "###.#";HM(N);
1200 LPRINT TAB(72);:LPRINT USING "###.##";DF(N)
1210 NEXT N
1220 LPRINT " ":CLS: GOTO 2150
1230 REM ** ROUTINE FOR BULLET PATH FROM SIGHT LINE **
1240 INPUT "CHOOSE: (1=YARDS 2=METERS)";QM
1250 IF QM<>1 AND QM<>2 THEN PRINT "TRY AGAIN":GOTO 1240
1260 IF QM=1 THEN INPUT "YOUR SIGHT-IN RANGE (YDS)";ZR:ZX=3*ZR
1270 IF QM=2 THEN INPUT "YOUR SIGHT-IN RANGE (METERS)";ZM:ZX=3.2808*ZM
1280 X=ZX: GOSUB 320: REM GET DATA FOR ZEROING RANGE
1290 ZE=E: REM TAG ZEROING ELEVATION
1300 PRINT "CHOOSE:"
1310 PRINT "   1=IMPACT AT ONE RANGE"
1320 INPUT "   2=TABULAR DATA";QG
1330 IF QG=2 THEN GOTO 1620
1340 IF QM=1 THEN INPUT "WHAT RANGE (YDS)";NR:NX=3*NR
1350 IF QM=2 THEN INPUT "WHAT RANGE (METERS)";NM:NX=3.2808*NM
1360 X=NX:GOSUB 320
1370 NE=E:DE=NE-ZE
1380 DI=-DE*(NX/300): REM DIFF IN INCHES
1390 PRINT " ":PRINT " "
1400 IF QM=1 THEN PRINT "SIGHT-IN RANGE (YDS):";TAB(30);ZR:PRINT " "
1410 IF QM=2 THEN PRINT "SIGHT-IN RANGE (METERS):";TAB(30);ZM:PRINT " "
1420 IF QM=1 THEN PRINT "OTHER RANGE (YDS):";TAB(30);NR:PRINT " "
1430 IF QM=2 THEN PRINT "OTHER RANGE (METERS):";TAB(30);NM:PRINT " "
1440 PRINT "POINT OF IMPACT (INCHES):";TAB(30);:PRINT USING "###.#";DI:PRINT ""
1450 PRINT "SIGHT ADJUSTMENT (MOA):";TAB(30);:PRINT USING "###.#";DE:PRINT ""
1460 PRINT " "
1470 INPUT "COPY THIS (1=YES 2=NO)";QC
1480 IF QC<>1 THEN GOTO 1540
1490 IF QM=1 THEN LPRINT "SIGHT-IN RANGE (YDS)";ZR;TAB(30);"OTHER RANGE (YDS)";NR:LPRINT " "
1500 IF QM=2 THEN LPRINT "SIGHT-IN RANGE (METERS)";ZM;TAB(30);"OTHER RANGE (METERS)";NM:LPRINT " "
1510 LPRINT "IMPACT POINT (INCHES):";:LPRINT USING "###.#";DI;
1520 LPRINT TAB(30);"SIGHT ADJUST (MOA):";:LPRINT USING "###.#";DE
1530 LPRINT " "
1540 PRINT "WHAT NEXT?"
1550 PRINT "   1=ANOTHER RANGE"
1560 PRINT "   2=NEW SIGHT-IN RANGE"
1570 INPUT "   3=MORE CHOICES";QH
1580 IF QH=1 THEN GOTO 1340
1590 IF QH=2 THEN GOTO 1240
1600 IF QH=3 THEN CLS:GOTO 240
1610 IF QH<>1 AND QH<>2 AND QH<>3 THEN PRINT "TRY AGAIN":GOTO 1540
1620 REM ** BULLET-PATH TABLE **
1630 IF QM=1 THEN INPUT "FIRST RANGE FOR TABLE (YDS)";FR:FX=3*FR
1640 IF QM=2 THEN INPUT "FIRST RANGE FOR TABLE (METERS)";FM:FX=3.2808*FM
1650 IF QM=1 THEN INPUT "LAST RANGE FOR TABLE (YDS)";LR:LX=3*LR
1660 IF QM=2 THEN INPUT "LAST RANGE FOR TABLE (METERS)";LM:LX=3.2808*LM
1670 IF QM=1 THEN INPUT "RANGE INCREMENT (YDS)";IR:IX=3*IR
1680 IF QM=2 THEN INPUT "RANGE INCREMENT (METERS)";IM:IX=3.2808*IM
1690 PRINT "":PRINT "ONE MOMENT PLEASE!  COMPUTING TABLE."
1700 IF QM=1 THEN Z=INT((LR-FR)/IR): REM DIM FOR ARRAY YARDS
1710 IF QM=2 THEN Z=INT((LM-FM+1)/IM): REM DIM FOR ARRAY METRIC
1720 DIM X(Z):DIM U(Z):DIM E(Z):DIM EN(Z):DIM DE(Z):DIM DI(Z):REM DIMENSION ARRAYS FOR BULLET-PATH TABLE
1730 X=FX:N=0:REM INITIALIZE
1740 GOSUB 320: REM DATA FOR NTH RANGE
1750 X(N)=X:U(N)=U:E(N)=E:EN(N)=EN:REM SAVE VALUES
1760 DE(N)=E-ZE:DI(N)=-(DE(N)*(X/3)/100):REM SAVE ELEV DIFF, IMPACT DIFF
1770 IF X(N)=0 THEN DE(N)=0:DI(N)=-H
1780 N=N+1:X=FX+N*IX:REM INCREMENT COUNTER, RANGE
1790 IF X>(LX+1) THEN GOTO 1810: REM BREAKOUT
1800 GOTO 1740:REM NEXT LOOP
1810 NF=N
1820 CLS
1830 PRINT "RANGE";TAB(10);"VELOC.";TAB(20);"IMPACT";TAB(30);"ADJUST"
1840 IF QM=1 THEN PRINT "YARDS";TAB(10);"FPS";TAB(20);"INCHES";TAB(30);"MOA"
1850 IF QM=2 THEN PRINT "METERS";TAB(10);"FPS";TAB(20);"INCHES";TAB(30);"MOA"
1860 FOR N=0 TO (NF-1)
1870 IF QM=1 THEN PRINT USING "####";X(N)/3;
1880 IF QM=2 THEN PRINT USING "####";X(N)/3.2808;
1890 PRINT TAB(10);:PRINT USING "####";U(N);
1900 PRINT TAB(20);:PRINT USING "###.#";DI(N);
1910 PRINT TAB(30);:PRINT USING "###.#";DE(N)
1920 NEXT N
1930 INPUT "COPY THIS (1=YES 2=NO)";QC
1940 IF QC<>1 THEN GOTO 2280
1950 LPRINT "CARTRIDGE: ";C$
1960 IF QA=1 AND QM=1 THEN LPRINT TAB(23);"STANDARD METRO";TAB(43);"SIGHT-IN RANGE (YARDS): ";ZR:GOTO 2000
1970 IF QA=1 AND QM=2 THEN LPRINT TAB(23);"STANDARD METRO";TAB(43);"SIGHT-IN RANGE (METERS): ";ZM:GOTO 2000
1980 IF QM=1 THEN LPRINT "ALTITUDE (FT):";AL;TAB(23);"TEMPERATURE (DEG-F):";TF;TAB(48);"SIGHT-IN RANGE (YARDS):";ZR
1990 IF QM=2 THEN LPRINT "ALTITUDE (FT):";AL;TAB(23);"TEMPERATURE (DEG-F):";TF;TAB(48);"SIGHT-IN RANGE (METERS):";ZM
2000 LPRINT "BULLET WEIGHT (GRS):";:LPRINT USING "####.#";G;:LPRINT TAB(48);"SIGHT ABOVE BORE (IN):";H
2010 LPRINT "MUZZLE VELOCITY (FPS):";V;TAB(48);"BALLISTIC COEFFICIENT (CX):";CX
2020 LPRINT " "
2030 LPRINT "RANGE";TAB(10);"VELOCITY";TAB(20);"ENERGY";TAB(30);"IMPACT";TAB(40);"ADJUST"
2040 IF QM=1 THEN LPRINT "YARDS";TAB(10);" FPS";TAB(20);"FT-LBS";TAB(30);"INCHES";TAB(40);" MOA"
2050 IF QM=2 THEN LPRINT "METERS";TAB(10);" FPS";TAB(20);"FT-LBS";TAB(30);"INCHES";TAB(40);" MOA"
2060 FOR N=0 TO (NF-1)
2070 IF QM=1 THEN LPRINT USING "####";X(N)/3;
2080 IF QM=2 THEN LPRINT USING "####";X(N)/3.2808;
2090 LPRINT TAB(10);:LPRINT USING "####";U(N);
2100 LPRINT TAB(20);:LPRINT USING "####";EN(N);
2110 LPRINT TAB(30);:LPRINT USING "###.#";DI(N);
2120 LPRINT TAB(40);:LPRINT USING "###.#";DE(N)
2130 NEXT N
2140 CLS: GOTO 2280:REM MENU & ERASE ARRAYS FOR REDIM BULLET-PATH TABLES
2150 REM ** PROGRAM CHOICES **
2160 PRINT "WHAT NEXT?"
2170 PRINT "   1=MORE DATA, SAME BULLET, SAME VELOCITY"
2180 PRINT "   2=SAME BULLET WEIGHT AND TYPE, NEW VELOCITY"
2190 PRINT "   3=NEW BULLET WEIGHT, SAME TYPE
2200 PRINT "   4=NEW BULLET TYPE
2210 INPUT "   5=END PROGRAM";QN
2220 ERASE X,E,V,U,SV,SU,TV,TU,EN,F,T,D,YM,HM,DF,MM:REM ERASE ARRAYS TO REDIMENSION VARIABLES IN RANGE TABLE
2230 IF QN=1 THEN GOTO 240
2240 IF QN=2 THEN GOTO 220
2250 IF QN=3 THEN GOTO 200
2260 IF QN=4 THEN GOTO 160
2270 IF QN<>1 AND QN<>2 AND QN<>3 AND QN<>4 THEN CLEAR:CLS:RUN "MENU.BAS"
2280 PRINT "WHAT NEXT?": PRINT TAB(5); "1=MORE DATA, SAME BULLET, SAME VELOCITY":PRINT TAB(5); "2=SAME BULLET WEIGHT AND TYPE, NEW VELOCITY":PRINT TAB(5); "3=NEW BULLET WEIGHT, SAME TYPE":PRINT TAB(5);"4=NEW NEW BULLET TYPE":PRINT TAB(5);"5=END PROGRAM"
2290 INPUT QN
2300 IF QN<>1 AND QN<>2 AND QN<>3 AND QN<>4 AND QN<>5 THEN PRINT "TRY AGAIN": GOTO 2280
2310 ERASE X,U,E,EN,DE,DI: REM ERASE ARRAYS FOR REDIMENSIONING VARIABLES IN BULLET-PATH TABLE
2320 IF QN=1 THEN GOTO 240
2330 IF QN=2 THEN GOTO 220
2340 IF QN=3 THEN GOTO 200
2350 IF QN=4 THEN GOTO 160
2360 CLEAR:CLS:RUN "MENU.BAS"
2370 REM  *** SUBROUTINE FOR NON-STANDARD METRO ***
2380 INPUT"ENTER ALTITUDE AT GUN";AL
2390 INPUT"ENTER TEMPERATURE (DEG-F)";TF
2400 RH=78: REM STD REL HUMIDITY
2410 A=SQR((459.67+TF)/518.67): REM MACH RATIO
2420 TAC=.002039*AL*(TF-59):REM TEMP CORR FOR ALTITUDE
2430 ALTC=AL+TAC:REM ALTITUDE ADJUSTED FOR TEMP
2440 BP=29.53/EXP(ALTC/27180):REM PRESSURE AT ALT AND TEMP
2450 RO=1.1357*BP/(29.53+.065092*TF)-(.065077*RH*EXP(.03288*TF-2.6538)/(459.67+TF)):REM REL ATM DENS RATIO
2460 RETURN
2470 REM ** ROUTINES FOR TRAJECTORY PROGRAM ON SPHERES - CODE 'SPHSUBS' - 04/01/88 - FROM PROGRAM 'TRAGSPH' WRITTEN 12/31/80 - REV 04/13/86 **
2480 IF UA > 3000 THEN PRINT "VELOCITY IS OUT OF PROGRAM RANGE":PRINT "":GOTO 220
2490 IF UA=<3000 AND UA>1848 THEN KA=1.06968:KB=-3.2287E-05:CS=7.51059:CT=-8.49217E-05:GOTO 2880
2500 IF UA<=1848 AND UA>1568 THEN KA=.8648:KB=7.8552E-05:CS=9.17436:CT=-1.20574E-03:GOTO 2880
2510 IF UA<=1568 AND UA>1400 THEN KA=.68011:KB=1.9631E-04:CS=11.4886:CT=-3.75971E-03:GOTO 2880
2520 IF UA<=1400 AND UA>1232 THEN KA=.34654:KB=4.3452E-04:CS=21.807:CT=-.0280554:GOTO 2880
2530 IF UA<=1232 AND UA>1120 THEN KA=.17783:KB=5.7143E-04:CS=41.6338:CT=-.134938:GOTO 2880
2540 IF UA<=1120 AND UA>829 THEN KA=-9.732002E-02:KB=8.170301E-04:CS=-73.1907:CT=-.613268:GOTO 2880
2550 IF UA<=829 AND UA>739 THEN KA=.14515:KB=5.2455E-04:CS=51.5107:CT=-.188141:GOTO 2880
2560 IF UA<=739 AND UA>112 THEN KA=.43518:KB=.0001323:CS=18.2907:CT=-.0068516:GOTO 2880
2570 IF UA<=112 AND UA>44.8 THEN KA=.36667:KB=7.4405E-04:CS=20.6594:CT=-.0373629:GOTO 2880
2580 IF UA<=44.8 AND UA>1 THEN KA=.34:KB=.001339:CS=21.6689:CT=-.0706802:GOTO 2880
2590 IF SUA>0 AND SUA<1999.2  THEN UA=3000-.597828*SUA+5.34994E-05*SUA^2-2.33281E-09*SUA^3:RETURN:REM UA = 3000-2000
2600 IF SUA>= 1999.2 AND SUA<2646.4 THEN UA=2797.41-.327967*SUA-6.59503E-05*SUA^2+1.52409E-08*SUA^3:RETURN: REM UA=2000-1750
2610 IF SUA>= 2646.4 AND SUA<3405.4 THEN UA=2667.57-.276735*SUA-5.12354E-05*SUA^2+9.33822E-09*SUA^3:RETURN: REM UA = 1750-1500
2620  IF SUA>= 3405.4 AND SUA<3754.8 THEN UA=2138.05 -.0709411*SUA-4.1484E-05*SUA^2+2.12169E-09*SUA^3:RETURN: REM UA = 1500-1400
2630 IF SUA>=3754.8 AND SUA<3942.9 THEN UA=1932.3-.0653629*SUA-9.809329E-06*SUA^2-2.81385E-09*SUA^3:RETURN: REM UA = 1400-1350
2640 IF SUA>= 3942.9 AND SUA<4142.7 THEN UA=2007.63 - .121846*SUA-3.14677E-06*SUA^2-2.0986E-09*SUA^3:RETURN:REM UA=1350-1300
2650 IF SUA>=4142.7 AND SUA<4355.3 THEN UA=2098.68-.160637*SUA-6.0342E-06*SUA^2-4.21731E-10*SUA^3:RETURN:REM UA=1300-1250
2660 IF SUA>= 4355.3 AND SUA<4582.4 THEN UA=1824.89-.0709549*SUA-9.17366E-06*SUA^2-1.117E-09*SUA^3:RETURN: REM UA=1250-1200
2670 IF SUA>= 4582.4 AND SUA<4827.1 THEN UA=1748.32-.0800836*SUA-2.90831E-07*SUA^2-1.82622E-09*SUA^3:RETURN:REM UA=1200-1150
2680 IF SUA>=4827.1 AND SUA<4983.2 THEN UA=1382.71+.0500764*SUA-1.21858E-05*SUA^2-1.69584E-09*SUA^3:RETURN: REM UA =1150-1120
2690 IF SUA>=4983.2 AND SUA<5091.9 THEN UA=1502.33 -3.11393E-03*SUA-8.70644E-06*SUA^2-1.218E-09*SUA^3:RETURN: REM UA=1120-1100
2700 IF SUA>=5091.9 AND SUA<5382.7 THEN UA=3374.44-.707005*SUA+5.11323E-05*SUA^2:RETURN: REM UA=1100-1050 (NOTE: QUADRATIC INTENDED)
2710 IF SUA>=5382.7 AND SUA<6062.9 THEN UA=1406.75+.168127*SUA-7.04783E-05*SUA^2+4.99952E-09*SUA^3:RETURN: REM UA=1050-950
2720 IF SUA>=6062.9 AND SUA<6916! THEN UA=1887.22-.12257*SUA-1.46805E-05*SUA^2+1.54969E-09*SUA^3:RETURN: REM UA=950-850
2730 IF SUA>=6916! AND SUA<7113.3 THEN UA=1107.74+4.93604E-03*SUA-3.29905E-06*SUA^2-4.05709E-10*SUA^3:RETURN: REM UA=850-830
2740 IF SUA>=7113.2 AND SUA<7427.2 THEN UA=1107.15+2.91359E-04*SUA-3.53236E-06*SUA^2-2.79983E-10*SUA^3:RETURN: REM UA=830-800
2750 IF SUA>=7427.2 AND SUA<7998.5 THEN UA=1125.33-.0128168*SUA-3.01353E-06*SUA^2-1.57634E-10*SUA^3:RETURN: REM UA=800-750
2760 IF SUA>=7998.5 AND SUA<8632.099 THEN UA=1114.79-.0190729*SUA-2.84295E-06*SUA^2-6.03581E-11*SUA^3:RETURN: REM UA=750-700
2770 IF SUA>= 8632.099 AND SUA<9321.8 THEN UA=1169.68-.0519078*SUA+1.21824E-06*SUA^2-1.75524E-10*SUA^3:RETURN: REM UA=700-650
2780 IF SUA>=9321.8 AND SUA<10076.3 THEN UA=1087.26-.0665144*SUA+5.79913E-06*SUA^2-3.97406E-10*SUA^3:RETURN: REM UA=650-600
2790 IF SUA>=10076.3 AND SUA<10907.2 THEN UA=1216.8-.0456478*SUA-3.06515E-06*SUA^2+1.50712E-10*SUA^3:RETURN: REM UA=600-550
2800 IF SUA>=10907.2 AND SUA<11829.2 THEN UA=1048!-.0306764*SUA-1.98147E-06*SUA^2+5.54418E-11*SUA^3:RETURN: REM UA=550-500
2810 IF SUA>=11829.2 AND SUA<14032! THEN UA=1292.14-.0758217*SUA+7.723451E-08*SUA^2+5.66186E-11*SUA^3:RETURN: REM UA=500-400
2820 IF SUA>=14032 AND SUA<16950.5 THEN UA=1827.17-.18746*SUA+7.88075E-06*SUA^2-1.26022E-10*SUA^3:RETURN: REM UA=400-300
2830 IF SUA>=16950.5 AND SUA<21181.4 THEN UA=731.773-7.78728E-03*SUA-1.95482E-06*SUA^2+5.36845E-11*SUA^3:RETURN: REM UA=300-200
2840 IF SUA>=21181.4 AND SUA<28640.2 THEN UA=647.409-.0179068*SUA-4.68034E-07*SUA^2+1.48818E-11*SUA^3:RETURN:REM UA=200-100
2850 IF SUA>=28640.2 AND SUA<36694.3 THEN UA=379.661-6.65559E-03*SUA-2.71132E-07*SUA^2+5.66068E-12*SUA^3:RETURN: REM UA=100-50
2860 IF SUA>= 36694.3 AND SUA<57778.7 THEN UA=242.813-6.67349E-03*SUA+2.49795E-08*SUA^2+3.60491E-13*SUA^3:RETURN: REM UA=50-10
2870 IF SUA>=57778.7 AND SUA<90337! THEN UA=51.2998-4.69618E-04*SUA-1.0662E-08*SUA^2+1.10454E-13*SUA^3:RETURN: REM UA=10-1
2880 SUA=4881*((1/KA)*LOG((KA+KB*UA)/UA)+CS)
2890 TUA=4881*((1/(KA*UA))-(KB/KA^2)*LOG((KA+KB*UA)/UA)+CT):RETURN

