10 CLS:PRINT TAB(15);"*** TRAJECTORIES FOR G1 BULLETS - CODE 'TRAG1Q' ***":PRINT ""
20 REM ** WRITTEN 04/17/84 - REV 04/13/85,08/30/86,08/20/87,10/25/87,09/23/88,07/06/89,O5/26/90 **
30 PRINT TAB(22); "COPYRIGHT 1984 BY WM. C. DAVIS, JR.":PRINT ""
40 PRINT TAB(10); "COPYING ANY PART OF THIS PROGRAM FOR COMMERCIAL USE, WITHOUT"
50 PRINT TAB(10);"SPECIFIC PERMISSION OF THE AUTHOR, IS STRICTLY FORBIDDEN.":PRINT ""
60 PRINT "SOME COMMENTS ON THE USE OF THIS PROGRAM ARE AVAILABLE FOR YOUR"
70 PRINT "INFORMATION, ALTHOUGH THEY ARE NOT REQUIRED FOR RUNNING THE PROGRAM."
80 PRINT "":PRINT "WHAT IS YOUR CHOICE?"
90 PRINT "  1=PROCEED WITH CALCULATIONS
100 PRINT "  2=REVIEW COMMENTS": INPUT QCOM:PRINT ""
110 IF QCOM=2 THEN CLS:GOSUB 3160
120 PRINT "WHAT ATMOSPHERIC CONDITIONS FOR YOUR CALCULATIONS?":PRINT "  1 = STANDARD METRO (59 DEG-F AT SEA LEVEL)":PRINT "  2 = ANOTHER TEMPERATURE AND/OR ALTITUDE":INPUT QA
130 IF QA=2 THEN GOSUB 3060 ELSE RO=1:AL=0:TF=59:A=1
140 INPUT "HEIGHT OF SIGHT ABOVE BORE (INS)";H
150 INPUT "CARTRIDGE IDENTIFICATION";C$
160 INPUT "BULLET WEIGHT (GRS)";G
170 INPUT "BALLISTIC COEFFICIENT (C1)";C1
180 INPUT "MUZZLE VELOCITY (FPS)";V:VA=V/A:REM ADJ F/SONIC VEL
190 X=0:GOSUB 280: REM INITIALIZE RANGE, FIND DATA FOR MUZZLE VELOCITY
200 PRINT "WHAT IS YOUR CHOICE?"
210 PRINT "   1=RANGE TABLE"
220 INPUT "   2=BULLET PATH FROM SIGHT LINE";QB
230 IF QB<>1 AND QB<>2 THEN PRINT "TRY AGAIN":GOTO 200
240 IF QB=1 THEN GOTO 470
250 IF QB=2 THEN GOTO 1200
260 PRINT " "
270 GOTO 200
280 REM ** FIND SVA,TVA,SUA, TRAJECTORY ELEMENTS **
290 GOSUB 2350: REM FIND COEFFS FOR V/A
300 SVA=AS+BS*(VA-VBA)+CS*(VA-VBA)^2
310 TVA=AT+BT*(VA-VBA)+CT*(VA-VBA)^2
320 SUA=SVA+RO*X/C1
330 GOSUB 2590: REM FIND COEFF FOR SUA
340 UA=VBA+(-BS-SQR(BS^2-4*CS*(AS-SUA)))/(2*CS):U=UA*A
350 EN=U^2*G/450400!: REM ENERGY
360 F=14.0069+6.59285*((U/V)-.65)-1.94051*((U/V)-.65)^2
370 TUA=AT+BT*(UA-VBA)+CT*(UA-VBA)^2
380 T=(C1/(RO*A))*(TUA-TVA)
390 D=12*F*T^2: REM DROP
400 YM=48.6*T^2: REM MAX ORDINATE
410 HM=YM-.4*H: REM MAX HEIGHT ABOVE SIGHT LINE
420 DF=176*(T-X/V): REM WIND DEFLECTION FOR 10MPH CROSS-COMPONENT
430 MM=2*(EN/U): REM MOMENTUM, LB-SEC
440 IF X=0 THEN E=0 ELSE E=(D+H)/(X/300): REM ELEVATION MOA
450 RETURN
460 REM ** DO RANGE TABLE **
470 INPUT "CHOOSE: (1=YARDS 2=METERS)";QM
480 IF QM<>1 AND QM<>2 THEN PRINT "TRY AGAIN":GOTO 470
490 IF QM=2 THEN INPUT "FIRST RANGE FOR TABLE (METERS)";FM:FX=3.2808*FM
500 IF QM=2 THEN INPUT "LAST RANGE FOR TABLE (METERS)";LM:LX=3.2808*LM
510 IF QM=2 THEN INPUT "RANGE INCREMENT (METERS)";IM:IX=3.2808*IM
520 IF QM=2 AND IM>(LM-FM) THEN PRINT "TRY AGAIN!":GOTO 490
530 IF QM=2 THEN GOTO 600
540 INPUT "FIRST RANGE FOR TABLE (YDS)";FR:FX=3*FR
550 INPUT "LAST RANGE FOR TABLE (YDS)";LR:LX=3*LR
560 INPUT "RANGE INCREMENT (YDS)";IR:IX=3*IR
570 IF IR>(LR-FR) THEN PRINT "TRY AGAIN!":GOTO 540
580 PRINT "":PRINT "ONE MOMENT PLEASE! COMPUTING TABLE."
590 Z=INT((LR-FR)/IR): REM DIMENSION FOR ARRAY
600 IF QM=2 THEN Z=INT((LM-FM)/IM+5): REM DIMENSION FOR ARRAY
610 DIM X(Z):DIM E(Z):DIM V(Z):DIM U(Z):DIM SV(Z):DIM SU(Z):DIM TV(Z):DIM TU(Z):DIM EN(Z):DIM F(Z):DIM T(Z):DIM D(Z):DIM YM(Z):DIM HM(Z):DIM DF(Z):DIM MM(Z): REM DIMENSION ARRAYS FOR RANGE TABLE
620 X=FX:N=0: REM INITIALIZE X,N
630 GOSUB 280: REM FIND DATA FOR NTH RANGE
640 X(N)=X:V(N)=V:U(N)=U:EN(N)=EN:T(N)=T:D(N)=D:YM(N)=YM:HM(N)=HM:DF(N)=DF:MM(N)=MM:E(N)=E: REM SAVE VALUES THIS PASS
650 IF X(N)=0 THEN YM(N)=0:HM(N)=-H
660 N=N+1:X=FX+N*IX: REM INCREMENT N AND X
670 IF X>(LX+1) THEN GOTO 690: REM BREAKOUT CONDITION
680 GOTO 630: REM NEXT LOOP
690 NF=N:REM END VALUE ON COUNTER
700 CLS
710 IF QA=1 THEN PRINT "CARTRIDGE: ";C$;TAB(48);"STANDARD METRO":GOTO 740
720 PRINT "CARTRIDGE IDENTIFICATION:";C$
730 PRINT "ALTITUDE (FT):";AL;TAB(48);"TEMPERATURE (DEG-F):";TF
740 PRINT "BULLET WEIGHT (GRS):";G;TAB(48);"SIGHT ABOVE BORE (IN):";H
750 PRINT "MUZZLE VELOCITY (FPS):";V;TAB(48);"BALLISTIC COEFF. (C1):";C1:PRINT " "
760 PRINT "RANGE";TAB(8);"REM.";TAB(16);"REM.";TAB(24);"MOM-";TAB(32);"DROP";TAB(40);"ELEV-";TAB(48);"TIME OF";TAB(56);"MAX.";TAB(64);"MAX.";TAB(72);"10MPH"
770 IF QM=1 THEN PRINT "YARDS";
780 IF QM=2 THEN PRINT "METERS";
790 PRINT TAB(8);"VELOC.";TAB(16);"ENERGY";TAB(24);"ENTUM";TAB(32);"INCHES";TAB(40);"ATION";TAB(48);"FLIGHT";TAB(56);"ORD";TAB(64);"HIGH";TAB(72);"WIND"
800 PRINT TAB(8);"FPS";TAB(16);"FT-LBS";TAB(24);"LB-SECS";TAB(40);"MOA";TAB(48);"SEC";TAB(56);"INCHES";TAB(64);"INCHES";TAB(72);"INCHES"
810 FOR N=0 TO (NF-1)
820 IF QM=1 THEN PRINT USING "####";X(N)/3;
830 IF QM=2 THEN PRINT USING "####";X(N)/3.2808;
840 PRINT TAB(8);:PRINT USING "####";U(N);
850 PRINT TAB(16);:PRINT USING "####";EN(N);
860 PRINT TAB(24);:PRINT USING "#.##";MM(N);
870 PRINT TAB(32);:PRINT USING "###.#";D(N);
880 PRINT TAB(40);:PRINT USING "##.#";E(N);
890 PRINT TAB(48);:PRINT USING "#.###";T(N);
900 PRINT TAB(56);:PRINT USING "###.#";YM(N);
910 PRINT TAB(64);:PRINT USING "###.#";HM(N);
920 PRINT TAB(72);:PRINT USING "###.##";DF(N)
930 NEXT N
940 INPUT "COPY TABLE? (1=YES 2=NO)";QP
950 IF QP<>1 THEN CLS: GOTO 2130
960 IF QA=1 THEN LPRINT "CARTRIDGE: ";C$;TAB(48);"STANDARD METRO":GOTO 990
970 LPRINT "CARTRIDGE IDENTIFICATION:";C$
980 LPRINT "ALTITUDE (FT): ";AL;TAB(48);"TEMPERATURE (DEG-F):";TF
990 LPRINT "BULLET WEIGHT (GRS):";G;TAB(48);"SIGHT ABOVE BORE (IN):";H
1000 LPRINT "MUZZLE VELOCITY:";V;TAB(48);"BALLISTIC COEFF. (C1):";C1:LPRINT " "
1010 LPRINT "RANGE";TAB(8);"REM.";TAB(16);"REM.";TAB(24);"MOM-";TAB(32);"DROP";TAB(40);"ELEV-";TAB(48);"TIME OF";TAB(56);"MAX.";TAB(64);"MAX.";TAB(72);"10MPH"
1020 IF QM=1 THEN LPRINT "YARDS";
1030 IF QM=2 THEN LPRINT "METERS";
1040 LPRINT TAB(8);"VELOC.";TAB(16);"ENERGY";TAB(24);"ENTUM";TAB(32);"INCHES";TAB(40);"ATION";TAB(48);"FLIGHT";TAB(56);"ORD";TAB(64);"HIGH";TAB(72);"WIND"
1050 LPRINT TAB(8);"FPS";TAB(16);"FT-LBS";TAB(24);"LB-SECS";TAB(40);"MOA";TAB(48);"SEC";TAB(56);"INCHES";TAB(64);"INCHES";TAB(72);"INCHES"
1060 FOR N=0 TO (NF-1)
1070 IF QM=1 THEN LPRINT USING "####";X(N)/3;
1080 IF QM=2 THEN LPRINT USING "####";X(N)/3.2808;
1090 LPRINT TAB(8);:LPRINT USING "####";U(N);
1100 LPRINT TAB(16);:LPRINT USING "####";EN(N);
1110 LPRINT TAB(24);:LPRINT USING "#.##";MM(N);
1120 LPRINT TAB(32);:LPRINT USING "###.#";D(N);
1130 LPRINT TAB(40);:LPRINT USING "##.#";E(N);
1140 LPRINT TAB(48);:LPRINT USING "#.###";T(N);
1150 LPRINT TAB(56);:LPRINT USING "###.#";YM(N);
1160 LPRINT TAB(64);:LPRINT USING "###.#";HM(N);
1170 LPRINT TAB(72);:LPRINT USING "###.##";DF(N)
1180 NEXT N
1190 LPRINT " ":CLS: GOTO 2130
1200 REM ** ROUTINE FOR BULLET PATH FROM SIGHT LINE **
1210 INPUT "CHOOSE: (1=YARDS 2=METERS)";QM
1220 IF QM<>1 AND QM<>2 THEN PRINT "TRY AGAIN":GOTO 1210
1230 IF QM=1 THEN INPUT "YOUR SIGHT-IN RANGE (YDS)";ZR:ZX=3*ZR
1240 IF QM=2 THEN INPUT "YOUR SIGHT-IN RANGE (METERS)";ZM:ZX=3.2808*ZM
1250 X=ZX: GOSUB 280: REM GET DATA FOR ZEROING RANGE
1260 ZE=E: REM TAG ZEROING ELEVATION
1270 PRINT "CHOOSE:"
1280 PRINT "   1=IMPACT AT ONE RANGE"
1290 INPUT "   2=TABULAR DATA";QG
1300 IF QG=2 THEN GOTO 1590
1310 IF QM=1 THEN INPUT "WHAT RANGE (YDS)";NR:NX=3*NR
1320 IF QM=2 THEN INPUT "WHAT RANGE (METERS)";NM:NX=3.2808*NM
1330 X=NX:GOSUB 280
1340 NE=E:DE=NE-ZE
1350 DI=-DE*(NX/300): REM IMPACT DIFF INCHES
1360 PRINT " ":PRINT " "
1370 IF QM=1 THEN PRINT "SIGHT-IN RANGE (YDS):";TAB(40);ZR:PRINT " "
1380 IF QM=2 THEN PRINT "SIGHT-IN RANGE (METERS):";TAB(40);ZM:PRINT " "
1390 IF QM=1 THEN PRINT "OTHER RANGE (YDS):";TAB(40);NR:PRINT " "
1400 IF QM=2 THEN PRINT "OTHER RANGE (METERS):";TAB(40);NM:PRINT " "
1410 PRINT "POINT OF IMPACT (INCHES):";TAB(40);:PRINT USING "###.#";DI:PRINT ""
1420 PRINT "SIGHT ADJUSTMENT (MOA):";TAB(40);:PRINT USING "###.#";DE:PRINT ""
1430 PRINT " "
1440 INPUT "COPY THIS (1=YES 2=NO)";QC
1450 IF QC<>1 THEN GOTO 1510
1460 IF QM=1 THEN LPRINT "SIGHT-IN RANGE (YDS)";ZR;TAB(40);"OTHER RANGE (YDS)";NR:LPRINT " "
1470 IF QM=2 THEN LPRINT "SIGHT-IN RANGE (METERS)";ZM;TAB(40);"OTHER RANGE (METERS)";NM:LPRINT " "
1480 LPRINT "IMPACT POINT (INCHES):";:LPRINT USING "###.#";DI;
1490 LPRINT TAB(40);"SIGHT ADJUST (MOA):";:LPRINT USING "###.#";DE
1500 LPRINT " "
1510 PRINT "WHAT NEXT?"
1520 PRINT "   1=ANOTHER RANGE"
1530 PRINT "   2=NEW SIGHT-IN RANGE"
1540 INPUT "   3=MORE CHOICES";QH
1550 IF QH=1 THEN GOTO 1310
1560 IF QH=2 THEN GOTO 1210
1570 IF QH=3 THEN CLS:GOTO 200
1580 IF QH<>1 AND QH<>2 AND QH<>3 THEN PRINT "TRY AGAIN":GOTO 1510
1590 REM ** BULLET-PATH TABLE **
1600 IF QM=1 THEN INPUT "FIRST RANGE FOR TABLE (YDS)";FR:FX=3*FR
1610 IF QM=2 THEN INPUT "FIRST RANGE FOR TABLE (METERS)";FM:FX=3.2808*FM
1620 IF QM=1 THEN INPUT "LAST RANGE FOR TABLE (YDS)";LR:LX=3*LR
1630 IF QM=2 THEN INPUT "LAST RANGE FOR TABLE (METERS)";LM:LX=3.2808*LM
1640 IF QM=1 THEN INPUT "RANGE INCREMENT (YDS)";IR:IX=3*IR
1650 IF QM=2 THEN INPUT "RANGE INCREMENT (METERS)";IM:IX=3.2808*IM
1660 PRINT "":PRINT "ONE MOMENT PLEASE!  COMPUTING TABLE."
1670 IF QM=1 THEN Z=INT((LR-FR)/IR): REM DIM FOR ARRAY YARDS
1680 IF QM=2 THEN Z=INT((LM-FM+1)/IM): REM DIM FOR ARRAY METRIC
1690 DIM X(Z):DIM U(Z):DIM E(Z):DIM EN(Z):DIM DE(Z):DIM DI(Z):REM DIMENSION ARRAYS FOR BULLET-PATH TABLE
1700 X=FX:N=0:REM INITIALIZE
1710 GOSUB 280: REM DATA FOR NTH RANGE
1720 X(N)=X:U(N)=U:E(N)=E:EN(N)=EN:REM SAVE VALUES
1730 DE(N)=E-ZE:DI(N)=-(DE(N)*(X/3)/100):REM SAVE ELEV DIFF, IMPACT DIFF
1740 IF X(N)=0 THEN DE(N)=0:DI(N)=-H
1750 N=N+1:X=FX+N*IX:REM INCREMENT COUNTER, RANGE
1760 IF X>(LX+1) THEN GOTO 1780: REM BREAKOUT
1770 GOTO 1710:REM NEXT LOOP
1780 NF=N
1790 CLS
1800 PRINT "RANGE";TAB(10);"VELOC.";TAB(20);"ENERGY";TAB(30);"IMPACT";TAB(40);"ADJUST"
1810 IF QM=1 THEN PRINT "YARDS";TAB(10);"FPS";TAB(20);"FT-LBS";TAB(30);"INCHES";TAB(40);"MOA"
1820 IF QM=2 THEN PRINT "METERS";TAB(10);"FPS";TAB(20);"FT-LBS";TAB(30);"INCHES";TAB(40);"MOA"
1830 FOR N=0 TO (NF-1)
1840 IF QM=1 THEN PRINT USING "####";X(N)/3;
1850 IF QM=2 THEN PRINT USING "####";X(N)/3.2808;
1860 PRINT TAB(10);:PRINT USING "####";U(N);
1870 PRINT TAB(20);:PRINT USING "####";EN(N);
1880 PRINT TAB(30);:PRINT USING "####.#";DI(N);
1890 PRINT TAB(40);:PRINT USING "####.#";DE(N)
1900 NEXT N
1910 INPUT "COPY THIS (1=YES 2=NO)";QC
1920 IF QC<>1 THEN GOTO 2260
1930 LPRINT "CARTRIDGE: ";C$
1940 IF QA=1 AND QM=1 THEN LPRINT TAB(23);"STANDARD METRO";TAB(43);"SIGHT-IN RANGE (YARDS): ";ZR:GOTO 1980
1950 IF QA=1 AND QM=2 THEN LPRINT TAB(23);"STANDARD METRO";TAB(43);"SIGHT-IN RANGE (METERS): ";ZM:GOTO 1980
1960 IF QM=1 THEN LPRINT "ALTITUDE (FT):";AL;TAB(23);"TEMPERATURE (DEG-F):";TF;TAB(48);"SIGHT-IN RANGE (YARDS):";ZR
1970 IF QM=2 THEN LPRINT "ALTITUDE (FT):";AL;TAB(23);"TEMPERATURE (DEG-F):";TF;TAB(48);"SIGHT-IN RANGE (METERS):";ZM
1980 LPRINT "BULLET WEIGHT (GRS):";G;TAB(48);"SIGHT ABOVE BORE (IN):";H
1990 LPRINT "MUZZLE VELOCITY (FPS):";V;TAB(48);"BALLISTIC COEFFICIENT (C1):";C1
2000 LPRINT " "
2010 LPRINT "RANGE";TAB(10);"VELOCITY";TAB(20);"ENERGY";TAB(30);"IMPACT";TAB(40);"ADJUST"
2020 IF QM=1 THEN LPRINT "YARDS";TAB(10);" FPS";TAB(20);"FT-LBS";TAB(30);"INCHES";TAB(40);" MOA"
2030 IF QM=2 THEN LPRINT "METERS";TAB(10);" FPS";TAB(20);"FT-LBS";TAB(30);"INCHES";TAB(40);" MOA"
2040 FOR N=0 TO (NF-1)
2050 IF QM=1 THEN LPRINT USING "####";X(N)/3;
2060 IF QM=2 THEN LPRINT USING "####";X(N)/3.2808;
2070 LPRINT TAB(10);:LPRINT USING "####";U(N);
2080 LPRINT TAB(20);:LPRINT USING "####";EN(N);
2090 LPRINT TAB(30);:LPRINT USING "####.#";DI(N);
2100 LPRINT TAB(40);:LPRINT USING "####.#";DE(N)
2110 NEXT N
2120 CLS: GOTO 2260:REM MENU & ERASE ARRAYS FOR REDIM BULLET-PATH TABLES
2130 REM ** PROGRAM CHOICES **
2140 PRINT "WHAT NEXT?"
2150 PRINT "   1=MORE DATA, SAME CARTRIDGE & LOAD"
2160 PRINT "   2=SAME CARTRIDGE AND BULLET, NEW VELOCITY"
2170 PRINT "   3=SAME CARTRIDGE, NEW BULLET"
2180 PRINT "   4=NEW CARTRIDGE"
2190 INPUT "   5=END PROGRAM";QN
2200 ERASE X,E,V,U,SV,SU,TV,TU,EN,F,T,D,YM,HM,DF,MM:REM ERASE ARRAYS TO REDIMENSION VARIABLES IN RANGE TABLE
2210 IF QN=1 THEN GOTO 200
2220 IF QN=2 THEN GOTO 180
2230 IF QN=3 THEN GOTO 160
2240 IF QN=4 THEN GOTO 140
2250 IF QN<>1 AND QN<>2 AND QN<>3 AND QN<>4 THEN CLEAR:CLS:RUN "MENU.BAS"
2260 PRINT "WHAT NEXT?": PRINT TAB(5); "1=MORE DATA, SAME CARTRIDGE & LOAD":PRINT TAB(5); "2=SAME CARTRIDGE AND BULLET, NEW VELOCITY":PRINT TAB(5); "3=SAME CARTRIDGE, NEW BULLET":PRINT TAB(5);"4=NEW CARTRIDGE":PRINT TAB(5);"5=END PROGRAM"
2270 INPUT QN
2280 IF QN<>1 AND QN<>2 AND QN<>3 AND QN<>4 AND QN<>5 THEN PRINT "TRY AGAIN": GOTO 2260
2290 ERASE X,U,E,EN,DE,DI: REM ERASE ARRAYS FOR REDIMENSIONING VARIABLES IN BULLET-PATH TABLE
2300 IF QN=1 THEN GOTO 200
2310 IF QN=2 THEN GOTO 180
2320 IF QN=3 THEN GOTO 160
2330 IF QN=4 THEN GOTO 140
2340 CLEAR:CLS:RUN "MENU.BAS"
2350 REM ** FIND COEFFICIENTS FOR S & T EQUATIONS **
2360 IF V<300 OR V>4500 THEN PRINT"VELOCITY IS OUT OF RANGE OF PROGRAM.  USE TABLES OR SELECT A VELOCITY BETWEEN 300 AND 4500 FPS.":GOTO 180
2370 IF VA>=300 AND VA<400 THEN GOTO 2840
2380 IF VA>=400 AND VA<500 THEN GOTO 2850
2390 IF VA>=500 AND VA<600 THEN GOTO 2860
2400 IF VA>=600 AND VA<700 THEN GOTO 2870
2410 IF VA>=700 AND VA<800 THEN GOTO 2880
2420 IF VA>=800 AND VA<900 THEN GOTO 2890
2430 IF VA>=900 AND VA<1000 THEN GOTO 2900
2440 IF VA>=1000 AND VA<1050 THEN GOTO 2910
2450 IF VA>=1050 AND VA<1075 THEN GOTO 2920
2460 IF VA>=1075 AND VA<1100 THEN GOTO 2930
2470 IF VA>=1100 AND VA<1110 THEN GOTO 2940
2480 IF VA>=1110 AND VA<1120 THEN GOTO 2950
2490 IF VA>=1120 AND VA<1130 THEN GOTO 2960
2500 IF VA>=1130 AND VA<1150 THEN GOTO 2970
2510 IF VA>=1150 AND VA<1250 THEN GOTO 2980
2520 IF VA>=1250 AND VA<1500 THEN GOTO 2990
2530 IF VA>=1500 AND VA<2000 THEN GOTO 3000
2540 IF VA>=2000 AND VA<2500 THEN GOTO 3010
2550 IF VA>=2500 AND VA<3000 THEN GOTO 3020
2560 IF VA>=3000 AND VA<3500 THEN GOTO 3030
2570 IF VA>=3500 AND VA<4000 THEN GOTO 3040
2580 IF VA>=4000 AND VA<=4500 THEN GOTO 3050
2590 REM ** FIND COEFFICIENTS FOR SU **
2600 IF SUA>43041! THEN PRINT"REMAINING VELOCITY IS OUT OF RANGE OF PROGRAM.  USE TABLES OR CHOOSE HIGHER MUZZLE VELOCITY OR SHORTER RANGE.":GOTO 80
2610 IF SUA<=43041! AND SUA>36664.2 THEN GOTO 2840
2620 IF SUA<=36664.2 AND SUA>31488.6 THEN GOTO 2850
2630 IF SUA<=31488.6 AND SUA>27124.6 THEN GOTO 2860
2640 IF SUA<=27124.6 AND SUA>23415.1 THEN GOTO 2870
2650 IF SUA<=23415.1 AND SUA>20325.5 THEN GOTO 2880
2660 IF SUA<=20325.5 AND SUA>17879.9 THEN GOTO 2890
2670 IF SUA<=17879.9 AND SUA>16095.6 THEN GOTO 2900
2680 IF SUA<=16095.6 AND SUA>15433.3 THEN GOTO 2910
2690 IF SUA<=15433.3 AND SUA>15150.3 THEN GOTO 2920
2700 IF SUA<=15150.3 AND SUA>14894.3 THEN GOTO 2930
2710 IF SUA<=14894.3 AND SUA>14798.5 THEN GOTO 2940
2720 IF SUA<=14798.5 AND SUA>14706.2 THEN GOTO 2950
2730 IF SUA<=14706.2 AND SUA>14616.9 THEN GOTO 2960
2740 IF SUA<=14616.9 AND SUA>14447! THEN GOTO 2970
2750 IF SUA<=14447! AND SUA>13720.5 THEN GOTO 2980
2760 IF SUA<=13720.5 AND SUA>12330.3 THEN GOTO 2990
2770 IF SUA<=12330.3 AND SUA>10168.1 THEN GOTO 3000
2780 IF SUA<=10168.1 AND SUA>8332.83 THEN GOTO 3010
2790 IF SUA<=8332.83 AND SUA>6699.05 THEN GOTO 3020
2800 IF SUA<=6699.05 AND SUA>5245.45 THEN GOTO 3030
2810 IF SUA<=5245.45 AND SUA>3958.11 THEN GOTO 3040
2820 IF SUA<=3958.11 AND SUA>2812.29 THEN GOTO 3050
2830 REM     ***SUBROUTINES FOR SPACE, TIME FUNCTIONS***
2840 VBA=350:AS=39663!:BS=-63.768:CS=.0758391:AT=49.669:BT=-.1845:CT=4.82396E-04:RETURN
2850 VBA=450:AS=33958.1:BS=-51.756:CS=.0473157:AT=35.269:BT=-.115879:CT=2.34824E-04:RETURN
2860 VBA=550:AS=29218.7:BS=-43.64:CS=.035161:AT=25.7322:BT=-.079629:CT=1.36695E-04:RETURN
2870 VBA=650:AS=25192:BS=-37.095:CS=.0311391:AT=18.9904:BT=-.057305:CT=9.20586E-05:RETURN
2880 VBA=750:AS=21792:BS=-30.896:CS=.0313196:AT=14.1144:BT=-.041349:CT=6.9381E-05:RETURN
2890 VBA=850:AS=19020.1:BS=-24.4588:CS=.0330303:AT=10.6366:BT=-.0288527:CT=5.58719E-05:RETURN
2900 VBA=950:AS=16906.5:BS=-17.8388:CS=.0325134:AT=8.27886:BT=-.01884:CT=4.41677E-05:RETURN
2910 VBA=1025:AS=15747.2:BS=-13.2423:CS=.0276581:AT=7.10211:BT=-.0129298:CT=3.32035E-05:RETURN
2920 VBA=1062.5:AS=15288.1:BS=-11.3183:CS=.023346:AT=6.66207:BT=-.0106524:CT=2.68757E-05:RETURN
2930 VBA=1087.5:AS=15019.2:BS=-10.2383:CS=.0199585:AT=6.41183:BT=-9.41688E-03:CT=2.2611E-05:RETURN
2940 VBA=1105:AS=14846:BS=-9.58136:CS=.0164795:AT=6.25378:BT=-8.66849E-03:CT=2.0396E-05:RETURN
2950 VBA=1115:AS=14751.9:BS=-9.231361:CS=.0165939:AT=6.16907:BT=-8.28369E-03:CT=1.83284E-05:RETURN
2960 VBA=1125:AS=14661.2:BS=-8.930021:CS=.0147629:AT=6.08802:BT=-7.93184E-03:CT=1.70991E-05:RETURN
2970 VBA=1140:AS=14530.6:BS=-8.482001:CS=.0116909:AT=5.97274:BT=-7.45342E-03:CT=1.50953E-05:RETURN
2980 VBA=1200:AS=14062.5:BS=-7.2568:CS=8.50001E-03:AT=5.57228:BT=-.006058:CT=9.6174E-06:RETURN
2990 VBA=1375:AS=12977.5:BS=-5.5464:CS=3.06207E-03:AT=4.72557:BT=-4.05656E-03:CT=3.72586E-06:RETURN
3000 VBA=1750:AS=11189.1:BS=-4.31589:CS=9.60342E-04:AT=3.56969:BT=-2.49074E-03:CT=1.27366E-06:RETURN
3010 VBA=2250:AS=9222.059:BS=-3.66916:CS=4.5401E-04:AT=2.57801:BT=-1.63915E-03:CT=5.68494E-07:RETURN
3020 VBA=2750:AS=7492.73:BS=-3.26733:CS=3.71407E-04:AT=1.88267:BT=-.0011924:CT=3.52828E-07:RETURN
3030 VBA=3250:AS=5950.45:BS=-2.90704:CS=3.48885E-04:AT=1.36656:BT=-8.97071E-04:CT=2.45908E-07:RETURN
3040 VBA=3750:AS=4582.38:BS=-2.57414:CS=3.10524E-04:AT=.974457:BT=-6.880031E-04:CT=1.74925E-07:RETURN
3050 VBA=4250:AS=3369.09:BS=-2.29123:CS=2.57709E-04:AT=.670381:BT=-5.40083E-04:CT=1.24357E-07:RETURN
3060 REM  *** SUBROUTINE FOR NON-STANDARD METRO ***
3070 INPUT"ENTER ALTITUDE AT GUN";AL
3080 INPUT"ENTER TEMPERATURE (DEG-F)";TF
3090 RH=78: REM STD REL HUMIDITY
3100 A=SQR((459.67+TF)/518.67): REM MACH RATIO
3110 TAC=.002039*AL*(TF-59):REM TEMP CORR FOR ALTITUDE
3120 ALTC=AL+TAC:REM ALTITUDE ADJUSTED FOR TEMP
3130 BP=29.53/EXP(ALTC/27180):REM PRESSURE AT ALT AND TEMP
3140 RO=1.1357*BP/(29.53+.065092*TF)-(.065077*RH*EXP(.03288*TF-2.6538)/(459.67+TF)):REM REL ATM DENS RATIO
3150 RETURN
3160 PRINT "":PRINT "":PRINT "THIS PROGRAM CALCULATES THE TRAJECTORIES OF BULLETS USING THE"
3170 PRINT "'C1' BALLISTIC COEFFICIENT, WHICH IS BASED ON DATA TABULATED"
3180 PRINT "FOR THE 'G1' DRAG FUNCTION. THE BALLISTIC COEFFICIENT BASED ON"
3190 PRINT "'INGALLS' TABLES, SOMETIMES IDENTIFIED AS THE 'Ci' BALLISTIC"
3200 PRINT "COEFFICIENT IS VERY SIMILAR TO THE C1 BALLISTIC COEFFICIENT"
3210 PRINT "WITHIN THE RANGE OF VELOCITIES THAT ARE OF PRACTICAL INTEREST"
3220 PRINT "FOR SPORTING BULLETS. THE C1 BALLISTIC COEFFICIENT IS USED BY"
3230 PRINT "THE MAJOR MANUFACTURERS OF SPORTING AMMUNITION IN THE UNITED "
3240 PRINT "STATES TO CALCULATE THE TRAJECTORIES OF PRACTICALLY ALL SPORTING"
3250 PRINT "BULLETS EXCEPT THOSE USED IN .22-CALIBER RIMFIRE AMMUNITION. THE"
3260 PRINT "BALLISTIC COEFFICIENTS LISTED BY THE MANUFACTURERS OF BULLETS FOR"
3270 PRINT "HANDLOADING  ARE BASED EITHER ON THE 'G1' TABLES OR ON 'INGALLS'
3280 PRINT "TABLES. UNLESS OTHERWISE STATED, 'THE BALLISTIC COEFFICIENT' OF
3290 PRINT "A SPORTING BULLET IS ASSUMED TO BE EITHER 'C1' OR 'Ci'. THE BALL-"
3300 PRINT "ISTIC COEFFICIENTS FOUND IN RELOADING HANDBOOKS ARE SUITABLE FOR"
3310 PRINT "USE IN THIS PROGRAM. BALLISTIC COEFFICIENTS FOR SOME BULLETS USED"
3320 PRINT "IN FACTORY LOADS ARE GIVEN IN THE 'AMERICAN RIFLEMAN', JUNE 1988.":PRINT ""
3330 PRINT "PRESS <RETURN> OR <ENTER> TO CONTINUE.";:INPUT QR
3340 IF QR=0 THEN GOTO 3350
3350 CLS:PRINT "THE PROJECTILE ON WHICH THE G1 TABLES ARE SPECIFICALLY BASED IS"
3360 PRINT "A FLAT-BASE, POINTED PROJECTILE OF LENGTH 3.28 TIMES ITS DIAMETER,"
3370 PRINT "HAVING A TANGENT OGIVE THAT IS 1.32 CALIBERS IN AXIAL LENGTH. IT HAS"
3380 PRINT "BEEN FOUND THAT BALLISTIC COEFFICIENTS BASED ON THE G1 DRAG FUNCTION"
3390 PRINT "CAN BE USED FOR ALL CONVENTIONALLY SHAPED SPORTING BULLETS WITH VERY"
3400 PRINT "SATISFACTORY ACCURACY. OTHER DRAG FUNCTIONS HAVE BEEN ESTABLISHED"
3410 PRINT "AND TABULATED FOR MILITARY PROJECTILES THAT ARE EMPLOYED AT VERY"
3420 PRINT "LONG RANGES, WITH CORRESPONDINGLY DIFFERENT BALLISTIC COEFFICIENTS"
3430 PRINT "SUCH AS 'C2', 'C5', 'C7', ETC. WITH VERY FEW EXCEPTIONS, THE DRAG"
3440 PRINT "CHARACTERISTICS OF SPORTING BULLETS HAVE NOT BEEN ESTABLISHED IN"
3450 PRINT "SUFFICIENT DETAIL TO WARRANT THE USE OF THESE OTHER DRAG FUNCTIONS,"
3460 PRINT "AND NO PRACTICALLY SIGNIFICANT IMPROVEMENT IN ACCURACY COULD BE"
3470 PRINT "GAINED BY THEIR USE.  WADCUTTER HANDGUN BULLETS AND ROUND BALLS ARE"
3480 PRINT "RADICALLY DIFFERENT IN SHAPE FROM OTHER SPORTING BULLETS, AND ARE"
3490 PRINT "NOT WELL REPRESENTED BY THE G1 DRAG FUNCTION. FOR THE VERY SHORT"
3500 PRINT "RANGES AT WHICH WADCUTTERS ARE USEFUL, THE ACCURACY OBTAINED BY USE"
3510 PRINT "OF THE C1 BALLISTIC COEFFICIENT IS ACCEPTABLE. ANOTHER PROGRAM ON "
3520 PRINT "THIS DISK IS SPECIFICALLY PROVIDED FOR USE WITH ROUND BALLS.":PRINT ""
3530 PRINT "PRESS <RETURN> OR <ENTER> TO PROCEED WITH YOUR CALCULATIONS.":INPUT QR
3540 IF QR=0 THEN CLS:RETURN

