10 CLS:PRINT TAB(10) "** TRAJECTORIES OF  PROJECTILES  FIRED VERTICALLY UPWARD **":PRINT"":REM CODE 'VTRAJ' - REV 12/01/83 - MSDOS VERSION 04/14/86 REV 02/10/87, 04/24/89, 05/06/89, 05/19,89 **
20 PRINT TAB(20) "COPYRIGHT 1983 BY WM. C. DAVIS, JR.":PRINT ""
30 INPUT "IDENTIFY PROJECTILE OR CARTRIDGE";C$:PRINT""
40 INPUT "ALTITUDE OF GUN (FEET)";HI
45 PRINT: PRINT "PUBLISHED BALLISTIC COEFFICIENTS FOR SPORTING AMMUNITION ARE ASSUMED TO BE"
46 PRINT "BASED ON THE G1 DRAG FUNCTION UNLESS OTHERWISE SPECIFIED.":PRINT
50 PRINT "WHAT DRAG FUNCTION?":PRINT "  G1=G1":PRINT "  G7=G7":PRINT "  SP=SPHERE"
60 INPUT P$
70 IF P$<>"G1" AND P$<>"G7" AND P$<>"SP" THEN PRINT "PLEASE TRY AGAIN":GOTO 50
80 INPUT "PROJECTILE DIAMETER (INCH):";D:PRINT ""
90 INPUT "PROJECTILE WEIGHT (GRAINS):";WG:W=WG/7000
100 IF P$="SP" THEN C=W/D^2:I=1:GOTO 130
110 INPUT "BALLISTIC COEFFICIENT :";C
120 I=W/(C*D^2): REM FORM FACTOR I
130 INPUT "MUZZLE VELOCITY (FT/SEC):";MV
140 ST=25:REM STEP FOR INTEGRATION LOOP - CHANGE IF DESIRED FOR FASTER EXECUTION - 100 FPS UNDERESTIMATES SUMMIT ABOUT 5-10%
150 PRINT "WHAT HARD COPY?":PRINT "  1=FINAL DATA ONLY":PRINT "  2=LINE-BY-LINE DATA":PRINT "  3=NONE":INPUT QA
160 IF QA<>2 THEN GOTO 180
170 PRINT "PRINTOUT AT WHAT VELOCITY INCREMENTS?":PRINT "  25=25 FT/SEC":PRINT "  50=50 FT/SEC":PRINT "  100=100 FT/SEC":INPUT QI
180 CLS
190 IF QA=2 AND QI<>25 AND QI<>50 AND QI<>100 THEN PRINT "WRONG INCREMENT":GOTO 170
200 IF QA=1 OR QA=2 THEN GOSUB 850 : REM LPRINT IDENTIFICATION DATA
210 T=0:H=HI:REM INITIALIZE TIME AND HEIGHT
220 FOR V=MV TO ST STEP -ST:REM START LOOP
230 M=V/1120: REM MACH NUMBER
240 IF P$="G1" THEN GOSUB 570
250 IF P$="G7" THEN GOSUB 670
260 IF P$="SP" THEN GOSUB 760
270 RO=.0005217*(1-3.59596E-05*H+4.7741E-10*H^2):REM DENSITY CORRECTED FOR ALTITUDE
280 AA=-I*KD*RO*D^2*V^2/W: REM AERODYNAMIC DRAG DECELERATION FT/SEC^2
290 A=AA-32.17: REM DECELERATION DUE TO DRAG PLUS WEIGHT
300 U=V-ST: REM VELOCITY AT END OF INCREMENT FT/SEC
310 DH=(U^2-V^2)/(2*A): REM HEIGHT INCREMENT GAINED IN LOOP, FT
320 DT=DH/(V-ST/2):REM TIME INCREMENT SEC
330 H=H+DH: REM SUM HEIGHT INCREMENTS, FT
340 T=T+DT:REM SUM TIME INCREMENTS SEC
350 PRINT "VELOCITY=";:PRINT USING "####";V;
360 PRINT "   TIME=";:PRINT USING "##.##";T;
370 PRINT "   HEIGHT ABOVE GROUND=";:PRINT USING "#####";H-HI;
380 PRINT "   DENSITY=";:PRINT USING ".######";RO
390 N=N+25
400 IF N=QI THEN GOSUB 950
410 NEXT V
420 IF QA=1 OR QA=2 THEN  GOSUB 820 
430 TA=T: REM TAG TIME ASCENDING
440 PRINT ""
450 INPUT "COMPUTE DESCENDING TRAJECTORY? (1=YES 2=NO)";QB
460 IF QB<>1 THEN CLS:GOTO 560
470 CLS:GOSUB 1000: REM GO DO DESCENDING TRAJECTORY
480 TD=T: REM TAG TIME DESCENDING
490 PRINT "TIME ASCENDING (SEC):";TAB(40);INT(TA+.5)
500 PRINT "TIME DESCENDING (SEC):"TAB(40);INT(TD+.5)
510 PRINT "TOTAL TIME (SEC):";TAB(40);INT(TA+TD+.5):PRINT " "
520 IF QA<>1 AND QA<>2 THEN GOTO 560
530 LPRINT "TIME ASCENDING (SEC):";TAB(40);INT(TA+.5)
540 LPRINT "TIME DESCENDING (SEC):";TAB(40);INT(TD+.5):LPRINT " "
550 LPRINT "TOTAL TIME (SEC):";TAB(40);INT(TA+TD+.5)
560 INPUT "WHAT NEXT? (1=RUN THIS PROGRAM AGAIN  2=RETURN TO MENU)";QNN
562 IF QNN=1 THEN CLS:RUN 30
564 RUN "MENU.BAS"
570 REM *** ROUTINE TO FIND KD1 (CODE 'POLYNM/KD1') ***
580 IF M=<.059 THEN KD=9.986920800000001D-02:RETURN
590 IF M>.059 AND M<=.249 THEN KD=.092991951#+.2748888200000002#*M-3.4642319#*M^2+14.469294#*M^3-20.951858#*M^4:RETURN
600 IF M>.249 AND M<=.839 THEN KD=.12061834#-.25104351#*M+.77422485#*M^2-1.2845148#*M^3+.8355325700000002#*M^4:RETURN
610 IF M>.839 AND M<=1.069 THEN KD=-6.047964100000003D-02+4.5757437#*M-14.35859#*M^2+15.444495#*M^3-5.4131483#*M^4:RETURN
620 IF M>1.069 AND M<=1.63 THEN KD=-5.2655688#+14.573805#*M-14.41555#*M^2+6.347296400000002#*M^3-1.0518008#*M^4:RETURN
630 IF M>1.63 AND M<=2.87 THEN KD=-.025251509#+.6282314300000002#*M-.4641662700000002#*M^2+.13537077#*M^3-.014020406#*M^4:RETURN
640 IF M>2.87 AND M<=3.91 THEN KD=1.0672197#-.916525*M+.36667112#*M^2-.065823587#*M^3+.0044593727#*M^4:RETURN
650 IF M>3.91 AND M<=5! THEN KD=.18558444#+.033763944#*M-.018500767#*M^2+.0037071892#*M^3-.00025511889#*M^4:RETURN
660 IF M>5! THEN KD=((.43150287#+.39932718#*M)^2-1)/M^2:RETURN
670 REM *** ROUTINE TO FIND KD7 (CODE 'POLYNM/KD7') ***
680 IF M=<.055 THEN KD=.046987803#:RETURN
690 IF M>.055 AND M<=.807 THEN KD=.047090974#-4.13736E-03*M+.048467034#*M^2-.13972469#*M^3+.111172*M^4:RETURN
700 IF M>.807 AND M<=.937 THEN KD=94.614383#-448.087*M+795.93921#*M^2-628.2481700000001#*M^3+185.95172#*M^4:RETURN
710 IF M>.937 AND M<=1.087 THEN KD=725.858-2866.4259#*M+4233.6837#*M^2-2771.8976#*M^3+678.9212499999999#*M^4:RETURN
720 IF M>1.087 AND M<=1.8 THEN KD=-.6569010200000001#+2.3506886#*M-2.4325414#*M^2+1.0711299#*M^3-.17312858#*M^4:RETURN
730 IF M>1.8 AND M<=3.93 THEN KD=.3150653900000001#-.22927692#*M+.10046774#*M^2-.0211114*M^3+.0016707016#*M^4:RETURN
740 IF M>3.93 AND M<=4.44 THEN KD=1.4607388#-1.2794659#*M+.4537367400000001#*M^2-.072403838#*M^3+.0043483486#*M^4:RETURN
750 IF M>4.44 THEN KD=((.90227886#+.154432*M)^2-1)/M^2:RETURN
760 REM *** ROUTINE TO FIND KD OF SPHERE (CODE 'POLYNM/KDS') ***
770 IF M<.46425 THEN KD=.192:RETURN
780 IF M>.46425 AND M<=1.5751 THEN KD=.3198+.2987*(M-1)-.0809*(M-1)^2-.3606*(M-1)^3:RETURN
790 IF M>1.5751 AND M<=4 THEN KD=.3812+.1199*(1/M-1/2.75)-.2375*(1/M-1/2.75)^2:RETURN
800 IF M>4 THEN KD=-.01*M+.40450811#:RETURN
810 REM *** ROUTINE TO LPRINT RESULTS ***
820 LPRINT""
830 LPRINT "MAXIMUM HEIGHT OF TRAJECTORY (FT):";TAB(40);INT(H-HI+.5)
840 LPRINT "TIME TO SUMMIT OF TRAJECTORY (SEC):";TAB(40);INT(100*T+.5)/100:LPRINT " ":LPRINT " ":RETURN
850 LPRINT "PROJECTILE TYPE: ";C$:LPRINT " "
860 LPRINT "ALTITUDE OF GUN (FT):";TAB(40);HI
870 LPRINT "PROJECTILE DIAMETER (INCH):";TAB(40);:LPRINT USING "#.###";D
880 LPRINT "PROJECTILE WEIGHT (GRAINS):";TAB(40);WG
890 LPRINT "DRAG FUNCTION (PROJECTILE TYPE):";TAB(40);P$
900 LPRINT "BALLISTIC COEFFICIENT (C):";TAB(40);INT(1000*C+.49)/1000
910 LPRINT "MUZZLE VELOCITY (FT/SEC):";TAB(40);MV
920 LPRINT " ":LPRINT " "
930 LPRINT TAB(20); "ASCENDING TRAJECTORY":LPRINT " ":LPRINT " "
940 RETURN
950 REM *** ROUTINE FOR VELOCITY-INCREMENT PRINTOUT ***
960 LPRINT "VELOCITY=";:LPRINT USING "####";V;
970 LPRINT "   TIME=";:LPRINT USING "##.##";T;
980 LPRINT "   HEIGHT ABOVE GROUND=";:LPRINT USING "#####";H-HI
990 N=0:RETURN
1000 REM *** PROGRAM FOR DESCENDING TRAJECTORY ***
1010 PRINT "WHAT HARD COPY?":PRINT "  1=FINAL DATA ONLY":PRINT "  2=LINE-BY-LINE DATA":PRINT "  3=NONE":INPUT QA:PRINT "":CLS
1020 IF QA=2 THEN PRINT "PRINTOUT AT WHAT TIME INCREMENTS?":PRINT " "
1030 IF QA=2 THEN PRINT "INCREMENT MUST BE IN SECONDS AND/OR TENTHS, EXACTLY -":PRINT " "
1040 IF QA=2 THEN PRINT "   FOR EXAMPLE - '.1', OR '.5', OR '1.0' OR '2.0'":PRINT " "
1050 IF QA=2 THEN INPUT TI:PRINT " "
1060 IF 10*TI<>INT(10*TI) THEN PRINT "WRONG INCREMENT":GOTO 1030
1070 IF QA=1 OR QA=2 THEN LPRINT TAB(20); "DESCENDING TRAJECTORY":LPRINT " ":LPRINT " "
1080 IF P$="SP" THEN GOTO 1130
1090 PRINT "ASSUME WHICH?":PRINT "  TU=BULLET TUMBLES ON RETURN":PRINT "  BF=BULLET FALLS BASE-FIRST (STABLE)":PRINT "  PF=BULLET FALLS POINT-FIRST (STABLE)":INPUT Q$
1100 IF Q$="BF" AND QA=1 OR Q$="BF" AND QA=2 THEN LPRINT TAB(20);"(BULLET RETURNING STABLE BASE-FIRST)":LPRINT " "
1110 IF Q$="PF" AND QA=1 OR Q$="PF" AND QA=2 THEN LPRINT TAB(20);"(BULLET RETURNING STABLE POINT-FIRST)":LPRINT ""
1120 IF Q$="TU" THEN GOSUB 1580: REM GO FIND EFFECTIVE DIAM OF TUMBLING BULLET
1130 S=H:A=32.17:T=0:V=0:KD=.192:I=1:N=0: REM INITIALIZE VARIABLES
1140 WHILE A>0 AND H>HI: REM UNTIL DRAG EQUALS WEIGHT OR BULLET STRIKES SURFACE
1150 DT=.1 : REM INCREMENT TIME BY .1 SEC
1160 T=T+DT: REM SUM TIME INCREMENTS
1170 DV=A*DT: REM VELOCITY INCREMENT
1180 V=V+DV: REM SUM VELOCITY INCREMENTS
1190 DH=(V-DV/2)*DT: REM SPACE INCREMENT
1200 H=H-DH: REM DECREMENT HEIGHT BY SPACE INCREMENT
1210 RO=.0005217*(1-3.59596E-05*H+4.7741E-10*H^2): REM DENSITY AT HEIGHT H
1220 M=V/1120:REM MACH NUMBER
1230 IF Q$="PF" THEN GOSUB 570 ELSE GOSUB 760:REM GO FIND KD
1240 FD=I*KD*RO*D^2*V^2: REM AERODYNAMIC DRAG FORCE (POUNDALS) AT VELOCITY V
1250 FG=32.17*W: REM GRAVITATIONAL FORCE (POUNDALS)
1260 A=(FG-FD)/W: REM NET ACCELERATION (FT/SEC/SEC)
1270 PRINT "VELOCITY=";:PRINT USING "####";V;
1280 PRINT "   TIME=";:PRINT USING "##.##";T;
1290 PRINT "   HEIGHT ABOVE GROUND=";:PRINT USING "#####";H-HI
1300 IF QA=2 THEN GOSUB 1530: REM LPRINT RUNNING PRINTOUT
1310 WEND
1320 WHILE H>HI: REM UNTIL BULLET STRIKES SURFACE (IF NOT YET)
1330 DT=.1: REM TIME INCREMENT
1340 T=T+DT: REM RESUME SUMMING TIME INCREMENTS
1350 DH=V*DT: REM SPACE INCREMENT AT CONSTANT TERMINAL VELOCITY
1360 H=H-DH: REM DECREMENT HEIGHT
1370 PRINT "VELOCITY=";:PRINT USING "####";V;
1380 PRINT "   TIME=";:PRINT USING "##.##";T;
1390 PRINT "   HEIGHT ABOVE GROUND=";:PRINT USING "#####";H-HI
1400 IF QA=2 THEN GOSUB 1530: REM LPRINT RUNNING PRINTOUT
1410 WEND
1420 IF H<0 THEN H=0
1430 EN=WG*V^2/450400!:REM ENERGY AT IMPACT (FT-LBS)
1440 PRINT " "
1450 PRINT "TERMINAL VELOCITY:";TAB(40);INT(V+.5);" FT/SEC"
1460 PRINT "ENERGY AT IMPACT:";TAB(40);:PRINT USING "###.###";EN;:PRINT " FT-LBS"
1470 LPRINT " "
1480 IF QA<>1 AND QA<>2 THEN GOTO 1520
1490 LPRINT "TERMINAL VELOCITY (FT/SEC):";TAB(40);INT(V+.5)
1500 LPRINT "ENERGY AT IMPACT (FT-LBS):";TAB(40);:LPRINT USING "###.###";EN
1510 LPRINT "TIME OF DESCENT (SEC):";TAB(40);INT(T+.5):LPRINT " "
1520 RETURN
1530 REM *** RUNNING LPRINT ROUTINE DESCENDING ***
1540 N=N+1
1550 IF INT(N)<>INT(10*TI) THEN RETURN
1560 LPRINT "VELOCITY=";INT(V+.5);TAB(22);"HEIGHT ABOVE GROUND=";INT(H-HI+.5);TAB(55);"TIME=";INT(10*T+.005)/10
1570 N=0:RETURN
1580 REM *** SUBROUTINE TO FIND SURFACE AREA OF BULLET AND DIAMETER OF SPHERE HAVING SAME AREA ***
1590 INPUT "LENGTH OF BULLET (INCH)";L1
1600 INPUT "AXIAL LENGTH OF OGIVE (INCH)";L2
1610 INPUT "DIAMETER OF MEPLAT (FLAT NOSE) IN INCHES";DM : RM=DM/2
1620 IF QA=1 OR QA=2 THEN LPRINT TAB(20);"(BULLET TUMBLING ON RETURN)":LPRINT " "
1630 IF QA=1 OR QA=2 THEN LPRINT "LENGTH OF BULLET:";TAB(40);L1
1640 IF QA=1 OR QA=2 THEN LPRINT "AXIAL LENGTH OF OGIVE:";TAB(40);L2
1650 IF QA=1 OR QA=2 THEN LPRINT "MEPLAT DIAMETER (FLAT NOSE):";TAB(40);DM:LPRINT " "
1660 RB=D/2
1670 RX=RB-RM
1680 RR=(L2^2+RX^2)/(2*RX) : REM OGIVAL RADIUS
1690 FOR X=.1*L2 TO L2 STEP .1*L2 : REM SET UP INTEGRATION LOOP
1700 Y=SQR(RR^2-X^2)
1710 DY=RR-Y
1720 RI=RB-DY : REM RADIUS OF INCREMENT
1730 DI=2*RI : REM DIAMETER OF INCREMENT
1740 CI=3.14159*DI : REM CIRCUMFERENCE OF INCREMENT
1750 AI= CI*.1*L2 : REM AREA OF CURVED SURFACE OF INCREMENT
1760 SA=SA+AI : REM SUMMATION OF INCREMENTAL AREAS ON OGIVE
1770 NEXT X : REM CLOSE INTEGRATION LOOP
1780 SM=3.14159*(DM/2)^2 : REM AREA OF MEPLAT
1790 SB=3.14159*D*(L1-L2) : REM AREA OF BOURRELET SURFACE
1800 SH=3.14159*(D/2)^2 : REM AREA OF BASE
1810 K=SM+SA+SB+SH : REM SUM OF ALL SURFACE AREAS OF BULLET
1820 PD=SQR(K/3.14159) : REM DIAMETER OF SPHERE OF EQUAL SURFACE AREA (PSUEDO-DIAMETER)
1830 D=PD: REM LET D= EFFECTIVE DIAM OF TUMBLING BULLET FOR DRAG CALCULATIONS TO FOLLOW
1840 RETURN

