'
'  DOOR.BAS Example Program
'

$ERROR ALL ON
$LIB ALL OFF
$LINK "PCL4PB.OBJ"
$INCLUDE "PCL4PB.BI"

'declare variables
DIM Buffer(256+16) AS BYTE
DIM BufSeg AS WORD
DIM Port AS INTEGER
DIM Code AS INTEGER
DIM I AS INTEGER
DIM LibVer AS INTEGER
DIM AnyKey AS STRING

IF COMMAND$ = "" THEN
  PRINT "  Usage: DOOR <Port>"
  PRINT "Example: DOOR 1"
  END
END IF

'Get COM port
Port = VAL(COMMAND$)

'Take over port
BufSeg = 1 + VARSEG(Buffer(0)) + (VARPTR(Buffer(0)) \ 16)
Code = SioRxBuf(Port, BufSeg, %Size256)
IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioRxBuf()"
  Code = SioError(Code)
  STOP
END IF

Code = SioReset(Port, %NORESET)

IF Code < 0 THEN
  PRINT "Error "; Code; " returned from SioReset()"
  Code = SioError(Code)
  STOP
END IF

CLS

PRINT "DOOR 4/18/95.  Port =";Port
PRINT " "
LibVer = SioInfo(ASC("V"))
PRINT "Library Version: "; LibVer \ 16; ".";
PRINT LibVer MOD 16

PRINT "Entering TERMINAL loop..."

DO
  'Anything incoming ?
  Code = SioGetc(Port, 1)
  IF Code = 13 THEN
    PRINT
  ELSEIF Code >= &H20 THEN
    PRINT CHR$(Code);
  END IF
  'Anything to send ?
  AnyKey$ = INKEY$
  IF AnyKey$ <> "" THEN
    'Exit if user types Control-Z
    IF AnyKey$ = CHR$(26) THEN EXIT DO
    Code = SioPutc(Port,ASC(AnyKey$))
  END IF
LOOP

Code = SioDone(Port)

END
                  