'
'
'   --- please read this ! ---
'
'  This source code is in "shrouded" form. It is distributed in this form
'  rather than as an object (.OBJ) file.
'
'  You can compile this code, but you will have to register with us in order
'  to get the normal (commented) PowerBASIC source code with normal variable
'  names.
'




$CPU 8086          
$LIB ALL OFF       
$ERROR ALL OFF     
$OPTIMIZE SIZE     
$COMPILE UNIT      



DEFWRD A-Z

$INCLUDE "zmodem.BI"
$INCLUDE "datetime.BI"
$INCLUDE "term_io.BI"
$INCLUDE "zdate.BI"
$INCLUDE "crc16.BI"
$INCLUDE "crc32.BI"
$INCLUDE "pcl4pb.BI"
$INCLUDE "ascii.BI"
$INCLUDE "zconst.BI"
$INCLUDE "modem_io.BI"
$INCLUDE "arrays.BI"
$INCLUDE "putget.BI"

%ABORT.CHAR  = 24
%ZATTNLEN    = 32
%ZBUFSIZE    = 1024
%MAX.ERRORS  = 5
%CARRIER.TEST = 0
%ZDELAY = 2

%ONE.SEC   =  18
%TWO.SECS  =  36
%HALF.SEC  =   9
%TENTH.SEC =   2

%False = 0
%True  = NOT %FALSE


 DIM UseCrc32 AS SHARED INTEGER
 DIM V20 AS SHARED INTEGER


 DIM V52 AS SHARED INTEGER
 DIM V17 AS SHARED INTEGER
 DIM V71 AS SHARED INTEGER
 DIM V79 AS SHARED LONG
 DIM V78(4) AS SHARED BYTE
 DIM V80 AS SHARED INTEGER
 DIM V81 AS SHARED INTEGER
 DIM V77 AS SHARED INTEGER
 DIM V5(%ZATTNLEN) AS SHARED BYTE
 DIM V33(15) AS SHARED BYTE
 DIM V101 AS SHARED STRING
 DIM V36 AS SHARED WORD
 DIM V32 AS SHARED WORD
 DIM V31 AS SHARED LONG
 DIM V111 AS SHARED LONG
 DIM V110(4) AS SHARED BYTE
 DIM V28 AS SHARED WORD
 DIM V92 AS SHARED INTEGER
 DIM V47 AS SHARED STRING
 DIM V1 AS SHARED STRING
 DIM V61(21) AS SHARED STRING
 DIM V60(4) AS SHARED STRING
 DIM V55 AS SHARED BYTE



 DIM V69 AS SHARED INTEGER
 DIM V107 AS SHARED BYTE
 DIM V76 AS SHARED INTEGER
 DIM V35 AS SHARED LONG
 DIM V53 AS SHARED INTEGER
 DIM V26 AS SHARED INTEGER
 DIM V114 AS SHARED BYTE
 DIM V73(%ZBUFSIZE) AS SHARED BYTE



 DIM V51 AS SHARED INTEGER
 DIM V90 AS SHARED LONG
 DIM V74 AS SHARED INTEGER
 DIM V109(%ZBUFSIZE) AS SHARED BYTE



SUB zmInitialize PUBLIC
V52 = %True
PRINT "zmInitialize"
UseCrc32 = %True
V47 = "0123456789abcdef"
V1 = "Aborted by USER"
V61(0) = "ZRQINIT"
V61(1) = "ZRINIT"
V61(2) = "ZSINIT"
V61(3) = "ZACK"
V61(4) = "ZFILE"
V61(5) = "ZSKIP"
V61(6) = "ZNAK"
V61(7) = "ZABORT"
V61(8) = "ZFIN"
V61(9) = "ZRPOS"
V61(10) = "ZDATA"
V61(11) = "ZEOF"
V61(12) = "ZFERR"
V61(13) = "ZCRC"
V61(14) = "ZCHALLENGE"
V61(15) = "ZCOMPL"
V61(16) = "ZCAN"
V61(17) = "ZFREECNT"
V61(18) = "ZCOMMAND"
V61(19) = "ZSTDERR"
V61(20) = "ZUNKNOWN"
V60(0) = "ZBIN "
V60(1) = "ZHEX "
V60(2) = "ZBIN32"
V60(3) = " "
END SUB



SUB V117(BYVAL V11 AS BYTE, _
            BYVAL V39 AS INTEGER, _
            BYVAL V49 AS INTEGER,_
                  V45() AS BYTE) PRIVATE
 DIM I AS INTEGER
 DIM V95 AS STRING
 IF V39 > 20 THEN V39 = 20
 V95 = CHR$(V11)
 V95 = V95 + ":"
 IF V39 < 0 THEN
   SELECT CASE V39
     CASE -42
       V95 = V95 + "MESSED_UP"
     CASE -41:
       V95 = V95 + "ZNOCARRIER"
     CASE -40:
       V95 = V95 + "ZERROR"
     CASE -1:
       V95 = V95 + "ZTIMEOUT"
   END SELECT
 ELSE
   IF V20 <> 0 THEN
     IF (V49>=%ZBIN) AND (V49<=%ZBIN32) THEN
       V95 = V95 + V60(V49-65) + " " + V61(V39) + " ("
       FOR I=0 TO 3
          V95 = V95 + STR$(V45(I))
          IF I<3 THEN
            V95 = V95 + ","
          ELSE
            V95 = V95 + ")"
          END IF
       NEXT I
     END IF
   END IF
 END IF
 IF LEN(V95) > 2 THEN
    CALL WriteMsg(V95)
 END IF
END SUB



SUB V132(BYVAL V100 AS BYTE) PRIVATE
 DIM V4 AS BYTE
 DIM V12 AS INTEGER
 V4 = &H7F AND V100
 SELECT CASE V4
    CASE %CR
      IF (&H7F AND V55) <> &H40 THEN
         V55 = V100
      END IF
    CASE %ZDLE,%DLE,%XON,%XOFF
      V12 = CharPut(V71,%ZDLE)
      V55 = &H40 XOR V100
    CASE ELSE
      V55 = V100
 END SELECT
 V12 = CharPut(V71,V55)
END SUB



FUNCTION V116(BYVAL V44 AS INTEGER) PRIVATE AS DWORD
DIM I AS INTEGER
DIM N AS INTEGER
DIM V30(%ZBUFSIZE) AS BYTE
DIM V15 AS DWORD
DIM V8 AS INTEGER
 V15 = &HFFFFFFFF???
 SEEK V44,0
 V8 = LOF(V44)
 FOR I = 0 to V8 - 1
    GET V44, ,V30(I)
    V15 = UpdateCrc32(V30(I),V15)
 NEXT I
 SEEK V44, 0
 V116 = V15
END FUNCTION



FUNCTION V115 PRIVATE AS INTEGER
  
  V115 = 1
END FUNCTION



FUNCTION V120(BYVAL V105 AS INTEGER) PRIVATE AS INTEGER
DIM R AS INTEGER
DO
  IF V115 = 0 THEN
    V120 = %RCDO
    EXIT FUNCTION
  END IF
  R = CharGet(V71,1)
  IF R < -1 THEN
    CALL WriteIntMsg("ERROR",R)
    V120 = R
    EXIT FUNCTION
  END IF
  IF R >= 0 THEN
    V120 = R
    EXIT FUNCTION
  END IF
  V105 = V105 - 1
  IF V105 <= 0 THEN
    V120 = %ZTIMEOUT
    EXIT FUNCTION
  END IF
LOOP
END FUNCTION



FUNCTION  V125 PRIVATE AS INTEGER
 DIM C AS INTEGER
 DO
   C = V120(V80)
   IF C < 0 THEN
     V125 = C
     EXIT FUNCTION
   END IF
   C = C AND &H7F
   IF (C <> %XON) AND (C <> %XOFF) THEN
     V125 = C
     EXIT FUNCTION
   END IF
 LOOP
END FUNCTION



SUB V143 PRIVATE
 DIM N AS INTEGER
 DIM V12 AS INTEGER
 V12 = SioTxFlush(V71)
 FOR N=1 TO 8
   V12 = CharPut(V71,%CAN)
   V12 = SioDelay(%TENTH.SEC)
 NEXT N
 FOR N=1 TO 10
   V12 = CharPut(V71,%BS)
 NEXT N
END SUB



SUB V131(StrArray() AS BYTE) PRIVATE
DIM I AS INTEGER
DIM V12 AS INTEGER
WHILE (I < %ZBUFSIZE) AND (StrArray(I)  <>  0)
   SELECT CASE  StrArray(I)
       CASE 221
         V12 = SioBrkSig(V71,ASC("A"))
       CASE 222
         V12 = SioDelay(%TWO.SECS)
       CASE ELSE
         V12 = CharPut(V71,StrArray(I))
         I = I + 1
   END SELECT
WEND
END SUB



SUB V129(BYVAL V100 AS BYTE) PRIVATE
DIM V12 AS INTEGER
DIM V50 AS INTEGER
DIM C AS BYTE
  V50 = 1 + (&H000F AND (V100 \ 16))
  C = ASC(MID$(V47, V50, 1))
  V12 = CharPut(V71,C)
  V50 = 1 + (&H000F AND V100)
  C = ASC(MID$(V47, V50, 1))
  V12 = CharPut(V71,C)
END SUB



SUB V149(BYVAL V48 AS INTEGER, _
                          V45() AS BYTE) PRIVATE
 DIM I AS INTEGER
 DIM V15 AS WORD
 DIM V12 AS INTEGER
 CALL V117(ASC("S"),V48,%ZHEX,V45())
 V12 = CharPut(V71,%ZPAD)
 V12 = CharPut(V71,%ZPAD)
 V12 = CharPut(V71,%ZDLE)
 V12 = CharPut(V71,%ZHEX)
 CALL V129(V48)
 V15 = UpdateCrc16(V48,0)
 
 FOR I = 0 TO 3
    CALL V129(V45(i))
    V15 = UpdateCrc16(V45(i),V15)
 NEXT I
 V15 = UpdateCrc16(0,V15)
 V15 = UpdateCrc16(0,V15)
 
 CALL V129(&H00FF AND (V15 \ 256))
 CALL V129(&H00FF AND V15)
 V12 = CharPut(V71,%CR)
 V12 = CharPut(V71,%LF)
 IF (V48  <>  %ZFIN) AND (V48  <>  %ZACK) THEN
      V12 = CharPut(V71,%XON)
 END IF
 IF V115 = 0 THEN
      V12 = SioTxFlush(V71)
 END IF
END SUB



FUNCTION V124(V45() AS BYTE) PRIVATE AS LONG
 DIM V57 AS LONG
 V57 = V45(%ZP3)
 V57 = (V57 * 256) OR V45(%ZP2)
 V57 = (V57 * 256) OR V45(%ZP1)
 V57 = (V57 * 256) OR V45(%ZP0)
 V124 = V57
END FUNCTION



SUB V130(BYVAL V57 AS LONG) PRIVATE
 V110(%ZP0) = V57
 V57 = V57 \ 256
 V110(%ZP1) = V57
 V57 = V57 \ 256
 V110(%ZP2) = V57
 V57 = V57 \ 256
 V110(%ZP3) = V57
END SUB



FUNCTION V127 PRIVATE AS INTEGER
DIM C AS INTEGER
 
getzdl100:
 IF V115 = 0 THEN
    V127 = %RCDO
    EXIT FUNCTION
 END IF
 C = V120(V80)
 IF C < 0  THEN
   V127 = C
   EXIT FUNCTION
 END IF
 SELECT CASE C
   CASE %ZDLE
      EXIT SELECT
   CASE %XON, %XOFF
      GOTO getzdl100
   CASE ELSE
      V127 = C
      EXIT FUNCTION
 END SELECT
 
getzdl200:
  IF V115 = 0 THEN
    V127 = %RCDO
    EXIT FUNCTION
  END IF
  
  C = V120(V80)
  IF C < 0 THEN
    V127 = C
    EXIT FUNCTION
  END IF
  IF C = %CAN THEN
    
    C = V120(V80)
    IF C < 0 THEN
      V127 = C
      EXIT FUNCTION
    END IF
    IF C = %CAN THEN
       
       C = V120(V80)
       IF C < 0 THEN
         V127 = C
         EXIT FUNCTION
       END IF
       IF C = %CAN THEN
          
          C = V120(V80)
          IF C < 0 THEN
             V127 = C
             EXIT FUNCTION
          END IF
       END IF
    END IF
 END IF
 
 SELECT CASE C
    CASE %CAN
        
        V127 = %GOTCAN
        EXIT FUNCTION
    CASE %ZCRCE,%ZCRCG,%ZCRCQ,%ZCRCW
        
        V127 = C OR %GOTOR
        EXIT FUNCTION
    CASE %ZRUB0
        
        V127 = &H007F
        EXIT FUNCTION
     CASE %ZRUB1
        
        V127 = &H00FF
        EXIT FUNCTION
     CASE %XON, %XOFF
        GOTO getzdl200
     CASE ELSE
        IF (&H60 AND C) = &H40 THEN
           V127 = &H40 XOR C
           EXIT FUNCTION
        END IF
 END SELECT
 CALL WriteHexMsg("Bad escape sequence ",C)
 V127 = %ZERROR
END FUNCTION



FUNCTION V122 PRIVATE AS INTEGER
 DIM C AS INTEGER
 DIM N AS INTEGER
 N = V125
 IF N < 0 THEN
    V122 = N
    EXIT FUNCTION
 END IF
 N = N - &H30
 IF N > 9 THEN N = N - 39
 IF (&HFFF0 AND N)  <>  0 THEN
    V122 = %ZERROR
    EXIT FUNCTION
 END IF
 C = V125
 IF C < 0 THEN
    V122 = C
    EXIT FUNCTION
 END IF
 C = C - &H30
 iF C > 9 THEN C = C - 39
 IF (&HFFF0 AND C) THEN
    V122 = %ZERROR
    EXIT FUNCTION
 END IF
 SHIFT LEFT N, 4
 V122 = N OR C
END FUNCTION



FUNCTION V123(V45() AS BYTE) PRIVATE AS INTEGER
 DIM V15 AS WORD
 DIM C AS INTEGER
 DIM N AS INTEGER
 C = V122
 IF C < 0 THEN
    V123 = C
    EXIT FUNCTION
 END IF
 V81 = C
 V15 = UpdateCrc16(V81,0)
 
 FOR N = 0 TO 3
   C = V122
   IF C < 0 THEN
      V123 = C
      EXIT FUNCTION
   END IF
   V45(N) = (&H00FF AND C)
   V15 = UpdateCrc16(&H00FF AND C,V15)
 NEXT N
 
 C = V122
 IF C < 0 THEN
    V123 = C
    EXIT FUNCTION
 END IF
 V15 = UpdateCrc16(&H00FF AND C, V15)
 C = V122
 IF C < 0 THEN
    V123 = C
    EXIT FUNCTION
 END IF
 V15 = UpdateCrc16(&H00FF AND C, V15)
 
 IF V15  <>  0 THEN
    V28 = V28 + 1
    CALL WriteIntMsg("CRC Error(1)=",V28)
    V123 = %ZERROR
    EXIT FUNCTION
 END IF
 IF V120(1) = %CR THEN
    C = V120(1)
 END IF
 V123 = V81
END FUNCTION



FUNCTION V119(V45() AS BYTE) PRIVATE AS INTEGER
 DIM V15 AS DWORD
 DIM C AS INTEGER
 DIM N AS INTEGER
 C = V127
 IF c < 0  THEN
    V119 = C
 END IF
 V81 = C
 V15 = &HFFFFFFFF???
 V15 = UpdateCrc32(V81,V15)
 
 FOR N = 0 TO 3
    C = V127
    IF (C \ 256) THEN
       V119 = C
       EXIT FUNCTION
    END IF
    V45(N) = &H00FF AND C
    V15 = UpdateCrc32(&H00FF AND C,V15)
 NEXT N
 
 FOR N = 0 TO 3
    C = V127
    IF (C \ 256) THEN
       V119 = C
       EXIT FUNCTION
    END IF
    V15 = UpdateCrc32(&H00FF AND C,V15)
 NEXT N
 
 IF V15 <> &HDEBB20E3??? THEN
    V28 = V28 + 1
    CALL WriteIntMsg("CRC Error(3)=",V28)
    V119 = %ZERROR
    EXIT FUNCTION
 END IF
 V119 = V81
END FUNCTION



FUNCTION V118(V45() AS BYTE) PRIVATE AS INTEGER
 DIM V15 AS WORD
 DIM C AS INTEGER
 DIM N AS INTEGER
 C = V127
 IF C < 0 THEN
    V118 = C
    EXIT FUNCTION
 END IF
 V81 = C
 V15 = UpdateCrc16(V81,0)
 
 FOR N = 0 TO 3
    C = V127
    IF (C \ 256) <> 0 THEN
       V118 = C
       EXIT FUNCTION
    END IF
    V45(N) = &H00FF AND C
    V15 = UpdateCrc16(&H00FF AND C,V15)
 NEXT N
 
 C = V127
 IF (C \ 256) <> 0 THEN
    V118 = C
    EXIT FUNCTION
  END IF
 V15 = UpdateCrc16(&H00FF AND C,V15)
 C = V127
 IF (C \ 256) THEN
    V118 = C
    EXIT FUNCTION
 END IF
 V15 = UpdateCrc16(&H00FF AND C,V15)
 
 IF V15 <> 0 THEN
    V28 = V28 + 1
    CALL WriteIntMsg("CRC Error(2)=",V28)
    V118 = 0
    EXIT FUNCTION
 END IF
 V118 = V81
END FUNCTION


FUNCTION V121(V45() AS BYTE) PRIVATE AS INTEGER
 DIM I AS INTEGER
 DIM C AS INTEGER
 DIM N AS INTEGER
 DIM CANcount AS INTEGER
 DIM AnyKey AS STRING
 N = 32
 CANcount = 5
V2:
 AnyKey = INKEY$
 IF AnyKey <> "" THEN
   IF AnyKey = CHR$(%ABORT.CHAR) THEN
      CALL V143
      CALL WriteMsg("Cancelled by USER")
      V121 = %ZCAN
      EXIT FUNCTION
   END IF
 END IF
 V77 = 0
 V81 = 0
 
 C = V125
 SELECT CASE C
    CASE %ZPAD
    CASE %RCDO,%ZTIMEOUT
        GOTO V23
    CASE %CAN
got.can:
        CANcount = CANcount - 1
        IF CANcount < 0 THEN
           C = %ZCAN
           GOTO V23
        END IF
        C = V120(1)
        SELECT CASE C
           CASE %ZTIMEOUT
               GOTO V2
           CASE %ZCRCW
               C = %ZERROR
               GOTO V23
            CASE %RCDO
               GOTO V23
            CASE %CAN
               CANcount = CANcount - 1
               IF CANcount < 0 THEN
                  C = %ZCAN
                  GOTO V23
               END IF
               GOTO V2
            CASE ELSE
               

           END SELECT

     CASE ELSE
        
again2:
        N = N - 1
        IF N < 0 THEN
           V28 = V28 + 1
           CALL WriteIntMsg("Header is unrecognizable. Errors=",V28)
           V121 = %ZCAN
           EXIT FUNCTION
        END IF
        IF C <> %CAN THEN CANcount = 5
        
        GOTO V2
    END SELECT
    
    CANcount = 5
V89:
   C = V125
   SELECT CASE C
     CASE %ZDLE

     CASE %ZPAD
         
         GOTO V89
      CASE %RCDO, %ZTIMEOUT
         GOTO V23
      CASE ELSE
         GOTO again2
   END SELECT
   
   C = V125
   SELECT CASE C
      CASE %ZBIN32
         V77 = %ZBIN32
         C = V119(V45())

       CASE %ZBIN
          V77 = %ZBIN
          C = V118(V45())

       CASE %ZHEX
          V77 = %ZHEX
          C = V123(V45())

       CASE %CAN
          GOTO got.can
       CASE %RCDO, %ZTIMEOUT
          GOTO V23
       CASE ELSE
          GOTO again2
   END SELECT
   
   V79 = V124(V45())
V23:
   CALL V117(ASC("R"),C,V77,V45())
   V121 = C
END FUNCTION



FUNCTION V134(V9() AS BYTE, _
               BYVAL V6  AS INTEGER) PRIVATE AS INTEGER

 DIM V12 AS INTEGER
 DIM C AS INTEGER
 DIM D AS INTEGER
 DIM N AS INTEGER
 DIM I AS INTEGER
 DIM V15 AS DWORD
 DIM DoneFlag AS INTEGER
 DIM RetValue AS INTEGER
 RetValue = %ZERROR
 V15 = &HFFFFFFFF???
 V76 = 0
 DoneFlag = %False
 DO
    C = V127
    IF (C \ 256) THEN
crcfoo1:
        SELECT CASE  C
            CASE %GOTCRCE, %GOTCRCG, %GOTCRCQ, %GOTCRCW
                  D = C
                  V15 = UpdateCrc32(&H00FF AND C,V15)
                  
                  FOR N = 0 TO 3
                     C = V127
                     IF (C \ 256)  THEN GOTO crcfoo1
                     V15 = UpdateCrc32(&H00FF AND C,V15)
                  NEXT N
                  
                  IF V15 <> &HDEBB20E3??? THEN
                     V28 = V28 + 1
                     CALL WriteIntMsg("CRC Error(4)=",V28)
                     RetValue = %ZERROR
                  ELSE
                     RetValue = D
                  END IF
                  DoneFlag = %True

               CASE %GOTCAN
                  RetValue = %ZCAN
                  DoneFlag = %True

               CASE %ZTIMEOUT:
                  RetValue = C
                  DoneFlag = %True

               CASE %RCDO:
                  RetValue = C
                  DoneFlag = %True

               CASE ELSE
                  CALL WriteIntMsg("Garbage(1) = ",C)
                  V12 = SioDelay(%HALF.SEC)
                  V12 = SioRxFlush(V71)
                  RetValue = C
                  DoneFlag = %True
              END SELECT
    END IF
    
    IF NOT DoneFlag THEN
       V6 = V6 - 1
       IF V6 < 0 THEN
           CALL WriteMsg("Long packet")
           RetValue = %ZERROR
           DoneFlag = %True
       END IF
       V9(V76) = (&H00FF AND C)
       V76 = V76 + 1
       V15 = UpdateCrc32(&H00FF AND C,V15)
    END IF
  LOOP WHILE (NOT DoneFlag)
  V134 = RetValue
END FUNCTION



FUNCTION V137(V9() AS BYTE, _
                 BYVAL V6  AS INTEGER) PRIVATE AS INTEGER
 DIM I AS INTEGER
 DIM C AS INTEGER
 DIM D AS INTEGER
 DIM V12 AS INTEGER
 DIM V15 AS WORD
 DIM DoneFlag AS INTEGER
 DIM RetValue AS INTEGER
 RetValue = %ZERROR
 IF V77 = %ZBIN32 THEN
     V137 = V134(V9(),V6)
     EXIT FUNCTION
 END IF
 V15 = 0
 V76 = 0
 DoneFlag = %False
 DO
    C = V127
    IF (C \ 256) THEN
crcfoo2:
         SELECT CASE C
            CASE %GOTCRCE,%GOTCRCG,%GOTCRCQ,%GOTCRCW
                D = C
                V15 = UpdateCrc16(&H00FF AND C,V15)
                
                C = V127
                IF (C \ 256) THEN GOTO crcfoo2
                V15 = UpdateCrc16(&H00FF AND C,V15)
                C = V127
                IF (C \ 256)  THEN GOTO crcfoo2
                V15 = UpdateCrc16(&H00FF AND C,V15)
                
                IF V15 <> 0 THEN
                   V28 = V28 + 1
                   CALL WriteIntMsg("CRC Error(5)=",V28)
                   RetValue = %ZERROR
                   DoneFlag = %True
                END IF
                RetValue = D
                DoneFlag = %True

             CASE %GOTCAN
                CALL WriteMsg("Received CAN")
                RetValue = %ZCAN
                DoneFlag = %True

             CASE %ZTIMEOUT
                RetValue = C
                DoneFlag = %True

             CASE %RCDO
                CALL WriteMsg("Lost carrier")
                RetValue = C
                DoneFlag = %True

             CASE ELSE
                CALL WriteHexMsg("Garbage(2) = ",C)
                V12 = SioDelay(%HALF.SEC)
                V12 = SioRxFlush(V71)
                RetValue = C
                DoneFlag = %True

         END SELECT
     END IF
     IF NOT DoneFlag THEN
        V6 = V6 - 1
        IF V6 < 0 THEN
            CALL WriteMsg("Long packet")
            RetValue = %ZERROR
            DoneFlag = %True
         END IF
         V9(V76) = &H00FF AND C
         V76 = V76 + 1
         V15 = UpdateCrc16(&H00FF AND C,V15)
     END IF
 LOOP WHILE (NOT DoneFlag)
 V137 = RetValue
END FUNCTION



SUB V82 PRIVATE
 DIM N AS INTEGER
 DIM I AS INTEGER
 DIM V12 AS INTEGER
 CALL V130(V79)
 N = 4
 V12 = SioDelay(%ZDELAY)
 V12 = SioRxFlush(V71)
 DO
     CALL V149(%ZFIN,V110())
     SELECT CASE  V120(%TWO.SECS)
         CASE %ZTIMEOUT:
         CASE %RCDO:
            EXIT SUB
         CASE 79:
            
            V12 = SioDelay(%HALF.SEC)
            V12 = SioRxFlush(V71)
            EXIT SUB
         CASE ELSE
            V12 = SioDelay(%HALF.SEC)
            V12 = SioRxFlush(V71)
            N = N - 1
      END SELECT
    LOOP WHILE (N > 0)
END SUB



FUNCTION V84 PRIVATE AS INTEGER
 DIM C AS INTEGER
 DIM N AS INTEGER
 DIM M AS INTEGER
 DIM Errors AS INTEGER
 DIM Flags AS BYTE
 FOR N=0 TO %ZATTNLEN-1
    V5(N) = 0
 NEXT N
 V28 = 0
 Errors = 0
 FOR M = 0 TO 10
     N = 10 - M
     IF V115 = 0 THEN
         CALL WriteMsg("Lost carrier")
         V84 =  %ZERROR
         EXIT FUNCTION
      END IF
      CALL V130(0)
      IF V17 THEN
        Flags = (%CANFDX OR %CANOVIO OR %CANFC32 OR %CANBRK)
        CALL WriteMsg("Set CRC 32")
      ELSE
        Flags = (%CANFDX OR %CANOVIO OR %CANBRK)
        CALL WriteMsg("Set CRC 16")
      END IF
      V110(%ZF0) = Flags
      CALL V149(V107,V110())
      IF V107 = %ZSKIP THEN
         V107 = %ZRINIT
      END IF
again3:
      C = V121(V78())
      SELECT CASE C
         CASE %ZFILE
             V114 = V78(%ZF0)
             V107 = %ZRINIT
             C = V137(V73(),%ZBUFSIZE)
             IF C = %GOTCRCW THEN
                V84 = %ZFILE
                EXIT FUNCTION
             END IF
             CALL V149(%ZNAK,V110())
             GOTO again3
          CASE %ZSINIT
             C = V137(V5(),%ZATTNLEN)
             IF C = %GOTCRCW THEN
               CALL V149(%ZACK,V110())
             ELSE
               CALL V149(%ZNAK,V110())
             END IF
             GOTO again3
          CASE %ZFREECNT
             
             CALL V130(0)
             CALL V149(%ZACK,V110())
             GOTO again3
          CASE %ZCOMMAND
             C = V137(V73(),%ZBUFSIZE)
             IF C = %GOTCRCW THEN
                 CALL V130(0)
                 DO
                    CALL V149(%ZCOMPL,V110())
                    Errors = Errors + 1
                 LOOP WHILE (Errors <= %MAX.ERRORS) AND (V121(V78()) <> %ZFIN)
                 CALL V82
                 V84 = %ZCOMPL
                 EXIT FUNCTION
             END IF
             CALL V149(%ZNAK,V110())
             GOTO again3
          CASE %ZCOMPL, %ZFIN
             V84 = %ZCOMPL
             EXIT FUNCTION
          CASE %ZCAN, %RCDO
             V84 = C
             EXIT FUNCTION
      END SELECT
 NEXT M
 CALL WriteMsg("Timed out")
 V84 = %ZERROR
END FUNCTION


FUNCTION V83 PRIVATE AS INTEGER
ON LOCAL ERROR GOTO GetHeaderTrap
 DIM I AS INTEGER
 DIM P AS INTEGER
 DIM C AS BYTE
 DIM V103 AS STRING
 DIM V102 AS LONG
 DIM V95 AS STRING
 V53 = %True
 V31 = 0
 V103 = ""
 
 P = 0
 DO
    C = V73(P)
    IF C <> 0 THEN
      V103 = V103 + UCASE$(CHR$(C))
      P = P + 1
    END IF
 LOOP WHILE (P < %ZBUFSIZE) AND (C <> 0)
 P = P + 1
 
 CALL String2Array(V103,V33())
 V101 = V103

 V103 = "Receiving <" + V101 + ">"
 WriteMsg(V103)

 
 V31 = 0
 DO
    C = V73(P)
    IF (C=%SP) OR (C=0) THEN EXIT DO
    V31 = (10 * V31) + (C - &H30)
    P = P + 1
 LOOP WHILE ((P < %ZBUFSIZE) AND (C <> 0) AND (C <> %SP))
 P = P + 1
 
 V103 = ""
 DO
   C = V73(P)
   P = P + 1
   IF (C<&H30) OR (C>&H37) THEN EXIT DO
   V103 = V103 + CHR$(C)
 LOOP WHILE ((P < %ZBUFSIZE) AND (C <> 0) AND (C <> %SP))
 P = P + 1
 CALL Z2DosDate(V103,V32,V36)
 
 IF DIR$(V101) <> "" THEN
   
   V69 = FREEFILE
   OPEN V101 FOR BINARY ACCESS WRITE AS V69
   V102 = LOF(V69)
   IF (V114 = %ZCRESUM) AND (V31 > V102) THEN
      V35 = V102
      
      SEEK V69, LOF(V69)
      CALL WriteLongMsg("Recovering to",V35)
   ELSE
      CLOSE V69
      V95 = V101 + " is already complete"
      CALL WriteMsg(V95)
      V83 = %ZSKIP
      EXIT FUNCTION
   END IF
 ELSE
   
   V35 = 0
   V69 = FREEFILE
   OPEN V101 FOR BINARY ACCESS WRITE AS V69
 END IF
 CALL WriteLongMsg("Size=",V31)
 V83 = %ZOK

GetHeaderExit:
 EXIT FUNCTION

GetHeaderTrap:
  SELECT CASE ERR
    CASE 53
      V95 = "Cannot open " + V101
      CALL WriteMsg(V95)
    CASE ELSE
      PRINT "RzmGetHeader Error: ("; ERR; ")"
    END SELECT
    V83 = %FALSE
    RESUME GetHeaderExit
END FUNCTION




FUNCTION V85(V75 AS LONG) PRIVATE AS INTEGER
ON LOCAL ERROR GOTO SaveToDiskTrap
 DIM I AS INTEGER
 DIM RetValue AS INTEGER
 DIM AnyKey AS STRING
 AnyKey = INKEY$
 IF AnyKey <> "" THEN
   IF AnyKey = CHR$(%ABORT.CHAR) THEN
      CALL WriteMsg(V1)
      CALL V143
   END IF
 END IF
 FOR I = 0 TO V76-1
   PUT V69, ,V73(I)
 NEXT I
 RetValue = %ZOK
 V75 = V75 + V76
 V85 = RetValue

SaveToDiskExit:
EXIT FUNCTION

SaveToDiskTrap:
  SELECT CASE ERR
    CASE ELSE
      PRINT "SaveToDisk Error:  ("; ERR; ")"
    END SELECT
    V85 = %FALSE
    RESUME SaveToDiskExit
END FUNCTION



FUNCTION V138 PRIVATE AS INTEGER
 DIM C AS INTEGER
 DIM N AS INTEGER
 DIM V75 AS LONG
 DIM DoneFlag AS INTEGER
 V28 = 0
 DoneFlag = %False
 V26 = %False
 C = V83
 IF C <> %ZOK THEN
    IF C = %ZSKIP THEN
       V107 = %ZSKIP
    END IF
    V138 = C
    EXIT FUNCTION
 END IF
 C = %ZOK
 N = %MAX.ERRORS
 V75 = V35
 V79 = V35
 DO
    CALL V130(V75)
    CALL V149(%ZRPOS,V110())
V66:
    C = V121(V78())
    SELECT CASE  C
        CASE %ZDATA
            IF V79 <> V75 THEN
                 N = N - 1
                 V28 = V28 + 1
                 CALL WriteIntMsg("POS Error(6)=",V28)
                 IF N < 0 THEN  GOTO got.err
                 CALL WriteMsg("Bad position")
                 CALL V131(V5())
            ELSE
V59:
                 C = V137(V73(),%ZBUFSIZE)
                 SELECT CASE C
                      CASE %ZCAN, %RCDO
                          GOTO got.err
                      CASE %ZERROR
                          N = N - 1
                          V28 = V28 + 1
                          CALL WriteIntMsg("Error",V28)
                          IF N < 0 THEN  GOTO got.err
                          CALL V131(V5())

                      CASE %ZTIMEOUT
                          N = N - 1
                          IF N < 0 THEN GOTO got.err

                      CASE %GOTCRCW
                          N = %MAX.ERRORS
                          C = V85(V75)
                          IF C <> %ZOK THEN
                             V138 = C
                             EXIT FUNCTION
                          END IF
                          CALL WriteLongMsg("ZCRCW: Pos=",V75)
                          CALL V130(V75)
                          CALL V149(%ZACK,V110())
                          GOTO V66
                      CASE %GOTCRCQ
                          N = %MAX.ERRORS
                          C = V85(V75)
                          IF C <> %ZOK THEN
                             V138 = C
                             EXIT FUNCTION
                          END IF
                          CALL WriteLongMsg("ZCRCQ: Pos=",V75)
                          CALL V130(V75)
                          CALL V149(%ZACK,V110())
                          GOTO V59

                      CASE %GOTCRCG
                          N = %MAX.ERRORS
                          C = V85(V75)
                          IF C <> %ZOK THEN
                             V138 = C
                             EXIT FUNCTION
                          END IF
                          CALL WriteLongMsg("ZCRCG: Pos=",V75)
                          GOTO V59

                      CASE %GOTCRCE
                          N = %MAX.ERRORS
                          C = V85(V75)
                          IF C <> %ZOK THEN
                             V138 = C
                             EXIT FUNCTION
                          END IF
                          CALL WriteLongMsg("ZCRCE: Pos=",V75)
                          GOTO V66

                    END SELECT
                END IF 

         CASE %ZNAK, %ZTIMEOUT
            N = N - 1
            IF N < 0 THEN GOTO got.err
            CALL WriteLongMsg("ZNAK: Pos=",V75)

         CASE %ZFILE
            C = V137(V73(),%ZBUFSIZE)

         CASE %ZEOF
            IF V79 = V75 THEN
               V138 = C
               EXIT FUNCTION
            ELSE
               GOTO V66
            END IF

         CASE %ZERROR
            N = N - 1
            IF N < 0 THEN GOTO got.err
            CALL WriteLongMsg("ZERROR: Pos=",V75)
            CALL V131(V5())

         CASE ELSE
            V138 = %ZERROR
            EXIT FUNCTION
      END SELECT
   LOOP WHILE (NOT DoneFlag)
got.err:
   V138 = %ZERROR
END FUNCTION



FUNCTION V136 PRIVATE AS INTEGER
 DIM C AS INTEGER
 DIM V105 AS LONG
 DIM V95 AS STRING
 DIM V44 AS INTEGER
 DIM V12 AS INTEGER
 DO
      IF V115 = 0 THEN
         V136 = %ZERROR
         EXIT FUNCTION
      END IF
      V105 = SioTimer
      C = V138
      close(V69)
      V44 = DosOpen(V101)
      IF V44 > 0 THEN
         CALL SetFileDT(V44,V32,V36)
         V12 = DosClose(V44)
      END IF
      CALL WriteCPS(V105,V31,V33(),(C=%ZSKIP))
      SELECT CASE C
          CASE %ZEOF, %ZSKIP
             C = V84
             SELECT CASE C
                 CASE %ZFILE
                    EXIT SELECT
                 CASE %ZCOMPL
                    CALL V82
                    V136 = %ZOK
                    EXIT FUNCTION
                 CASE ELSE
                    V136 = %ZERROR
                    EXIT FUNCTION
              END SELECT

          CASE ELSE
             V136 = C
         END SELECT
   LOOP
END FUNCTION



FUNCTION V135(BYVAL V70 AS INTEGER) PRIVATE AS INTEGER
 DIM I AS INTEGER
 DIM V12 AS INTEGER
 V71 = V70
 V17 = UseCrc32
 CALL WriteIntMsg("zmReceive: V71 = COM",1+V71)
 V80 = 10 * %ONE.SEC
 V107 = %ZRINIT
 I = V84
 IF (I=%ZCOMPL) OR ((I=%ZFILE) AND (V136 = %ZOK)) THEN
    CALL WriteMsg("Done.")
    V135 = %True
    EXIT FUNCTION
 ELSE
     V12 = SioTxFlush(V71)
     CALL WriteMsg("Sending CAN")
     CALL V143
     CALL WriteMsg("Done.")
     V135 = %False
     EXIT FUNCTION
 END IF
END FUNCTION



SUB V140(BYVAL V48 AS BYTE, _
                    V45() AS BYTE) PRIVATE
DIM V15 AS DWORD
DIM V12 AS INTEGER
 DIM I AS INTEGER
 DIM N AS INTEGER
 CALL V117(ASC("S"),V48,%ZBIN32,V45())
 V12 = CharPut(V71,%ZPAD)
 V12 = CharPut(V71,%ZDLE)
 V12 = CharPut(V71,%ZBIN32)
 CALL V132(V48)
 V15 = &HFFFFFFFF???
 V15 = UpdateCrc32(V48,V15)
 
 FOR N = 0 TO 3
    CALL V132(V45(N))
    V15 = UpdateCrc32(V45(N),V15)
 NEXT N
 V15 = (NOT V15)
 
 FOR N = 0 TO 3
    CALL V132(&H00FF AND V15)
    V15 = (V15 \ 256)
 NEXT N
 IF V48 <> %ZDATA THEN
    V12 = SioDelay(%TENTH.SEC+%ZDELAY)
 END IF
END SUB



SUB V141(BYVAL V48 AS BYTE, _
                    V45() AS BYTE) PRIVATE
 DIM V15 AS WORD
 DIM I AS INTEGER
 DIM N AS INTEGER
 DIM V12 AS INTEGER
 IF V17 THEN
    CALL V140(V48,V45())
    EXIT SUB
 END IF
 CALL V117(ASC("S"),V48,%ZBIN,V45())
 V12 = CharPut(V71,%ZPAD)
 V12 = CharPut(V71,%ZDLE)
 V12 = CharPut(V71,%ZBIN)
 CALL V132(V48)
 V15 = UpdateCrc16(V48,0)
 
 FOR N = 0 TO 3
    CALL V132(V45(N))
    V15 = UpdateCrc16(V45(N),V15)
 NEXT N
 V15 = UpdateCrc16(0,V15)
 V15 = UpdateCrc16(0,V15)
 
 CALL V132(V15 \ 256)
 CALL V132(&H00FF AND V15)
 IF (V48 <> %ZDATA) THEN
   V12 = SioDelay(%TENTH.SEC+%ZDELAY)
 END IF
END SUB



SUB V144(V9() AS BYTE, _
               BYVAL V6 AS INTEGER, _
               BYVAL V38 AS BYTE) PRIVATE
 DIM V15 AS DWORD
 DIM I AS INTEGER
 DIM V12 AS INTEGER
 V15 = &HFFFFFFFF???
 
 FOR I = 0 TO V6-1
    CALL V132(V9(I))
    V15 = UpdateCrc32(V9(I),V15)
 NEXT I
 V15 = UpdateCrc32(V38,V15)
 V15 = (NOT V15)
 V12 = CharPut(V71,%ZDLE)
 V12 = CharPut(V71,V38)
 
 FOR I = 0 TO 3
    CALL V132(&H00FF AND V15)
    V15 = (V15 \ 256)
 NEXT I
 IF V38 = %ZCRCW THEN
    V12 = CharPut(V71,%XON)
 END IF
 V12 = SioDelay(1+%ZDELAY)
END SUB



SUB V145(V9() AS BYTE, _
               BYVAL V6 AS INTEGER, _
               BYVAL V38 AS BYTE) PRIVATE
 DIM V15 AS WORD
 DIM I AS INTEGER
 DIM V12 AS INTEGER
 IF V17 THEN
    CALL V144(V9(),V6,V38)
    EXIT SUB
 END IF
 V15 = 0
 
 FOR I= 0 TO V6-1
    CALL V132(V9(I))
    V15 = UpdateCrc16(V9(I),V15)
 NEXT I
 
 V15 = UpdateCrc16(V38,V15)
 V12 = CharPut(V71,%ZDLE)
 V12 = CharPut(V71,V38)
 V15 = UpdateCrc16(0,V15)
 V15 = UpdateCrc16(0,V15)
 
 CALL V132(V15 \ 256)
 CALL V132(&H00FF AND V15)
 IF V38 = %ZCRCW THEN
    V12 = CharPut(V71,%XON)
 END IF
 V12 = SioDelay(1+%ZDELAY)
END SUB



SUB V146 PRIVATE
 DIM I AS INTEGER
 DIM V12 AS INTEGER
 DO
    CALL V130(V111)
    CALL V141(%ZFIN,V110())
    SELECT CASE V121(V78())
        CASE %ZFIN
            V12 = CharPut(V71,ASC("O"))
            V12 = CharPut(V71,ASC("O"))
            V12 = SioDelay(%TENTH.SEC)
            V12 = SioTxFlush(V71)
            EXIT SUB
         CASE %ZCAN,%RCDO,%ZFERR,%ZTIMEOUT
            EXIT SUB
    END SELECT
 LOOP WHILE (%True)
END SUB



FUNCTION V93 PRIVATE AS INTEGER
 DIM N AS INTEGER
 DIM C AS INTEGER
 CALL WriteMsg("Getting receiver info.")
 FOR N=1 TO %MAX.ERRORS-1
     C = V121(V78())
     SELECT CASE C
         CASE %ZCHALLENGE
            CALL V130(V79)
            CALL V149(%ZACK,V110())
         CASE %ZCOMMAND
            CALL V130(0)
            CALL V149(%ZRQINIT,V110())
         CASE %ZRINIT
            V74 = (V78(%ZP1) * 256) OR V78(%ZP0)
            V17 = (V78(%ZF0) AND %CANFC32)
            IF V17 THEN
               CALL WriteMsg("Get CRC 32")
            ELSE
               CALL WriteMsg("Get CRC 16")
            END IF
            V93 = %ZOK
            EXIT FUNCTION
         CASE %ZCAN, %RCDO, %ZTIMEOUT
            V93 = %ZERROR
            EXIT FUNCTION
         CASE ELSE
            IF (c <> %ZRQINIT) OR (V78(%ZF0) <> %ZCOMMAND) THEN
               CALL V149(%ZNAK,V110())
            END IF
    END SELECT
 NEXT N
 V93 = %ZERROR
END FUNCTION



FUNCTION V94 PRIVATE AS INTEGER
ON LOCAL ERROR GOTO SyncTrap
 DIM I AS INTEGER
 DIM C AS INTEGER
 DIM V12 AS INTEGER
 DIM V63 AS INTEGER
 V63 = %MAX.ERRORS
 DO
     C = V121(V78())
     
     V12 = SioRxFlush(V71)
     SELECT CASE C
         CASE %ZTIMEOUT
            V63 = V63 - 1
            IF V63 < 0 THEN
               V94 = %ZERROR
               EXIT FUNCTION
            END IF
         CASE %ZCAN, %ZABORT, %ZFIN, %RCDO
            V94 = %ZERROR
            EXIT FUNCTION
         CASE %ZRPOS
            SEEK V51, V79
            CALL WriteLongMsg("New Pos=",V79)
            V111 = V79
            V94 = C
            EXIT FUNCTION
         CASE %ZSKIP, %ZRINIT, %ZACK
            V94 = C
            EXIT FUNCTION
         CASE ELSE
            CALL WriteMsg("Unspecified error!")
            CALL V141(%ZNAK,V110())
        END SELECT
    LOOP
SyncTrapExit:
    EXIT FUNCTION

SyncTrap:
  SELECT CASE ERR
    CASE ELSE
      PRINT "SzmSync Error: ("; ERR; ")"
    END SELECT
    V94 = %ZERROR
    RESUME SyncTrapExit
END FUNCTION




FUNCTION V148 PRIVATE AS INTEGER
ON LOCAL ERROR GOTO SendFileDataTrap
  DIM I AS INTEGER
  DIM C AS INTEGER
  DIM V12 AS INTEGER
  DIM V38 AS INTEGER
  DIM V64 AS INTEGER
  DIM V7 AS INTEGER
  DIM V10 AS INTEGER
  DIM BytesLeft AS LONG
  DIM V58 AS INTEGER
  DIM V40 AS INTEGER
  DIM V41 AS INTEGER
  DIM AnyKey AS STRING
  V41 = 1
  V58 = %ZBUFSIZE
  V7 = V58
V88:
  V12 = SioDelay(%ZDELAY)
  IF SioRxQue(V71) = 0 THEN
V113:
  C = V94
  SELECT CASE C
      CASE %ZSKIP
         V148 = %ZSKIP
         EXIT FUNCTION
      CASE %ZACK
      CASE %ZRPOS
         V28 = V28 + 1
         CALL WriteIntMsg("POS Error(7)=",V28)
         IF ((V7 \ 4) > 32) THEN
            V7 = (V7 \ 4)
         ELSE
            V7 = 32
         END IF
         V40 = 0
         V41 = (V41 * 2) OR 1
      CASE %ZRINIT
         V148 = %ZOK
         EXIT FUNCTION
      CASE ELSE
         V148 = %ZERROR
         EXIT FUNCTION
  END SELECT
  DO
    I = V120(%ZDELAY)
    IF I < 0 THEN EXIT DO
    SELECT CASE I
       CASE %CAN, %ZPAD
         GOTO V113
       CASE %RCDO
          V148 = %ZERROR
          EXIT FUNCTION
    END SELECT
  LOOP
  END IF

  V64 = V74
  CALL V130(V111)
  CALL V141(%ZDATA,V110())
  DO
     AnyKey = INKEY$
     IF AnyKey <> "" THEN
       IF AnyKey = CHR$(%ABORT.CHAR) THEN
         CALL WriteMsg(V1)
         CALL V143
         GOTO V68
       END IF
     END IF
     IF V115 = 0 THEN GOTO V68
     
     BytesLeft = LOF(V51) - LOC(V51)
     IF BytesLeft < V7 THEN
        V10 = BytesLeft
     ELSE
        V10 = V7
     END IF
     FOR I = 0 TO V10 - 1
        GET V51, ,V109(I)
     NEXT I
     IF V10 < V7 THEN
        V38 = %ZCRCE
     ELSE
        IF (V74  <>  0) AND ((V64 - V10) <= 0) THEN
           V64 = (V64 - V10)
           V38 = %ZCRCW
        ELSE
           IF V92 THEN
              V38 = %ZCRCG
           ELSE
              V38 = %ZCRCW
           END IF
        END IF
      END IF
      
      SELECT CASE V38
         CASE %ZCRCE
            CALL WriteLongMsg("ZCRCE: Pos=",V111)
         CASE %ZCRCW
            CALL WriteLongMsg("ZCRCW: Pos=",V111)
          CASE %ZCRCG
            CALL WriteLongMsg("ZCRCG: Pos=",V111)
          CASE ELSE
             CALL WriteLongMsg("ZCRC?: Pos=",V111)
       END SELECT
       
       CALL V145(V109(),V10,V38)
       V111 = V111 + V10
       V40 = V40 + 1
       IF (V7 < V58) AND (V40 > V41) THEN
          IF (V7 * 2) < V58 THEN
              V7 = (V7 * 2)
          ELSE
              V7 = V58
              V40 = 0
          END IF
       END IF
       IF V38 = %ZCRCW THEN GOTO V113
       DO
          I = V120(%ZDELAY)
          IF I < 0 THEN EXIT DO
          SELECT CASE I
             CASE %CAN
                CALL WriteMsg("CAN !")
             CASE %ZPAD
                CALL WriteMsg("Trouble?")
                V12 = SioTxFlush(V71)
                CALL V145(V109(),0,%ZCRCE)
                GOTO V113
             CASE %RCDO
                V148 = %ZERROR
                EXIT FUNCTION
          END SELECT
       LOOP
  LOOP WHILE (V38 = %ZCRCG)
  DO
      CALL V130(V111)
      CALL WriteMsg("Sending EOF")
      CALL V141(%ZEOF,V110())
      C = V94
      SELECT CASE C
          CASE %ZACK
          CASE %ZRPOS
             GOTO V88
          CASE %ZRINIT
             V148 = %ZOK
             EXIT FUNCTION
          CASE %ZSKIP
             V148 = C
             EXIT FUNCTION
          CASE ELSE
V68:
             V148 = %ZERROR
             EXIT FUNCTION
      END SELECT
  LOOP WHILE (C = %ZACK)
  V148 = C

SendFileDataExit:
  EXIT FUNCTION

SendFileDataTrap:
  PRINT "SendFileData Error: ("; ERR; ")"
  V148 = %FALSE
  RESUME SendFileDataExit
END FUNCTION




FUNCTION V147 PRIVATE AS INTEGER
ON LOCAL ERROR GOTO SendFileTrap
 DIM I AS INTEGER
 DIM C AS INTEGER
 DIM AnyKey AS STRING
 V28 = 0
 DO
    AnyKey = INKEY$
    IF AnyKey <> "" THEN
      IF AnyKey = CHR$(%ABORT.CHAR) THEN
        CALL WriteMsg(V1)
        CALL V143
        V147 = %ZERROR
        EXIT FUNCTION
      END IF
    END IF
    IF V115 = 0 THEN
        CALL WriteMsg("Lost carrier")
        V147 = %ZERROR
        EXIT FUNCTION
    END IF
    FOR I=0 TO 3
       V110(I) = 0
    NEXT I
    V110(%ZF0) = %ZCRESUM  
    CALL V141(%ZFILE,V110())
    CALL V145(V109(),%ZBUFSIZE,%ZCRCW)
    DO
        C = V121(V78())
        SELECT CASE C
            CASE %ZCAN, %RCDO, %ZTIMEOUT, %ZFIN, %ZABORT
               V147 = %ZERROR
               EXIT FUNCTION
            CASE %ZRINIT
            CASE %ZCRC
               CALL V130(V116(V51))
               CALL V149(%ZCRC,V110())
            CASE %ZSKIP
               V147 = C
               EXIT FUNCTION
            CASE %ZRPOS
               SEEK V51, V79
               CALL WriteLongMsg("Setting start position =",V79)
               V90 = V79
               V111 = V79
               V147 = V148
               EXIT FUNCTION
         END SELECT
       LOOP WHILE (C = %ZRINIT)
   LOOP
SendFileTrapExit:
   EXIT FUNCTION

SendFileTrap:
    PRINT "SendFile Error: ("; ERR; ")"
    V147 = %FALSE
    RESUME SendFileTrapExit
END FUNCTION



FUNCTION V139(BYVAL V70 AS INTEGER, _
           BYVAL LastFile AS INTEGER) PRIVATE AS INTEGER
 DIM I AS INTEGER
 DIM N AS INTEGER
 DIM V105 AS LONG
 DIM V95 AS STRING
 DIM V44 AS INTEGER
 DIM V12 AS INTEGER
 
 V17 = UseCrc32
 V101 = LCASE$(V101)
 V28 = 0
 V71 = V70
 IF V115 = 0 THEN
    CALL WriteMsg("Lost carrier")
    V12 = SioDelay(%TWO.SECS)
    V139 = %False
    EXIT FUNCTION
 END IF

 V44 = DosOpen(V101)
 IF V44 > 0 THEN
     CALL GetFileDT(V44,V32,V36)
     V12 = DosClose(V44)
     I = FREEFILE
     OPEN V101 FOR BINARY ACCESS READ AS I
     V31 = LOF(I)
     CLOSE I
 ELSE
     
     V95 = "Unable to open(2) " + V101
     CALL WriteMsg(V95)
     CALL V146
     V139 = %False
     EXIT FUNCTION
 END IF
 V95 = "Sending " + V101 + " size=" + STR$(V31)
 CALL WriteMsg(V95)
 IF V31 = 0 THEN
    CALL WriteMsg("File is empty!")
    V12 = SioDelay(%ONE.SEC)
    V139 = %False
    EXIT FUNCTION
 END IF
 
 FOR I = 0 TO %ZBUFSIZE-1
    V109(I) = 0
 NEXT I
 CALL String2Array(V101,V33())
 CALL Dos2Zdate(V32,V36,V95)
 V95 = V101 + " " + LTRIM$(STR$(V31)) + " " + V95
 CALL String2Array(V95,V109())
 V109(LEN(V101)) = 0
 V80 = 10 * %ONE.SEC
 V5(0) = ASC("r")
 V5(1) = ASC("z")
 V5(2) = 13
 V5(3) = 0
 CALL V131(V5())
 FOR I=0 TO %ZATTNLEN-1
    V5(I) = 0
 NEXT I
 CALL V130(0)
 CALL V149(%ZRQINIT,V110())
 IF V93 = %ZERROR THEN
     V139 = %False
     EXIT FUNCTION
 END IF
 V51 = FREEFILE
 OPEN V101 FOR BINARY ACCESS READ AS V51
 
 V105 = SioTimer
 N = V147
 CALL WriteCPS(V105,V31,V33(),(N=%ZSKIP))
 close(V51)
 IF LastFile THEN
    CALL V146
 END IF
 V139 = %True
SendExit:
 EXIT FUNCTION

SendTrap:
  SELECT CASE ERR
    CASE 53
      V95 = "Cannot open " + V101 + " for append"
      CALL WriteMsg(V101)
    CASE ELSE
      PRINT "Send Error: ("; ERR; ")"
    END SELECT
    V139 = %FALSE
    RESUME SendExit
END FUNCTION



FUNCTION ZmodemTx(BYVAL V70 AS INTEGER, _
             BYVAL V34 AS STRING, _
             BYVAL V91 AS INTEGER) PUBLIC AS INTEGER
 DIM V65 AS STRING
 DIM V54 AS INTEGER
 DIM V72 AS INTEGER
 DIM V95   AS STRING
 DIM V12   AS INTEGER
 DIM TheLen AS INTEGER

 IF NOT V52 THEN
   CALL zmInitialize
 END IF

V92 = V91
V72 = %False
V54 = %False
 
 TheLen = FetchName(V34)
 IF TheLen = 0 THEN
    ZmodemTx = %False
    EXIT FUNCTION
 END IF
 
 V65 = DIR$(V34)
 IF V65 = "" THEN
    V95 = "Cannot open " + V34
    CALL WriteMsg(V95)
    ZmodemTx = %False
    EXIT FUNCTION
 END IF
 
 DO
    V101 = V65
    V65 = DIR$
    IF V65 = "" THEN V54 = %True
    IF V101 = "" THEN
       EXIT DO
    END IF
    V95 = "Sending <" + V101 + ">"
    CALL WriteMsg(V95)
    V12 = SioDelay(%TENTH.SEC+%ZDELAY)
    V72 = V139(V70,V54)
 LOOP WHILE (NOT V54)
 
 IF V72 THEN
    CALL WriteMsg("ZMODEM completed")
 ELSE
    CALL WriteMsg("ZMODEM failed")
 END IF
 V12 = ModemQuiet(V70,9)
 ZmodemTx = V72
END FUNCTION



FUNCTION ZmodemRx(BYVAL V70 AS INTEGER, _
             BYVAL V91 AS INTEGER) PUBLIC AS INTEGER
 DIM V72 AS INTEGER
 DIM V12 AS INTEGER

 IF NOT V52 THEN
   CALL zmInitialize
 END IF
 V92 = V91
 V72 = V135(V70)
 IF V72 THEN
     CALL WriteMsg("ZMODEM completed")
 ELSE
     CALL WriteMsg("ZMODEM failed")
 END IF
 V12 = ModemQuiet(V70,9)
 ZmodemRx = V72
END FUNCTION

SUB ZmodemDebug(BYVAL V19 AS INTEGER) PUBLIC
IF NOT V52 THEN
   CALL zmInitialize
END IF
V20 = V19
PRINT "ZMODEM V19 = ";V20
END SUB
