/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "tools.h"
#include <dos.h>
#include <strings.h>
#include <direct.h>
#include <stdlib.h>
#include <ctype.h>

       
/***
 *
 *  Function    :  geterrorlevel
 *
 *  Description :  Return errorlevel code from previous command executed
 *                 by current shell (COMMAND.COM or equivalent)
 *
 *  Parameters  :  none
 *
 *  Return      :  errorlevel
 *                 -1 If MS-DOS version not supported
 *
 *  Warning     :  This function is only valid with shells
 *                 MS-DOS COMMAND.COM 3.20, 3.21, 3.30, 4.0, 4.01, 5.0, 6.0,
 *                 NDOS 6.0,
 *                 4DOS 4.02
 */

int geterrorlevel( void )
{
 unsigned psp, far *tmp;
 int offset, version;
 char *shell, *prgname;

        /* _psp is our PSP.  Follow the "parent" links back
           until we find a PSP for COMMAND.COM, which has
           a parent link that points at itself. */

 for ( psp = _psp; psp != *(tmp = MK_FP(psp,0x16)); psp = *tmp );


        /* locate environment */
 prgname = MK_FP( *(unsigned far *)MK_FP(psp,0x2C), 0 );
 while ( *prgname ) while ( *prgname++ );  /* locate end of environment */
 prgname += 3;
 shell = strrchr( prgname, '\\' );
 if ( ! shell )
    shell = strrchr( prgname, ':' );
 if ( ! shell )
    shell = prgname;
 else
    shell++;

 /* offset depends of shell version */
 version = _osmajor * 100 + _osminor;

 switch( toupper(*shell) )
 {
  case 'N': /***   NDOS   ***/
     {
      union REGS regs;
      regs.x.ax = 0xE44D;
      regs.h.bh = 0;
      int86( 0x2F, &regs, &regs );
      if ( regs.x.ax != 0x44EE )
         return -1;

      switch( regs.h.bl * 100 + regs.h.bh ) /* version */
      {
       case 100: offset = 0x3FAB; break; /* NU 6.0 */
       default : return -1;
      }
     }
     break;

  case '4': /***   4DOS   ***/
     {
      union REGS regs;
      regs.x.ax = 0xD44D;
      regs.h.bh = 0;
      int86( 0x2F, &regs, &regs );
      if ( regs.x.ax != 0x44DD )
         return -1;

      switch( regs.h.bl * 100 + regs.h.bh ) /* version */
      {
       case 420: offset = 0x01E6; break;
       default : return -1;
      }
     }
     break;

  default : /***   COMMAND.COM: MS-DOS or DR-DOS   ***/
     {
      /* Check for DR-DOS */
      union REGS regs;
      regs.x.ax = 0x4452;
      regs.x.cflag = 1;
      int86( 0x21, &regs, &regs );
      if ( ! regs.x.cflag )
         {
          switch( atoi(getenv("VER")) )
          {
           case 500: offset = 0x44C1; break; /* or 0AE8 ? */
           case 600: offset = 0x474D; break;
           default : return -1;
          }
         }
       else
          switch( version )
          {
           case 320:
           case 321: offset = 0x0AFA /* or 3D31 */; break;
           case 330: offset = 0x0BEA; break;
           case 400: offset = 0x0F2B; break;
           case 401: offset = 0x0F2C; break;
           case 500: offset = 0x02A3; break;
           case 600: offset = 0x02A5; break;
           default : return -1;
          }
     }
     break;
 }

 return *(unsigned far *)MK_FP( psp, offset );
}
