/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"
#include <ctype.h>

/***
 *  Function    :  strreduce
 *
 *
 *  Description :  Parse a string to suppress blanks, tabs and newlines
 *                 and transform it in uppercase.
 *
 *
 *  Decisions   :  - Portions of string between double quotes are unmodified
 *                   (quotes are removed).
 *
 *                 - '\' is used to quote the next character.
 *
 *                 - Characters with accent are also transformed to uppercase.
 *
 *  Parameters  :  in/out   char *string
 *
 *  Return      :  pointer to end of string ( '\0' ).
 *
 *  OS/Compiler :  All
 ***/

char *strreduce( char *string )

{ char *ptr;

	       	 /*   Suppress quotes and put in uppercase   */
  for ( ptr = string; *string; string ++ )
      switch( *string )
            {
              case '"' : string ++;
                         while ( *string && *string != '"' ) *ptr++ = *string++;
	                 if ( *string == '"' && *(++string) == '"' ) *ptr++ = '"';
	                 break;

              case ' ' :
              case '\t':
              case '\n': break;

              case '\\': *ptr++ = *string;

              default  : *ptr++ = chcase( *string, UPPER );
                         break;
            }

  *ptr = '\0';
  return --ptr;
}
