/***************************************************************/
/*                                                             */
/*    Copyright 1991 by Wayne E. McDaniel                      */
/*    All Rights Reserved                                      */
/*    AutoLibrary is a Trademark of Avid Software              */
/*                                                             */
/***************************************************************/

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* SNF is String Not Found */
#define ERR_SNF 0

/* Error definitions. */
#define ERR_OK                        0
#define ERR_NO_MEMORY             -1000
#define ERR_EOF                   -1001
#define ERR_COMM_PACKAGE          -1002
#define ERR_NO_STRING_SPECIFIED   -1003
#define ERR_ENDING_TIMEOUT        -1004
#define ERR_REPEAT_TIMEOUT        -1005
#define ERR_CAPTURE_FULL          -1006
#define ERR_NOT_INITIALIZED       -1007
#define ERR_EXCEEDED_COMLIST_SIZE -1008
#define ERR_WRITING               -1009
#define ERR_OPENING               -1010
#define ERR_ALREADY_INITIALIZED   -1011
#define ERR_CANNOT_EXIT           -1012
#define ERR_INVALID_PORT          -1013
#define ERR_QUEUE_FULL            -1014

/* Other defines */
#define AVID_NO_TIMEOUT (long) 2147483600

/* IMPORTANT.. SEND_SEARCH_CAPTURE_MAX must be less than TEMP_BUF_MAX */
#define SEND_SEARCH_CAPTURE_MAX 80
#define TEMP_BUF_MAX 85

/* System Parameter. */
#define AVID __LINE__,__FILE__

/* Function defines. */
#define AvidClosePort        alzclose
#define AvidConvert          alzconvt
#define AvidDrainPort        alzdrain
#define AvidEveryChar        alzevery
#define AvidExitAutoLibrary  alzexit
#define AvidGetFromHoldArea  alzhold
#define AvidLogInfo          alzinfol
#define AvidInitAutoLibrary  alzinit
#define AvidOpenPort         alzopen
#define AvidProcessOptions   alzopts
#define AvidRead             alzread
#define AvidRegisterSend     alzrsend
#define AvidRegisterWait     alzrwait
#define AvidSend             alzsend
#define AvidSendSearch       alzss
#define AvidVersion          alzver

/* Function definitions. */
int  alzclose (int, char *, int, int *, char *);
int  alzconvt (int, char *, int *, char *);
int  alzdrain (int, char *, int, long, long, int *, char *);
int  alzexit  (int, char *, int *, char *);
void alzevery (int);
long alzhold  (int, char *, int, long, long, char *, int *, char *);
int  alzinfol (int, char *, int, char *, int, int *, char *);
int  alzinit  (int, char *, int *, char *);
int  alzopen  (int, char *, char *, int *, char *);
char alzopts  (int, char *, char *, char *, char *, char *, int *);
int  alzread  (int, char *, int, long, long, int *, char *);
int  alzrsend (int, char *, int, char *, int *, char *);
int  alzrwait (int, char *, int, int, char *, int *, char *);
int  alzsend  (int, char *, int, char *, int *, char *);
int  alzss    (int, char *, int, long, long, int *, char *, ...);
int  alzver   (int, char *, int *, char *);

#define CommInterfaceClose hw_close
#define CommInterfaceOpen  hw_open
#define CommInterfaceRead  hw_read
#define CommInterfaceSend  hw_send

int hw_close(int, int *, char *);
int hw_open(int, char *, int *, char *);
int hw_read(int, long, long, int *, char *);
int hw_send(int, int, int, char *, int, int *, char *);
