/***************************************************************/
/*                                                             */
/*    Copyright 1991 by Wayne E. McDaniel                      */
/*    All Rights Reserved                                      */
/*    AutoLibrary is a Trademark of Avid Software              */
/*                                                             */
/***************************************************************/

#define COMLIST_SIZE 30

/* The wait for string record. */
struct wrec {
    struct  wrec    *next;
    int     rv;
    int     matched;
    int     len;
    char    *waitptr;
};

/* The send string record. */
struct srec {
    struct  srec    *next;
    int     before;
    int     between;
    int     len;
    char    *sendptr;
};

/* The auto record. */
struct autorec {
    struct  wrec    *whead;
    struct  srec    *shead;
    struct  wrec    *wtail;
    struct  srec    *stail;
    int     hw_port;
    char    *hw_port_name;
    int     d_exit_now;
    int     d_print_now;
    int     d_log_now;
    FILE    *log_file;
    int     num_log;    /* This is the number of messages logged with
			   AvidInfoLog. */
    int     d_before;   /* Default */
    int     d_between;  /* Default */
    char    *hbuf;      /* Pointer to the hold area. */
    int     hsize;      /* The size of the hold area. */
    int     hpos;       /* The position to put the next received character. */
    int     hnum1;      /* The number of characters hold thinks there is in the hold area. */
    int     hnum2;      /* The number of characters auto thinks there is in the hold area. */
    int     max_cap;    /* The maximum number of characters to capture. */
};

#ifndef GLOBAL
extern struct autorec *comlist[];
#endif

static char *o_before =       "_b";
static char *o_between =      "_B";
static char *o_poscap =       "+c";
static char *o_negcap =       "-c";
static char *o_rep_drn =      ".d";
static char *o_end_drn =      ".D";
static char *o_error_message ="*E";
static char *o_exit_yes =     "+E";
static char *o_exit_no =      "-E";
static char *o_holdsize =     "+h";
static char *o_location =     "*L";
static char *o_log_yes =      "+L";
static char *o_log_no =       "-L";
static char *o_nnulls =       ".N";
static char *o_print_yes =    "+p";
static char *o_print_no =     "-p";
static char *o_send =         ".s";
static char *o_registered =   "+R";
static char *o_time_stamp =   "*T";
static char *o_wait =         "0w"; /* Digits 1 thru 9 are valid. */

/* Switches */
static char *o_stop_bits_1 = ".1";
static char *o_stop_bits_2 = ".2";
static char *o_word_len_7 =  ".7";
static char *o_word_len_8 =  ".8";
static char *o_baud =        ".b";
static char *o_even =        ".e";
static char *o_none =        ".n";
static char *o_odd =         ".o";
static char *o_strip_yes =   "+S";
static char *o_strip_no =    "-S";
static char *o_dtr =         ".T";
static char *o_xon_yes =     "+X";
static char *o_xon_no =      "-X";
static char *o_rx_len =      "rx";
static char *o_tx_len =      "tx";
