/*	argtest - test program for getargs

	(C)	Copyright 1985, Allen I. Holub.  All rights reserved.
	This program may be copied for personal, non-profit use only

	history...

	May 1985	published in Dr. Dobb's Journal #103.
	19 May 85	Transcribed by James R. Van Zandt						*/

#include <stdio.h>
#include <getargs.h>

int boolarg=0, chararg='&', intarg=0;
char *strarg="do wha";
extern proc();
ARG Argtab[]={	{'b',	BOOLEAN,	&boolarg,		"boolean argument"	},
				{'c',	CHARACTER,	&chararg,		"character argument"},
				{'n',	INTEGER,	&intarg,		"integer argument"	},
				{'s',	STRING,		(int *)&strarg,	"string argument"	},
				{'p',	PROC,		(int *)&proc,	"procedure argument"}
			};

#define TABSIZE (sizeof(Argtab)/sizeof(ARG))

proc(str)
char *str;
{	printf("procedure called as follows: proc(\"%s\") \n",str);
}

main(argc,argv)
int argc; char **argv;
{	register int i;
	printf("argc=%d.  ",argc);
	printf("command line before processing: \n    \"argtest ");
	for (i=1; i<argc; printf("%s ",argv[i++])) {}
	printf("\"\n\n");
	argc=getargs(argc,argv,Argtab,TABSIZE);
	printf("\nvariable values after processing:\n");
	printf("    boolarg = %s \n",boolarg?"TRUE":"FALSE");
	printf("    chararg = %c \n",chararg);
	printf("    intarg  = %d \n",intarg);
	printf("    strarg  = %s \n\n",strarg);
	printf("argc=%d.  ",argc);
	printf("command line after processing: \n    \"argtest ");
	for (i=1; i<argc; printf("%s ",argv[i++])) {}
	printf("\"\n");
}
