#include "stdlib.h"
#include "alloc.h"
#include "virimg.h"



#define data_char(x) *((char *)pointer_add(DATA_CHAR,x))
#define image(x,y) *((char *)large_array(x,y))
#define s_image(x) *((char *)pointer_add(S_IMAGE,x))
#define image5(x) *((char *)large_array(5,x))

#define SZ 80000

void test(void *S_IMAGE)
{
	long i;
	printf ("Checking an arbitary image\n");
	printf ("Filling image\n");
	for (i=0;i<SZ;i++)
		s_image(i)=(char)i;
	printf ("Checking char array\n");
	for (i=0;i<SZ;i++)
		if (s_image(i)!=(char)i) goto ERR2;
	printf ("arbitary image ok\n");
	return;
ERR2:
	printf ("Error checking arbitary image\n");
	exit(-1);
}

void main()
{
	long i,j,l;
	initialise_virtual_arrays("c:\\image.swp",32768,3,SZ,16);
	printf ("Array size %ld chars\n",SZ);
	printf ("Memory still available %ld\n",coreleft());
	printf ("Press a key to check arrays\n");
	getch();
	start_timer();

	l=0;
	for (j=0;j<10;j++)
	{
		printf ("Filling virtual array %d\n",j);
		for (i=0;i<SZ;i++)
		{
			image(j,i)=l;
		}
		l++;
	}

	l=0;
	for (j=0;j<10;j++)
	{
		printf ("Checking virtual array %d\n",j);
		for (i=0;i<SZ;i++)
		{
			if (image(j,i)!=(char)l) goto ERR;
		}
		l++;
	}
	printf ("All arrays checked out o.k.\n");
	test (img(6));
	printf ("Checking image array 5\n");
	printf ("Filling image\n");
	for (i=0;i<SZ;i++)
		image5(i)=(char)i;
	printf ("Checking char array\n");
	for (i=0;i<SZ;i++)
		if (image5(i)!=(char)i) goto ERR;
	printf ("image array 5 ok\n");
	stop_timer();
	exit(1);
ERR:
	printf ("Error in large array %ld %ld %d %d\n",j,i,(int)(image(j,i)),(int)(char)l);
}
